

<div class="wrap">

    <h2>TabSuite Members Settings</h2>

    <p>TabSuite Members allows you to turn your WordPress site into a facebook application where anyone who "installs" your application is

    automatically subscribed to your website with their name and email address.</p>

    

    <form method="post" action="options.php">

		<?php 

			settings_fields('tabsuite_members_settings'); 

			$options = get_option('tabsuite_members_options');

       	?>

        	<table class="form-table">

                <tr valign="top">

                    <th scope="row">Facebook Application ID</th>

                    <td>

                    	<input type="text" name="tabsuite_members_options[facebook_application_id]" value="<?php echo $options["facebook_application_id"]; ?>" />

                        <br />

                        This is the application ID provided by facebook.

                    </td>

                </tr>

                <tr valign="top">

                    <th scope="row">Facebook Application Name</th>

                    <td>

                    	http://apps.facebook.com/<input type="text" name="tabsuite_members_options[facebook_application_name]" value="<?php echo $options["facebook_application_name"]; ?>" />

                        <br />

                        This is the application URL on by facebook. (Example: http://apps.facebook.com/your_app);

                    </td>

                </tr>

                

                <tr valign="top">

                    <th scope="row">Facebook Application Canvas URL</th>

                    <td>

                    	<select name="tabsuite_members_options[facebook_application_canvas_page_id]"> 

                         <option value=""><?php echo attribute_escape(__('Select page')); ?></option> 

                         <option value="0"<?php echo ( 0 == $option["facebook_application_canvas_page_id"] ? ' selected="selected"' : '' ); ?>><?php echo home_url(); ?>/</option>

                         <?php 

                          $pages = get_pages(); 

                          foreach ($pages as $pagg) {

						  	$page_link = get_page_link($pagg->ID);

                            $option = '<option value="'.$pagg->ID.'"'.( $pagg->ID == $options["facebook_application_canvas_page_id"] ? ' selected="selected"' : '' ).'>';

                            $option .= $page_link;

                            $option .= '</option>';

                            echo $option;

                          }

                         ?>

                        </select>

                        <br />

                        <input type="checkbox" name="tabsuite_members_options[facebook_application_canvas_requires_activation]" value="1"<?php echo ( $options["facebook_application_canvas_requires_activation"] == "1" ? ' checked="checked"' : '' ); ?> />

                    	Require application activation to view the canvas page<br />

                        <br />

                        This is the first page a facebook user sees when visiting your application on facebook. You could think of it as a sales page

                        on why the user should install your application (website). You can optionally skip straight to the application activation/authorization

                        dialog, prompting the user to install your application immediately, without seeing the content of this page beforehand.

                    </td>

                </tr>

                <tr valign="top">

                    <th scope="row">Facebook Fan Page redirect URL</th>

                    <td>

                        <input type="text" name="tabsuite_members_options[facebook_fan_page_url]" value="<?php echo $options["facebook_fan_page_url"]; ?>" style="width:500px;" />

                        <br />

                        You can force the user to access your application via the fan page it's installed on. To activated it, enter the URL of your fan page's application tab here. 

                        Otherwise, it will redirect to your application's profile page.

                    </td>

                </tr>

                

                <tr valign="top">

                    <th scope="row">Pages for Anyone</th>

                    <td>

                        <input type="text" name="tabsuite_members_options[pages_for_anyone]" value="<?php echo $options["pages_for_anyone"]; ?>" />

                        <br />

                    	Enter the page IDs of any pages you want to grant access to all visitors to your facebook page/application, even if they don't install the application and subscribe to your website.

                        Use comma-separated values, i.e. "2,3,4". Here's a video on <a href="http://www.youtube.com/watch?v=8-MqNV3JX3U" target="_blank">how to find the ID of a page or post</a>.

                    </td>

                </tr>

                

            </table>

        <p class="submit"><input type="submit" class="button-primary" value="Save Changes" /></p>

	</form>

    

    <h2>Shortcodes</h2>

    <p>There are several WordPress shortcodes available for use in your content.</p>

    <p><strong>[like]Content...[/like]</strong> This will display content only to those that have liked the page the application is installed on.</p>

    

    <p><strong>[nolike]Content...[/nolike]</strong> This will display content only to those that have NOT liked the page the application is installed on.</p>

    

    <p><strong>[loggedin]Content...[/loggedin]</strong> This will display content only to those are logged into your application. This happens only if they've been prompted

    to install the application and allowed access.</p>

    

    <p><strong>[notloggedin]Content...[/notloggedin]</strong> This will display content only to those are not currently logged into your application. 

    This is usually because they haven't installed/allowed the application.</p>

    

    

</div>





