<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

define('LF_OPTIN_CAPTCHA_MAX', 5);

class leadflow_optin_captcha {
	
  // convert HEX(HTML) color notation to RGB
  static function hex2rgb($color) {
    if ($color[0] == '#') {
      $color = substr($color, 1);
    }

    if (strlen($color) == 6) {
        list($r, $g, $b) = array($color[0].$color[1],
                                 $color[2].$color[3],
                                 $color[4].$color[5]);
    } elseif (strlen($color) == 3) {
        list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
    } else {
        return array(255, 255, 255);
    }

    $r = hexdec($r);
    $g = hexdec($g);
    $b = hexdec($b);

    return array($r, $g, $b);
  } // html2rgb


  // output captcha image
  static function generate() {
    @session_start();
    
    $a = rand(0, (int) LF_OPTIN_CAPTCHA_MAX);
    $b = rand(0, (int) LF_OPTIN_CAPTCHA_MAX);
    $color = @$_GET['color'];
    $color = urldecode($color);
    
    $optin_ID = $_GET['optin_ID'];
    
    $font_color = @$_GET['font_color'];
    $font_color = urldecode($font_color);
    
    if ($a > $b) {
      $out = "$a - $b =";
      $_SESSION['lf-captcha-' . $optin_ID] = $a - $b;
    } else {
      $out = "$a + $b =";
      $_SESSION['lf-captcha-' . $optin_ID] = $a + $b;
    }

    $font   = 5;
    $width  = ImageFontWidth($font) * strlen($out);
    $height = ImageFontHeight($font);
    $im     = ImageCreate($width, $height);

    $x = imagesx($im) - $width ;
    $y = imagesy($im) - $height;

    $white = imagecolorallocate ($im, 255, 255, 255);
    $gray = imagecolorallocate ($im, 66, 66, 66);
    $black = imagecolorallocate ($im, 0, 0, 0);
    $trans_color = $white; //transparent colour
    
    if ($color) {
      $color = self::hex2rgb($color);
      $new_color = imagecolorallocate ($im, $color[0], $color[1], $color[2]);
      imagefill($im, 1, 1, $new_color);
    } else {
      imagecolortransparent($im, $trans_color);
    }
    
    if ($font_color) {
			$font_color = self::hex2rgb($font_color);
			$font_color = imagecolorallocate ($im, $font_color[0], $font_color[1], $font_color[2]);
			imagestring ($im, $font, $x, $y, $out, $font_color);
    } else {
			imagestring ($im, $font, $x, $y, $out, $black);
    }

    

    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
    header('Content-type: image/gif');
    imagegif($im);
    die();
  } // create


  static function get($optin_ID) {
    @session_start();
    return $_SESSION['lf-captcha-' . $optin_ID];
  } // get
  
} // leadflow_optin_captcha

if (isset($_GET['lf-generate-captcha'])) {
  leadflow_optin_captcha::generate();
}