<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_admin_ajax extends leadflow {
   // Registration of Ajax Endpoints
   static function register_ajax_endpoints() {
     // flows
     add_action('wp_ajax_lf_refresh_list', array('leadflow_flow_common', 'refresh_list_ajax'));
     add_action('wp_ajax_lf_refresh_debug_log', array('leadflow_flow_debug', 'refresh_debug_log_ajax'));
     add_action('wp_ajax_lf_load_end_template', array('leadflow_flow_common', 'load_end_template_ajax'));
     add_action('wp_ajax_lf_get_flow_component', array('leadflow_flow_components', 'generate_flow_component_ajax'));

     // API Services
     add_action('wp_ajax_lf_save_api', array('leadflow_settings', 'save_api_ajax'));
     add_action('wp_ajax_lf_activate_service', array('leadflow_settings', 'activate_service_ajax'));
     add_action('wp_ajax_lf_deactivate_service', array('leadflow_settings', 'deactivate_service_ajax'));

     // Ajax - Generate Optin Backend Widgets - First Optin
     add_action('wp_ajax_lf_generate_widget_first_optin', array('leadflow_optin_first_optin', 'generate_widget_ajax'));

     // Ajax - Generate Optin Backend Widgets - Second Optin
     add_action('wp_ajax_lf_generate_widget_second_optin', array('leadflow_optin_second_optin', 'generate_widget_ajax'));

     // Various Ajax Endpoints
     add_action('wp_ajax_lf_dismiss_pointer', array('leadflow_pointers', 'dismiss_pointer_ajax'));
     add_action('wp_ajax_lf_export_subscribers', array('leadflow_bulk', 'export_subscribers'));
     add_action('wp_ajax_lf_push_flow', array('leadflow_bulk', 'push_flow'));
     add_action('wp_ajax_lf_export_csv_headers', array('leadflow_export', 'export_setup_headers'));
     add_action('wp_ajax_lf_export_csv', array('leadflow_export', 'export_csv'));
     add_action('wp_ajax_lf_import_csv', array('leadflow_import', 'import_csv'));
     add_action('wp_ajax_lf_download_geoip', array('leadflow_geoip', 'download_geoip'));
     add_action('wp_ajax_lf_download_templates', array('leadflow_templates', 'download_templates'));
     add_action('wp_ajax_lf_download_template_file', array('leadflow_templates', 'download_template_file'));

     // settings
     add_action('wp_ajax_lf_send_api_info', array('leadflow_admin_ajax', 'send_api_info'));
     add_action('wp_ajax_lf_reset_stats', array('leadflow_settings', 'reset_stats_ajax'));
     add_action('wp_ajax_lf_delete_temp', array('leadflow_settings', 'delete_temp_ajax'));


   } // register_ajax_endpoints


   // send api details to email/sms
   static function send_api_info() {
     $msg = '';
     if (empty($_GET['notification_type'])) {
       wp_send_json_error('Unknown notification type.');
     }

     $options = get_option(LF_OPTIONS, array());

     $details = leadflow_mobile_api::get_access_details();
     if (empty($details['api_key'])) {
       wp_send_json_error('API is disabled.');
     }

     $hash = base64_encode(rtrim(home_url(), '/') . '/|' . $options['api_key']);
     $redirect_url = add_query_arg(array('lfp_redirect' => urlencode($hash)), home_url());

     if ($_GET['notification_type'] == 'email') {
       if (empty($_GET['to']) || !is_email($_GET['to'])) {
         wp_send_json_error('Please double-check your email address.');
       }


       $msg .= 'Mobile access details for <b>' . get_bloginfo('name') . "</b><br><br>\n\n";
       $msg .= 'One click mobile app access: <a href="' . $details['redirect_url']  . '">' . $details['redirect_url']  . "</a><br>\n";
       $msg .= 'API endpoint URL: <a href="' . $details['api_endpoint'] . '">' . $details['api_endpoint'] . "</a><br>\n";
       $msg .= 'API key: ' . $details['api_key'] . "<br>\n";
       $msg .= 'Packed access data: ' . $details['hash'] . "<br><br>\n\n";
       $msg .= 'If you don\'t have the app installed on your mobile device, get it for free on the <a href="https://itunes.apple.com/WebObjects/MZStore.woa/wa/viewSoftware?id=1035184782&mt=8">Apple App Store</a> or the <a href="https://play.google.com/store/apps/details?id=com.imsc.leadsflowpro">Google Play Store</a>.';
       $msg .= "\n\n\n<br><br><br><i>Have a good one!</i>";

       $tmp = wp_mail($_GET['to'], 'LeadsFlow Pro mobile access details for ' . get_bloginfo('name'), $msg, array('Content-Type: text/html; charset=UTF-8'));
       if ($tmp) {
         wp_send_json_success('Details sent via email.');
       } else {
         wp_send_json_error('Unable to send email.');
       }
     } elseif ($_GET['notification_type'] == 'sms') {
       if (empty($_GET['to']) || strlen($_GET['to']) < 8) {
         wp_send_json_error('Please double-check your phone number.');
       }
		
	   global $leadflow_lc;
	   		
       $msg = 'Add a new site to the LFP app by clicking ' . $details['redirect_url'];
	   
	   $sms_args=array('body' => array('to_nb' => $_GET['to'], 'msg' => $msg, 'username' => $leadflow_lc->get_decryptedoption($leadflow_lc->email), 'license_key' => $leadflow_lc->get_decryptedoption($leadflow_lc->authkey) ));
       
	   update_option('sms_args',$sms_args);
	   $res = wp_remote_post('https://leadsflowpro.com/members/?lf_sms_proxy=send', $sms_args);

       if (!is_wp_error($res)) {
         $res = wp_remote_retrieve_body($res);
         $res = json_decode($res);

         if (!empty($res->success)) {
            wp_send_json_success('Details sent via SMS.');
         } else {
            wp_send_json_error($res->data);
         }
       } else {
         wp_send_json_error($res->get_error_message());
       }
     } else {
       wp_send_json_error('Unknown notification type.');
     }

     wp_send_json_error('Unknown error');
   } // send_api_details


   // reset stats table
   static public function reset_stats_ajax() {
     global $wpdb;

     $wpdb->query('TRUNCATE TABLE ' . $wpdb->lf_stats);

     die('1');
   } // reset_stats_ajax


   // send verification
   static function send_verification() {

     $response = wp_remote_post(LF_CLIENT_URL,
                   array('body' => array( 'username' => 'bob', 'password' => '1234xyz' )
                 ));

     if (is_wp_error($response)) {
       die('0');
     } else {
       echo $response['body'];
       die();
     }

     die();
   } // send_verification


 } // leadflow_admin_ajax