<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 * Admin Ajax
 */

 class leadflow_admin_enqueues extends leadflow {


   // admin enqueues
   static function admin_enqueues() {
     $screen = get_current_screen();

     wp_localize_script('jquery', 'leadflow_path', LF_PLUGIN_URL . '/');

     // Fix Subscribers Tags - Wrong Menu Selected
     if ($screen->id == 'edit-leadflow-subscriber-tags' || $screen->id == 'admin_page_leadflow-bulk' || $screen->id == 'admin_page_leadflow-export') {
       wp_enqueue_script('leadflow-menu-fix', LF_PLUGIN_URL . '/js/lf-admin-menu-fix.js', array('jquery'), leadflow::$version, true);
     }

     // dashboard
     if ($screen->id == 'toplevel_page_leadflow') {
       wp_enqueue_script('heartbeat');
       wp_enqueue_script('jquery-effects-pulsate');

       wp_enqueue_script('leadflow-google-chart', "//www.gstatic.com/charts/loader.js", false, false, true);
       //wp_enqueue_script('leadflow-google-chart', '//www.google.com/jsapi', false, false, true);
       wp_enqueue_script('leadflow-google-maps', '//maps.google.com/maps/api/js?key=AIzaSyCnCb5R10SVmR1fBMdzZKMmOAq1BkGv8Zc&amp;language=en', false, false, true);
       wp_enqueue_script('leadflow-flot', LF_PLUGIN_URL . '/js/flot/jquery.flot.min.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-gmap3', LF_PLUGIN_URL . '/js/gmap3.min.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-dashboard', LF_PLUGIN_URL . '/js/lf-admin-dashboard.js', array('jquery'), leadflow::$version, true);
     }

     // pages & posts
     if ($screen->id == 'page' || $screen->id == 'post') {
       wp_enqueue_script('leadflow-lock', LF_PLUGIN_URL . '/js/lf-admin-lock.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);
     }


     // flows
     if ($screen->id == 'edit-lead-flows' || $screen->id == 'lead-flows') {
       wp_enqueue_media();
       wp_enqueue_script('jquery-ui-sortable');
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-flows', LF_PLUGIN_URL . '/js/lf-admin-flows.js', array('jquery'), leadflow::$version, true);
     }

     // edit optin tags
     if ($screen->id == 'edit-leadflow-subscriber-tags') {
       wp_enqueue_script('wp-color-picker');
       wp_enqueue_style('wp-color-picker');
     }

     // optins
     if ($screen->id == 'edit-optin-pages' || $screen->id == 'optin-pages' || $screen->id == 'toplevel_page_leadflow') {
       wp_enqueue_media();

       wp_enqueue_script('wp-color-picker');
       wp_enqueue_style('wp-color-picker');
       wp_enqueue_script('jquery-ui-sortable');
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);

       // Icon Picker
       wp_enqueue_script('leadflow-iconpicker', LF_PLUGIN_URL . '/js/icon-picker/jquery.fonticonpicker.min.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_style('leadflow-iconpicker', LF_PLUGIN_URL . '/js/icon-picker/css/jquery.fonticonpicker.min.css', array(), leadflow::$version);
       wp_enqueue_style('leadflow-iconpicker-theme', LF_PLUGIN_URL . '/js/icon-picker/themes/grey-theme/jquery.fonticonpicker.grey.min.css', array(), leadflow::$version);

       // Icon Picker - Fonts
       wp_enqueue_style('leadflow-iconpicker-fonts-fontello', LF_PLUGIN_URL . '/js/icon-picker/fonts/fontello/css/fontello.css', array(), leadflow::$version);
       wp_enqueue_style('leadflow-iconpicker-fonts-icomoon', LF_PLUGIN_URL . '/js/icon-picker/fonts/icomoon/style.css', array(), leadflow::$version);

       // Timepicker
       wp_enqueue_script('jquery-ui');
       wp_enqueue_script('jquery-ui-slider');
       wp_enqueue_script('jquery-ui-datepicker');

       wp_enqueue_style('jquery-ui');
       wp_enqueue_style('jquery-ui-datepicker');
       wp_enqueue_style('jquery-ui-slider');

       wp_enqueue_style( 'jquery-ui-datepicker-style' , LF_PLUGIN_URL . '/js/timepicker/jquery-ui-datepicker.css', array(), leadflow::$version);

       wp_enqueue_script('leadflow-timepicker', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-timepicker-addon.min.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-timepicker-slider', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-sliderAccess.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-timepicker-i18n', LF_PLUGIN_URL . '/js/timepicker/i18n/jquery-ui-timepicker-addon-i18n.min.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_style('leadflow-timepicker', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-timepicker-addon.min.css', array(), leadflow::$version);

       // Button Styles
       wp_enqueue_style('leadflow-button-css3', LF_PLUGIN_URL . '/css/button-styles.css', array(), leadflow::$version);

       // Image Picker
       wp_enqueue_style('leadflow-imagepicker', LF_PLUGIN_URL . '/js/image-picker/image-picker.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-imagepicker', LF_PLUGIN_URL . '/js/image-picker/image-picker.min.js', array('jquery'), leadflow::$version, true);

       wp_enqueue_script('leadflow-optins', LF_PLUGIN_URL . '/js/lf-admin-optins.js', array('jquery'), leadflow::$version, true);

     }

     // AB tests
     if ($screen->id == 'leadflow-abtests') {
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-ab-tests', LF_PLUGIN_URL . '/js/lf-admin-ab-tests.js', array('jquery'), leadflow::$version, true);
     }

     // subscribers list
     if ($screen->id == 'edit-leadflow-subscribers' || $screen->id == 'leadflow-subscribers') {
       wp_enqueue_script('jquery-ui-dialog');
       wp_enqueue_style('wp-jquery-ui-dialog');
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-subscribers', LF_PLUGIN_URL . '/js/lf-admin-subscribers.js', array('jquery'), leadflow::$version, true);
     }

     // bulk
     if ($screen->id == 'admin_page_leadflow-bulk') {
       wp_enqueue_script('leadflow-bulk', LF_PLUGIN_URL . '/js/lf-admin-bulk.js', array('jquery'), leadflow::$version, true);
     }

     // CSV Import
     if ($screen->id == 'leadsflow-pro_page_leadflow-import' || $screen->id == 'leadsflow-lite_page_leadflow-import') {
       wp_enqueue_script('jquery-ui');
       wp_enqueue_script('jquery-ui-sortable');
       wp_enqueue_script('ui-sortable');
       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-import', LF_PLUGIN_URL . '/js/lf-admin-import.js', array('jquery'), leadflow::$version, true);
     }

     // CSV Export
     if ($screen->id == 'admin_page_leadflow-export') {
       wp_enqueue_script('leadflow-export', LF_PLUGIN_URL . '/js/lf-admin-export.js', array('jquery'), leadflow::$version, true);
     }

     // subscribers
     if ($screen->id == 'leadsflow-pro_page_leadflow-subscribers' || $screen->id == 'leadsflow-lite_page_leadflow-subscribers') {
     }


     // stats
     if ($screen->id == 'leadsflow-pro_page_leadflow-stats' || $screen->id == 'leadsflow-lite_page_leadflow-stats'){
       wp_enqueue_script('jquery-ui');
       wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('jquery-ui-button');
		wp_enqueue_script('jquery-ui-menu');


       wp_enqueue_style('jquery-ui');
       wp_enqueue_style('jquery-ui-datepicker');
	   wp_enqueue_style('jquery-ui-button');
		wp_enqueue_style('jquery-ui-menu');


       wp_enqueue_style( 'jquery-ui-datepicker-style' , '//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css');

       wp_enqueue_script('leadflow-stats', LF_PLUGIN_URL . '/js/lf-admin-stats.js', array('jquery'), leadflow::$version, true);
       wp_enqueue_script('leadflow-google-chart', "//www.gstatic.com/charts/loader.js", false, false, true);
		wp_enqueue_script('moment-js', LF_PLUGIN_URL . '/js/moment.js', array('jquery'), leadflow::$version, true);

		wp_enqueue_style( 'jquery-ui-daterangepicker' , LF_PLUGIN_URL . '/js/daterangepicker/jquery.comiseo.daterangepicker.css', leadflow::$version);
		wp_enqueue_script('jquery-ui-daterangepicker-js', LF_PLUGIN_URL . '/js/daterangepicker/jquery.comiseo.daterangepicker.js', array('jquery'), leadflow::$version, true);
		

       wp_enqueue_style('leadflow-select2', LF_PLUGIN_URL . '/js/select2/css/select2.min.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-select2', LF_PLUGIN_URL . '/js/select2/js/select2.full.js', array('jquery'), leadflow::$version, true);

       // Setup graph
       if (!empty($_GET['stats-view'])) {
         $stats_view = explode('|', $_GET['stats-view']);
       }
	   
	   if (!empty($_GET['stats-view-range'])) {
		  $date_range = json_decode(stripslashes($_GET['stats-view-range']));
	   } else {
		   
		   $date_range = json_decode(stripslashes('{\"start\":\"'.date('Y-m-d', time()-30*24*60*60).'\",\"end\":\"'.date('Y-m-d', time()).'\"}'));
	   }

       if (!empty($stats_view) && !empty($stats_view[1])) {
         global $show_stats;
		 $show_stats=true;
		 
		 
		 if($stats_view[0] == 'ab' ){
		 	$stats = leadflow_stats::get_ab_stats_by_id($stats_view[1], $date_range->start, $date_range->end); 
		 } else {
		 	$stats = leadflow_stats::get_stats_by_id($stats_view[1], $date_range->start, $date_range->end); 
		 }
		 
         wp_localize_script('leadflow-stats', 'lf_stats', $stats);
		 wp_localize_script('leadflow-stats', 'lf_stats_range_start', $date_range->start);
		 wp_localize_script('leadflow-stats', 'lf_stats_range_end', $date_range->end);
       }

     }

    // settings
     if ($screen->id == 'leadsflow-pro_page_leadflow-settings' || $screen->id == 'leadsflow-lite_page_leadflow-settings') {
       wp_enqueue_script('wp-pointer');
       wp_enqueue_style('wp-pointer');
       wp_enqueue_script('jquery-ui-tabs');
	   wp_enqueue_script('leadflow-settings', LF_PLUGIN_URL . '/js/lf-admin-settings.js', array('jquery'), leadflow::$version, true);
       //wp_enqueue_script('leadflow-geoip-download', LF_PLUGIN_URL . '/js/lf-geoip-download.js', array('jquery'), leadflow::$version, true);
       wp_localize_script('leadflow-geoip-download', 'geoip_vars', array('geoip_proxy' => leadflow_geoip::get_geoip_file_status()));
     }

     // all LF pages
     if (strpos($screen->id, 'optin-pages') !== false ||
         strpos($screen->id, 'leadflow') !== false ||
         strpos($screen->id, 'lead-flows') !== false ||
         strpos($screen->id, 'leadsflow-pro') !== false ||
		 strpos($screen->id, 'leadsflow-lite') !== false ||
         strpos($screen->id, 'leadsflow-pro_page_leadflow-settings') !== false ||
		 strpos($screen->id, 'leadsflow-lite_page_leadflow-settings') !== false ||
         strpos($screen->id, 'edit-optin-subscribers') !== false) {

       wp_dequeue_style('jquery-ui-css'); // EDD fix
       wp_enqueue_style('leadflow-admin', LF_PLUGIN_URL . '/css/lf-admin.css', array(), leadflow::$version);
       wp_enqueue_script('leadflow-admin', LF_PLUGIN_URL . '/js/lf-admin.js', array('jquery'), leadflow::$version, true);
     }

     wp_enqueue_style('leadflow-admin-pointers', LF_PLUGIN_URL . '/css/lf-admin-pointers.css', array(), leadflow::$version);
   } // admin_enqueues


 } // leadflow_admin_enqueues