<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_cron extends leadflow {
  static $cron_2h = 'lf_cron_2h';
  static $cron_halfh = 'lf_cron_halfh';
  static $cron_daily = 'lf_cron_daily';

  // some things have to be loaded earlier
  static function plugins_loaded() {
    add_filter('cron_schedules', array(__CLASS__, 'register_cron_intervals'));
  } // plugins_loaded


  // register additional cron interval
  static function register_cron_intervals($schedules) {
    $schedules['lf_everyhalfhour'] = array(
      'interval' => (int) (HOUR_IN_SECONDS / 2),
      'display' => 'Once Every Half Hour');
    $schedules['lf_every2hours'] = array(
      'interval' => HOUR_IN_SECONDS * 2,
      'display' => 'Once Every Two Hours');
    $schedules['lf_every4hours'] = array(
      'interval' => HOUR_IN_SECONDS * 4,
      'display' => 'Once Every Four Hours');
	$schedules['lf_every24hours'] = array(
      'interval' => HOUR_IN_SECONDS * 24,
      'display' => 'Once Every Day');

    return $schedules;
  } // cron_intervals


  // clear cron scheadule
  static function clear() {
    wp_clear_scheduled_hook(self::$cron_2h);
    wp_clear_scheduled_hook(self::$cron_halfh);
    wp_clear_scheduled_hook(self::$cron_daily);
    wp_clear_scheduled_hook('lf_jvzoo_cron');
    wp_clear_scheduled_hook('lf_cron_2h');

  } // clear


  // setup cron jobs
  static function setup() {
    if (!wp_next_scheduled(self::$cron_2h)) {
      wp_schedule_event(current_time('timestamp') + 30, 'lf_every2hours', self::$cron_2h);
    }
    if (!wp_next_scheduled(self::$cron_halfh)) {
      wp_schedule_event(current_time('timestamp') + 35, 'lf_everyhalfhour', self::$cron_halfh);
    }
	if (!wp_next_scheduled(self::$cron_daily)) {
      wp_schedule_event(current_time('timestamp') + 40, 'lf_every24hours', self::$cron_daily);
    }
  } // setup


  // add actions for all crons
  static function add_actions() {
    add_action(self::$cron_2h, array('leadflow_flow_common', 'process_ecommerce_flow_jvzoo_cron'));
    add_action(self::$cron_halfh, array('leadflow_subscribers_common', 'update_stars_bulk_cron'));
	add_action(self::$cron_daily, array('leadflow_templates', 'cron_download_templates'));
  } // register_actions
} // leadflow_cron