<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_external_api extends leadflow {
  static $provider = '';
  static $default_options = array('status' => false, 'api_endpoint' => '', 'api_key' => '', 'username' => '', 'lists' => array(), 'gui_status' => false);
  static $available_providers = array('facebook' => 'Facebook', 'mailchimp' => 'MailChimp', 'mad_mimi' => 'Mad Mimi', 'campaign_monitor' => 'Campaign Monitor', 'activecampaign' => 'ActiveCampaign', 'getresponse' => 'GetResponse', 'aweber' => 'Aweber', 'pushover' => 'PushOver', 'gotowebinar' => 'GoToWebinar', 'infusionsoft' => 'InfusionSoft', 'webinarignition' => 'WebinarIgnition', 'wp' => 'WordPress', 'icontact' => 'iContact', 'rapid_mailer' => 'Rapid Mailer', 'wishlist' => 'WishList Member', 'zapier' => 'Zapier', 'sendlane' => 'SendLane', 'twilio' => 'Twilio', 'fullcontact' => 'FullContact', 'sendinblue' => 'SendInBlue', 'jvzoo' => 'JVZoo', 'ontraport' => 'Ontraport', 'webinarjam' => 'WebinarJam', 'mailpoet' => 'MailPoet', 'mymail' => 'MyMail');


  static function set_provider($provider) {
    $provider = strtolower(trim($provider));

    if (array_key_exists($provider, self::$available_providers)) {
      self::$provider = $provider;
      return true;
    } else {
      trigger_error('Unknown API provider - ' . $provider, E_USER_ERROR);
      return false;
    }
  } // set_provider


  static function update_options($data) {
	if (!self::$provider) {
      trigger_error('Set API provider before using set_option() function.', E_USER_ERROR);
    }

    $options = self::get_options(true);

    if (!isset($options[self::$provider]) || !is_array($options[self::$provider])) {
      $options[self::$provider] = self::$default_options;
    }
    $data = array_merge($options[self::$provider], $data);
    $options[self::$provider] = $data;
    update_option('leadflow_external_api', $options);
  } // update_option


  static function get_options($return_all = false) {
    $options = get_option('leadflow_external_api', array());

    if ($return_all) {
      return $options;
    } else {
      if (!self::$provider) {
        trigger_error('Set API provider before using the get_options() function.', E_USER_ERROR);
      }

      if (isset($options[self::$provider]) && is_array($options[self::$provider])) {
        return $options[self::$provider];
      } else {
        return self::$default_options;
      }
    }
  } // get_option


  static function get_status() {
    $options = self::get_options();

    return $options['status'];
  } // get_status


  static function verify_api($data, $save_data = true) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the verify_api() function.', E_USER_ERROR);
    }

    return call_user_func(array(__CLASS__, self::$provider . '_verify_api'), $data, $save_data);
  } // verify_api


  static function get_lists($refresh = false) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the get_lists() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_get_lists'), $refresh);
  } // get_lists


  static function add_subscriber($list_id, $fields, $options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the add_subscriber() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    if (!is_array($fields)) {
      $fields = array('email' => $fields);
    }

    if (!isset($fields['email']) || !is_email($fields['email'])) {
      return new WP_Error('external_api', 'Invalid email address.');
    }

    if (!in_array($list_id, array_keys(self::get_lists()))) {
      return new WP_Error('external_api', 'Invalid list ID.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_add_subscriber'), $list_id, $fields, $options);
  } // add_subscriber


  static function init_api($extras = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the add_subscriber() function.', E_USER_ERROR);
    }

    if (self::get_status() == false) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_init_api'), $extras);
  } // init_api


  static function send($to, $subject, $message, $options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the send() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_send'), $to, $subject, $message, $options);
  } // send

  static function get_sounds($options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the get_sounds() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_get_sounds'), $options);
  } // get_sounds


  static function get_person($email, $options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the get_person() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_get_person'), $email, $options);
  } // get_person


  static function get_person_url($email, $options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the get_person_url() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_get_person_url'), $email, $options);
  } // get_person_url
  static function get_transactions($options = array()) {
    if (!self::$provider) {
      trigger_error('Set API provider before using the get_transaction() function.', E_USER_ERROR);
    }

    if (!self::get_status()) {
      return new WP_Error('external_api', 'API is not verified.');
    }

    return call_user_func(array(__CLASS__, self::$provider . '_get_transactions'), $options);
  } // get_transactions

  // ******* MailChimp ************

  static function mailchimp_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/mailchimp.api.php';

    if (!isset($data['api_key']) || empty($data['api_key'])) {
      return false;
    }

    $api = new MCAPI($data['api_key']);
    $api->lists();

    if ($api->errorCode) {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'MailChimp', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
    }

    return $verified;
  } // mailchimp_verify_api


  static function mailchimp_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $retval = $api->lists();
      if (!$api->errorCode) {
        foreach ($retval['data'] as $list) {
          $lists[$list['id']] = $list['name'];
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // mailchimp_get_lists


  static function mailchimp_init_api() {
    require_once LF_PLUGIN_PATH . 'api/mailchimp.api.php';
    $options = self::get_options();

    $api = new MCAPI($options['api_key']);

    return $api;
  } // mailchimp_init_api


  static function mailchimp_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    $member_info = $api->listMemberInfo($list_id, $fields['email']);
    if (isset($member_info['errors']) && $member_info['errors'] == 1) {
      $email = $fields['email'];
      unset($fields['email']);
      $new = array();
      foreach ($fields as $key => $val) {
        $new[strtoupper($key)] = $val;
      }
      $tmp = $api->listSubscribe($list_id, $email, $new, 'html', false);

      if($tmp === true) {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list. ' . $api->errorMessage);
      }
    } else {
      return false;
    }
  } // mailchimp_add_subscriber

  // ******* MailChimp ************

  // ******* Mad Mimi ************

  static function mad_mimi_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/MadMimi.class.php';

    if (!isset($data['username']) || !isset($data['api_key']) || empty($data['username']) || empty($data['api_key'])) {
      return false;
    }

    $api = new MadMimi($data['username'], $data['api_key']);

    if ($api->lists() == 'Unable to authenticate' || $api->lists() == false) {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Mad Mimi', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'lists' => array()));
    }

    return $verified;
  } // mad_mimi_verify_api


  static function mad_mimi_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $tmp = $api->Lists();
      if ($tmp != 'Unable to authenticate') {
        $tmp = new SimpleXMLElement($tmp);
        foreach ($tmp as $list) {
          $lists[(string) $list->attributes()->id] = (string) $list->attributes()->name;
        }
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // mad_mimi_get_lists


  static function mad_mimi_init_api() {
    require_once LF_PLUGIN_PATH . 'api/MadMimi.class.php';
    $options = self::get_options();

    $api = new MadMimi($options['username'], $options['api_key']);

    return $api;
  } // mad_mimi_init_api


  static function mad_mimi_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    $check = $api->Memberships($fields['email']);
    if ($check) {
      $check = new SimpleXMLElement($check);
      foreach ($check as $tmp) {
        if ($list_id == (string) $tmp->attributes()->id) {
          return false;
        }
      }
    }

    $fields['add_list'] = $list_id;
    $subscribe = $api->AddUser($fields, 0);

    if ($subscribe) {
      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list. ');
    }
  } // mad_mimi_add_subscriber

  // ******* Mad Mimi ********************

  // ******* Campaign Monitor ************

  static function campaign_monitor_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/campaignmonitor_api/csrest_general.php';
    $username = '';

    if (!isset($data['api_key']) || empty($data['api_key'])) {
      return false;
    }

    $api = new CS_REST_General(array('api_key' => $data['api_key']));

    $result = $api->get_clients();
    if($result->was_successful()) {
      $verified = true;
      $username = $result->response[0]->ClientID;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' =>'Campaign Monitor', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $username, 'lists' => array()));
    }

    return $verified;
  } // campaign_monitor_verify_api


  static function campaign_monitor_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api(array('type' => 'clients'));

      $result = $api->get_lists();
      if ($result->was_successful()) {
        foreach ($result->response as $list) {
          $lists[$list->ListID] = $list->Name;
        }
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // campaign_monitor_get_lists


  static function campaign_monitor_init_api($extras) {
    $options = self::get_options();

    if ($extras['type'] == 'clients') {
      require_once LF_PLUGIN_PATH . 'api/campaignmonitor_api/csrest_clients.php';

      $api = new CS_REST_Clients($options['username'], array('api_key' => $options['api_key']));
    } elseif ($extras['type'] == 'subscribers') {
      require_once LF_PLUGIN_PATH . 'api/campaignmonitor_api/csrest_subscribers.php';

      $api = new CS_REST_Subscribers($extras['list_id'], array('api_key' => $options['api_key']));
    } else {
      user_error('Unknown API type for Campaign Monitor', E_USER_ERROR);
    }

    return $api;
  } // campaign_monitor_init_api


  static function campaign_monitor_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api(array('type' => 'subscribers', 'list_id' => $list_id));
    $fields2 = array();

    if (!isset($fields['name'])) {
      $fields['name'] = '';
    }

    $check = $api->get($fields['email']);
    if($check->was_successful()) {
      return false;
    }

    foreach ($fields as $key => $val) {
      if ($key == 'email' || $key == 'name') {
         continue;
      }
      $fields2[] = array('Key' => $key, 'Value' => $val);
    }

    $result = $api->add(array('EmailAddress' => $fields['email'], 'Name' => $fields['name'], 'CustomFields' => $fields2, 'Resubscribe' => false));

    if($result->was_successful()) {
      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list. ' . $result->response->Message);
    }
  } // campaign_monitor_add_subscriber

  // ******* Campaign Monitor ************

  // ******* ActiveCampaign ********************

  static function activecampaign_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/activecampaign_api/ActiveCampaign.class.php';

    if (!isset($data['username']) || !isset($data['api_key']) || empty($data['username']) || empty($data['api_key'])) {
      return false;
    }

    $api = new ActiveCampaign($data['username'], $data['api_key']);

    if ($api->credentials_test()) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'ActiveCampaign', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'lists' => array()));
    }

    return $verified;
  } // activecampaign_verify_api


  static function activecampaign_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $tmp = $api->api("list/list?ids=all");
      if ($tmp) {
        foreach ($tmp as $tmp2) {
          if (!is_object($tmp2)) {
            continue;
          }
          $lists[(string) $tmp2->id] = $tmp2->name;
        }
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // activecampaign_get_lists


  static function activecampaign_init_api() {
    require_once LF_PLUGIN_PATH . 'api/activecampaign_api/ActiveCampaign.class.php';
    $options = self::get_options();

    $api = new ActiveCampaign($options['username'], $options['api_key']);

    return $api;
  } // activecampaign_init_api


  static function activecampaign_add_subscriber($list_id, $fields, $options) {
    $contact = array();
    $api = self::init_api();

    foreach ($fields as $field => $val) {
	   if ($field == 'email' || $field == 'first_name' || $field == 'last_name'  || $field == 'orgname'  || $field == 'tags'  || $field == 'ip4') {
		 $tmp = $field;
	   } else {
		 $tmp = strtoupper($field);
		 $tmp = "field[%{$tmp}%,0]";	
	   }
	   $contact[$tmp] = $val;
	  
	 } // foreach
    $contact["p[{$list_id}]"] = $list_id;
    $contact["status[{$list_id}]"] = 1;

    $exists = $api->api('contact/view?email=' . $fields['email'], $contact);
    if (!isset($exists->id)) {
      $add = $api->api('contact/add', $contact);
      if ((int) $add->success) {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list. ');
      }
     } else {
       return false;
     }
  } // activecampaign_add_subscriber

  // ******* ActiveCampaign ****************

  // ******* GetResponse *******************

  static function getresponse_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/getresponse.api.php';

    if (!isset($data['api_key']) || empty($data['api_key'])) {
      return false;
    }

    $api = new GetResponse($data['api_key']);

    if ($api->ping()) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'GetResponse', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
    }

    return $verified;
  } // getresponse_verify_api


  static function getresponse_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $result = (array) $api->getCampaigns();
      if ($result) {
        foreach ($result as $id => $data) {
          $lists[$id] = $data->name;
        }
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // getresponse_get_lists


  static function getresponse_init_api() {
    require_once LF_PLUGIN_PATH . 'api/getresponse.api.php';
    $options = self::get_options();

    $api = new GetResponse($options['api_key']);

    return $api;
  } // getresponse_init_api


  static function getresponse_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    $test = (array)$api->getContactsByEmail($fields['email']);
    if (sizeof($test)) {
      return false;
    }

    if (!isset($fields['name'])) {
      $fields['name'] = '';
    }
    $fields2 = $fields;
    unset($fields2['name'], $fields2['email']);

    $subscribe = $api->addContact($list_id, $fields['name'], $fields['email'], 'standard', 0, $fields2);

    if (@$subscribe->queued == 1) {
      return true;
    } elseif ($subscribe == -1) {
      return false;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list.');
    }
  } // getresponse_add_subscriber

  // ******* GetResponse ************
  // ******* Aweber *****************

  static function aweber_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/aweber_api/aweber_api.php';
    $keys = array();

    if (!isset($data['api_key']) || empty($data['api_key'])) {
      return false;
    }

    if (!isset($data['app_id'])) {
      $data['app_id'] = '';
    }

    try {
      $auth = AWeberAPI::getDataFromAweberID($data['api_key']);
      if ($auth) {
        list($keys['consumer_key'], $keys['consumer_secret'], $keys['access_key'], $keys['access_secret']) = $auth;
        $verified = true;
      } else {
        $verified = false;
      }
    } catch(AWeberAPIException $exc) {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Aweber', 'status' => $verified, 'api_key' => $data['api_key'], 'keys' => $keys, 'lists' => array(), 'app_id' => $data['app_id']));
    }

    return $verified;
  } // aweber_verify_api


  static function aweber_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      if ($api->lists) {
        foreach ($api->lists as $list) {
          $lists[$list->id] = $list->name;
        }
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // aweber_get_lists


  static function aweber_init_api() {
    require_once LF_PLUGIN_PATH . 'api/aweber_api/aweber_api.php';
    $options = self::get_options();

    try {
      $aweber = new AWeberAPI($options['keys']['consumer_key'], $options['keys']['consumer_secret']);
      $account = $aweber->getAccount($options['keys']['access_key'], $options['keys']['access_secret']);
    } catch(AWeberAPIException $exc) {
      return new WP_Error('external_api', 'Unable to authenticate on Aweber API.');
    }

    return $account;
  } // aweber_init_api


  static function aweber_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    if (is_wp_error($api)) {
      return $api;
    }

    try {
      $listURL = '/accounts/' . $api->id . '/lists/' . $list_id;
      $list = $api->loadFromUrl($listURL);

      if (!isset($fields['name'])) {
        $fields['name'] = '';
      }

      $params = array('email' => $fields['email'], 'name' => $fields['name']);
      unset($fields['email'], $fields['name']);
      if ($fields) {
        $params['custom_fields'] = $fields;
      }

      $subscribers = $list->subscribers;
      $new_subscriber = $subscribers->create($params);

      return true;
    } catch(AWeberAPIException $exc) {
      if (strpos($exc->message, 'already subscribed') !== false) {
        return false;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list. ' . $exc->message);
      }
     }
  } // aweber_add_subscriber

  // ******* Aweber ************

  // ******* Pushover ************

  static function pushover_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/pushover.php';

    if (!isset($data['api_key']) || empty($data['api_key'])) {
      return false;
    }

    $api = new Pushover();
    $api->setToken($data['api_key']);
    $api->setTitle('test');
    $api->setMessage('test');
    $api->setDebug(true);
    $api->setUser('test');
    $res = $api->send();
    if($res['output']->token == 'invalid') {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Pushover', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
    }

    return $verified;
  } // pushover_verify_api


  static function pushover_init_api() {
    require_once LF_PLUGIN_PATH . 'api/pushover.php';
    $options = self::get_options();

    $api = new Pushover();
    $api->setToken($options['api_key']);

    return $api;
  } // pushover_init_api

  static function pushover_get_lists($refresh = false) {
    return array();
  } // pushover_init_api


  static function pushover_send($user, $title, $message, $options = array()) {
    $api = self::init_api();
    $api->setTimestamp(time());

    if (empty($message) || empty($user)) {
      return new WP_Error('external_api', 'User token and message values are required.');
    }

    $options = array_merge(array('sound' => '', 'url' => '', 'url_title' => ''), $options);
    $api->setTitle($title);
    $api->setSound($options['sound']);
    $api->setUrl($options['url']);
    $api->setUrlTitle($options['url_title']);
    $api->setDebug(true);

    $user = trim($user);
    $tmp = explode(':', $user);
    if (sizeof($tmp) == 2) {
      $user = trim($tmp[0]);
      $device = trim($tmp[1]);
    } else {
      $user = trim($user);
      $device = '';
    }

    $api->setUser($user);
    $api->setDevice($device);
    $api->setMessage($message);
    $send = $api->send();

    if ((int) $send['output']->status) {
      return true;
    } else {
      return new WP_Error('external_api', 'Push message not sent - ' . (string) $send['output']->errors->error);
    }
  } // pushover_send

  static function pushover_get_sounds($options = array()) {
    $sounds = array('pushover' => 'Pushover (default)',
                     'bike' => 'Bike',
                     'bugle' => 'Bugle',
                     'cashregister' => 'Cash Register',
                     'classical' => 'Classical',
                     'cosmic' => 'Cosmic',
                     'falling' => 'Falling',
                     'gamelan' => 'Gamelan',
                     'incoming' => 'Incoming',
                     'intermission' => 'Intermission',
                     'magic' => 'Magic',
                     'mechanical' => 'Mechanical',
                     'pianobar' => 'Piano Bar',
                     'siren' => 'Siren',
                     'spacealarm' => 'Space Alarm',
                     'tugboat' => 'Tug Boat',
                     'alien' => 'Alien Alarm (long)',
                     'climb' => 'Climb (long)',
                     'persistent' => 'Persistent (long)',
                     'echo' => 'Pushover Echo (long)',
                     'updown' => 'Up Down (long)',
                     'none' => 'None (silent)');

    return $sounds;
  } // pushover_get_sounds

  // ******* Pushover *************

  // ******* GoToWebinar ************

  static function gotowebinar_verify_api($data, $save_data = true) {
    if (!isset($data['api_key']) || empty($data['api_key']) ||
        !isset($data['username']) || empty($data['username']) ||
        !isset($data['password']) || empty($data['password'])) {
      return false;
    }
    
	$response = wp_remote_post('https://api.citrixonline.com/oauth/access_token', array(
		'body' => array('grant_type' => 'password', 'client_id' => $data['api_key'], 'user_id' => $data['username'], 'password' => $data['password']),
		)
	);
    
	if (!is_wp_error($response) && $response['response']['code'] == 200) {
      $response = json_decode($response['body']);
      if ($response->access_token && $response->organizer_key) {
        $verified = true;
      } else {
        $verified = false;
      }
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'GoToWebinar', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'password' => $data['password'], 'access_token' => $response->access_token, 'organizer_key' => $response->organizer_key,  'lists' => array()));
    }

    return $verified;
  } // gotowebinar_verify_api


  static function gotowebinar_get_lists($refresh = false) {
    $options = self::get_options();

    if (!$refresh) {
      return $options['lists'];
    } else {
      $lists = array();
      $response = wp_remote_get('https://api.citrixonline.com/G2W/rest/organizers/' . $options['organizer_key'] . '/upcomingWebinars', array('headers' => 'Authorization: OAuth oauth_token=' . $options['access_token']));

      if (!is_wp_error($response) && $response['response']['code'] == 200) {
        $response = json_decode(preg_replace('/webinarKey":(\d+)/', 'webinarKey":"\1"', $response['body']));
        if (is_array($response)) {
          foreach ($response as $tmp) {
            $lists[(string) $tmp->webinarKey] = $tmp->subject;
          }
        }
      }

      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // gotowebinar_get_lists


  static function gotowebinar_add_subscriber($list_id, $fields, $options) {
    $options = self::get_options();

    if (!isset($fields['firstName']) || !$fields['firstName'] ||
        !isset($fields['lastName']) || !$fields['lastName']) {
      return new WP_Error('external_api', 'Fields firstName and lastName are required.');
    }
	
	
    $ch = curl_init();
    $opts = array(CURLOPT_CONNECTTIMEOUT => 10, CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 60, CURLOPT_SSL_VERIFYHOST => false, CURLOPT_SSL_VERIFYPEER => false);
    $opts[CURLOPT_URL] = 'https://api.citrixonline.com/G2W/rest/organizers/' . $options['organizer_key'] . '/webinars/' . $list_id . '/registrants';
    $opts[CURLOPT_HTTPHEADER] = array('Accept: application/vnd.citrix.g2wapi-v1.1+json', 'Content-Type: application/json', 'Authorization: OAuth oauth_token=' . $options['access_token']);
    if(empty($fields['city'])) $fields['city']="n/a";
	$opts[CURLOPT_POSTFIELDS] = json_encode($fields);

    curl_setopt_array($ch, $opts);
    $result = curl_exec($ch);
    
	
    if ($result === false) {
      $tmp = curl_error($ch);
      curl_close($ch);
      return new WP_Error('external_api', 'Unable to add email address to webinar. ' . $tmp);
    }

    curl_close($ch);
    $result = json_decode($result);

    if (isset($result->description) || !$result->registrantKey) {
      return false;
    } else {
      return true;
    }
  } // gotowebinar_add_subscriber

  // ******* GoToWebinar ************

  // ******* Infusionsoft ************

  static function infusionsoft_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/infusionsoft/isdk.php';

    if (!isset($data['api_key']) || empty($data['api_key']) ||
       !isset($data['username']) || empty($data['username'])) {
      return false;
    }

    $api = new iSDK();
    $api->enableLogging(false);

    try {
      $test = $api->cfgCon($data['username'], $data['api_key']);
    } catch (iSDKException $e) {
      $test = false;
    }

    if ($test) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Infusionsoft', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'lists' => array()));
    }

    return $verified;
  } // infusionsoft_verify_api


  static function infusionsoft_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $groups = $api->dsquery("ContactGroup", 1000, 0, array('GroupName' => '%'), array('Id', 'GroupName'), 'GroupName');

      if (sizeof($groups)) {
        foreach ($groups as $group) {
          $lists[$group['Id']] = $group['GroupName'];
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // infusionsoft_get_lists


  static function infusionsoft_init_api() {
    require_once LF_PLUGIN_PATH . 'api/infusionsoft/isdk.php';
    $options = self::get_options();

    $api = new iSDK();
    $api->cfgCon($options['username'], $options['api_key']);

    return $api;
  } // infusionsoft_init_api


  static function infusionsoft_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();
    $fields2 = array();

    foreach ($fields as $key => $val) {
      $fields2[ucfirst($key)] = $val;
    }

    $fields = $fields2;

    $test = $api->findByEmail($fields['Email'], array('Id'));
    if (sizeof($test)) {
      return false;
    }

    $contact_id = $api->addCon($fields);
    if ($contact_id && strpos($contact_id, 'ERROR') === false) {
      $api->grpAssign($contact_id, $list_id);
      $api->optIn($fields['Email'], 'Subscribed via LeadsFlow Pro.');

      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list. ' . $contact_id);
    }
  } // infusionsoft_add_subscriber

  // ******* Infusionsoft ************

  // ******* WebinarIgnition ************

  static function webinarignition_verify_api($data, $save_data = true) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'webinarignition_leads_new';

    $test = $wpdb->get_var($wpdb->prepare('SHOW TABLES LIKE %s', $table_name));

    if (defined('WEBINARIGNITION_URL') && $test) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'WebinarIgnition', 'status' => $verified, 'api_key' => '', 'lists' => array()));
    }

    return $verified;
  } // webinarignition_verify_api


  static function webinarignition_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      global $wpdb;
      $lists = array();
      $table_name = $wpdb->prefix . 'webinarignition';

      $apps = $wpdb->get_results('SELECT ID, appname FROM ' . $table_name . ' ORDER BY appname ASC');
      foreach ($apps as $app) {
        $lists[$app->ID] = $app->appname;
      }

      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // webinarignition_get_lists


  static function webinarignition_init_api() {
    return true;
  } // webinarignition_init_api


  static function webinarignition_add_subscriber($list_id, $fields, $options) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'webinarignition_leads_new';

    $check = $wpdb->get_var($wpdb->prepare('SELECT ID FROM ' . $table_name . ' WHERE email = %s and app_id = %d', $fields['email'], $list_id));

    if ($check) {
      return false;
    }

    $fields2 = array('app_id' => $list_id, 'email' => $fields['email'], 'created' => date('F j, Y'), 'trk3' => leadflow::getUserIP(), 'trk1' => 'Optin', 'event' => 'No', 'replay' => 'No');

    $fields = shortcode_atts(array('name' => '', 'phone' => '', 'skype' => ''), $fields);
    $fields = array_merge($fields, $fields2);

    $new = $wpdb->insert($table_name, $fields);

    if ($new) {
      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list.');
    }
  } // webinarignition_add_subscriber

  // ******* WebinarIgnition ************

  // ******* WordPress ******************

  static function wp_verify_api($data, $save_data = true) {
    $verified = true;

    if ($save_data) {
      self::update_options(array('name' => 'WordPress users', 'status' => $verified, 'api_key' => '', 'lists' => array()));
    }

    return $verified;
  } // wp_verify_api


  static function wp_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();

      $roles = array_reverse(get_editable_roles());
      foreach ($roles as $role => $details ) {
        $name = translate_user_role($details['name']);
        $lists[$role] = $name;
      }

      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // wp_get_lists


  static function wp_init_api() {
    return true;
  } // wp_init_api


  static function wp_add_subscriber($list_id, $fields, $options) {
    if (get_user_by('email', $fields['email'])) {
      return false;
    }
    if (!isset($fields['user_login']) || !$fields['user_login']) {
      return new WP_Error('external_api', 'Field user_login is not set.');
    }
    if (username_exists($fields['user_login'])) {
      return false;
    }

    $fields['user_email'] = $fields['email'];
    unset($fields['id'], $fields['ID'], $fields['email']);
    if (!isset($fields['user_pass'])) {
      $fields['user_pass'] = wp_generate_password(8, false);
    }
    $fields['role'] = $list_id;

    $tmp = wp_insert_user($fields);
    if (is_wp_error($tmp)) {
      return new WP_Error('external_api', 'Unable to add new user. ' . $tmp->get_error_message());
    } else {
      wp_new_user_notification($tmp, $fields['user_pass']);
      return true;
    }
  } // wp_add_subscriber

  // ******* WordPress ************
  // ******* iContact *************

  static function icontact_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/iContactApi.php';

    if (empty($data['api_key']) || empty($data['username']) || empty($data['password'])) {
      return false;
    }

    try {
      iContactApi::getInstance()->setConfig(array(
        'appId'       => $data['api_key'],
        'apiUsername' => $data['username'],
        'apiPassword' => $data['password']
      ));
      $api = iContactApi::getInstance();
      $api = $api->getLists();

      $verified = true;
    } catch (Exception $e) {
        $verified = false;
        //var_dump($api->getErrors());
    }

    if ($save_data) {
      self::update_options(array('name' => 'iContact', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'password' => $data['password'], 'lists' => array()));
    }

    return $verified;
  } // icontact_verify_api


  static function icontact_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $tmp = $api->getLists();
      if ($tmp) {
        foreach ($tmp as $key => $list) {
          $lists[$list->listId] = $list->name;
        }
      }

      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // icontact_get_lists


  static function icontact_init_api() {
    require_once LF_PLUGIN_PATH . 'api/iContactApi.php';
    $options = self::get_options();

    iContactApi::getInstance()->setConfig(array(
        'appId'       => $options['api_key'],
        'apiUsername' => $options['username'],
        'apiPassword' => $options['password']
      ));
    $api = iContactApi::getInstance();

    return $api;
  } // icontact_init_api


  static function icontact_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    if (!isset($fields['name'])) {
      $fields['name'] = '';
    }
	
    try {
      $contact = $api->addContact($fields['email'], 'normal', @$fields['prefix'], @$fields['firstname'], @$fields['lastname'], @$fields['suffix'], @$fields['street'], @$fields['street2'], @$fields['city'], @$fields['state'], @$fields['postalcode'], @$fields['phone'], @$fields['fax'], @$fields['business']);
      if ($contact->contactId) {
        $api->subscribeContactToList($contact->contactId, $list_id);
      } else {
        return false;
      }
    } catch (Exception $oException) {
        return new WP_Error('external_api', 'Unable to add email address to the list. ' . $api->getErrors());
    }
    return true;
  } // icontact_add_subscriber

  // ******* iContact ************
  // ******* Rapid Mailer ************

  static function rapid_mailer_verify_api($data, $save_data = true) {
    if (defined('IMSCRAPIDMAILER_SYSTEM')) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Rapid Mailer', 'status' => $verified, 'api_key' => '', 'lists' => array()));
    }

    return $verified;
  } // rapid_mailer_verify_api


  static function rapid_mailer_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      global $wpdb;
      $table = $wpdb->prefix . 'newsmailinglists';

      $res = $wpdb->get_results($wpdb->prepare('SELECT id, title FROM ' . $table . ' WHERE privatelist = %s', array('N')));

      if ($res) {
        foreach ($res as $list) {
          $lists[$list->id] = $list->title;
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // rapid_mailer_get_lists


  static function rapid_mailer_init_api() {
    return true;
  } // rapid_mailer_init_api


  static function rapid_mailer_add_subscriber($list_id, $fields, $options) {
    global $wpdb;
    $table = $wpdb->prefix . 'newssubscribers';
    $table2 = $wpdb->prefix . 'newssubscriberslists';

    $user_check = (int) $wpdb->get_var($wpdb->prepare('SELECT id FROM ' . $table . ' AS subs LEFT JOIN '. $table2 . ' as lists ON subs.id = lists.subscriber_id WHERE subs.email = %s AND lists.list_id = %d', array($fields['email'], $list_id)));

    if($user_check) {
      return false;
    }

    if (!isset($fields['name'])) {
      $fields['name'] = '';
    }

    $wpdb->insert($table, array('email' => $fields['email'],
                                'name' => $fields['name'],
                                'ip_address' => leadflow::getUserIP(),
                                'created' => current_time('mysql'),
                                'modified' => current_time('mysql')
                                ), '%s');

    if ($wpdb->insert_id) {
      $wpdb->insert($table2, array('subscriber_id' => $wpdb->insert_id,
                                   'list_id' => $list_id,
                                   'active' => 'Y',
                                   'paid_date' => date('Y-m-d'),
                                   'created' => current_time('mysql'),
                                   'modified' => current_time('mysql')
                                   ), array('%d', '%d', '%s', '%s', '%s'));
      if ($wpdb->insert_id) {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list.');
      }
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list.');
    }
  } // rapid_mailer_add_subscriber

  // ******* Rapid Mailer ************
  // ******* WishList ************

  static function wishlist_verify_api($data, $save_data = true) {
    if (function_exists('wlmapi_add_member')) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'WishList Member', 'status' => $verified, 'api_key' => '', 'lists' => array()));
    }

    return $verified;
  } // wishlist_verify_api


  static function wishlist_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();

      $levels = wlmapi_get_levels();

      if ($levels['success'] && $levels['levels']['level']) {
        foreach ($levels['levels']['level'] as $list) {
          $lists[$list['id']] = $list['name'];
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // wishlist_get_lists


  static function wishlist_init_api() {
    return true;
  } // wishlist_init_api


  static function wishlist_add_subscriber($list_id, $fields, $options) {
    global $wpdb;

    if (empty($fields['user_login']) || username_exists($fields['user_login']) || email_exists($fields['email'])) {
      return new WP_Error('external_api', 'Username or email already exists.');
    }
	
	$default_wl_fields=array('email','user_login','user_nicename','company','address1','address2','city','state','zip','country');
    foreach( $fields as $key=>$value ){
		if( !in_array($key, $default_wl_fields) ){
			$fields['custom_'.$key]=$value;
			unset($fields[$key]);
		}
	} 

    if (empty($fields['user_pass'])) {
      $fields['user_pass'] = wp_generate_password(8, false);
    }
	
	
	 
    $fields['user_email'] = $fields['email'];
	unset($fields['email']);
	
	
	
    $fields['SendMail'] = true;
    $fields['Levels'] = array($list_id);

    $member = wlmapi_add_member($fields);

    if ($member && $member['success'] == 1) {
      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add new user.');
    }
  } // wishlist_add_subscriber

  // ******* WishList ************
  // ******* Zapier ******************

  static function zapier_verify_api($data, $save_data = true) {
    $res = wp_remote_get('https://zapier.com/hooks/catch/test/', array('sslverify' => false));
    $res = wp_remote_retrieve_body($res);

    if (!is_wp_error($res)) {
      $res = json_decode($res);
      if (!empty($res->status) && $res->status == 'success') {
        $verified = true;
      } else {
        $verified = false;
      }
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Zapier', 'status' => $verified, 'api_key' => '', 'lists' => array()));
    }

    return $verified;
  } // zapier_verify_api


  static function zapier_get_lists($refresh = false) {
    return array();
  } // zapier_get_lists


  static function zapier_init_api() {
    return true;
  } // zapier_init_api


  static function zapier_add_subscriber($list_id, $fields, $options) {
    return false;
  } // zapier_add_subscriber

  static function zapier_send($webhook_url, $fields = array(), $message = '', $options = array()) {
    if (empty($webhook_url)) {
      return false;
    }

    $res = wp_remote_post($webhook_url, array('sslverify' => false, 'body' => $fields));

    if (!is_wp_error($res)) {
      $res = wp_remote_retrieve_body($res);
      $res = json_decode($res);

      if (!empty($res->status) && $res->status == 'success') {
        return true;
      } else {
        return new WP_Error('external_api', 'Zap returned the following request status: ' . $res->status);
      }
    } else {
      return new WP_Error('external_api', 'Unable to send Zap. ' . $res->get_error_message());
    }
  } // zapier_send

  // ******* Zapier ************

  // ******* Sendlane ************

  static function sendlane_verify_api($data, $save_data = true) {
    if (empty($data['username']) || empty($data['api_key']) || empty($data['api_endpoint'])) {
      return false;
    }

    $res = wp_remote_post('https://'.$options['api_endpoint'].'.sendlane.com/api/v1/lists', array('body' => array('api' => $data['api_key'], 'hash' => md5($data['username'] . $data['api_key']))));
	
	$lists=array();
	
    if (!is_wp_error($res)) {
      $res = json_decode($res['body']);
	  foreach ($res as $list) {
            $lists[$list->list_id] = $list->list_name;
          }
      $verified = true;
    } else {
      $verified = false;
    }

    if (isset($res->error)) {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
		
		$sendlane_data=array( 
			'name' => 'Sendlane', 
			'status' => $verified, 
			'api_key' => $data['api_key'], 
			'api_endpoint' => $data['api_endpoint'], 
			'username' => $data['username'], 
			'lists' => array()
		);
		self::update_options($sendlane_data);
    }

    return $verified;
  } // sendlane_verify_api


  static function sendlane_get_lists($refresh = false) {
    $options = self::get_options();

    if (!$refresh) {
      return $options['lists'];
    } else {
      $lists = array();

      $res = wp_remote_post('https://'.$options['api_endpoint'].'.sendlane.com/api/v1/lists', array('body' => array('api' => $options['api_key'], 'hash' => md5($options['username'] . $options['api_key']))));
      
	   
      if (!is_wp_error($res)) {
        $res = json_decode($res['body']);
        if (!isset($res->error)) {
          foreach ($res as $list) {
            $lists[$list->list_id] = $list->list_name;
          }
        } else {
          $lists = array();
        }
      } else {
        $lists = array();
      }
    }
    self::update_options(array('lists' => $lists));

    return $lists;
  } // sendlane_get_lists


  static function sendlane_init_api() {
    return true;
  } // sendlane_init_api


  static function sendlane_add_subscriber($list_id, $fields, $options) {
    $_options = self::get_options();

    $email = trim(@$fields['firstname'] . ' ' . @$fields['lastname'] . ' <' . $fields['email'] . '>');

	$res = wp_remote_post('https://'.$_options['api_endpoint'].'.sendlane.com/api/v1/list-subscribers-add', array('body' => array('api' => $_options['api_key'], 'hash' => md5($_options['username'] . $_options['api_key']), 'email' => $email, 'list_id' => (int) $list_id)));

    
    if (!is_wp_error($res)) {
      $res = json_decode($res['body']);
      if (isset($res->error)) {
        return new WP_Error('external_api', 'Unable to add email address to the list. ' . $res->error);
      } else {
        return true;
      }
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list. Unknown error.');
    }
  } // sendlane_add_subscriber

  // ******* Sendlane ********************

  // ******* Twilio ************

  static function twilio_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/Twilio.php';

    if (empty($data['username']) || empty($data['api_key'])) {
      return false;
    }

    $http = new Services_Twilio_TinyHttp('https://api.twilio.com', array('curlopts' => array(CURLOPT_SSL_VERIFYPEER => false,CURLOPT_SSL_VERIFYHOST => false)));
    $api = new Services_Twilio($data['username'], $data['api_key'], '2010-04-01', $http);
  
    try {
      $account = $api->accounts->get($data['username']);
      if ($account->status == 'active') {
        $verified = true;
      } else {
        $verified = false;
      }
    } catch (Services_Twilio_RestException $e) {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Twilio', 'status' => $verified, 'api_key' => $data['api_key'], 'username' => $data['username'], 'lists' => array()));
    }

    return $verified;
  } // twilio_verify_api


  static function twilio_get_lists($refresh = false) {
    $options = self::get_options();

    if (!$refresh) {
      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      foreach ($api->account->incoming_phone_numbers as $number) {
        if (!$number->friendly_name) {
          $lists[$number->phone_number] = $number->phone_number;
        } else {
          $lists[$number->phone_number] = $number->friendly_name;
        }
      }
    }
    self::update_options(array('lists' => $lists));

    return $lists;
  } // twilio_get_lists


  static function twilio_init_api() {
    require_once LF_PLUGIN_PATH . 'api/Twilio.php';
    $options = self::get_options();

    $http = new Services_Twilio_TinyHttp('https://api.twilio.com', array('curlopts' => array(CURLOPT_SSL_VERIFYPEER => false,CURLOPT_SSL_VERIFYHOST => false)));
    $api = new Services_Twilio($options['username'], $options['api_key'], '2010-04-01', $http);

    return $api;
  } // twilio_init_api


   static function twilio_send($to, $from, $message, $options = array()) {
    $api = self::init_api();
    //var_dump($options);

    try {
	  $sms = $api->account->messages->sendMessage($from, $to, $message);
      if ($sms->status == 'sent' || $sms->status == 'queued') {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to send SMS. Message status: ' . $sms->status);
      }
    } catch (Services_Twilio_RestException $e) {
      return new WP_Error('external_api', 'Unable to send SMS. ' . $e->getMessage());
    }
  } // twilio_add_subscriber

  // ******* Twilio ********************


  // ******* FullContact ************

  static function fullcontact_verify_api($data, $save_data = true) {
    if (empty($data['api_key'])) {
      return false;
    }

    $res = wp_remote_get('https://api.fullcontact.com/v2/stats.json?apiKey=' . $data['api_key']);
    $res = wp_remote_retrieve_body($res);
    $res = json_decode($res, true);
    if (empty($res['status']) || $res['status'] != 200) {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'FullContact', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
    }

    return $verified;
  } // fullcontact_verify_api


  static function fullcontact_get_person_url($email, $extra = array()) {
    $options = self::get_options();

    $email = trim($email);
    if (!is_email($email)) {
      return '';
    }

    $tmp = '//api.fullcontact.com/v2/person.html?apiKey=' . $options['api_key'] . '&email=' . urlencode($email) . '&css=' . urlencode(LF_PLUGIN_URL . '/css/fullcontact-template.css');
	
    return $tmp;
  } // fullcontact_get_person_url
  static function fullcontact_get_person($email, $extra = array()) {
    $options = self::get_options();

    $email = trim($email);
    if (!is_email($email)) {
      return new WP_Error('external_api', 'Invalid email address.');
    }

    // check cache
    $tmp = get_transient('lf_fullcontact_' . $email);
    if ($tmp) {
      $tmp['_cached'] = true;
      return $tmp;
    }

    $res = wp_remote_get('https://api.fullcontact.com/v2/person.json?apiKey=' . $options['api_key'] . '&email=' . urlencode($email));
    $res = wp_remote_retrieve_body($res);
    $res = json_decode($res, true);

    if (empty($res['status'])) {
      return new WP_Error('external_api', 'Unknown return status.');
    } elseif ($res['status'] == 202) {
      // request queued
      return array();
    } elseif ($res['status'] == 200) {
      // results found
      set_transient('lf_fullcontact_' . $email, $res, DAY_IN_SECONDS * 30);
      return $res;
    } elseif ($res['status'] == 404) {
      // no results
      return false;
    } elseif ($res['status'] == 400 || $res['status'] == 422) {
      // wrong request or something simmilar
      return new WP_Error('external_api', 'Malformed request.');
    } elseif ($res['status'] == 403) {
      // wrong key or limit reached
      return new WP_Error('external_api', 'Wrong API key, or API limit reached.');
    } else {
      // other
      return new WP_Error('external_api', 'Unknown error. FullContact is probably down.');
    }

    return false;
  } // fullcontact_get_details


  static function fullcontact_get_lists($refresh = false) {
    return array();
  } // fullcontact_get_lists


  static function fullcontact_init_api() {
    return false;
  } // fullcontact_init_api

  // ******* FullContact ************

  // ******* SendInBlue ************

  static function sendinblue_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/Mailin.php';

    if (empty($data['api_key'])) {
      return false;
    }

    $api = new Mailin('https://api.sendinblue.com/v2.0', $data['api_key']);
    $tmp = $api->get_account();

    if (empty($tmp['code']) || $tmp['code'] != 'success') {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'SendInBlue', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
    }

    return $verified;
  } // sendinblue_verify_api
  
  
  
 


  static function sendinblue_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $api = self::init_api();

      $tmp = $api->get_lists(array("page"=>1, "page_limit" => 50));
	   

      if (!empty($tmp['code']) && $tmp['code'] == 'success') {
        foreach ($tmp['data']['lists'] as $list) {
          $lists[$list['id']] = $list['name'];
        } // foeach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // sendinblue_get_lists


  static function sendinblue_init_api() {
    require_once LF_PLUGIN_PATH . 'api/Mailin.php';
    $options = self::get_options();

    $api = new Mailin('https://api.sendinblue.com/v2.0', $options['api_key']);

    return $api;
  } // sendinblue_init_api


  static function sendinblue_add_subscriber($list_id, $fields, $options) {
    $api = self::init_api();

    $email = $fields['email'];
    unset($fields['email']);

    $member_info = $api->get_user($email);
    if (!empty($member_info['code']) && $member_info['code'] == 'success' &&
        !empty($member_info['data']['listid']) && in_array($list_id, $member_info['data']['listid'])) {
        return false;
    } else {
      $result = $api->create_update_user($email, $fields, false, array($list_id), false, false);
      if (!empty($result['code']) && $result['code'] == 'success') {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list. ' . $result['code']);
      }
    }
  } // sendinblue_add_subscriber
  // ******* SendInBlue ************


	// ******* Facebook **************/
	
	
static function facebook_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/Facebook/autoload.php';

    if ( empty($data['app_id']) || empty($data['app_secret']) || empty($data['lfp_facebook_pages_all']) ) {
      return false;
    }
	
	if(!empty($data['lfp_facebook_pages_all'])){
		update_option('lfp_facebook_pages_all', $data['lfp_facebook_pages_all']);	
		update_option('lfp_facebook_page', $data['lfp_facebook_page']);			
	}
	
	
	$facebook_pages = json_decode(stripslashes($data['lfp_facebook_pages_all']), true); 
	
	foreach($facebook_pages as $facebook_page){
		if($facebook_page['id'] == $data['lfp_facebook_page']){
			$sl_access_token=$facebook_page['access_token'];
		}
	}
	
	$fb = new Facebook\Facebook([
	  'app_id' => $data['app_id'],
	  'app_secret' => $data['app_secret'],
	  'default_graph_version' => 'v2.5',
	  ]);
	  
	  
	  
	if($sl_access_token){
		
		$fb->post('/'.$data['lfp_facebook_page'].'/subscribed_apps', ['access_token' => $sl_access_token]);
		
		// OAuth 2.0 client handler
		$oAuth2Client = $fb->getOAuth2Client();
		
		
		try {
		  // Returns a long-lived access token
		  $accessToken = $oAuth2Client->getLongLivedAccessToken($sl_access_token);
		  update_option('lfp_facebook_long_token', (string)$accessToken);	
		  $verified = true;
		} catch(Facebook\Exceptions\FacebookSDKException $e) {
		  // There was an error communicating with Graph
		  $verified = false;
		}
	}

    if (! isset($accessToken)) {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Facebook', 'status' => $verified, 'app_id' => $data['app_id'], 'app_secret' => $data['app_secret'], 'app_page' => $data['app_page'], 'lists' => array()));
    }

    return $verified;
  } // facebook_verify_api
  




  // ******* JVZoo ************

  static function jvzoo_verify_api($data, $save_data = true) {
    if (empty($data['api_key'])) {
      return false;
    }
	
	global $leadflow_lc;
	$auth_query = '&key='.$leadflow_lc->get_decryptedoption($leadflow_lc->authkey).'&domain='.$_SERVER['SERVER_NAME'].'&email='.$leadflow_lc->get_decryptedoption($leadflow_lc->email);
    
	
	$lfp_jv_endpoint='https://leadsflowpro.com/';
	$api_request='latest-affiliates-transactions';
	$api_params='';
	$lc_email=$leadflow_lc->get_decryptedoption($leadflow_lc->email);
	$lc_domain=$_SERVER['SERVER_NAME'];
	$lc_key=$leadflow_lc->get_decryptedoption($leadflow_lc->authkey);
	$jvzoo_api_key=$data['api_key'];
	$lc_ic=$leadflow_lc->get_decryptedoption($leadflow_lc->icmember);
	$res = wp_remote_get($lfp_jv_endpoint.'/?lfp-jvzoo-api='.$api_request.'&lfp-jvzoo-api-params='.$api_params.'&lc_email='.$lc_email.'&lc_domain='.$lc_domain.'&lc_key='.$lc_key.'&lc_ic='.$lc_ic.'&jvzoo_api_key='.$jvzoo_api_key, array('sslverify' => false, 'timeout' => 30) );
	
			
    $response_code = wp_remote_retrieve_response_code($res);

    if (empty($response_code) || substr($response_code, 0, 1) != '2') {
      $verified = false;
    } else {
      $verified = true;
    }

    if ($save_data) {
      $sync_timestamp = current_time('timestamp') - DAY_IN_SECONDS * (int) $data['sync_days'];
      self::update_options(array('name' => 'JVZoo', 'status' => $verified, 'api_key' => $data['api_key'], 'sync_from_timestamp' => $sync_timestamp, 'sync_days' => (int) $data['sync_days'], 'lists' => array()));
      delete_option('lf_jvzoo_last_transaction');
	  delete_option('lf_jvzoo_last_affiliate_transaction');
    }

    return $verified;
  } // jvzoo_verify_api


  static function jvzoo_get_transactions_raw($affiliate=false) {
	global $leadflow_lc;
    $options = self::get_options();
    
	if($affiliate){
		$last_transaction = get_option('lf_jvzoo_last_affiliate_transaction', false);
	} else {
		$last_transaction = get_option('lf_jvzoo_last_transaction', false);	
	}
	
	
    if (!empty($last_transaction['transaction_id'])) {
      $tmp = $last_transaction['transaction_id'];
    } else {
      $tmp = '';
    }

	
	$lfp_jv_endpoint='https://leadsflowpro.com/';
	
	if($affiliate){
		$api_request='latest-affiliates-transactions';
	} else {
		$api_request='latest-transactions';
	}
	
	$api_params=$tmp;
	$lc_email=$leadflow_lc->get_decryptedoption($leadflow_lc->email);
	$lc_domain=$_SERVER['SERVER_NAME'];
	$lc_key=$leadflow_lc->get_decryptedoption($leadflow_lc->authkey);
	$jvzoo_api_key=$options['api_key'];
	$lc_ic=$leadflow_lc->get_decryptedoption($leadflow_lc->icmember);
	$res = wp_remote_get($lfp_jv_endpoint.'/?lfp-jvzoo-api='.$api_request.'&lfp-jvzoo-api-params='.$api_params.'&lc_email='.$lc_email.'&lc_domain='.$lc_domain.'&lc_key='.$lc_key.'&lc_ic='.$lc_ic.'&jvzoo_api_key='.$jvzoo_api_key, array('sslverify' => false, 'timeout' => 30) );
	
	
    $response_code = wp_remote_retrieve_response_code($res);

    if (empty($response_code) || substr($response_code, 0, 1) != '2') {
      return new WP_Error('jvzoo_api', 'Unable to get last transactions. Response code: ' . $response_code);
    } elseif ($response_code == 204) {
      return array();
    }

    $res = wp_remote_retrieve_body($res);
    $res = json_decode($res, true);
	
	
	
    $transactions = $res['results'];
	
	
    if (empty($transactions) || !is_array($transactions)) {
      $transactions = array();
    } else {
	    if($affiliate){
			update_option('lf_jvzoo_last_affiliate_transaction', $transactions[sizeof($transactions) - 1]);
		} else {
			update_option('lf_jvzoo_last_transaction', $transactions[sizeof($transactions) - 1]);
		}
    }

    return $transactions;
  } // jvzoo_get_transactions_raw


  static function jvzoo_get_transactions($extra = array()) {
    $transactions = array();
    $options = self::get_options();
    
    $tmp = self::jvzoo_get_transactions_raw();
    while (!empty($tmp) && !is_wp_error($tmp)) {
      $trans2 = array();
      foreach ($tmp as $tmp_trans) {
        // filter out incomplete and reversed transactions
        if (empty($tmp_trans['date']) || $tmp_trans['status'] != 'COMPLETED') {
          continue;
        }

        // filter out too old transactions
        $date = strtotime($tmp_trans['date']);
        if ($date < $options['sync_from_timestamp']) {
          continue;
        }
		$tmp_trans['is_affiliate_transaction']=0;
        $trans2[] = $tmp_trans;
      } // foreach transactions

      $transactions = array_merge($transactions, $trans2);
      $tmp = self::jvzoo_get_transactions_raw();
	  
    } // while transactions
	
	
	//Retrieve Affiliate Transactions
	
	$tmp = self::jvzoo_get_transactions_raw(true);
    while (!empty($tmp) && !is_wp_error($tmp)) {
      $trans2 = array();
      foreach ($tmp as $tmp_trans) {
        // filter out incomplete and reversed transactions
        if (empty($tmp_trans['date']) || $tmp_trans['status'] != 'COMPLETED') {
          continue;
        }

        // filter out too old transactions
        $date = strtotime($tmp_trans['date']);
        if ($date < $options['sync_from_timestamp']) {
          continue;
        }
		
		$tmp_trans['is_affiliate_transaction']=1;		
        $trans2[] = $tmp_trans;
      } // foreach transactions

      $transactions = array_merge($transactions, $trans2);
      $tmp = self::jvzoo_get_transactions_raw(true);
	  
    } // while transactions


	usort($transactions, function ($a, $b) {
		return strtotime($a['date']) - strtotime($b['date']);
	});


    if (is_wp_error($tmp)) {
      return $tmp;
    } else {
      return $transactions;
    }
  } // jvzoo_get_transactions


  static function jvzoo_get_lists($refresh = false) {
    return array();
  } // jvzoo_get_lists


  static function jvzoo_init_api() {
    return false;
  } // jvzoo_init_api

  // ******* JVZoo ************

   // ******* Ontraport ********************

  static function ontraport_verify_api($data, $save_data = true) {
    if (empty($data['app_id']) || empty($data['api_key'])) {
      return false;
    }

    $res = wp_remote_get('https://api.ontraport.com/1/objects/meta?format=byId', array('headers' => array('Api-Appid' => $data['app_id'], 'Api-Key' => $data['api_key'])));
    if (wp_remote_retrieve_response_code($res) == 200) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      self::update_options(array('name' => 'Ontraport', 'status' => $verified, 'api_key' => $data['api_key'], 'app_id' => $data['app_id'], 'lists' => array()));
    }

    return $verified;
  } // ontraport_verify_api


  static function ontraport_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $options = self::get_options();

      $res = wp_remote_get('https://api.ontraport.com/1/objects?objectID=14&performAll=true&sortDir=asc&searchNotes=true', array('headers' => array('Api-Appid' => $options['app_id'], 'Api-Key' => $options['api_key'])));
      if (wp_remote_retrieve_response_code($res) == 200) {
        $res = wp_remote_retrieve_body($res);
        $res = json_decode($res, true);

        if (!empty($res['data']) && is_array($res['data'])) {
          foreach ($res['data'] as $object) {
            $lists['14-' . $object['tag_id']] = $object['tag_name'] . ' (tag)';
          }
        }
      }

      $res = wp_remote_get('https://api.ontraport.com/1/objects?objectID=5&performAll=true&sortDir=asc&searchNotes=true', array('headers' => array('Api-Appid' => $options['app_id'], 'Api-Key' => $options['api_key'])));
      if (wp_remote_retrieve_response_code($res) == 200) {
        $res = wp_remote_retrieve_body($res);
        $res = json_decode($res, true);

        if (!empty($res['data']) && is_array($res['data'])) {
          foreach ($res['data'] as $object) {
            $lists['5-' . $object['drip_id']] = $object['name'] . ' (sequence)';
          }
        }
      }

      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // ontraport_get_lists


  static function ontraport_init_api() {
    return true;
  } // ontraport_init_api


  static function ontraport_add_subscriber($list_id, $fields, $options) {
    $options = self::get_options();
    $list_id = explode('-', $list_id);

    $fields['objectID'] = 0;
    if ($list_id[0] == 5) {
      $fields['updateSequence'] = $list_id[1];
    }

    $res = wp_remote_post('https://api.ontraport.com/1/objects', array('headers' => array('Api-Appid' => $options['app_id'], 'Api-Key' => $options['api_key']), 'body' => $fields));

    if (wp_remote_retrieve_response_code($res) == 200) {
      $res = wp_remote_retrieve_body($res);
      $res = json_decode($res, true);
      if (empty($res['data']['id'])) {
        return new WP_Error('external_api', 'Error - unable to get new user ID.');
      } else {
        $user_id = $res['data']['id'];
      }
    } else {
      return new WP_Error('external_api', 'Error - ' . wp_remote_retrieve_response_message($res));
    }

    if ($list_id[0] == 14) {
      $params['ids'] = $user_id;
      $params['objectID'] = 0;
      $params['add_list'] = $list_id[1];

      $res = wp_remote_post('https://api.ontraport.com/1/objects/tag', array('headers' => array('Api-Appid' => $options['app_id'], 'Api-Key' => $options['api_key']), 'body' => $params, 'method' => 'PUT'));

      if (wp_remote_retrieve_response_code($res) != 200) {
        return new WP_Error('external_api', 'Error - unable to add tag to the user.');
      }
    } // if tag

    return true;
  } // ontraport_add_subscriber

  // ******* Ontraport ****************

  // ******* WebinarJam ****************

  static function webinarjam_init_api() {
    require_once LF_PLUGIN_PATH . 'api/webinarjam.php';
    $options = self::get_options();

    $api = new webinarjamapi($options['api_key']);

    return $api;
  } // webinarjam_init_api


  static function webinarjam_verify_api($data, $save_data = true) {
    require_once LF_PLUGIN_PATH . 'api/webinarjam.php';
    $verified = false;

    if (empty($data['api_key'])) {
      return false;
    }
	
    $api = new webinarjamapi($data['api_key']);
    
	
	$webinars = $api->get_webinars();

    if ($webinars) {
      $verified = true;

      if ($save_data) {
        self::update_options(array('name' => 'WebinarJam', 'status' => $verified, 'api_key' => $data['api_key'], 'lists' => array()));
      }

      return true;
    } else {
      return false;
    }
  } // webinarjam_verify_api


  static function webinarjam_get_lists($refresh = false) {
    require_once LF_PLUGIN_PATH . 'api/webinarjam.php';

    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    }

    $api = self::init_api();
    $webinars = $api->get_webinars();
    $lists = array();

    if ($webinars) {
      $webinars = json_decode($webinars);
      foreach ($webinars->webinars as $webinar) {
        $lists[$webinar->webinar_id] = $webinar->name;
      }
    }
    self::update_options(array('lists' => $lists));

    return $lists;
  } // webinarjam_get_lists


  static function webinarjam_add_subscriber($webinar_id, $fields, $options) {
    require_once LF_PLUGIN_PATH . 'api/webinarjam.php';

    $api = self::init_api();
	$webinar = $api->add_subscriber($webinar_id, $fields['name'],$fields['email'],$fields['schedule'],$fields['ip_address'],'',$fields['phone']);

    return $webinar;
  } // webinarjam_add_subscriber

  // ******* WebinarJam ****************
  
  // ******* MailPoet ************
  static function mailpoet_verify_api($data, $save_data = true) {
    if (defined('WYSIJA')) {
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      global $wpdb;
      $table = $wpdb->prefix . 'wysija_list';
      $res = $wpdb->get_results('SELECT list_id, name FROM ' . $table . '');

      $lists = array();
      if ($res) {
        foreach ($res as $list) {
          $lists[$list->list_id] = $list->name;
        } // foreach
      }
      
      self::update_options(array('name' => 'Mail Poet', 'status' => $verified, 'api_key' => '', 'lists' => $lists));
    }

    return $verified;
  } // mailpoet_verify_api


  static function mailpoet_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      global $wpdb;
      $table = $wpdb->prefix . 'wysija_list';

      $res = $wpdb->get_results('SELECT list_id, name FROM ' . $table . '');

      if ($res) {
        foreach ($res as $list) {
          $lists[$list->list_id] = $list->name;
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // mailpoet_get_lists


  static function mailpoet_init_api() {
    return true;
  } // mailpoet_init_api


  static function mailpoet_add_subscriber($list_id, $fields, $options) {
    global $wpdb;

    $user_data = $fields;
    $data_subscriber = array( 'user' => $user_data,
                              'user_list' => array('list_ids' => array($list_id)));
 
    $helper_user = WYSIJA::get('user','helper');
    $add_subscriber = $helper_user->addSubscriber($data_subscriber);
	

    if ($add_subscriber) {
      return true;
    } else {
      return new WP_Error('external_api', 'Unable to add email address to the list.');
    }
  } // mailpoet_add_subscriber

  // ******* MailPoet ************
  
  // ******* MyMail ***********/
  static function mymail_verify_api($data, $save_data = true) {
    if(function_exists('mymail')){
      $verified = true;
    } else {
      $verified = false;
    }

    if ($save_data) {
      $lists = array();
      $res = mymail('lists')->get();
      
      if ($res) {
        foreach ($res as $list) {
          $lists[$list->ID] = $list->name;
        } // foreach
      }
      
      self::update_options(array('name' => 'MyMail', 'status' => $verified, 'api_key' => '', 'lists' => $lists));
    }

    return $verified;
  } // mymail_verify_api


  static function mymail_get_lists($refresh = false) {
    if (!$refresh) {
      $options = self::get_options();

      return $options['lists'];
    } else {
      $lists = array();
      $res = mymail('lists')->get();
      
      if ($res) {
        foreach ($res as $list) {
          $lists[$list->ID] = $list->name;
        } // foreach
      }
      self::update_options(array('lists' => $lists));

      return $lists;
    }
  } // mymail_get_lists


  static function mymail_init_api() {
    return true;
  } // mymail_init_api


  static function mymail_add_subscriber($list_id, $fields, $options) {
    global $wpdb;
    
    $subscriber_id = mymail('subscribers')->add($fields);
    
    if (!is_wp_error($subscriber_id)) {
      $success = mymail('subscribers')->assign_lists($subscriber_id, $list_id);
      
      if ($success) {
        return true;
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list.');
      }
    } else {
      
      if (!empty($subscriber_id->errors['email_exists'])) {
        $subscriber_id = mymail('subscribers')->get_by_mail($fields['email']);

        $success = mymail('subscribers')->assign_lists($subscriber_id->ID, $list_id);
        if ($success) {
          return true;
        } else {
          return new WP_Error('external_api', 'Unable to add email address to the list.');
        }
      } else {
        return new WP_Error('external_api', 'Unable to add email address to the list.');
      }
    }
  } // mymail_add_subscriber

  // ******* MyMail ************
} // leadflow_external_api