<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/


class leadflow_import extends leadflow {

  static private $sample_rows = 10;
  static private $inserts_per_ajax = 10;
  static private $csv_settings = array('double-quotes' => '"', 
    'single-quote' => "'",
    'comma' => ',',
    'colon' => ':',
    'semicolon' => ';',
    'tab' => "\n",
    'slash' => '\\');

  

	 
	 
  // Import CSV for Ajax Call
  static function import_csv() {
    global $wpdb;	
		
    $file = $_POST['file'];
    $total = $_POST['total'];
    $offset = $_POST['offset'];
    $insert_per_call = $_POST['insert_per_call'];
    $skip_if_exists = $_POST['skip'];
    $settings = json_decode(stripslashes($_POST['settings']), true);
    $tags = json_decode(stripslashes($_POST['tags']), true);

    $fseek_offset = (int) $_POST['fseek_offset'];
    
	
    // If file does not exist
    if (!file_exists($file)) {
      wp_send_json_error('CSV file does not exists!');
    }

    // If no variables are set
    if (empty($settings)) {
      wp_send_json_error('No relationship variables have been set!');
    }

    // Counter for inserted rows
    $inserted_rows = 0;
    $skipped_rows = 0;
    $updated_rows = 0;
    $invalid_email = 0;
	$invalid_emails = array();
    $inserted_rows_callback = 0;
    
	if($fseek_offset == 0){
		$first_row=true;
	} else {
		$first_row=false;
	}
	
    $csv = fopen($file, "r");
    fseek($csv, $fseek_offset);

    $delimiter = self::$csv_settings[$_POST['delimiter']];
    $enclosure = self::$csv_settings[$_POST['enclosure']];
    $escape = self::$csv_settings[$_POST['escape']];
     
    while (($data = fgetcsv($csv, 0, $delimiter, $enclosure, $escape)) !== FALSE) {
	  if($first_row){
		 $first_row=false;
		 continue;  
	  }
      // User data
      $user_email = '';
      $user_fields = array();

      if ($skip_if_exists == '1') {
        $user_fields['skip_if_existing'] = 'true';
      }

      $num = count($data);
      for ($c=0; $c < $num; $c++) {
        // find setup of current variable
        $var_setup = $settings[$c];
        if ($var_setup == 'ignore') {
          continue;
        }

        switch($var_setup) {
          case 'email':
            $user_email = $data[$c];
            break;
          default:
            $user_fields[$settings[$c]] = $data[$c];
            break;
        } // switch
      } // for $c = 0
	  
	  
	  if (!filter_var($user_email, FILTER_VALIDATE_EMAIL) === false) {	
	  
			  $user_exists = leadflow_subscribers_common::is_subscriber($user_email);
			  
				
			  if ($skip_if_exists == '1' && $user_exists) {
				$skipped_rows++;
				continue;
				
			  }
		
			  if (empty($user_exists)) {
				
				$custom = array();
				if (isset($user_fields['skip_if_existing'])) unset($user_fields['skip_if_existing']);
				foreach ($user_fields as $key => $val) {
				  $custom[$key] = $val;
				}
		
				$custom['source'] = 'import';
		
				// Add user
				$user = leadflow_subscribers_common::add($user_email, $custom);
				
						
				// Add user tags
				if (is_array($tags) && count($tags)) {
				  leadflow_subscribers_common::add_tags($user, $tags);
				}
				update_post_meta($user,'signup_source','import');
				$inserted_rows++;
			  } else if (!empty($user_exists)) {
				
				// Add user tags
				if (is_array($tags) && count($tags)) {
				  leadflow_subscribers_common::add_tags($user_exists, $tags);
				}
		
				$updated_rows++;
			  }
	  } else {
		  $invalid_email++;
		  $invalid_emails[]=$user_email;
	  }
      $inserted_rows_callback++;

      // Have we reached insert per call limit?
      if ($inserted_rows_callback >= $insert_per_call) {
        $inserted_rows_callback = 0;
        break;
      }

    } // while

    $ftell = ftell($csv);
	if(feof($csv)){
		global $current_user;
		update_option('lfp_import_done_'.time(), 'OK');
		leadflow_stats::event_add_import(array('uuid' => get_current_user_id(), 'type'=>'import', 'post_id' => 0, 'new' => false, 'file' => basename($file), 'total_imported' => (int)$total), true);
		
	}
	
    fclose($csv);
    
    wp_send_json_success(array('ftell' => $ftell+mb_strlen(''), 
                               'updated' => $updated_rows, 
                               'inserted' => $inserted_rows, 
                               'skipped' => $skipped_rows,
							   'invalid' => $invalid_email,
							   'invalid_emails' => implode('<br />',$invalid_emails)));
  } // import_csv


  static function content() {
    ini_set("auto_detect_line_endings", true);

    echo '<h2>LeadFlow Import</h2>';

    if (!isset($_FILES['lf-csv-import']) && !isset($_POST['lf-csv-import'])) {

      /*
      * Step 1 - file Upload
      */

      echo '<form method="POST" action="#" enctype="multipart/form-data">';
      echo wp_nonce_field( plugin_basename( __FILE__ ), 'lf-csv-import' );

      echo '<div class="lf-help">';
      echo 'Use this tool to upload a list of subscribers in CSV format.<br /><br />The first row should contain the column names and will not be imported. <br /><br />You will be able to assign each column of data to the appropriate field on the next step. ';
      echo '</div>';

      echo '<table class="form-table">';
      echo '<tbody>';

      echo '<tr>';
      echo '<th scope="row">';
      echo '<label for="lf-csv-import">CSV File To Upload</label>';
      echo '</th>';
      echo '<td><input type="file" id="lf-csv-import" name="lf-csv-import" value="" /></td>';
      echo '</tr>';
      echo '<tr>';

      echo '<tr>';
      echo '<th scope="row">';
      echo '<label for="lf-csv-enclosure">Enclosure</label>';
      echo '</th>';
      echo '<td>
      <select name="lf-csv-enclosure" id="lf-csv-enclosure">
      <option value="double-quotes">"</option>
      <option value="single-quote">\'</option>
      </select>    
      </td>';
      echo '</tr>';
      echo '<tr>';

      echo '<tr>';
      echo '<th scope="row">';
      echo '<label for="lf-csv-delimiter">Delimiter</label>';
      echo '</th>';
      echo '<td>
      <select name="lf-csv-delimiter" id="lf-csv-delimiter">
      <option value="comma">,</option>
      <option value="colon">:</option>
      <option value="semicolon">;</option>
      </select>
      </td>';
      echo '</tr>';
      echo '<tr>';

      echo '<tr>';
      echo '<th scope="row">';
      echo '<label for="lf-csv-escape">Escape</label>';
      echo '</th>';
      echo '<td>
      <select name="lf-csv-escape" id="lf-csv-escape">
      <option value="slash">/</option>
      </select>
      </td>';
      echo '</tr>';
      echo '<tr>'; 

      echo '<tr>';
      echo '<th scope="row">';
      echo '<label for="lf-csv-exists">Skip subscriber if it already exists?</label>';
      echo '</th>';
      echo '<td><input type="checkbox" name="lf-csv-exists" id="lf-csv-exists" value="1"/></td>';
      echo '</tr>';
      echo '<tr>';

      echo '</tbody>';
      echo '</table>';

      echo '<input type="submit" name="submit" value="Upload" class="button button-primary" />';
      echo '</form>';
    } 
    else if (isset($_FILES['lf-csv-import'])){

      /*
      * Step 2 - Relationship settings
      */

      $allowed = array('csv','txt','xcsv');
      $ext = pathinfo($_FILES['lf-csv-import']['name'], PATHINFO_EXTENSION);
      if(!in_array($ext,$allowed) ) {
        echo '<strong class="error">Your import file is wrong type, it must be CSV or TXT file.</strong>';
        return false;
      }
      
      $file = wp_upload_bits('import-file-' . $_FILES['lf-csv-import']['name'], null, file_get_contents($_FILES['lf-csv-import']['tmp_name']));
	 
	  if (!is_wp_error($file)) {
        // $file['url'] http:/...
        // $file['file'] c:/...

        // File not found or not existing on server
        if (!file_exists($file['file'])) {
          echo 'Selected file has not been uploaded to the server or is corrupted.';
        }

        // Relationship variables have not been set
        if (!isset($_POST['lf-test-settings'])) {
          $variables = array();

          $csv = fopen($file['file'], "r");

          $delimiter = self::$csv_settings[$_POST['lf-csv-delimiter']];
          $enclosure = self::$csv_settings[$_POST['lf-csv-enclosure']];
          $escape = self::$csv_settings[$_POST['lf-csv-escape']];

          while (($data = fgetcsv($csv, 0, $delimiter, $enclosure, $escape)) !== FALSE) {
            $num = count($data);
            for ($c=0; $c < $num; $c++) {
              $variables[] = $data[$c];
            }
            break;
          }

          $skip_if_exists = 'value="0"';
          if (!empty($_POST['lf-csv-exists'])) {
            $skip_if_exists = 'value="1" checked="checked"';
          }

          if (is_array($variables) && count($variables) > 0) {

            echo '<form method="POST" action="#" name="lf-test-settings" id="lf-test-settings">';
            echo '<input type="hidden" name="lf-csv-import" value="' . $file['file'] . '" />';
            echo '<input type="hidden" name="lf-csv-exists" ' . $skip_if_exists . ' />';
            echo '<input type="hidden" name="lf-csv-enclosure" value="' . urlencode($_POST['lf-csv-enclosure']) . '" />';
            echo '<input type="hidden" name="lf-csv-delimiter" value="' . $_POST['lf-csv-delimiter']  . '" />';
            echo '<input type="hidden" name="lf-csv-escape" value="' . $_POST['lf-csv-escape']  . '" />';

            // Setup relationships
            foreach ($variables as $key => $var) {
              echo '<div class="lf-import-container">';
              echo '<label>' . $var . '</label>';
              echo '<select name="lf-setting-var[]" id="lf_setting_var_' . $key . '" class="lf-setting-var">';
              echo '<option value="ignore" selected="selected">Ignore</option>';
              echo '<option value="email">E-Mail</option>';
              echo '<option value="firstname">First Name</option>';
              echo '<option value="lastname">Last Name</option>';
              echo '</select>';
              echo '</div>';
            }

            echo '<br/>';

            // Set subscriber tags
            echo '<div class="lf-import-container bigger">';
            echo '<label>Set predefined tags</label>';
            echo '<select name="lf-import-tags[]" id="" class="lf-setting-var" multiple="multiple">';

            $tags = get_terms('leadflow-subscriber-tags', array('orderby' => 'id', 'hide_empty' => false));
            if ($tags) {
              foreach ($tags as $tag) {
                $color = leadflow_common::get_subscriber_tags_meta($tag->term_id);

                $data = '';
                if ($color) {
                  // CSS
                  if (isset($color['tag_color'])) {
                    $data .= 'data-background-color="' . $color['tag_color'] . '" ';
                  }

                  if (isset($color['font_color'])) {
                    $data .= 'data-font-color="' . $color['font_color'] . '"';
                  }
                }
                echo '<option value="' . $tag->slug . '" ' . $data . '>' . $tag->name . '</option>';
              }
            }

            echo '</select>';

            echo '</div>';

            echo '<br/>';

            echo '<input type="submit" name="submit" value="Test settings" class="button button-primary"/>';
            echo '</form>';
          } // if $variables
        } // if !isset lf_test_settings
      } else {
         echo 'File could not be uploaded.';
      } // if !is_wp_Error file upload
    } 
    else if (isset($_POST['lf-csv-import'])) {

      /*
      * Step 3 - Sample preview & ajax import button
      */

      // If tags have not been set send empty array
      if (!isset($_POST['lf-import-tags'])) {
        $_POST['lf-import-tags'] = array();
      }

      // Is skipping checkbox checked?
      $skip_if_exists = 'value="0"';
      if (!empty($_POST['lf-csv-exists'])) {
        $skip_if_exists = 'value="1" checked="checked"';
      }

      // Import status div container
      echo '<div id="lf-import-status" style="display:none;">';

      // Current status info
      echo '<div class="lf-current-status">';
      echo '<span id="lf-updated-rows">Updated/Duplicates:<span></span></span>';
      echo '<span id="lf-inserted-rows">Inserted:<span></span></span>';
      echo '<span id="lf-skipped-rows">Skipped:<span></span></span>';
      echo '<span id="lf-invalid-rows" style="display:none;">Invalid email:<span></span></span>';
      echo '<span id="lf-total-rows">Total:<span></span></span>';
      echo '</div>';

      // Current Progress Info
      echo '<div class="lf-progress animate">';
      echo '<div class="lf-progress-bar"></div>';
      echo '<div class="lf-progress-text"></div>';
      echo '</div>';
	  
	  echo '<div class="lf-import-finished"></div>';
	  echo '<div class="lf-import-invalid"><span>Invalid emails:</span><br /></div>';
	  
	  

      echo '</div>';

      // Import form for ajax
      echo '<form method="POST" action="#" name="lf-import-csv-ajax">';

      echo '<input type="hidden" name="lf-import-tags" value=\'' . json_encode($_POST['lf-import-tags']) . '\' />';
      echo '<input type="hidden" name="lf-csv-import" value="' . $_POST['lf-csv-import'] . '" />';
      echo '<input type="hidden" name="lf-setting-var" value=\'' . json_encode($_POST['lf-setting-var']) . '\' />';
      echo '<input type="hidden" name="lf-csv-exists" ' . $skip_if_exists . ' />';
      echo '<input type="hidden" name="lf-csv-enclosure" value="' . $_POST['lf-csv-enclosure'] . '" />';
      echo '<input type="hidden" name="lf-csv-delimiter" value="' . $_POST['lf-csv-delimiter']  . '" />';
      echo '<input type="hidden" name="lf-csv-escape" value="' . $_POST['lf-csv-escape']  . '" />';

      // Test settings
      $file = $_POST['lf-csv-import'];
      $settings = $_POST['lf-setting-var'];

      // User tags
      $tags = array();
      if (isset($_POST['lf-import-tags'])) {
        $tags = $_POST['lf-import-tags'];
      }

      echo '<table class="wp-list-table widefat fixed striped posts" id="lf-import-sample-table">
      <thead>
      <tr>';

      foreach ($settings as $k => $value) {
        if ($value == 'ignore') continue;
        echo '<th><strong>' . ucfirst($value) . '</strong></th>';
      } // foreach $settings

      echo '<th><strong>Tags</strong></th>';

      echo '</tr>
      </thead>
      <tbody>';

      // Outputed sample rows counter
      $rows = 0;

      $csv = fopen($file, "r");

      $delimiter = self::$csv_settings[$_POST['lf-csv-delimiter']];
      $enclosure = self::$csv_settings[$_POST['lf-csv-enclosure']];
      $escape = self::$csv_settings[$_POST['lf-csv-escape']];

      while (($data = fgetcsv($csv, 0, $delimiter, $enclosure, $escape)) !== FALSE) {

        if ($rows == 0) {
          $rows++;
          continue; 
        }

        echo '<tr>';

        $num = count($data);
        for ($c=0; $c < $num; $c++) {
          // find setup of current variable
          $var_setup = $settings[$c];
          if ($var_setup == 'ignore') {
            continue;
          }

          switch($var_setup) {
            case 'email':
              echo '<td>' . $data[$c] . '</td>';
              break;
            default:
              echo '<td>' . $data[$c] . '</td>';
              break;
          } // switch

        } // for $c = 0

        // Output subscriber tags
        echo '<td>';
        if (isset($tags) && !empty($tags)) {
          echo '<ul class="lf-custom-tags" style="margin:0px !important;">';
          $tags_data = '';
          foreach ($tags as $tag) {
            if (term_exists($tag, 'leadflow-subscriber-tags')) {
              $tag = get_term_by('slug', $tag, 'leadflow-subscriber-tags');
              $color = leadflow_common::get_subscriber_tags_meta($tag->term_id);

              $style = '';
              if ($color) {
                // CSS
                $style = 'style="';
                if (isset($color['tag_color'])) {
                  $style .= 'background:' . $color['tag_color'] . ';';
                }

                if (isset($color['font_color'])) {
                  $style .= 'color:' . $color['font_color'] . ';';
                }
                $style .= '"';
              }
              $tags_data .= '<li><a href="#" ' . $style . '>' . $tag->name . '</a></li>';
            } else {
              $tags_data .= '<li><a href="#">' . $tag . '</a></li>';
            }
          }
          $tags_data = rtrim($tags_data, ',');
          echo $tags_data;
          echo '</ul>';
        } // if isset($tags)
        echo '</td>';
        echo '</tr>';
        $rows++;

        // If outputed rows equal sample rows limit
        if ($rows-1 >= self::$sample_rows) {
          break;
        }
      } // while
      
      echo '<input type="hidden" name="lf-csv-records" value="' . (count(file($file))-1) . '" />';
      echo '<input type="hidden" name="lf-csv-insert-per-ajax" value="' . self::$inserts_per_ajax . '"/>';

      echo '</tbody>';
      echo '</table>';

      echo '<br/>';
      echo '<input type="submit" name="submit" value="Import Data" id="lf-import-data-btn" class="button button-primary"/>';
      echo '</form>';
    } 

  } // content


} // leadflow_import