<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_conditionals extends leadflow {


  static function setup_headers() {
    global $attached_optins, $optin_ID, $post;
    $attached_optins = self::get_attached_optins();

    if ($attached_optins) {
      remove_action('wp_head', '_admin_bar_bump_cb');
      
      add_action('wp_enqueue_scripts', array('leadflow_optin_enqueues', 'css_enqueues'), 1); // radi css enqueue
      add_action('wp_enqueue_scripts', array('leadflow_optin_enqueues', 'js_enqueues')); // radi enqueue

      add_action('wp_head', array('leadflow_optin_enqueues', 'conditional_header_css'));
      add_action('wp_print_footer_scripts', array('leadflow_optin_enqueues', 'conditional_footer_js'));
    }
  } // setup_headers  
  
  
  // remove admin bar push
  static function remove_admin_login_header() {
    remove_action('wp_head', '_admin_bar_bump_cb');
  }


  static function output_optins_to_footer() {
    global $attached_optins, $optin_ID;
    $attached_optins = self::get_attached_optins();

    if ($attached_optins) {

      remove_action('wp_footer', 'wp_admin_bar_render', 1000);

      foreach ($attached_optins as $optinID => $optin) {
        if ($optin['type'] != 'standalone' && $optin['type'] != 'preview' && $optin['type'] != 'embed') {
          $optin_ID = $optinID;
		  
		  if ($optin['type'] == 'shortcode') echo '<div class="lf-optin-preview-wrapper">';
          echo leadflow_optin_common::template_to_string(LF_PLUGIN_PATH . 'templates/' . $optin['type'] . '/default.php');
		  if ($optin['type'] == 'shortcode') echo "</div></div>";
          
        }
		
		/*if($optin['type']=='embed'){
			 echo '<div class="lf-optin-preview-wrapper">';
			 echo '<p><b>Embed</b> put this piece of code into your content area.</p>';
			 echo '<pre><code>';
			 echo '&lt;iframe src="' . get_permalink($optinID) . '" width="100%" height="500px">&lt;/iframe>';
			 echo '<iframe src="' . get_permalink($optinID) . '" width="100%" height="500px"></iframe>';
			 echo '</code></pre>';
			 echo "</div></div>";
			 		
		}*/
      }
    }
  } // output_optins_to_footer


  static function enqueue_widget_script($widget_type) {

    switch ($widget_type) {

      case 'list':
        // font icons
        wp_enqueue_style('lf-optin-fontello');
        wp_enqueue_style('lf-optin-icomoon');
        break;

      case 'button':
      case 'submit-button':
        // button images/css
        wp_enqueue_style('lf-optin-button');
        break;

      case 'captcha':
        // js,php
        break;

      case 'countdown':
        // flipclock
        wp_enqueue_style('lf-optin-flipclock');
        wp_enqueue_script('lf-optin-flipclock');

        break;

      case 'colorpicker':
        // iris, wp color pciker
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('iris');
        wp_enqueue_script('wp-color-picker');
        break;

      case 'video':
        // fitvid
        wp_enqueue_script('lf-optin-fitvid');
        break;

      case 'date-time-picker':
        // jquery ui, uislider, datetimepicker...
        wp_enqueue_style('jquery-ui');
        wp_enqueue_style('jquery-ui-datepicker');
        wp_enqueue_style('jquery-ui-slider');
        wp_enqueue_style('jquery-ui-datepicker-style');

        wp_enqueue_style('lf-optin-timepicker');

        wp_enqueue_script('jquery-ui');
        wp_enqueue_script('jquery-ui-slider');
        wp_enqueue_script('jquery-ui-datepicker');
        wp_enqueue_script('lf-optin-timepicker');
        wp_enqueue_script('lf-optin-timepicker-slider');
        wp_enqueue_script('lf-optin-timepicker-i18n');
        break;

      case 'rating':
        // rating
        wp_enqueue_script('lf-optin-rating');
        break;

      case 'file-upload':
        // file upload
        break;

    }
  } // enqueue_widget_script


  /*
   * Fetch only attached AB tests on current page/post
   */
  static function get_attached_ab() {
    global $post, $doing_test, $currently_active_ab, $wp;
    $output = array();  
    
    // Is it custom url AB Test - Standalone?
    if (!empty($doing_test)) {
      $output[$_SESSION['leadsflow']['ab-test'][$currently_active_ab]] = array('type' => 'standalone');
      return $output;
    }
    
    if (empty($post->post_type)) {
      return false;
    }

    // Before anything check if we have a/b tests attached to current page/post
    $ab_tests = get_posts(array('post_type' => 'leadflow-abtests', 'posts_per_page' => '-1', 'post_status' => 'publish'));
    if (!empty($ab_tests)) {
      foreach ($ab_tests as $ab_test) {
        $triggers = get_post_meta($ab_test->ID, LF_META, true);
        #$optin_type = get_post_meta($ab_test->ID, 'ab_test_type', true);

        if (empty($triggers['ab-test'])) {
          continue;
        }
        
        $page_conditionals = self::check_page_conditionals($ab_test->ID, $triggers['ab-test']);
        $user_conditionals = self::check_user_conditionals($ab_test->ID, $triggers['ab-test']);

        if ($page_conditionals || $user_conditionals) {
          // Break on first A/B Test
          $output[$ab_test->ID] = array('type' => '');
    
          return $output;
        }
      }
    }

    return false;
  } // get_attached_ab
  

  /*
  * Fetch only attached optins on current page/post
  */
  static function get_attached_optins() {
    global $post, $doing_test, $currently_active_ab, $wp, $preview_optin;
    $output = array();  
   
    if (!empty($_GET['preview-post-id'])) {
      $preview_optin_ID = $_GET['preview-post-id'];
      if (!empty($preview_optin_ID) || $preview_optin) {
        $type = get_post_meta($preview_optin_ID, 'optin_type', true);
        $output[$preview_optin_ID] = array('type' => $type);
        return $output;
      }
    }
    
    // Is it custom url AB Test - Standalone?
    if (!empty($doing_test) || !empty($currently_active_ab)) {
      
      $optin_type = 'standalone';
      if (!empty($_SESSION['leadsflow']['ab-test'][$currently_active_ab])) {
        $optin_type = leadflow_optin_common::get_optin_type($_SESSION['leadsflow']['ab-test'][$currently_active_ab]);
      }
      
      $output[$_SESSION['leadsflow']['ab-test'][$currently_active_ab]] = array('type' => $optin_type);
      return $output;
    }
    
    if (empty($post->post_type)) {
      return false;
    }

    // For standalone
    if (!empty($post->post_type) && $post->post_type == 'optin-pages') {
      $type = get_post_meta($post->ID, 'optin_type', true);
      $output[$post->ID] = array('type' => $type);
      return $output;
    }
    
    // Check for stanard optins
    $optins = get_posts(array('post_type' => 'optin-pages', 
      'meta_query' => array( 'relation' => 'OR',
        array('key' => 'optin_type',
          'value' => 'welcome',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'popup',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'header',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'pullout',
          'compare' => '=')
      ), 'posts_per_page' => '-1', 'post_status' => 'publish'));

    if (!empty($optins)) {

      foreach ($optins as $optin) {
        $type = get_post_meta($optin->ID, 'optin_type', true);

        // Optin Meta
        $meta = get_post_meta($optin->ID, LF_META, true);

        if (!empty($meta[$type]['force_everywhere']) && $meta[$type]['force_everywhere'] == 'true') {
          $output[$optin->ID] = array('type' => $type);
          continue;
        }

        if (!empty($meta[$type])) {
          $options = $meta[$type];
          $enabled_autopopup = @$meta['popup']['optin_auto_popup'];

          if ($type == 'popup' && $enabled_autopopup == '0' && $post->post_type != 'optin-pages') {
            $shortcode_type = leadflow_optin_common::uses_shortcode($post->post_content);
            if (!empty($shortcode_type)) {
              $output[$shortcode_type['id']] = array('type' => $shortcode_type['type']);
              continue;
            }
          } else {
            $page_conditionals = self::check_page_conditionals($optin->ID, $options);
            $user_conditionals = self::check_user_conditionals($optin->ID, $options);

            if ($page_conditionals && !$user_conditionals) {
              $output[$optin->ID] = array('type' => $type);
            }
          }

        }

      }

      return $output;
    }

    // shortcode widget optin
    $output = array();
    if (is_active_widget(false, false, 'lfp_optin', true)) {
      $widget_active = is_active_widget(false, false, 'lfp_optin', true);
      $sidebars = get_option('sidebars_widgets');

      if ($widget_active) {
        $active_sidebar = $sidebars[$widget_active];
        $widgets = preg_grep('/lfp_optin(?:_(\d+))?/i', $active_sidebar);
        if (!empty($widgets)) {

          $widget_setup = get_option('widget_lfp_optin');
          foreach ($widgets as $i => $widget) {
            $widget_id = str_replace('lfp_optin-', '', $widget);
            $optin_ID = $widget_setup[$widget_id]['optin_id'];
            $output[$optin_ID] = array('type' => 'shortcode');
          }
        }
      }

      return $output;
    }
    
    // shortcode in page/post text
    global $post;
    $pattern = get_shortcode_regex();

    if (preg_match_all( '/'. $pattern .'/s', $post->post_content, $matches )
        && array_key_exists( 2, $matches )
        && in_array( 'optin_shortcode', $matches[2] ) ) {
          
      $optin_ID = trim(str_replace('id="', '', rtrim($matches[3][0], '"')));
      $output[$optin_ID] = array('type' => 'shortcode');
          
      return $output;
    }

    return false;
  } // get_attached_optins


  static function check_page_conditionals($optin_ID, $options) {
    global $post;
    $checked = false;

    if (isset($options['conditions'])) {
      $checked = true;

      if (in_array('is_home', $options['conditions'])) {
        if (is_home()) {
          return true;
        }
      }

      if (in_array('is_front_page', $options['conditions'])) {
        if (is_front_page()) {
          return true;
        }
      }      

      if (in_array('is_archive', $options['conditions'])) {
        if (is_archive()) {
          return true;
        }
      }      

      if (in_array('is_single', $options['conditions'])) {
        if (is_single()) {
          return true;
        }
      }
    }

    if (isset($options['on_search'])) {
      $checked = true;
      
      if (is_search()) {
        return true;
      }
    }

    if (isset($options['on_post'])) {
      $checked = true;

      if(in_array($post->ID, $options['on_post'])) {
        return true;
      }
    }

    if (isset($options['on_pages'])) {
      $checked = true;
      
      if(in_array($post->ID, $options['on_pages'])) {
        return true;
      }
    }

    if (isset($options['on_category'])) {
      $checked = true;
      if(is_category($options['on_category']) || in_category($options['on_category'], $popup_id)) {
        return true;
      }
    }

    return false;
  } // check_page_conditionals


  static function check_user_conditionals($optin_ID, $options) {    

    if (isset($options['filter_subscribed']) && $options['filter_subscribed'] == 1) {
      if (leadflow_optin_common::is_user_subscribed($optin_ID)) {
        return true;
      }
    }

    if (isset($options['filter_loggedin'])) {
      if ($options['filter_loggedin'] == 1 && !is_user_logged_in()) {
        return true;
      } elseif ($options['filter_loggedin'] == 2 && is_user_logged_in()) {
        return true;
      }
    }

    if (isset($options['limit_per_user']) && $options['limit_per_user'] > 0) {
      if (leadflow_optin_common::get_user_popup_views($optin_ID) >= $options['limit_per_user']) {
        return true;
      }
    }

    return false;
  } // check_user_conditionals


} // leadflow_optin_conditionals