<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_enqueues extends leadflow {
  static $footer_js = '';

  // Conditioanl enqueues and cleanup
  static function conditional_enqueues() {
    add_action('wp_head', array('leadflow_optin_enqueues', 'clean_scripts_header'), 1);
    add_action('wp_footer', array('leadflow_optin_enqueues', 'clean_footer'), 1);
  } // conditional_enqueues


  static function clean_scripts_header() {
    global $wp_scripts, $doing_test, $wp_styles, $post;

    if (!empty($doing_test) || (!empty($post->post_type) && $post->post_type == 'optin-pages')) {
	 
      foreach ($wp_styles->queue as $script) {
        if (strpos($script, 'optin') === false && strpos($script, 'wp-') === false && strpos($script, 'wp_') === false && strpos($script, 'jquery-') === false && strpos($script, 'leadflow') === false && strpos($script, 'lf') === false) {
          wp_dequeue_style($script);
        }
      } // foreach $wp_styles->queue

      foreach ($wp_scripts->queue as $script) {
        if (strpos($script, 'optin') === false && strpos($script, 'wp-') === false && strpos($script, 'wp_') === false && strpos($script, 'jquery') === false && strpos($script, 'leadflow') === false && strpos($script, 'lf') === false) {
          wp_dequeue_script($script);
        }
      } // foreach $wp_scripts->queue
    }

  } // clean_scripts_header

  
  static function clean_scripts_footer() {
    global $wp_scripts, $doing_test, $wp_styles, $post;

    if (!empty($doing_test) || (!empty($post->post_type) && $post->post_type == 'optin-pages')) {
	 
      foreach ($wp_styles->queue as $script) {
        if (strpos($script, 'optin') === false && strpos($script, 'wp-') === false && strpos($script, 'wp_') === false && strpos($script, 'jquery-') === false && strpos($script, 'leadflow') === false && strpos($script, 'lf') === false) {
          wp_dequeue_style($script);
        }
      } // foreach $wp_styles->queue

      foreach ($wp_scripts->queue as $script) {
        if (strpos($script, 'optin') === false && strpos($script, 'wp-') === false && strpos($script, 'wp_') === false && strpos($script, 'jquery') === false && strpos($script, 'leadflow') === false && strpos($script, 'lf') === false) {
          wp_dequeue_script($script);
        }
      } // foreach $wp_scripts->queue
    }
	
  } // clean_scripts_footer



  // removes hooks from wp_footer() that are not controlled by LeadsFlow
  static function clean_footer() {
    global $wp_filter, $post, $optin_ID;

    $out = '';
     
	$wp_footer_actions=$wp_filter['wp_footer']; 
    
	foreach ($wp_footer_actions as $ind => $tmp2) {
		foreach ($wp_filter['wp_footer'][$ind] as $name => $tmp) {
			if (strpos($name, 'flow') === false && strpos($name, 'optin') === false  &&	strpos($name, 'wp_') === false) {
				remove_action('wp_footer', $name);
			}
		}
    }
	
	// Popup
    if (@$post->post_type == 'optin-pages') {
      return;
    }

  } // clean_footer


  static function css_enqueues() {
    global $post, $attached_optins;

    if ($attached_optins) {

      // Defaults
      wp_enqueue_style('lf-optin', LF_PLUGIN_URL . '/templates/style.css', array(), leadflow::$version);
      wp_enqueue_style('lf-optin-frontend', LF_PLUGIN_URL . '/css/lf-frontend.css', array(), leadflow::$version);

      // Icon Picker - Fonts
      wp_enqueue_style('lf-optin-fontello', LF_PLUGIN_URL . '/js/icon-picker/fonts/fontello/css/fontello.css', array(), leadflow::$version);
      wp_enqueue_style('lf-optin-icomoon', LF_PLUGIN_URL . '/js/icon-picker/fonts/icomoon/style.css', array(), leadflow::$version);

      // Button Styles
      wp_enqueue_style('lf-optin-button', LF_PLUGIN_URL . '/css/button-styles.css', array(), leadflow::$version);

      // FlipClock
      wp_register_style('lf-optin-flipclock', LF_PLUGIN_URL . '/js/flipclock/flipclock.css', array(), leadflow::$version);

      // Rating plugin
      wp_register_style('lf-optin-rating', LF_PLUGIN_URL . '/js/raty/jquery.raty.css', array(), leadflow::$version);

      wp_register_style('lf-optin-timepicker', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-timepicker-addon.min.css', array(), leadflow::$version);
      wp_register_style( 'jquery-ui-datepicker-style' , '//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css');


      foreach ($attached_optins as $optin_ID => $optin_type) {

        // Fetch current optin meta
        $meta = get_post_meta($optin_ID, LF_META, true);

        // Setup optin skin
        $skin = '';
        if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
          $skin = $meta['general']['skin'];
          // skin
          wp_register_style('lf-optin-skin', LF_PLUGIN_URL . '/templates/skins/' . $skin . '.css', array(), leadflow::$version);
        }

      } // foreach
      
    } // if $optins

  } // css_enqueues


  /*
   * $params
   * - force_all
   * - optin_id
   */
  static function js_enqueues($params = array()) {
    global $post, $attached_optins;

    if (!empty($params['optin_id'])) {
      $attached_optins = $params['optin_id'];
    }

    /*
    wp_register_script('jquery-ui-dialog');
    wp_register_script('jquery');
    wp_register_script('jquery-ui');
    wp_register_script('jquery-ui-slider');
    wp_register_script('jquery-ui-datepicker');
    wp_register_script('wp-color-picker');
    */

    wp_register_script('lf-optin', LF_PLUGIN_URL . '/templates/optin.js', array(), leadflow::$version, 1);
    wp_register_script('iris', admin_url('js/iris.min.js'), array('jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch'), false, 1);

    wp_register_script('wp-color-picker', admin_url('js/color-picker.min.js'), array('iris'), false, 1);

    wp_localize_script('wp-color-picker', 'wpColorPickerL10n',
      array('clear' => 'Clear',
        'defaultString' => 'Default',
        'pick' => 'Select Color'));

    wp_register_script('lf-optin-idle', LF_PLUGIN_URL . '/js/jquery.idle.js', array('jquery'), '1.2.1', true);
    wp_register_script('lf-optin-fitvid', LF_PLUGIN_URL . '/templates/fitvid.js', array('jquery'), leadflow::$version);
    wp_register_script('lf-optin-flipclock', LF_PLUGIN_URL . '/js/flipclock/flipclock.min.js', array('jquery'),leadflow::$version, true);
    wp_register_script('lf-optin-rating', LF_PLUGIN_URL . '/js/raty/jquery.raty.js', array('jquery'),leadflow::$version, true);

    wp_register_script('lf-optin-timepicker', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-timepicker-addon.min.js', array(), leadflow::$version, true);
    wp_register_script('lf-optin-timepicker-slider', LF_PLUGIN_URL . '/js/timepicker/jquery-ui-sliderAccess.js', array(), leadflow::$version, true);
    wp_register_script('lf-optin-timepicker-i18n', LF_PLUGIN_URL . '/js/timepicker/i18n/jquery-ui-timepicker-addon-i18n.min.js', array(), leadflow::$version, true);

    // Optin Type Specifics
    wp_register_script('lf-optin-welcome', LF_PLUGIN_URL . '/templates/welcome/optin.welcome.js', array(), leadflow::$version, true);
    wp_register_script('lf-optin-popup', LF_PLUGIN_URL . '/templates/popup/optin.popup.js', array(), leadflow::$version, true);
    wp_register_script('lf-optin-header', LF_PLUGIN_URL . '/templates/header/optin.header.js', array(), leadflow::$version, true);
    wp_register_script('lf-optin-pullout', LF_PLUGIN_URL . '/templates/pullout/optin.pullout.js', array(), leadflow::$version, true);

    // Do we have any optins attached to current page?
    if ($attached_optins) {
	   foreach($attached_optins as $optin_id => $optin_data){
		  $views = @$_COOKIE['lf_optin_views'];
		  $views = @unserialize($views);
		  @$views[$optin_id]++;
		  update_option('set_cookie_views_attached2', $views);
		  @setcookie('lf_optin_views', serialize($views), time() + DAY_IN_SECONDS * 60, '/');
		  
		}	
		
      // Enqueue On All Optins
      wp_enqueue_script('lf-optin-idle');

      wp_enqueue_script('lf-optin-ouibounce', LF_PLUGIN_URL . '/templates/ouibounce.min.js', array('jquery'), leadflow::$version,true);
      wp_enqueue_script('lf-optin-inview', LF_PLUGIN_URL . '/templates/jquery.inview.min.js', array('jquery'), leadflow::$version,true);

      // Register on all optins
      wp_register_script('lf-optin-frontend', LF_PLUGIN_URL . '/js/lf-frontend.js', array('jquery'), leadflow::$version, true);

      // Localize
      wp_localize_script('lf-optin-frontend', 'optin_frontend', array('raty_path' => LF_PLUGIN_URL . '/js/raty/'));

      wp_register_script('lf-optin-fitvid', LF_PLUGIN_URL . '/templates/fitvid.js', array('jquery'), leadflow::$version);
      wp_register_script('lf-optin-actions', LF_PLUGIN_URL . '/templates/optin.js', array('jquery'), leadflow::$version, true);

      foreach ($attached_optins as $optin_ID => $optin) {

        // Optin Meta
        $meta = get_post_meta($optin_ID, LF_META, true);

        // First Optin widgets start here
        $widgets = leadflow_optin_common::get_widgets($optin_ID, 'first');
        foreach ($widgets as $row => $widget) {
          foreach ($widget as $k => $widget_data) {
            leadflow_optin_conditionals::enqueue_widget_script($widget_data['type']);
          }
        }

        // Second Optin widgets start here
        $widgets = leadflow_optin_common::get_widgets($optin_ID, 'second');
        foreach ($widgets as $row => $widget) {
          foreach ($widget as $k => $widget_data) {
            leadflow_optin_conditionals::enqueue_widget_script($widget_data['type']);
          }
        }

        // Optin Type Switch
        switch($optin['type']) {
          case 'welcome':
            wp_register_script('lf-optin-popup', LF_PLUGIN_URL . '/templates/popup/popup.js', array('jquery'), leadflow::$version, true);
            wp_enqueue_script('lf-optin-welcome');
            wp_localize_script('lf-optin-welcome', 'optin_welcome_vars', array('idle_time' => $meta['welcome']['on_inactivity'],
              'on_load_time' => $meta['welcome']['on_pageload']));
            break;
          case 'popup':
            wp_enqueue_script('jquery-ui-dialog');
            wp_enqueue_script('lf-optin-popup');
            wp_localize_script('lf-optin-popup', 'optin_popup_vars', array('idle_time' => $meta['popup']['on_inactivity'],
              'on_load_time' => $meta['popup']['on_pageload']));
            wp_enqueue_style('lf-optin-popup', LF_PLUGIN_URL . '/templates/popup/style.css', array(), leadflow::$version);
            break;
          case 'header':
            wp_enqueue_script('lf-optin-header');
            wp_enqueue_style('lf-optin-header', LF_PLUGIN_URL . '/templates/header/style.css', array(), leadflow::$version);
            break;
          case 'pullout':
            wp_enqueue_style('lf-optin-fontello', LF_PLUGIN_URL . '/js/icon-picker/fonts/fontello/css/fontello.css', array(), leadflow::$version);
            wp_enqueue_script('lf-optin-pullout');
            wp_register_script('lf-optin-pullout', LF_PLUGIN_URL . '/templates/pullout/pullout.js', array('jquery'), leadflow::$version, true);
            wp_localize_script('lf-actions', 'optin_vars', array('idle_time' => $meta['pullout']['on_inactivity'],
              'on_load_time' => $meta['pullout']['on_pageload']));
            wp_enqueue_style('lf-optin-pullout', LF_PLUGIN_URL . '/templates/pullout/style.css', array(), leadflow::$version);
            break;
          default:
            wp_localize_script('lf-optin-shortcode', 'optin_style',
              array('css' => leadflow_optin_common::generate_optin_css($optin_ID),
                'skin' => leadflow_optin_common::get_skin($optin_ID)));
            break;
        } // switch
      }


      wp_enqueue_style('lf-optin');
      wp_enqueue_style('lf-optin-skin');
      wp_enqueue_style('lf-optin-frontend');
      wp_enqueue_script('lf-optin');
      wp_enqueue_script('lf-optin-frontend');
      wp_enqueue_script('lf-optin-inview');
      wp_enqueue_style('jquery-ui');
      wp_enqueue_style('wp-jquery-ui-dialog');

      if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
        $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
      } elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
        $after_subscribe_url = $meta['form']['redirect-custom-url'];
      }


      wp_localize_script('lf-optin', 'optin_vars',
        array('ajaxurl' => admin_url('admin-ajax.php'),
              'postID' => $optin_ID,
              'post_title' => get_the_title(),
              'after_subscribe_action' => @$meta['form']['after-subscribe-action'],
              'after_subscribe_url' => @$after_subscribe_url,
              'after_subscribe_message' => @$meta['form']['after-subscribe-alert-message'],
              'video_id' => trim(@$meta['settings']['video-id']),
              'custom_fields_addon' => class_exists('leadflow_fields')));


    }
  } // js_enqueues


  static function conditional_header_css() {
    global $post, $attached_optins;

    if ($attached_optins) {
      foreach ($attached_optins as $optin_ID => $optin_type) {
		echo leadflow_optin_frontend_common::generate_css($optin_ID);		
      } // foreach
    } // if ($optins)
	
	
	
  } // conditional_header_css


  static function conditional_footer_js() {
    global $post, $attached_optins;

    if ($attached_optins) {
      foreach ($attached_optins as $optin_ID => $optin_type) {

        //echo leadflow_optin_frontend_common::generate_css($optin_ID);

      } // foreach
    } // if ($optins)

  } // conditional_footer_js


  // check if popup should be displayed based on user based conditional options
  static function check_user_conditionals($popup_id, $type = 'popup') {
    $options = get_post_meta($popup_id, LF_META, true);

    if (!isset($options[$type])) {
      return true;
    }

    $options = $options[$type];

    if (isset($options['filter_subscribed']) && $options['filter_subscribed'] == 1) {
      if (leadflow_optin_common::is_user_subscribed($popup_id)) {
        return false;
      }
    }

    if (isset($options['filter_loggedin'])) {
      if ($options['filter_loggedin'] == 1 && !is_user_logged_in()) {
        return false;
      } elseif ($options['filter_loggedin'] == 2 && is_user_logged_in()) {
        return false;
      }
    }

    if (isset($options['limit_per_user']) && $options['limit_per_user'] > 0) {
      if (leadflow_optin_common::get_user_popup_views($popup_id) >= $options['limit_per_user']) {
        return false;
      }
    }

    return true;
  } // check_user_conditionals


  // check if popup should be displayed based on page based conditional options
  static function check_page_conditionals($popup_id, $type = 'popup') {
    global $post;
    $checked = false;
    #var_dump('optin id ' . $popup_id);
    $options = get_post_meta($popup_id, LF_META, true);

    if (!isset($options[$type]) || $type == 'shortcode'){
      return false;
    }

    $options = $options[$type];

    if (isset($options['on_home'])) {
      $checked = true;
      if (is_home() || is_front_page()) {
        return true;
      }
    }

    if (isset($options['on_archive'])) {
      $checked = true;
      if (is_archive()) {
        return true;
      }
    }

    if (isset($options['on_search'])) {
      $checked = true;
      if (is_search()) {
        return true;
      }
    }

    if (isset($options['on_post'])) {
      $checked = true;
      if(in_array($post->ID, $options['on_post'])) {
        return true;
      }
    }

    if (isset($options['on_pages'])) {
      $checked = true;

      if(in_array($post->ID, $options['on_pages'])) {
        return true;
      }
    }

    if (isset($options['on_category'])) {
      $checked = true;

      if(is_category($options['on_category']) || in_category($options['on_category'], $popup_id)) {
        return true;
      }
    }

    return false;

    // original
    if ($checked) {
      return false;
    } else {
      return true;
    }
  } // check_page_conditionals


} // leadflow_optin_enqueues