<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
* Admin Ajax
*/

class leadflow_optin_preview extends leadflow {


  // admin enqueues
  static function admin_enqueues() {
    global $optin_preview;
    $screen = get_current_screen();

    // optins
    if ($screen->id == 'edit-optin-pages' || $screen->id == 'optin-pages') {
    // Preview Setup
      $preview = get_transient('lf-show-preview');
      if (!empty($preview)) {
        
        delete_transient('lf-show-preview');
        $optin_preview = $preview;
        
        wp_enqueue_script('leadflow-optin-preview', LF_PLUGIN_URL . '/js/lf-admin-optin-preview.js', array('jquery'), leadflow::$version, true);
        wp_localize_script('leadflow-optin-preview', 'lf_preview_vars', array('optin_ID' => $preview));
      }

    }

  } // admin_enqueues


  // admin preview dialog
  static function print_preview_dialog() {
    global $optin_preview;
    $screen = get_current_screen();

    if ($screen->id == 'edit-optin-pages' || $screen->id == 'optin-pages') {

      if (!empty($optin_preview)) {
        $settings = get_option(LF_OPTIONS, array());
        
        $optin_type = get_post_meta($optin_preview, 'optin_type', true);
        if ($optin_type == 'standalone' || $optin_type == 'embed') {
          $preview_url = get_permalink($optin_preview);
        } else {
          $preview_url = get_permalink($settings['optin_preview_page']) . '?preview-post-id=' . $optin_preview;
        }
        
        echo '<script type="text/javascript">';
        echo 'jQuery(document).ready(function($){';
        echo "var win = window.open('" . $preview_url . "', '_blank');
              if(win){
                //Browser has allowed it to be opened
                win.focus();
              }else{
                //Broswer has blocked it
                alert('Please allow popups for this site');
              }";
        echo '});';
        echo '</script>';
      }
    }
  } // print_preview_dialog


} // leadflow_optin_preview