<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_stats extends leadflow {
  static function flow_add_view($flow_id, $flow_start, $new_subscriber = false) {
    global $wpdb;

    $flow_type = leadflow_flow_common::get_flow_type($flow_id);
    if (!$flow_type) {
       return false;
    }

    if ($flow_start) {
      $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views = views + 1',
                       array(current_time('mysql'), $flow_id, 'flow', 1, 0, 0)));
    } else {
      if ($new_subscriber) {
        self::subscriber_add();
        $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views_box2 = views_box2 + 1, conversions = conversions + 1',
                       array(current_time('mysql'), $flow_id, 'flow', 0, 1, 1)));
      } else {
        $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views_box2 = views_box2 + 1',
                       array(current_time('mysql'), $flow_id, 'flow', 0, 1, 0)));  
      }
      
      leadflow_page_lock::unlock_page($flow_id, 'flow');
    }
    
    return true;    
  } // flow_add_view
  
  
  static function event_add_custom() {
    
  } // event_add_custom
  
  
  static function subscriber_add($count = 1) {
    global $wpdb;
    
    $count = (int) $count;
    
    $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE conversions = conversions + %d',
                       array(current_time('mysql'), 0, 'subscriber', 0, 0, $count, $count)));
                       
    return true;
  } // subscriber_add
  
  
  // Add view count for optin
  static function optin_add_view($optin_id, $step) {
    global $wpdb, $currently_active_ab, $doing_test;
    
    $optin_type = leadflow_optin_common::get_optin_type($optin_id);
    if (!$optin_type) {
       return false;
    }
    
    if ($step != 'box1' && $step != 'box2' && $step != 'optin') {
      trigger_error('Unknown step in optin stats. Use box1, box2 or optin.', E_USER_ERROR);
      return false;
    }

    if (!isset($_SESSION['lf_optins'][$optin_id])) {
      $_SESSION['lf_optins'][$optin_id] = array();
    }
    
    if ($step == 'box1' && empty($_SESSION['lf_optins'][$optin_id]['box1'])) {
      $_SESSION['lf_optins'][$optin_id]['box1'] = true;
      
      $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views = views + 1',
                       array(current_time('mysql'), $optin_id, 'optin', 1, 0, 0)));
                       
      if ($doing_test) {
        $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views = views + 1',
                       array(current_time('mysql'), $currently_active_ab, 'ab_test', 1, 0, 0)));
      }
    } elseif ($step == 'box2' && empty($_SESSION['lf_optins'][$optin_id]['box2'])) {
      $_SESSION['lf_optins'][$optin_id]['box1'] = true;
      
      $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE views_box2 = views_box2 + 1',
                       array(current_time('mysql'), $optin_id, 'optin', 0, 1, 0)));
    } elseif ($step == 'optin') {
      $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE conversions = conversions + 1',
                       array(current_time('mysql'), $optin_id, 'optin', 0, 0, 1)));  
      if ($doing_test) {
        $wpdb->query($wpdb->prepare('INSERT INTO ' . $wpdb->lf_stats . ' (date, object_id, type, views, views_box2, conversions)
                       VALUES (%s, %d, %s, %d, %d, %d)
                       ON DUPLICATE KEY UPDATE conversions = conversions + 1',
                       array(current_time('mysql'), $currently_active_ab, 'ab_test', 0, 0, 1)));  
      }
      
      if (!empty($optin_id)) {
        leadflow_page_lock::unlock_page($optin_id, 'optin');
      }
    }
                           
    return true;    
  } // optin_add_view
  
  
  // event add optin
  static function event_add_optin($event, $save_to_user = false) {
	$defaults = array('timestamp' => current_time('timestamp'), 'type' => 'optin', 'post_id' => 0, 'new' => false, 'country' => '', 'city' => '', 'region' => '', 'uuid' => 0);
    
    $event = array_merge($defaults, $event);
    
    self::events_update($event);
    
    if ($save_to_user) {
      leadflow_subscribers_common::add_event($event['uuid'], $event);
    }
    
    return true;
  } // event_add_optin
  
  // event add optin
  static function event_add_import($event, $save_to_user = false) {
	$defaults = array('timestamp' => current_time('timestamp'), 'type' => 'import', 'post_id' => 0, 'new' => false, 'file'=> '', 'total' => 0, 'uuid' => 0);
    
    $event = array_merge($defaults, $event);
    
    self::events_update($event);
    
    if ($save_to_user) {
      leadflow_subscribers_common::add_event($event['uuid'], $event);
    }
    
    return true;
  } // event_add_optin
  
  static function event_add_flow($event, $save_to_user = false) {
	  update_option('add_flow', 'add');
	$defaults = array('timestamp' => current_time('timestamp'), 'type' => 'flow', 'post_id' => 0, 'new' => false, 'country' => '', 'city' => '', 'region' => '', 'uuid' => 0);
    
    $event = array_merge($defaults, $event);
    
    self::events_update($event);
    
    if ($save_to_user) {
      leadflow_subscribers_common::add_event($event['uuid'], $event);
    }
    
    return true;
  } // event_add_flow
  
  
  static function event_add_ecommerce($event, $save_to_user = false) {
    $defaults = array('timestamp' => current_time('timestamp'), 'type' => 'flow_ecommerce', 'post_id' => 0, 'new' => false, 'country' => '', 'city' => '', 'region' => '', 'price' => 0, 'uuid' => 0);
    
    $event = array_merge($defaults, $event);
    
    self::events_update($event);
    
    if ($save_to_user) {
      leadflow_subscribers_common::add_event($event['uuid'], $event);
    }
    
    return true;
  } // event_add_ecommerce
  
  
  static function events_update($events) {
    $max_events = 200;
    $events_old = self::events_get();
    
    if (empty($events[0])) {
      $events = array($events);
    }
    
    $events = array_merge($events, $events_old);
    if (sizeof($events) > $max_events) {
      $events = array_slice($events, 0, $max_events);
    }
    
    update_option(LF_EVENTS, $events, false);
    
    return true; 
  } // events_update
  
  
  static function events_get($types = array(), $limit = 0) {
    $events_org = get_option(LF_EVENTS, array());
    $events = array();
    
    if ($types) {
      $size = sizeof($events_org);
      for ($i = 0; $i < $size; $i++) {
        if (in_array($events_org[$i]['type'], $types)) {
          $events[] = $events_org[$i];
        }
        if ($limit && sizeof($events) >= $limit) {
          return $events;
        }
      } // for
    } else { // if $types filter
      if ($limit) {
        $events = array_slice($events_org, 0, $limit);
      } else {
        $events = $events_org;
      }
    }
    
    return $events;
  } // events_get
  
  
  static function events_get_formatted_subscriber($subscriber_id, $limit = 20, $last_timestamp = 0) {
    $output = array();
    $events = self::events_get(false, $limit);
    $size = sizeof($events);
    for ($i = 0; $i < $size; $i++) {
      $event = $events[$i];
      $location = '';
      
      if ($event['uuid'] != $subscriber_id) {
        continue;
      }
      
      $tmp = array('timestamp' => $event['timestamp'], 'type' => $event['type']);
      
      if (!empty($event['country'])) {
        if (!empty($event['city'])) {
          $location .= $event['city'] . ', ';
        }
        if (!empty($event['region'])) {
          $location .= $event['region'] . ', ';
        }
        $location .= $event['country'];
        $location = ' from ' . $location;
      }
      
      $object_title = get_the_title($event['post_id']);
      
      if ($event['type'] == 'flow_ecommerce') {
        $tmp['img_dir'] = 'event_types';
        $tmp['img'] = 'ecommerce';
        if(!empty($event['product_name'])) {
          $tmp['msg'] = 'Purchased ' . $event['product_name'] . ' from JVZoo for $' . $event['price']. ' (via ' . $object_title . ' flow)';
        } else {
          $tmp['msg'] = 'Made a new transaction' . $location . ' via ' . $object_title . ' flow valued at $' . $event['price'];  
        }
      } elseif ($event['type'] == 'flow') {
        $tmp['img_dir'] = 'event_types';
        $tmp['img'] = 'flow';
        if ($event['new']) {
          $tmp['msg'] = 'Subscribed for the first time' . $location . ' via ' . $object_title . ' flow';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' passed through ' . $object_title . ' flow';
        }
      } elseif ($event['type'] == 'optin') {
        $tmp['img_dir'] = 'event_types';
        $tmp['img'] = 'optin';
        if ($event['new']) {
          $tmp['msg'] = 'Opted in the first time' . $location . ' via ' . $object_title . ' optin';
        } else {
          $tmp['msg'] = 'Opted in' . $location . ' through ' . $object_title . ' optin';
        }
      }    
      $output[] = $tmp;
    } // for $events
    
    return $output;
  } // events_get_formatted_subscriber
  
  
  static function events_get_formatted_dashboard($limit = 20, $last_timestamp = 0) {
    $events = self::events_get(false, $limit);
    $cut = false;
    
    $size = sizeof($events);
    for ($i = 0; $i < $size; $i++) {
      $event = $events[$i];
      $location = '';
      
      if ($last_timestamp && $event['timestamp'] < $last_timestamp) {
        $cut = true;
        break;
      }
      
      $tmp = array('timestamp' => $event['timestamp'], 'type' => $event['type']);
      $subscriber = leadflow_subscribers_common::get_details($event['uuid']);
      if ($event['type']!='import' && !$subscriber) {
		$events[$i]='';  
        continue;
      }
      
      if (!empty($event['country'])) {
        if (!empty($event['city'])) {
          $location .= $event['city'] . ', ';
        }
        if (!empty($event['region'])) {
          $location .= $event['region'] . ', ';
        }
        $location .= $event['country'];
        $location = ' from ' . $location;
      }
      
      if ($subscriber['firstname'] || $subscriber['lastname']) {
        $tmp['name'] = str_replace('  ', ' ', trim($subscriber['firstname'] . ' ' . $subscriber['lastname'] . ' (' . $subscriber['email'] . ')'));
      } else {
        $tmp['name'] = $subscriber['email'];
      }
	  	  
      if ($event['type'] == 'flow_ecommerce') {
        if($event['affiliate_transaction']===1){
			$tmp['msg'] = 'You made an affiliate sale to <a href="'.get_edit_post_link( $event['uuid'] ).'">' . $tmp['name'] .'</a>'. $location . ' via <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> flow valued at $' . $event['price'];
		} else {
			$tmp['msg'] = 'You made a sale to <a href="'.get_edit_post_link( $event['uuid'] ).'">' . $tmp['name'] .'</a>'. $location . ' via <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> flow valued at $' . $event['price'];
		}
		
      } elseif ($event['type'] == 'flow') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber, <a href="'.get_edit_post_link( $event['uuid'] ).'">'. $tmp['name']. '</a>, added' . $location . ' via <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> flow';
        } else {
          $tmp['msg'] = '<a href="'.get_edit_post_link( $event['uuid'] ).'">'.$tmp['name'].'</a>' . $location . ' passed through <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> flow';
        }
      } elseif ($event['type'] == 'optin') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber, <a href="'.get_edit_post_link( $event['uuid'] ).'">' . $tmp['name'] . '</a>, ' . $location . ' added via <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> optin';
        } else {
          $tmp['msg'] = '<a href="'.get_edit_post_link( $event['uuid'] ).'">'.$tmp['name'].'</a>' . $location . ' opted in through <a href="'.get_edit_post_link( $event['post_id'] ).'">' . get_the_title($event['post_id']) . '</a> optin';
        }
      } elseif ($event['type'] == 'import') {
		  $user_info = get_userdata($event['uuid']);
          $tmp['msg'] = $user_info->user_login.' Imported <strong>'.$event['total_imported'].'</strong> subscribers from <strong>'.$event['file'].'</strong>';
      } else {
        $tmp['msg'] =''; 
      }
	  
      $tmp['compiled'] = '<li><img width="24" src="' . LF_PLUGIN_URL . '/images/event_types/' . $tmp['type'] . '.png" alt="' . $tmp['type'] . '" title="' . $tmp['type'] . '"> ' . $tmp['msg'] . ' <span class="time_diff">' . human_time_diff($tmp['timestamp'],  current_time('timestamp')). ' ago</span></li>';
      
      $events[$i] = $tmp['compiled'];
    } // for $events
    
    if ($cut) {
      $events = array_splice($events, 0, $i);
    }
    
    return $events;
  } // events_get_formatted_dashboard
  
  
  static function events_get_formatted_mobile_activity($limit = 0) {
    $events = self::events_get(array('optin', 'flow', 'flow_ecommerce'), $limit);
    $icons = get_option('lf-icons');
    
    $size = sizeof($events);
    for ($i = 0; $i < $size; $i++) {
      $event = $events[$i];
      $location = '';
      $tmp['msg'] = '';
      $tmp = array('timestamp' => $event['timestamp'], 'type' => $event['type']);
      $subscriber = leadflow_subscribers_common::get_details($event['uuid']);
      if (!$subscriber) {
        continue;
      }
      
      
      $tmp['icon_url'] = $icons[$event['type']]['file'];
      
      if (!empty($event['country'])) {
        if (!empty($event['city'])) {
          $location .= $event['city'] . ', ';
        }
        if (!empty($event['region'])) {
          $location .= $event['region'] . ', ';
        }
        $location .= $event['country'];
        $location = ' from ' . $location;
      }
      
      
      if ($subscriber['firstname'] || $subscriber['lastname']) {
        $tmp['name'] = str_replace('  ', ' ', trim($subscriber['firstname'] . ' ' . $subscriber['lastname'] . ' (' . $subscriber['email'] . ')'));
      } else {
        $tmp['name'] = $subscriber['email'];
      }
      if ($event['type'] == 'flow_ecommerce') {
        $tmp['msg'] = 'New transaction made' . $location . ' via ' . get_the_title($event['post_id']) . ' flow valued at $' . $event['price'];
      } elseif ($event['type'] == 'flow') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber added' . $location . ' via ' . get_the_title($event['post_id']) . ' flow';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' passed through ' . get_the_title($event['post_id']) . ' flow';
        }
      } elseif ($event['type'] == 'optin') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber' . $location . ' added via ' . get_the_title($event['post_id']) . ' optin';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' opted in through ' . get_the_title($event['post_id']) . ' optin';
        }
      }    
      $events[$i] = $tmp;
    } // for $events
    
    return $events;
  } // events_get_formatted_mobile_activity
  
  
  static function get_user_events($user_id) {
    $output = array();
    $events = get_post_meta($user_id, 'events', true);
    
    if (!empty($events)) {
    foreach ($events as $key => $event) {
      $location = '';
      $tmp = array('timestamp' => $event['timestamp'], 'type' => $event['type']);
      $tmp['msg'] = '';
      
      $subscriber = leadflow_subscribers_common::get_details($user_id);
      if (!$subscriber) {
        continue;
      }
      
      if (!empty($event['country'])) {
        if (!empty($event['city'])) {
          $location .= $event['city'] . ', ';
        }
        if (!empty($event['region'])) {
          $location .= $event['region'] . ', ';
        }
        $location .= $event['country'];
        $location = ' from ' . $location;
      }
      
      
      if ($subscriber['firstname'] || $subscriber['lastname']) {
        $tmp['name'] = str_replace('  ', ' ', trim($subscriber['firstname'] . ' ' . $subscriber['lastname'] . ' (' . $subscriber['email'] . ')'));
      } else {
        $tmp['name'] = $subscriber['email'];
      }
      if ($event['type'] == 'flow_ecommerce') {
        $tmp['msg'] = 'New transaction made' . $location . ' via ' . get_the_title($event['post_id']) . ' flow valued at $' . $event['price'];
      } elseif ($event['type'] == 'flow') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber added' . $location . ' via ' . get_the_title($event['post_id']) . ' flow';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' passed through ' . get_the_title($event['post_id']) . ' flow';
        }
      } elseif ($event['type'] == 'optin') {
        if ($event['new']) {
          $tmp['msg'] = 'New subscriber' . $location . ' added via ' . get_the_title($event['post_id']) . ' optin';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' opted in through ' . get_the_title($event['post_id']) . ' optin';
        }
      } 
      $output[] = $tmp;
    } // foreach $events
    }
    return $output; 
  } // events_get_formatted_mobile_activity
  
  
  static function events_get_formatted_mobile_subscriber($events) {
    $size = sizeof($events);
    for ($i = 0; $i < $size; $i++) {
      $event = $events[$i];
      $location = '';
      
      $tmp = array('timestamp' => $event['timestamp'], 'type' => $event['type']);
      
      if (!empty($event['country'])) {
        if (!empty($event['city'])) {
          $location .= $event['city'] . ', ';
        }
        if (!empty($event['region'])) {
          $location .= $event['region'] . ', ';
        }
        $location .= $event['country'];
        $location = ' from ' . $location;
      }
      
      $object_title = get_the_title($event['post_id']);
      
      if ($event['type'] == 'flow_ecommerce') {
        $tmp['msg'] = 'Made a new transaction' . $location . ' via ' . $object_title . ' flow valued at $' . $event['price'];
      } elseif ($event['type'] == 'flow') {
        if ($event['new']) {
          $tmp['msg'] = 'Subscribed for the first time' . $location . ' via ' . $object_title . ' flow';
        } else {
          $tmp['msg'] = 'Subscriber' . $location . ' passed through ' . $object_title . ' flow';
        }
      } elseif ($event['type'] == 'optin') {
        if ($event['new']) {
          $tmp['msg'] = 'Opted in the first time' . $location . ' via ' . $object_title . ' optin';
        } else {
          $tmp['msg'] = 'Opted in' . $location . ' through ' . $object_title . ' optin';
        }
      }    
      $events[$i] = $tmp;
    } // for $events
    
    return $events;
  } // events_get_formatted_mobile_subscriber
  
  
  static function get_flows_stats() {
    global $wpdb;
    $out = array();
    
    // sums
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as passes, SUM(conversions) as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s', array('flow')), ARRAY_A);
    $out['views'] = (int) $tmp['views'];
    $out['passes'] = (int) $tmp['passes'];
    $out['new_subscribers'] = (int) $tmp['new_subscribers'];
    
    // sums 24h
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as passes, SUM(conversions) as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('flow', date('Y-m-d', current_time('timestamp')))), ARRAY_A);
    $out['views_24h'] = (int) $tmp['views'];
    $out['passes_24h'] = (int) $tmp['passes'];
    $out['new_subscribers_24h'] = (int) $tmp['new_subscribers'];
    
    // trends
    $today = $wpdb->get_row($wpdb->prepare('SELECT SUM(views_box2) as passes, SUM(conversions) as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('flow', date('Y-m-d', current_time('timestamp')))), ARRAY_A);
    if (!$today) {
      $today['passes'] = 0;
      $today['new_subscribers'] = 0;
    }
    
    $yesterday = $wpdb->get_row($wpdb->prepare('SELECT SUM(views_box2) as passes, SUM(conversions) as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('flow', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)))), ARRAY_A);
    if (!$yesterday) {
      $yesterday['passes'] = 0;
      $yesterday['new_subscribers'] = 0;
    }
    
    if (!$yesterday['passes']) {
      $out['trend_passes'] = number_format(($today['passes']? 100: 0), 1);
    } else {
      $out['trend_passes'] = number_format(($yesterday['passes'] - $today['passes']) / $yesterday['passes'] * -100, 1);  
    }
    
    if (!$yesterday['new_subscribers']) {
      $out['trend_new_subscribers'] = number_format(($today['new_subscribers']? 100: 0), 1);
    } else {
      $out['trend_new_subscribers'] = number_format(($yesterday['new_subscribers'] - $today['new_subscribers']) / $yesterday['new_subscribers'] * -100, 1);  
    }
    
    return $out;
  } // get_flows_stats
  
  
  static function get_flow_stats($flow_id, $days_history = 30) {
    global $wpdb;
    $flow_id = (int) $flow_id;
    $days_history = (int) $days_history;
    
    if (!leadflow_flow_common::get_flow_type($flow_id)) {
      return array('views' => 0, 'passes' => 0, 'new_subscribers' => 0, 'trend_passes' => 0, 'trend_new_subscribers' => 0, 'history' => array());
    }
    
    // sums
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as passes, SUM(conversions) as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id = %d', array('flow', $flow_id)), ARRAY_A);
    $out['views'] = (int) $tmp['views'];
    $out['passes'] = (int) $tmp['passes'];
    $out['new_subscribers'] = (int) $tmp['new_subscribers'];
    
    // trends
    $today = $wpdb->get_row($wpdb->prepare('SELECT views as views, views_box2 as passes, conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id = %d', array('flow', date('Y-m-d', current_time('timestamp')), $flow_id)), ARRAY_A);
    if (!$today) {
      $today['passes'] = 0;
      $today['views'] = 0;
      $today['new_subscribers'] = 0;
    }
    
    $yesterday = $wpdb->get_row($wpdb->prepare('SELECT views as views, views_box2 as passes, conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id = %d', array('flow', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)), $flow_id)), ARRAY_A);
    if (!$yesterday) {
      $yesterday['passes'] = 0;
      $yesterday['views'] = 0;
      $yesterday['new_subscribers'] = 0;
    }
    
    if (!$yesterday['views']) {
      $out['trend_views'] = number_format(($today['views']? 100: 0), 1);
    } else {
      $out['trend_views'] = number_format(($yesterday['views'] - $today['views']) / $yesterday['views'] * -100, 1);  
    }
    
    if (!$yesterday['passes']) {
      $out['trend_passes'] = number_format(($today['passes']? 100: 0), 1);
    } else {
      $out['trend_passes'] = number_format(($yesterday['passes'] - $today['passes']) / $yesterday['passes'] * -100, 1);  
    }
    
    if (!$yesterday['new_subscribers']) {
      $out['trend_new_subscribers'] = number_format(($today['new_subscribers']? 100: 0), 1);
    } else {
      $out['trend_new_subscribers'] = number_format(($yesterday['new_subscribers'] - $today['new_subscribers']) / $yesterday['new_subscribers'] * -100, 1);  
    }
    
    // graph
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as passes, conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id = %d AND date > %s', array('flow', $flow_id, date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = array('views' => 0, 'passes' => 0, 'new_subscribers' => 0, 'passes_rate' => 0.0, 'new_subscribers_rate' => 0.0);
    }
    foreach ($stats as $day) {
      $days[$day->date] = array('views' => $day->views, 'passes' => $day->passes, 'new_subscribers' => $day->new_subscribers, 'passes_rate' => $day->views? number_format(min((int) $day->passes / $day->views * 100, 100), 1): number_format(0, 1), 'new_subscribers_rate' => $day->views? number_format(min((int) $day->new_subscribers / $day->views * 100, 100), 1): number_format(0, 1));
    }
    $out['history'] = $days;
    
    return $out;
  } // get_flow_stats
  
  
  static function get_optin_stats($optin_id, $days_history = 30) {
    global $wpdb;
    $optin_id = (int) $optin_id;
    $days_history = (int) $days_history;
    
    if (!leadflow_optin_common::get_optin_type($optin_id)) {
      return array('views' => 0, 'views_box2' => 0, 'conversions' => 0, 'conversion_rate' => 0, 'trend_views' => 0, 'trend_conversions' => 0, 'history' => array());
    }
    
    // sums
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as views_box2, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id = %d', array('optin', $optin_id)), ARRAY_A);
    $out['views'] = (int) $tmp['views'];
    $out['views_box2'] = (int) $tmp['views_box2'];
    $out['conversions'] = (int) $tmp['conversions'];
    $out['conversion_rate'] = $out['views']? number_format(min((int) $out['conversions'] / $out['views'] * 100, 100), 1): number_format(0, 1);
    
    // trends
    $today = $wpdb->get_row($wpdb->prepare('SELECT views as views, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id = %d', array('optin', date('Y-m-d', current_time('timestamp')), $optin_id)), ARRAY_A);
    if (!$today) {
      $today['views'] = 0;
      $today['conversions'] = 0;
    }
    
    $yesterday = $wpdb->get_row($wpdb->prepare('SELECT views as views, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id = %d', array('optin', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)), $optin_id)), ARRAY_A);
    if (!$yesterday) {
      $yesterday['views'] = 0;
      $yesterday['conversions'] = 0;
    }
    
    if (!$yesterday['views']) {
      $out['trend_views'] = number_format(($today['views']? 100: 0), 1);
    } else {
      $out['trend_views'] = number_format(($yesterday['views'] - $today['views']) / $yesterday['views'] * -100, 1);  
    }
    
    if (!$yesterday['conversions']) {
      $out['trend_conversions'] = number_format(($today['conversions']? 100: 0), 1);
    } else {
      $out['trend_conversions'] = number_format(($yesterday['conversions'] - $today['conversions']) / $yesterday['conversions'] * -100, 1);  
    }
    
    // graph
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as views_box2, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id = %d AND date > %s', array('optin', $optin_id, date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = array('views' => 0, 'views_box2' => 0, 'conversions' => 0, 'conversion_rate' => 0.0);
    }
    foreach ($stats as $day) {
      $days[$day->date] = array('views' => $day->views, 'views_box2' => $day->views_box2, 'conversions' => $day->conversions, 'conversion_rate' => $day->views? number_format(min((int) $day->conversions / $day->views * 100, 100), 1): number_format(0, 1));
    }
    $out['history'] = $days;
    
    return $out;
  } // get_optin_stats
  
  
  
  static function get_optins_chart($days_history = 30) {
    global $wpdb;
    $days_history = (int) $days_history;
    
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as views_box2, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date > %s', array('optin', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = array('views' => 0, 'views_box2' => 0, 'conversions' => 0, 'conversion_rate' => 0.0);
    }
    foreach ($stats as $day) {
      if(isset($days[$day->date])){
		  $days[$day->date]['views']+=$day->views;
		  $days[$day->date]['views_box2']+=$day->views_box2;
		  $days[$day->date]['conversions']+=$day->conversions;		  
	  } else {
		  $days[$day->date] = array('views' => $day->views, 'views_box2' => $day->views_box2, 'conversions' => $day->conversions, 'conversion_rate' => $day->views? number_format(min((int) $day->conversions / $day->views * 100, 100), 1): number_format(0, 1));
	  }
    }
    $out['history'] = $days;
    
    return $out;
  } // get_optins_chart
  
  
  static function createDateRangeArray($strDateFrom,$strDateTo)
	{
		// takes two dates formatted as YYYY-MM-DD and creates an
		// inclusive array of the dates between the from and to dates.
	
		// could test validity of dates here but I'm already doing
		// that in the main script
	
		$aryRange=array();
	
		$iDateFrom=mktime(1,0,0,substr($strDateFrom,5,2),     substr($strDateFrom,8,2),substr($strDateFrom,0,4));
		$iDateTo=mktime(1,0,0,substr($strDateTo,5,2),     substr($strDateTo,8,2),substr($strDateTo,0,4));
	
		if ($iDateTo>=$iDateFrom)
		{
			array_push($aryRange,date('Y-m-d',$iDateFrom)); // first entry
			while ($iDateFrom<$iDateTo)
			{
				$iDateFrom+=86400; // add 24 hours
				array_push($aryRange,date('Y-m-d',$iDateFrom));
			}
		}
		return $aryRange;
	}


  static function get_stats_by_id($objectid, $date_start, $date_end) {
    global $wpdb;
    
	
	
	
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as views_box2, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE object_id = %s AND date >= %s  AND date <= %s', array($objectid, $date_start, $date_end )));
    
	$days = array();
    $days_arr = self::createDateRangeArray($date_start, $date_end);
	
	
	
    foreach ($days_arr as $date ){
      $days[$date] = array('views' => 0, 'viewsbox2' => 0, 'conversions' => 0, 'conversion_rate' => 0.0);
    }
    foreach ($stats as $day) {
      if(isset($days[$day->date])){
		  $days[$day->date]['views']+=$day->views;
		  $days[$day->date]['viewsbox2']+=$day->views_box2;
		  $days[$day->date]['conversions']+=$day->conversions;		  
	  } else {
		  $days[$day->date] = array('views' => $day->views, 'viewsbox2' => $day->views_box2, 'conversions' => $day->conversions, 'conversion_rate' => $day->views? number_format(min((int) $day->conversions / $day->views * 100, 100), 1): number_format(0, 1));
	  }
    }
	
	
    $output=array();	
	
	
    $temp_headers=array();
	$temp_headers[]='Date';
	$temp_headers[]='Views';
	$temp_headers[]='Views Box 2';
	$temp_headers[]='Conversions';
	$output[]=$temp_headers;
	
	
	foreach($days as $date=>$data){
		$temp_array=array();
		$temp_array[]=$date;
		$temp_array[]=$data['views'];
		$temp_array[]=$data['viewsbox2'];
		$temp_array[]=$data['conversions'];
		
		$output[]=$temp_array;	
	}
	
    return $output;
  } // get_optins_chart
  
  
  
  static function get_ab_stats_by_id($objectid, $date_start, $date_end) {
    global $wpdb;
    
	
	$ab_test_details = leadflow_ab_test_common::get_details($objectid);
	$ab_ids = explode(',',$ab_test_details['ids']);
	
	
	
	$days_arr = self::createDateRangeArray($date_start, $date_end);
		
	foreach ($days_arr as $date ){
	  $tmp_day_array=array();
	  foreach($ab_ids as $ab_id){
		$tmp_day_array['views_'.$ab_id]= 0;
		$tmp_day_array['viewsbox2_'.$ab_id]= 0;
		$tmp_day_array['conversions_'.$ab_id]= 0;
	  }
	  $days[$date] = $tmp_day_array;
	}
	
	
	foreach($ab_ids as $ab_id){
		$stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as views_box2, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE object_id = %s AND date >= %s  AND date <= %s', array($ab_id, $date_start, $date_end )));
		
		
		
		
		foreach ($stats as $day) {

		  if(!isset($days[$day->date])) $days[$day->date]=array();
		  
		  if(!isset($days[$day->date]['views_'.$ab_id])) $days[$day->date]['views_'.$ab_id]=0;
		  if(!isset($days[$day->date]['viewsbox2_'.$ab_id])) $days[$day->date]['viewsbox2_'.$ab_id]=0;
		  if(!isset($days[$day->date]['conversions_'.$ab_id])) $days[$day->date]['conversions_'.$ab_id]=0;
		  //if(!isset($days[$day->date]['conversion_rate_'.$ab_id])) $days[$day->date]['conversion_rate_'.$ab_id]=0;
			  
		  $days[$day->date]['views_'.$ab_id]+=$day->views;
		  $days[$day->date]['viewsbox2_'.$ab_id]+=$day->views_box2;
		  $days[$day->date]['conversions_'.$ab_id]+=$day->conversions;		  		
		}
	}
	
	$output=array();	
	
	
    $temp_headers=array();
	$temp_headers[]='Date';
	foreach($ab_ids as $ab_id){
		$temp_headers[]=get_the_title($ab_id).' Views';
		$temp_headers[]=get_the_title($ab_id).' Views Box 2';
		$temp_headers[]=get_the_title($ab_id).' Conversions';
	}
	$output[]=$temp_headers;
	
	
	foreach($days as $date=>$data){
		$temp_array=array();
		$temp_array[]=$date;
		foreach($ab_ids as $ab_id){
			if(isset($data['views_'.$ab_id])) {
				$temp_array[]=$data['views_'.$ab_id];
			} else {
				$temp_array[]=0;
			}
			if(isset($data['viewsbox2_'.$ab_id])) {
				$temp_array[]=$data['viewsbox2_'.$ab_id];
			} else {
				$temp_array[]=0;
			}
			if(isset($data['conversions_'.$ab_id])) {
				$temp_array[]=$data['conversions_'.$ab_id];
			} else {
				$temp_array[]=0;
			}
		}
		$output[]=$temp_array;	
	}
	
    return $output;
  } // get_optins_chart
  
  
  
  static function get_flows_chart($days_history = 30) {
    global $wpdb;
    $days_history = (int) $days_history;
    
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, views_box2 as views_box2, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date > %s', array('flow', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = array('views' => 0, 'views_box2' => 0, 'conversions' => 0, 'conversion_rate' => 0.0);
    }
    foreach ($stats as $day) {
      if(isset($days[$day->date])){
		  $days[$day->date]['views']+=$day->views;
		  $days[$day->date]['views_box2']+=$day->views_box2;
		  $days[$day->date]['conversions']+=$day->conversions;		  
	  } else {
		  $days[$day->date] = array('views' => $day->views, 'views_box2' => $day->views_box2, 'conversions' => $day->conversions, 'conversion_rate' => $day->views? number_format(min((int) $day->conversions / $day->views * 100, 100), 1): number_format(0, 1));
	  }
    }
    $out['history'] = $days;
    
    return $out;
  } // get_optin_stats
  
  static function get_subscriber_growth() {
    global $wpdb;
		
	if ( false === ( $days = get_transient( 'subscriber_growth_chart' ) ) ) {
		$stats = $wpdb->get_results('SELECT date as date, conversions as conversions FROM ' . $wpdb->lf_stats . ' ORDER BY date ASC' );
		
		 $days = array();
		
		foreach ($stats as $day) {
		  @$days[ substr($day->date,5,5) ]+=(int)$day->conversions;	  
		}
		
		$previous_date='';
		foreach ($days as $date=>$val) {
		  if($previous_date) $days[$date]+=$days[$previous_date];
		  $previous_date=$date;
		}
	
    	set_transient( 'subscriber_growth_chart', $days, 3 * HOUR_IN_SECONDS );
	}
	
    return $days;
  } // get_subscriber_growth
  
  
  
  
  
  static function get_specified_optin_stats($what = 'views', $optin_id = '', $date_from = '', $date_to = '') {
    global $wpdb;
    
    $sql = "SELECT date, {$what} FROM ".  $wpdb->lf_stats . " WHERE object_id='" . $optin_id . "'";
    
    if (!empty($date_from)) {
      $sql .= " AND date>='" . $date_from . "'";
    }
    
    if (!empty($date_to)) {
      $sql .= " AND date<='" . $date_to . "'";
    }
    
    $sql .= "ORDER by date ASC";

    $results = $wpdb->get_results($sql);
    
    return $results;
  } // get_specified_optin_stats
  
  
  static function get_optins_stats($optin_id = '', $date_from = '', $date_to = '') {
    global $wpdb;
    $out = array();
    
    $sums_query_addon = '';

    $sums_query_params = array('optin');
    $sums_24_query_params = array('optin', date('Y-m-d', current_time('timestamp')));
    $sums_trends_24_params = array('optin', date('Y-m-d', current_time('timestamp')));
    $sums_yesterday_24_params = array('optin', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)));
    
    if (!empty($optin_id)) {
      $sums_query_params[] = $optin_id;
      $sums_query_addon = "AND object_id = %d ";
      $trends_query_addon = "AND object_id = %d ";
	  
      $sums_24_query_params[] = $optin_id;
      $sums_trends_24_params[] = $optin_id;
      $sums_yesterday_24_params[] = $optin_id;
    }

    if (!empty($date_from)) {
      // Sums
      $sums_query_params[] = $date_from;
      $sums_query_addon .= "AND date>=%s ";
      
      $sums_24_query_params[] = $date_from;
      $sums_trends_24_params[] = $date_from;
      $sums_yesterday_24_params[] = $date_from;
    }
    
    if (!empty($date_to)) {
      // Sums
      $sums_query_params[] = $date_to;
      $sums_query_addon .= "AND date<='{$date_to}'";
      
      $sums_24_query_params[] = $date_to;
      $sums_trends_24_params[] = $date_to;
      $sums_yesterday_24_params[] = $date_to;
    }// AND (date>'2015-08-16' AND date<'2015-08-25')

    // sums
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as views_box2, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s '. $sums_query_addon, $sums_query_params), ARRAY_A);
    $out['views'] = (int) $tmp['views'];
    $out['views_box2'] = (int) $tmp['views_box2'];
    $out['conversions'] = (int) $tmp['conversions'];
    $out['conversion_rate'] = $out['views']? number_format(min((int) $out['conversions'] / $out['views'] * 100, 100), 1): number_format(0, 1);

    // sums 24h
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(views_box2) as views_box2, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s '.$sums_query_addon, $sums_24_query_params), ARRAY_A);
    $out['views_24h'] = (int) $tmp['views'];
    $out['views_box2_24h'] = (int) $tmp['views_box2'];
    $out['conversions_24h'] = (int) $tmp['conversions'];
    $out['conversion_rate_24h'] = $out['views']? number_format(min((int) $out['conversions'] / $out['views'] * 100, 100), 1): number_format(0, 1);
    
    // trends 24h
    $today = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s '.$trends_query_addon, $sums_trends_24_params), ARRAY_A);
    if (!$today) {
      $today['views'] = 0;
      $today['conversions'] = 0;
    }
    
		
	$yesterday = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s '.$trends_query_addon, $sums_yesterday_24_params), ARRAY_A);
    if (!$yesterday) {
      $yesterday['views'] = 0;
      $yesterday['conversions'] = 0;
    }
    
    if (!$yesterday['views']) {
      $out['trend_views'] = number_format(($today['views']? 100: 0), 1);
    } else {
      $out['trend_views'] = number_format(($yesterday['views'] - $today['views']) / $yesterday['views'] * -100, 1);  
    }
    
    if (!$yesterday['conversions']) {
      $out['trend_conversions'] = number_format(($today['conversions']? 100: 0), 1);
    } else {
      $out['trend_conversions'] = number_format(($yesterday['conversions'] - $today['conversions']) / $yesterday['conversions'] * -100, 1);  
    }
    return $out;
  } // get_optins_stats
  
  
  static function get_subscribers_stats($days_history = 30, $countries_cnt = -1) {
    global $wpdb;
    $days_history = (int) $days_history;

    $out['total'] = (int) @wp_count_posts('leadflow-subscribers')->publish;
    $out['new_24h'] = (int) $wpdb->get_var($wpdb->prepare('SELECT SUM(conversions) as cnt FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('subscriber', date('Y-m-d', current_time('timestamp')))));
    
    // trends
    $today = $wpdb->get_row($wpdb->prepare('SELECT conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('subscriber', date('Y-m-d', current_time('timestamp')))), ARRAY_A);
    if (!$today) {
      $today['new_subscribers'] = 0;
    }
    
    $yesterday = $wpdb->get_row($wpdb->prepare('SELECT conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s', array('subscriber', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)))), ARRAY_A);
    if (!$yesterday) {
      $yesterday['new_subscribers'] = 0;
    }
    
    if (!$yesterday['new_subscribers']) {
      $out['trend_24h'] = number_format(($today['new_subscribers']? 100: 0), 1);
    } else {
      $out['trend_24h'] = number_format(($yesterday['new_subscribers'] - $today['new_subscribers']) / $yesterday['new_subscribers'] * -100, 1);  
    }
    
    // graph
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, conversions as new_subscribers FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date > %s', array('subscriber', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = 0;
    }
    foreach ($stats as $day) {
      $days[$day->date] = $day->new_subscribers;
    }
    $out['history'] = $days;
    
	
    
    // countries
    $countries = array();
    $tmp_cnt = 0;
    if ($countries_cnt == -1) {
      $tmp = $wpdb->get_results($wpdb->prepare('SELECT COUNT(meta_id) as cnt, meta_value as country_name FROM ' . $wpdb->postmeta . ' WHERE meta_key = %s GROUP BY meta_value ORDER BY country_name ASC', array('country')));
    } else {
      $tmp = $wpdb->get_results($wpdb->prepare('SELECT COUNT(meta_id) as cnt, meta_value as country_name FROM ' . $wpdb->postmeta . ' WHERE meta_key = %s GROUP BY meta_value ORDER BY cnt DESC', array('country')));  
    }
    
    foreach($tmp as $country) {
      if (empty($country->country_name)) {
        $name = 'Unknown';
        //$country->cnt = $out['total'];
      } else {
        $name = $country->country_name;
      }
      $tmp_cnt += $country->cnt;
      $countries[$name] = array('cnt' => $country->cnt, 'per' => number_format(100 * $country->cnt / $out['total'], 1));
    }
    
    if (!isset($countries['Unknown']) && $tmp_cnt < $out['total']) {
      $countries['Unknown'] = array('cnt' => $out['total'] - $tmp_cnt, 'per' => number_format(100 * ($out['total'] - $tmp_cnt) / $out['total'], 1));
    }
    
	$total_countries = count($countries);
    if ($countries_cnt != -1) {
	  $other_total=0;
	  
	  $skip_countries=$countries_cnt;
	  foreach($countries as $country){
		  if($skip_countries>0){
			  $skip_countries--;
			  continue;
		  }		  		  
		  $other_total+=$country['cnt'];
	  }
	  
      $countries = array_slice($countries, 0, $countries_cnt);
	  if($out['total']) $countries[($total_countries-$countries_cnt).' other countries'] = array('cnt' => $other_total, 'per' => number_format(100 * $other_total / $out['total'], 1));
    } else {
      ksort($countries);  
    }
	
    $out['countries'] = $countries;
    
    return $out;
  } // get_subscribers_stats
  
  
  static function get_ab_test_stats($ab_test_id, $days_history = 30) {
    global $wpdb;
    $ab_test_id = (int) $ab_test_id;
    $days_history = (int) $days_history;
    $ab_test_details = leadflow_ab_test_common::get_details($ab_test_id);

    if (!leadflow_ab_test_common::get_ab_test_type($ab_test_id)) {
      return false;
    }
    
	
	if(empty($ab_test_details['ids'])){
		return false;	
	}
    // sums
    $tmp = $wpdb->get_row($wpdb->prepare('SELECT SUM(views) as views, SUM(conversions) as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id IN ('.$ab_test_details['ids'].')', array('optin')), ARRAY_A);
    $out['views'] = (int) $tmp['views'];
    $out['conversions'] = (int) $tmp['conversions'];
    $out['conversion_rate'] = $out['views']? number_format(min((int) $out['conversions'] / $out['views'] * 100, 100), 1): number_format(0, 1);
    
    // trends
    $today = $wpdb->get_row($wpdb->prepare('SELECT views as views, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id IN ('.$ab_test_details['ids'].')', array('optin', date('Y-m-d', current_time('timestamp')))), ARRAY_A);
    if (!$today) {
      $today['views'] = 0;
      $today['conversions'] = 0;
    }
    
    $yesterday = $wpdb->get_row($wpdb->prepare('SELECT views as views, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND date = %s AND object_id IN ('.$ab_test_details['ids'].')', array('optin', date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS)))), ARRAY_A);
    if (!$yesterday) {
      $yesterday['views'] = 0;
      $yesterday['conversions'] = 0;
    }
    
    if (!$yesterday['views']) {
      $out['trend_views'] = number_format(($today['views']? 100: 0), 1);
    } else {
      $out['trend_views'] = number_format(($yesterday['views'] - $today['views']) / $yesterday['views'] * -100, 1);  
    }
    
    if (!$yesterday['conversions']) {
      $out['trend_conversions'] = number_format(($today['conversions']? 100: 0), 1);
    } else {
      $out['trend_conversions'] = number_format(($yesterday['conversions'] - $today['conversions']) / $yesterday['conversions'] * -100, 1);  
    }
    
    // graph
    $stats = $wpdb->get_results($wpdb->prepare('SELECT date as date, views as views, conversions as conversions FROM ' . $wpdb->lf_stats . ' WHERE type = %s AND object_id = %d AND date > %s', array('ab_test', $ab_test_id, date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $days_history)))));
    
    $days = array();
    for ($i = $days_history; $i >= 0; $i--) {
      $date = date('Y-m-d', (current_time('timestamp') - DAY_IN_SECONDS * $i));
      $days[$date] = array('views' => 0, 'conversions' => 0, 'conversion_rate' => 0.0);
    }
    foreach ($stats as $day) {
      $days[$day->date] = array('views' => $day->views, 'conversions' => $day->conversions, 'conversion_rate' => $day->views? number_format(min((int) $day->conversions / $day->views * 100, 100), 1): number_format(0, 1));
    }
    $out['history'] = $days;
    
    return $out;
  } // get_ab_test_stats
  

  static function delete_stats($object_id) {
    $object_id = (int) $object_id;
    if (!$object_id) {
      return false;
    }
    
    if (!isset($object_type)) {
      $tmp = get_post_type($object_id);
      if ($tmp == 'lead-flows') {
        $object_type = 'flow';
      } elseif ($tmp == 'optin-pages') {
        $object_type = 'optin';
      } elseif ($tmp == 'ab-tests') {
        $object_type = 'ab_test';
      } else {
        return false;
      }
    }
    if ($object_type != 'flow' && $object_type != 'optin' && $object_type != 'ab_test') {
      return false;
    }
    
    global $wpdb;
    $wpdb->delete($wpdb->lf_stats, array('object_id' => $object_id, 'type' => $object_type), array('%d', '%s'));  

    return true;
  } // delete_stats
} // leadflow_stats