<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */


class leadflow_widget_optin extends WP_Widget {
  function leadflow_widget_optin() {
    $widget_ops = array('classname' => 'lfp_optin', 'description' => 'Display an Optin as a widget.');
    $control_ops = array('width' => 400, 'height' => 350);
     parent::__construct('lfp_optin', 'LeadsFlow Pro Optin', $widget_ops, $control_ops);
  }

  function widget($args, $instance) {
    extract($args);
    extract($instance);

    echo $before_widget;
    if (!empty($instance['title'])) {
      echo $before_title . $instance['title'] . $after_title;
    }

    if (empty($optin_id)) {
      echo '<b>You need to select an OptIn in the widget in order to display it.</b>';
      return;
    }
    
    leadflow_optin_conditionals::setup_headers();
    echo do_shortcode('[optin-shortcode id="' . $optin_id . '"]');
    
    echo $after_widget;
  } // widget

  function update($new_instance, $old_instance) {
    $instance = $old_instance;
    $instance['title'] = trim($new_instance['title']);
    $instance['optin_id'] = (int) $new_instance['optin_id'];

    return $instance;
  } // update

  function form($instance) {
    $instance = wp_parse_args((array) $instance, array('title' => 'Subscribe now', 'optin_id' => '0', 'width' => '300'));
    extract($instance, EXTR_SKIP);
    
    $optins = array();
    $optins[] = array('val' => '', 'label' => 'Please select an optin');
    $tmp_optins = get_posts(array('post_type' => 'optin-pages', 'post_status' => 'publish', 'numberposts' => -1, 'meta_key' => 'optin_type', 'meta_value' => 'shortcode', 'order' => 'ASC', 'orderby' => 'title'));
    foreach ($tmp_optins as $optin) {
      $optins[] = array('val' => $optin->ID, 'label' => get_the_title($optin->ID));
    }

    echo '<p><label for="' . $this->get_field_id('title') . '">Title:</label><input class="widefat" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="' . esc_attr($title) . '" /></p>';
    
    echo '<p><label class="lfp-label" for="' . $this->get_field_id('optin_id') . '">OptIn: </label>';
    echo '<select id="' . $this->get_field_id('optin_id') . '" name="' . $this->get_field_name('optin_id') . '">';
    leadflow_common::create_select_options($optins, $optin_id, true);
    echo '</select><br>Only OptIns of the shortcode type can be displayed in a widget.</p>';
  
    
    echo '<hr>';
  } // form

} // leadflow_widget_optin