/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

 
jQuery(document).ready(function($){
  //Check if Dashboard is active  
  if ( $( "#world_map" ).length ) {	
		  map_obj = $('#world_map');
		  map_obj.gmap3({map: { options: {
			  maxZoom: 3,
			  minZoom: 2,
			  mapTypeControl: false,
			  navigationControl: false,
			  scrollwheel: true,
			  streetViewControl: false,
			  panControl: false,
			  zoomControl: false,
			  scaleControl: false,
			  overviewMapControl: false,
			  styles: [
			{
				"featureType": "poi",
				"elementType": "geometry.fill",
				"stylers": [
					{
						"color": "#C5E3BF"
					}
				]
			},
			{
				"featureType": "road",
				"elementType": "geometry",
				"stylers": [
					{
						"lightness": 100
					},
					{
						"visibility": "simplified"
					}
				]
			},
			{
				"featureType": "road",
				"elementType": "geometry.fill",
				"stylers": [
					{
						"color": "#D1D1B8"
					}
				]
			},
			{
				"featureType": "water",
				"elementType": "geometry",
				"stylers": [
					{
						"visibility": "on"
					},
					{
						"color": "#80c7c4"
					}
				]
			}
		]
			  }  
		  } });
		  
		  lf_add_markers(lf_map_markers, 0);
		  lf_add_events(lf_events);
		  
		  countries = new Array();
		  countries.push(['Country', 'Number of Subscribers']);
		  $.each(lf_countries_pie, function(country, tmp_data) {
		   countries.push([country, parseInt(tmp_data.cnt)]);
		   
		  });
		  
		  
		  optins_days = new Array();
		  optins_days.push(['Date', 'Views', 'Conversions']);
		  $.each(lf_optins_stats.history, function(date, tmp_data) {
			  optins_days.push([date, parseInt(tmp_data.views), parseInt(tmp_data.conversions)]);
		  });
		  
		  flows_days = new Array();
		  flows_days.push(['Date', 'Views', 'Conversions']);
		  $.each(lf_flows_stats.history, function(date, tmp_data) {
			  flows_days.push([date, parseInt(tmp_data.views), parseInt(tmp_data.conversions)]);
		  });
		  
		  
		  subscriber_growth = new Array();
		  subscriber_growth.push(['Date', 'Total']);
		  $.each(lf_subscriber_growth, function(date, count) {
			  subscriber_growth.push([date, parseInt(count)]);
		  });
		  
		  
		  
		  google.charts.load('current', {packages: ['corechart', 'bar', 'line']});
		  
		  
		  
		  function drawSubGrowthStats() {
			  if(subscriber_growth.length > 1){ 
			  	  var data = new google.visualization.arrayToDataTable(subscriber_growth); 	  
				  var options = {
					colors: ['#61a72e'],
					chartArea: {width: '85%'},
					hAxis: {showTextEvery:Math.round(subscriber_growth.length*0.1)},
					legend: {position:'none'}
				  };
			
				  var chart = new google.visualization.ColumnChart(
					document.getElementById('subgrowth_chart'));
			
				  chart.draw(data, options);
			  }
			}
			google.charts.setOnLoadCallback(drawSubGrowthStats);
			
			
			
		  
		  
		
		
		  
		  function drawOptinsStats() {
			  var data = new google.visualization.arrayToDataTable(optins_days);
			  
		
			  var options = {
				colors: ['#7d7d7d', '#61a72e'],
				chartArea: {width: '80%'},
				hAxis: {showTextEvery:3},
				legend: 'top',
				series: {
				  0: {targetAxisIndex: 0},
				  1: {targetAxisIndex: 1}
				},
				vAxes: {
				  // Adds titles to each axis.
				  0: {title: 'Views'},
				  1: {title: 'Conversions'}
				}
			  };
		
			  var chart = new google.visualization.ColumnChart(
				document.getElementById('optins_chart'));
		
			  chart.draw(data, options);
			}
			google.charts.setOnLoadCallback(drawOptinsStats);
			
			
			 function drawFlowsStats() {
			  var data = new google.visualization.arrayToDataTable(flows_days);
			  
		
			  var options = {
				colors: ['#7d7d7d', '#61a72e'],
				chartArea: {width: '80%'},
				hAxis: {showTextEvery:3},
				legend: 'top',
				series: {
				  0: {targetAxisIndex: 0},
				  1: {targetAxisIndex: 1}
				},
				vAxes: {
				  // Adds titles to each axis.
				  0: {title: 'Views'},
				  1: {title: 'Conversions'}
				}
			  };
		
			  var chart = new google.visualization.ColumnChart(
				document.getElementById('flows_chart'));
		
			  chart.draw(data, options);
			}
			google.charts.setOnLoadCallback(drawFlowsStats);
			
			
			
			
			  function drawChart() {
				var data = google.visualization.arrayToDataTable(countries);
				var options = {
				  _title: 'Subscribers per Country',
				  legend: 'none',
				  pieSliceText: 'label',
				  chartArea:{left:0,top:0,width:'100%',height:'100%'},
				  slices: {
					0: { color: '#61a72e' },
					1: { color: '#2ab167' },
					2: { color: '#eda50a' },
					3: { color: '#2a93b1' },
					4: { color: '#2a5ab1' },
				  }
				};
		
				var chart = new google.visualization.PieChart(document.getElementById('countries_pie'));
				chart.draw(data, options);
			  }
				
			  google.charts.setOnLoadCallback(drawChart);
			  
			  
			  
			  
			  $(window).resize(function(){
				  drawSubGrowthStats();
				  drawOptinsStats();
				  drawFlowsStats();
				  drawChart();
				});
			  
			  
		
		function lf_add_events(events) {
		  if (events.length == 0) {
			return;
		  }
		  
		  
		  
		  jQuery(lf_events).each( function(ind, event) {
			jQuery(event).appendTo('ul#latest_events').hide().fadeIn(500);
			if (jQuery('ul#latest_events li').length > 13) {
			  jQuery('ul#latest_events li:last').remove();
			}
		  });
		} //lf_add_events
		
		
		function lf_map_pin_click(marker, event, data) {
		  var map = jQuery('#world_map').gmap3('get');
		  var infowindow = jQuery('#world_map').gmap3({get:{name:'infowindow', tag: 'info'}});
		
		  if (!data) {
			return;
		  }
		
		  data = '<div class="lf_infowindow">' + data + '</div>';
		
		  if (infowindow){
			infowindow.open(map, marker);
			infowindow.setContent(data);
		  } else {
			jQuery('#world_map').gmap3({ infowindow:{tag: 'info', anchor: marker, options:{content: data} } });
		  }
		} // lf_map_pin_click
		
		
		function lf_add_markers(markers, animation) {
		  if (markers.length == 0) {
			return;
		  }
			
		  tmp_pins = [];
		  jQuery(markers).each(function(ind, pin) {
			tmp_pins.push({latLng:[pin.lat, pin.lng], options:{icon : new google.maps.MarkerImage(lf_plugin_url+'/images/'+pin.icon+'.png'), title: pin.address + '; ' + pin.timestamp_diff + ' ago', _icon: 'x', animation: 0, show_description: 1, data: pin.address + '; ' + pin.timestamp_diff + ' ago' }});
		  });
			
		  map_obj.gmap3({ marker:{ values: tmp_pins, events:{ click: function(marker, event, context){ lf_map_pin_click(marker, event, marker.data); } } }});
		  map_obj.gmap3({ autofit:{} });
		  map_obj.gmap3({trigger: 'resize'});
		  
		  
		} // lf_add_markers

  } // END Check if Dashboard is active  
}); // onload
