/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

jQuery(document).ready(function($){
  
  var tmp_fseek = 0;
  var exported = 0;
  var skipped = 0;
  var total = 0;

  // Export CSV Ajax
  $('form[name="lf-export-csv-ajax"]').on('submit', function(e){
    e.preventDefault();
    var form = $(this);
    var timestamp = $.now();
  
    // Get inputs
    var records = $('input[name="lf-subscriber-records"]', form).val();
    var query = $('input[name="lf-subscriber-query"]', form).val();
    var selected = $('input[name="lf-subscriber-selected"]', form).val();
    var export_per_call = $('input[name="lf-export-per-call"]', form).val();
	
	$('#export_subscribers_per_page').attr('disabled', 'disabled');
	
    // Ajax Params
    var params = {offset:0, timestamp:timestamp, export_per_call:export_per_call, query:query, selected_users:selected};
    
    // Setup CSV headers
    $.ajax({ type: 'POST',
      async:false,
      url: ajaxurl,
      data: {action: 'lf_export_csv_headers', 
             offset: params.offset, 
             export_per_call: jQuery('#export_subscribers_per_page option:selected').val(),
             query : params.query,
             selected_users : params.selected_users,
             timestamp : params.timestamp
      },
      dataType: 'json'})
      .done(function(response) {
        if (!response.success) {
          alert('Invalid option. Please reload');
          return;
        }
      })
      .fail(function(response){
        alert('An undocumented error has occured. Please reload the page and try again.');
      });
    
    startingpoint = $.Deferred();
    startingpoint.resolve();
    
    // Quick fix if we have less records then insers per row
    if (records < 10) {
      params.export_per_call = 1;
    }
    
    // Total number of required loops
    loops = Math.ceil(records/jQuery('#export_subscribers_per_page option:selected').val());
    
    // Disable button while working
    $('#lf-export-data-btn').addClass('loading');
    
    for (var i=0;i+1 <= loops; i++) {
      startingpoint = startingpoint.pipe( function() {
        $('#lf-export-status').show();
        
        params.offset++;
        
        // Current progress
        //progress = Math.round(((params.offset*params.export_per_call)/records)*100);
        progress = Math.round( (params.offset/loops)*100 );
        
        $('div.lf-progress-bar', '#lf-export-status').css('width',progress + '%');
        $('div.lf-progress-text', '#lf-export-status').html(progress + '%');

        return do_export(params);
      });
    } // each action 

    $('#lf-back-to-subscribers').show();
    return false;
  });
  
  // handle each individual ajax call
  function do_export(params) {
	return $.ajax({ type: 'POST',
      url: ajaxurl,
      data: {action: 'lf_export_csv', 
             offset: params.offset, 
             export_per_call: jQuery('#export_subscribers_per_page option:selected').val(),
             query : params.query,
             selected_users : params.selected_users,
             timestamp : params.timestamp
      },
      dataType: 'json'})
      .done(function(response) {
        if (!response.success) {
          alert('Invalid option. Please reload');
          return;
        }
        
        //$('#lf-export-data-btn').hide();
        exported += response.data.exported;
        skipped += response.data.skipped;
        total = exported+skipped;
        
        $('#lf-exported-rows>span', '#lf-export-status').html(exported);
        $('#lf-skipped-rows>span', '#lf-export-status').html(skipped);
        $('#lf-total-rows>span', '#lf-export-status').html(total);
        
		if (total == $('input[name="lf-subscriber-records"]').val()) {
          $('#lf-export-status').prepend('<div id="lf-export-url">Exported File location: <span><a href="'+response.data.weburl+'" target="_blank">' + response.data.weburl + '</a></span></div><div></div>');
          $('#lf-export-data-btn').removeClass('loading').hide();
		  jQuery('.lf-progress').hide();

		  jQuery('.lf-export-finished').show();	
		  jQuery('.lf-export-finished').html('Export Finished');			
        }
        
      })
      .fail(function(response){
        alert('An undocumented error has occured. Please reload the page and try again.');
      })
      .always(function(response) {
        //$('#lf-export-data-btn').hide();
      });
  } // do_import

}); // jQuery.ready