/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */


jQuery(document).ready(function($){
  // auto save after type is choosen
  if ($('#_first_post_save').length == 1 && $('#_first_post_save').val() == '0') {
    $('input#publish').trigger('click');
  }


  $('#flow-components').on('click', '.flow-component-email .toggle_editor_visual', function(){
	 var editor_id=this.id.replace('-tmce','');
	 
	 $('#'+editor_id+'-html').removeClass('toggle_editor_active');
	 $('#'+editor_id+'-tmce').addClass('toggle_editor_active');
	 $('#'+editor_id).addClass('lfp-tinymce');
	 tinymce.init({
			selector: "textarea#"+editor_id, theme:"modern",skin:"lightgray",language:"en",formats:{alignleft: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"left"}},{selector: "img,table,dl.wp-caption", classes: "alignleft"}],aligncenter: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"center"}},{selector: "img,table,dl.wp-caption", classes: "aligncenter"}],alignright: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"right"}},{selector: "img,table,dl.wp-caption", classes: "alignright"}],strikethrough: {inline: "del"}},relative_urls:false,remove_script_host:false,convert_urls:false,browser_spellcheck:true,fix_list_elements:true,entities:"38,amp,60,lt,62,gt",entity_encoding:"raw",keep_styles:false,cache_suffix:"wp-mce-4208-20151113",preview_styles:"font-family font-size font-weight font-style text-decoration text-transform",end_container_on_empty_block:true,wpeditimage_disable_captions:false,wpeditimage_html5_captions:true,plugins:"charmap,colorpicker,hr,lists,media,paste,tabfocus,textcolor,fullscreen,wordpress,wpautoresize,wpeditimage,wpemoji,wpgallery,wplink,wpdialogs,wptextpattern,wpview,wpembed",wp_lang_attr:"en-US",resize:"vertical",menubar:false,wpautop:true,indent:false,toolbar1:"bold,italic,strikethrough,bullist,numlist,blockquote,hr,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,fullscreen,wp_adv",toolbar2:"formatselect,underline,alignjustify,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help",toolbar3:"",toolbar4:"",tabfocus_elements:":prev,:next",body_class:"optin_widget_first_optin_2_settings_text post-type-optin-pages post-status-publish locale-en-us"
	}); 
  });	


  $('#flow-components').on('click', '.flow-component-email .toggle_editor_text', function(){
	 var editor_id=this.id.replace('-html','');
	 $('#'+editor_id+'-tmce').removeClass('toggle_editor_active');
	 $('#'+editor_id+'-html').addClass('toggle_editor_active');
	 $('#'+editor_id).removeClass('lfp-tinymce');
	 tinyMCE.execCommand('mceRemoveEditor', false, editor_id); 
  });
  
  	

  // Scroll from top
  if ($('body').hasClass('post-type-lead-flows')) {
    $(window).scroll(function() {
      if ($(this).scrollTop() >= 130) { // this refers to window
        $('#side-sortables').addClass('fixed');
      } else {
        $('#side-sortables').removeClass('fixed');
      }
    }).trigger('scroll');
  } // add class on scroll to fix right side boxes

  // local_db & end component
  $('#flow_active_components .select2').lf_select2({ width: '470px' });
  // standard vars box
  $('#flow_active_components .select2-vars').not('.skip_select2').select2_sortable({ width: '470px' });
  // start component, normal tags select2
  $('.var_box_chosen').not('.skip_chosen').lf_select2({ minimumResultsForSearch: Infinity, width: '470px' });


 
  var data = [];
  twillio_numbers = $('.lfp-twillio-recipients').lf_select2({ 
  data:data,
  tags: true,
  tokenSeparators: [',', ' ']
  });


  // auto expand debug textarea
  $('#lf-debug-log').on('focus', function() {
    $(this).height($(this).prop('scrollHeight') + 'px');
  });
  $('#lf-debug-log').on('focusout', function() {
    $(this).height('60px');
  });


  // populate select2 with %%var_names%%
  // bind and run
  $('#flow_active_components').on('change', '.var_name_watch', function() {
    lf_var_names = new Array;
    $('.var_name_watch').each(function() {
      if (!$(this).val()) {
        return;
      }
	  if($(this).hasClass('var_name_php')){
        lf_var_names.push('php_'+$(this).val());
	  } else {
		lf_var_names.push($(this).val());  
	  }
    }); // prepare a list o var names

    $('#flow_active_components select.select2-vars, select.dynamic_update_field_names').not('.skip_select2').each(function(ind, dropdown) {
      $.each(lf_var_names, function(val, label) {
        if ($(dropdown).find('option[value="%%' + label + '%%"]').length == 0) {
          $('<option />', { value: '%%' + label + '%%', text: '%%' + label + '%%' }).appendTo(dropdown);
        }
      });
    });
    
    // build sample URL / form
    code = 'lfp_external_flow(' + $('#post_ID').val() + ', array(';
    url = $('#flow_permalink').val() + '?';
    if ($('#general_variables-order').length && $('#general_variables-order').val().search('get') != -1) {
      form = '<form method="get" action="' + $('#flow_permalink').val() + '">\n';  
    } else {		
      form = '<form method="post" action="' + $('#flow_permalink').val() + '">\n';
    }
	var add_email_to_form=false; 
    $.each(lf_var_names, function(val, label) {
      if(label!='email'){
		if(label.indexOf("php")!==0){
	  	  url += label + '=VAL&amp;';
      	  form += '  <input type="text" name="' + label + '" value="">\n';
      	  code += "'" + label + "' => 'VAL', ";
	    }
	  } else {
		add_email_to_form=true;  
	  }
	  
    });
	if( add_email_to_form ){
		url += 'email=VAL&amp;';
      	form += '  <input type="text" name="email" value="">\n';
      	code += "'email' => 'VAL', ";
	}
    form += '</form>';
    code += '));';
    $('#sample_flow_url').html(url.replace(/&amp;$/i, ''));
    $('#sample_flow_form').val(form);
    $('#sample_flow_code').html(code.replace(/, \)\);$/i, '));'));

    // keep radio input fresh
    parent_row = $(this).parents('tr');
    $('input[type=radio]', parent_row).val($(this).val());
	
  }).find('.var_name_watch').first().trigger('change');
  // build vars in select2


  // flow type change/box
  $('.flow_type_box').hover(function() {
    $(this).addClass('selected_hover');
  },
  function() {
    $(this).removeClass('selected_hover');
  });
  $('.flow_type_box').on('click', function() {
    old_type = $('#flow_type').val();
    new_type = $(this).data('flow_type');
    $('#flow_type').val(new_type);
    $('.flow_type_box').removeClass('selected');
    $(this).addClass('selected');

    if ($('#flow-general').length && old_type != new_type) {
      alert('Important - saving the flow with the new type will reset all flow components!');
    }
  });
  // flow type box/change
  
 

  // filter components
  // bind and run
  var last_search = '';
  $('#lf-components-search').val($.cookie('lf_components_search'));
  $('#lf-components-search').on('change mouseup keyup focus blur search', function(e) {
    search = $(this).val();

    if (search == last_search) {
      return false;
    }
    if (!search) {
      last_search = search;
      $.cookie('lf_components_search', search, { expires: 90 });
      $('#flow_available_components li').show();

      return true;
    } else {
      last_search = search;
      $.cookie('lf_components_search', search, { expires: 90 });
      reg_exp = new RegExp(search, 'i');

      $('#flow_available_components li').each(function(ind, el) {
        name = $('i, b', el).text();
        if (name.search(reg_exp) != -1) {
          $(el).show;
        } else {
          $(el).hide();
        }
      });

      return true;
    }
  }).trigger('search');
  // filter components


  // init components sortable
  $('#flow_active_components').sortable({
      placeholder: 'ui-state-highlight',
      handle: '.move_component',
      items: 'li:not(.unsortable)'});
  // init coponents sortable
 
  // change ecommerce type
  $('.flow-component-ecommerce select[id$=ecommerce_type]').on('change', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component');

    $('.settings_box', component).hide();
    $('.settings_box_' + val, component).show();
  }).trigger('change');
  // change ecommerce type

  // auto set vars are off warning
  $('.flow-component-local_db select[id$=auto_set_vars]').on('change', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component');

    if (val == '1') {
      $('#auto_set_vars_off', component).hide();
    } else {
      $('#auto_set_vars_off', component).show();
    }
  }).trigger('change');
  // change auto set vars


  // change end component type
  $('.flow-component-end select[id$=-action]').on('change', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component');

    $('.settings_box', component).hide();
    $('.settings_box_' + val, component).show();
  }).trigger('change');
  // change end component type
  
  // change start component fallback type
  $('.flow-component-start select[id$=-fallback_type]').on('change', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component');
	
    $('.settings_box', component).hide();
    $('.settings_box_' + val, component).show();
  }).trigger('change');
  // change start component fallback type


  // change variable order
  $('#flow-general #general_variables-order').on('change', function(e) {
    val = $(this).val();

    if (val == 'get' || val == 'post' || val == 'postget' || val == 'getpost') {
      $('.script_sample_box').hide();
      $('.link_sample_box').show();
      $('.form_sample_box').show();
      $('.code_sample_box').hide();
    } else if (val == 'internal') {
      $('.script_sample_box').hide();
      $('.link_sample_box').hide();
      $('.form_sample_box').hide();
      $('.code_sample_box').show();
    } else if (val == 'script' || val == 'getscript' || val == 'scriptget') {
      $('.script_sample_box').show();
      $('.link_sample_box').hide();
      $('.code_sample_box').hide();
      $('.form_sample_box').hide();
    } else {
      $('.script_sample_box').hide();
      $('.link_sample_box').hide();
      $('.code_sample_box').hide();
      $('.form_sample_box').hide();
    }
    
    $('#flow_active_components .var_name_watch').first().trigger('change');
  }).trigger('change');
  // change variable order
  
  // change URL redirect type
  $('.flow-component-end select[id$=redirect_url]').on('change', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component');

    if (val == '_custom-url') {
      $('div.settings_box_custom_url', component).show();
    } else {
      $('div.settings_box_custom_url', component).hide();
    }
  }).trigger('change');
  // change URL redirect type


  // load end template
  $('.flow-component-end input.load-end-template').on('click', function(e) {
    e.preventDefault();

    var button = this;
    template = $('.flow-component-end select[id*=-message_template]').val();
    editor = $(this).parents('li').find('.wysiwyg');

	
    if (!template) {
      alert('Please select a template to load.');
      return false;
    }

    if(!confirm('Loading a template will overwrite your custom message. Continue?')) {
      return false;
    }

    $(button).addClass('loading');
    $.get(ajaxurl, { 'action': 'lf_load_end_template', 'template': template }, function(response) {
      if (response.success) {
        alert('Template loaded.');
		jQuery('#'+$(editor).attr('id')).val(response.data);
		if(tinyMCE.get($(editor).attr('id'))) {
			tinyMCE.get($(editor).attr('id')).setContent(response.data);
		}
      } else {
        alert('An error has occured. ' + response.data);
      }
    }).fail(function() { alert('Undocumented error. Please reload the page and try again.'); })
    .always(function() { $(button).removeClass('loading'); });

    return false;
  }); // load end template


  // change custom_url component request type
  // bind and run
  $('#flow_active_components').on('change', '.flow-component-custom_url select[name*=request_type]', function(e) {
    val = $(this).val();
    component = $(this).parents('.flow-component')

    $('.settings_box', component).hide();
    $('.settings_box_' + val, component).show();
  }).trigger('change');
  // change custom_url component request type

  // change form catcher type
  // bind and run
  $('#flow-form select#form_location').on('change', function(e) {
    val = $(this).val();

    if (val == 'remote') {
      $('.box_form_catcher_remote').show();
      $('.box_form_catcher_local').hide();
    } else {
      $('.box_form_catcher_remote').hide();
      $('.box_form_catcher_local').show();
    }
  }).trigger('change');
  // change form catcher type

  function get_next_component_id() {
    max = 0;
    $('#flow_active_components li').each(function(ind, element) {
      if ($(element).data('flow-component-id') > max) {
        max = $(element).data('flow-component-id');
      }
    });

    return max + 1;
  } // get_next_component_id


  // add new flow component
  $('#flow_available_components').on('click', 'a', function(e) {
    e.preventDefault();

    component_type = $(this).parents('li').data('flow-component');
    next_id = get_next_component_id();

    $.post(ajaxurl,
          {action: 'lf_get_flow_component', 'id': next_id, 'component_type': component_type, 'flow_id': $('#post_ID').val()},
          function(response) {
            if (response.success) {
              if ($('#flow_active_components li.flow-component-end').length) {
                tmp = $(response.data).insertBefore('#flow_active_components li.flow-component:last-child').hide();
              } else {
                tmp = $(response.data).insertAfter('#flow_active_components li.flow-component:last-child').hide();
              }
              select2 = $('.select2-vars', tmp).not('.skip_select2').select2_sortable({ width: '470px' });
              $(tmp).slideDown(500);
              if (select2.length) {
                $('#flow_active_components .var_name_watch').trigger('change');
              }

              if($('select[id$=primary_email_field]').val() != '%%email%%' &&
                 $('select[id$=primary_email_field]').val() != '__ecommerce') {
                if ($('select[id$=vars-var_values-0]', tmp).val() == '%%email%%') {
                  $('select[id$=vars-var_values-0]', tmp).val($('select[id$=primary_email_field]').val()).trigger('change');
                }
              }

              $('select[name*=request_type]', tmp).trigger('change');

              $('.edit_component', tmp).trigger('click');
            } else {
              alert('Unable to add selected component. Please reload the page and try again.');
            }
          },
          'json'
    ).fail(function() {
      alert('An unknown error has occured. Please reload the page and try again.');
    });

    return false;
  }); // add new flow component


  // remove flow component
  $('#flow_active_components').on('click', 'a.remove_component', function(e){
    e.preventDefault();

    if (confirm('Are you sure you want to remove the selected Flow component?')) {
      component = $(this).parents('li');
      $(component).slideUp(500, function(){
        $(this).remove();
      });
    }

    return false;
  }); // remove component


  // show help for flow component
  $('#flow_active_components').on('click', 'a.help_component', function(e){
    e.preventDefault();
    component = $(this).parents('li');

    if ($('div.settings:visible', component).length == 0) {
      $('a.edit_component', component).trigger('click');
      $('.component_help', component).show();

    } else {
      $('.component_help', component).toggle();
    }

    return false;
  }); // help component


  // refresh dropdown with lists
  $('#flow_active_components').on('click', 'input.refresh-lists-dropdown', function(e){
    e.preventDefault();
    $(this).addClass('loading');
    var button = this;

    component = $(this).parents('li');
    provider = $('input[name*=_flow-component-type]', component).val();
    dropdown = $('select[name*=list_id]', component);
    if (!dropdown) {
      dropdown = $('.list_id_dropdown', component);
    }
    if (!dropdown) {
      alert('Unable to find list_id dropdown');
    }

    $.get(ajaxurl, { 'action': 'lf_refresh_list', 'provider': provider }, function(response) {
      if (response.success) {
        $('option', dropdown).remove();
        $.each(response.data, function(val, label) {
          $('<option />', { value: val, text: label }).appendTo(dropdown);
        });

        alert('List names have been refreshed!');
      } else {
        alert('An error has occured. ' + response.data)
      }
    }).fail(function() { alert('Undocumented error. Please reload the page and try again.'); })
    .always(function() { $(button).removeClass('loading'); });

    return false;
  }); // refresh dropdown with lists


  // attach file to email
  $('#flow_active_components').on('click', 'a.email-attach', function(e){
    e.preventDefault();
    var button = this;
    component = $(this).parents('li');
    field = $('input[id*=attachment][type=text]', component);
    field_id = $('input[id*=attachment][type=hidden]', component);

    // Media Upload
    if ( typeof wp !== 'undefined' && wp.media && wp.media.editor) {
      custom_uploader = wp.media.frames.file_frame = wp.media({
            title: 'Choose file to attach',
            button: {
                text: 'Attach selected file'
            },
            multiple: false
      });
      custom_uploader.on('select', function() {
            attachment = custom_uploader.state().get('selection').first().toJSON();
            field.val(attachment.url);
            field_id.val(attachment.id);
      });
      custom_uploader.open();
    } else {
      alert('Error - WordPress file uploader is not available.');
    }

    return false;
  }); // attach file to email


  $('#flow_active_components').on('click', 'a.email-detach', function(e){
    e.preventDefault();

    component = $(this).parents('li');
    $('input[id*=attachment]', component).val('');

    return false;
  }); // detach file from email


  // edit flow component
  $('#flow_active_components').on('click', 'a.edit_component', function(e){
    e.preventDefault();

    component = $(this).parents('li');
    component_type = $('input[name*=flow-component-type]', component).val();
    settings = $('.settings', component);
    desc = $('.short_description', component);

    if ($(settings).is(':visible')) {
      $(settings).hide();
      $(desc).html(get_flow_short_desc(component_type, settings));
      $(desc).show();
    } else {
      $(settings).show();
      $(desc).hide();
    }

    return false;
  }); // edit flow


  // generate description on load
  $('#flow_active_components li').each(function(ind, elem){
    component = $(this);
    component_type = $('input[name*=flow-component-type]', component).val();
    settings = $('.settings', component);
    desc = $('.short_description', component);
    $(desc).html(get_flow_short_desc(component_type, settings));
  }); // for each active component

  // show what's inside the component
  function get_flow_short_desc(component_type, settings) {
    out = '';

    switch (component_type) {
    case 'start':
      if ($('.flow-vars-table tr', settings).length > 0) {
        count = $('.flow-vars-table tr', settings).length - 2;
        fallback = $('select[id$=fallback_optin]', settings).val();
        cookie = $('select[id$=uuid_cookie]', settings).val();

        if (fallback != '0') {
          fallback = ', fallback OptIn is <b>enabled</b> ';
        } else {
          fallback = ', fallback OptIn is <b>disabled</b> ';
        }
        if (cookie != '0') {
          cookie = 'and UUID tracking cookie is <b>enabled</b>.';
        } else {
          cookie = 'and UUID tracking cookie is <b>disabled</b>.';
        }

        if (count == 0) {
          out += 'No external variables are defined; the flow <b>will not function properly</b>.';
        } else if (count == 1) {
          out += 'Parsing <b>one external variable</b>' + fallback + cookie;
        } else {
          out += 'Parsing <b>' + count + ' external variables</b>' + fallback + cookie;
        }
      } else {
        cookie = $('select[id$=uuid_cookie]', settings).val();
        if (cookie != '0') {
          out = 'UUID tracking cookie is <b>enabled</b>.';
        } else {
          out = 'UUID tracking cookie is <b>disabled</b>.';
        }
      }
    break;
    case 'aweber':
    case 'mailchimp':
    case 'mad_mimi':
    case 'rapid_mailer':
    case 'activecampaign':
    case 'campaign_monitor':
    case 'getresponse':
    case 'icontact':
    case 'sendlane':
    case 'sendinblue':
	case 'mailpoet':
	case 'mymail':		
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No list selected. <b>Component is disabled.</b>';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Creating a subscriber with <b>one variable</b> on <b>' + list + '</b> list.';
        } else {
          out += 'Creating a subscriber with <b>' + count + ' variables</b> on <b>' + list + '</b> list.';
        }
      }
    break;
    case 'infusionsoft':
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No list selected. <b>Component is disabled.</b>';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Creating a subscriber with <b>one variable</b> and setting the group to <b>' + list + '</b>.';
        } else {
          out += 'Creating a subscriber with <b>' + count + ' variables</b> and setting the group to <b>' + list + '</b>.';
        }
      }
    break;
    case 'ontraport':
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No tag / sequence selected. <b>Component is disabled.</b>';
      } else {
        list = list.replace('(', '</b>').replace(')', '');
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Creating a subscriber with <b>one variable</b> and setting the <b>' + list + '.';
        } else {
          out += 'Creating a subscriber with <b>' + count + ' variables</b> and setting the <b>' + list + '.';
        }
      }
    break;
    case 'wishlist':
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No list selected. <b>Component is disabled.</b>';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Creating a user with <b>one variable</b> and <b>' + list + '</b> user level.';
        } else {
          out += 'Creating a user with ' + count + ' variables and <b>' + list + '</b> user level.';
        }
      }
    break;
    case 'gotowebinar':
    case 'webinarignition':
    case 'webinarjam':
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No webinar selected. <b>Component is disabled.</b>';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Adding a new participant with <b>one variable</b> on <b>' + list + '</b> webinar.';
        } else {
          out += 'Adding a new participant with <b>' + count + ' variables</b> on <b>' + list + '</b> webinar.';
        }
      }
    break;
    case 'wp':
      list = $('select[id$=list_id] option:selected', settings).text();
      if (!list) {
        out += 'No user role selected. <b>Component is disabled.</b>';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'No variables selected. <b>Component is disabled.</b>';
        } else if (count == 1) {
          out += 'Adding a new user with <b>one variable</b> and <b>' + list + '</b> role.';
        } else {
          out += 'Adding a new user with <b>' + count + ' variables</b> and <b>' + list + '</b> role.';
        }
      }
    break;
    case 'ecommerce':
      software = $('select[id$=ecommerce_type]', settings).val();
      price = $('input[id$=default_price]', settings).val();
      if (software == 'universal') {
        out += 'Processing a <b>universal</b> transaction with a default price of <b>$' + price + '</b>.';
      } else if (software == 'jvzoo') {
        out += 'Automatically processing <b>JVZoo transactions</b>.';
      } else if (software == 'woocommerce') {
        out += 'Automatically processing <b>WooCommerce transactions</b>.';
      }
    break;
    case 'cookie':
      count = $('.vars_box tr', settings).length - 2;
      days = $('input[id$=expire]', settings).val();
      if (count == 0) {
        out += '<b>No cookies</b> will be set.';
      } else if (count == 1) {
        out += 'Setting <b>' + count + ' cookie</b> which will expire in <b>' + days + ' days</b>.';
      } else {
        out += 'Setting <b>' + count + ' cookies</b> which will expire in <b>' + days + ' days</b>.';
      }
    break;
    case 'zapier':
      url = $('input[id$=webhook_url]', settings).val();
      if (!url) {
        out += 'Zap action <b>will not be sent</b>; please enter the Zap webhook URL.';
      } else {
        count = $('.vars_box tr', settings).length - 2;
        if (count == 0) {
          out += 'Zap action <b>will not be sent</b>; please enter at least one variable';
        } else if (count == 1) {
          out += 'Sending a Zap action with <b>' + count + ' variable</b>.';
        } else {
          out += 'Sending a Zap action with <b>' + count + ' variables</b>.';
        }
      }
    break;
    case 'end':
      action = $('select[id$=action]', settings).val();
      if (action == 'message') {
        out += 'Displaying a <b>message</b> to the user.';
      } else if (action == 'redirect') {
        if ($('select[id$=redirect_url]', settings).val() == '_custom-url') {
          tmp = $('input[id$=redirect_url_custom]', settings).val() || 'unknown URL';
        } else {
          tmp = $('select[id$=redirect_url] option:selected', settings).text();
        }
        out += '<b>Redirecting to</b> ' + tmp + '.';
      } else if (action == 'return') {
        out += '<b>Returning the UUID</b> to the calling function.';
      } else if (action == 'json') {
        out += 'Returning <b>standard json</b> output.';
      } else if (action == 'auto') {
        out += '<b>Auto-detecting</b> return type.';
      } else if (action == 'blank') {
        out += 'Ending with <b>no output</b>.';
      } else if (action == 'image') {
        out += 'Displaying a <b>transparent 1x1 px GIF</b>.';
      }
    break;
    case 'local_db':
      count = $('.vars_box tr', settings).length - 2;
      if (count == 0) {
        out += '<b>No variables</b> will be saved,';
      } else if (count == 1) {
        out += 'Saving <b>1 variable</b>';
      } else {
        out += 'Saving <b>' + count + ' variables</b>';
      }
      tags = $('select[id$=tags_remove]', settings).val();
      if (tags) {
        tags = tags.length;
      } else {
        tags = 0;
      }
      if (tags == 0) {
        out += ', <b>no tags</b> will be removed';
      } else if (tags == 1) {
        out += ', removing <b>1 tag</b>';
      } else {
        out += ', removing <b>' + tags + ' tags</b>';
      }
      tags = $('select[id$=tags_add]', settings).val();
      if (tags) {
        tags = tags.length;
      } else {
        tags = 0;
      }
      if (tags == 0) {
        out += ' and <b>no tags</b> will be added to the user\s profile.';
      } else if (tags == 1) {
        out += ' and adding <b>' + tags + ' tag</b> to the user\'s profile.';
      } else {
        out += ' and adding <b>' + tags + ' tags</b> to the user\'s profile.';
      }

    break;
    case 'twilio':
      if (!$('select[id$=to]  option:selected', settings).text()) {
        out += 'No SMS recipients configured. <b>Component is disabled.</b>';
      } else {
        nb = $('select[id$=from] option:selected', settings).text();
		
		recipients=new Array();
		$('select[id$=to] :selected', settings).each(function(i, selected){ 
		  recipients.push($(selected).text()); 
		});
				
        out += '<b>Sending a SMS</b> via number labeled as ' + nb + ' to '+recipients.join(', ')+' .'
      }
    break;
    case 'email':
      if (!$('input[id$=recipient]', settings).val()) {
        out += 'No email recipients configured. <b>Component is disabled.</b>';
      } else {
        subject = $('input[id$=subject]', settings).val();
        out += '<b>Sending an email</b> with the following subject: <b>' + subject + '</b>.';
      }
    break;
    case 'filesystem':
      path = $('input[id$=path]', settings).val();
      if (!path) {
        out += 'File path is not configured. <b>Component is disabled.</b>';
      } else {
        filename = path.replace(/^.*[\\\/]/, '');
        mode = $('select[id$=mode]', settings).val();
        if (mode == 'w') {
          out += 'Creating a new file: <b>' + filename + '</b>.';
        } else {
          out += 'Appending to file: <b>' + filename + '</b>.';
        }
      }
    break;
    case 'custom_url':
      type = $('select[id$=request_type]', settings).val();
      url = $('input[id$=url]', settings).val();
      if (type == 'custom') {
        out += 'Making a request with <b>custom variables</b> to <b>' +  url + '</b>.';
      } else {
        out += 'Making a request with <b>cloned GET &amp; POST variables</b> to <b>' +  url + '</b>.';
      }
    break;
    case 'mysql':
      query = $('textarea[id$=query]', settings).val();
      if (!query) {
        out += 'No SQL query set. <b>Component is disabled.</b>';
      } else {
        cnt = query.split(';').length;
        out += '<b>Executing</b> ' + cnt + ' or more SQL queries.';
      }
    break;
    case 'php':
      code = $('textarea[id$=code]', settings).val();
      if (!code) {
        out += 'No PHP code defined. <b>Component is disabled.</b>';
      } else {
        cnt = code.split(/\r|\r\n|\n/);
        out += '<b>Executing</b> ' + cnt.length + ' lines of PHP code.';
      }
    break;
    case 'pushover':
      if (!$('textarea[id$=to]', settings).val()) {
        out += 'No push notification recipients configured. <b>Component is disabled.</b>';
      } else {
        subject = $('input[id$=subject]', settings).val();
        if (subject) {
          out += 'Sending a push notification with the following subject: <b>' + subject + '</b>.';
        } else {
          out += 'Sending a push notification with <b>no subject</b>.';
        }

      }
    break;
    default:
      out = 'Details are <b>not available</b> for this component.';
    } // switch

    return out;
  } // get_flow_short_desc


  // ------------- var boxes ---------------
  // delete var in box
  $('#wpbody-content').on('click', '.lf-delete-vars-row', function(e) {
    e.preventDefault();

    $(this).parents('tr').remove();

    return false;
  }); // delete var in box


  // add new var in box
  $('#wpbody-content').on('click', '.lf-add-vars-row', function(e) {
    e.preventDefault();
    
	table = $(this).prev('table');
    max_id = 0;
	
    $(table).find('tr').each(function(i, el) {
      tmp = parseInt($(el).data('row-id')) + 0;
      if (tmp > max_id) {
        max_id = tmp;
      }
    });
    tpl = $(table).find('tr.lf_var_template');
	
    tpl_tr = tpl;
    tpl = $(tpl).clone().wrap('<div></div>').parent().html();
	tpl = tpl.replace(/%%__id%%/ig, max_id + 1);
    tpl = tpl.replace('display: none;', '');
    tpl = tpl.replace('skip_chosen', '');
    tpl = tpl.replace('skip_select2', '');
    tpl = tpl.replace('lf_var_template', '');
    $(tpl).insertBefore(tpl_tr);

    $('select.var_box_chosen[id*=var_values-' + (max_id + 1) +  ']', table).lf_select2({ width: '470px' });
    tmp = $('select.select2-vars[id*=var_values-' + (max_id + 1) +  ']', table).select2_sortable({ width: '470px' });
    if (tmp.length == 1) {
      $('#flow_active_components .var_name_watch').trigger('change');
    }

    return false;
  });
  // add new var in box
  // ------------- var boxes ---------------


  // refresh debug log
  $('#lf-refresh-debug-log').on('click', function(e) {
    e.preventDefault();
    var button = this;

    $(this).addClass('loading');
    $('#lf-debug-log').val('').css('color', 'white');

    $.get(ajaxurl, { action: 'lf_refresh_debug_log', post_id: $('#post_ID').val() }, function(response) {
      if (response.success) {
        $('#lf-debug-log').val(response.data).animate({ color: 'black' }, 1100).width('100%');
      } else {
        alert('Unknown error. Please try again.');
      }
    }, 'json')
    .fail(function() { alert('Unknown error. Please try again.'); })
    .always(function() { $(button).removeClass('loading'); });

    return false;
  }); // refresh debug log


  // send test zap
  $('#flow_active_components').on('click', '.test_zap', function(e) {
    e.preventDefault();
    vars = {};
    button = this;

    $(button).addClass('loading');

    container = $(this).parents('.settings');
    webhook = $('input[name*=webhook]', container).val();
    $('input[id*=var_names]', container).each(function(i, el) {
      if (!$(el).val()) {
        return true;
      }

      vars[$(el).val()] = $(el).parents('tr').find('select[name*="var_values"]').val().join(' ');
    });
    vars['_rand'] = Math.floor((Math.random() * 100) + 1);

    $.post(webhook, vars, function(response) {
      if (response.status == 'success') {
        alert('Request sent. Sample data will be available in Zapier momentarily.');
      } else {
        alert('Zapier did not responde as expected. Please try again in a few minutes.');
      }
    }, 'json').fail(function() { alert('Please double check the Zap webhook URL and try again.'); }).always(function() { $(button).removeClass('loading'); });

    return false;
  }); // send test zap


  // toogle help text on question mark click
  $('.postbox').each(function(i, item) {
	if ($('p.description', item).length && this.id != 'flow-components') {
      postbox = $('.handlediv', item);
      $('<a title="Click to toggle detailed help for this box\'s settings" class="lf-more-info">&nbsp;&nbsp;<i class="dashicons dashicons-editor-help"></i>&nbsp;&nbsp;</a>').insertAfter(postbox);
    }
  });
  $('.postbox h3').each(function(i, item){
    $(item).unbind('click');
  });
  $('.postbox').on('click', '.lf-more-info', function(e){
    e.preventDefault();
    postbox = $(this).closest('.postbox');
    $('p.description', postbox).slideToggle(500);

    return false;
  });


  // enable/disable custom URL
  $('#general_custom_url').on('change', function() {
    if ($(this).val() == '1') {
      $('.custom_url_box').show();
    } else {
      $('.custom_url_box').hide();
    }
  }).trigger('change');
  
  
  
  // enable/disable facebook verify token
  $('#general_facebook-leads').on('change', function() {
    if ($(this).val() == '1') {
      $('.facebook_leads').show();
    } else {
      $('.facebook_leads').hide();
    }
  }).trigger('change');
}); // onload