/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */


jQuery(document).ready(function($){

  // Readonly
  $('body.post-type-leadflow-subscribers #title').attr('readonly', 'true');

  if ($('.select2').length) {
    $('.select2').lf_select2({
     placeholder: "Select a tag",
     allowClear: true,
     tags:true,
     templateResult: formatState
    });
  }

  // confirm subscriber delete
  $('body.post-type-leadflow-subscribers a.submitdelete').on('click', function(e) {
    if (!confirm('Are you sure you want to delete the selected subscriber? There is NO undo, there is NO trash!')) {
      e.preventDefault();
      return false;
    }

    return true;
  });
	// Subscribers
  if ($('.lf-subscribers-filters').length) {

    $('.alignleft.actions:not(.bulkactions)', '.tablenav.top').after('<div class="alignleft filter" id="lf-subscribers-filter-container" style="margin-top:0px;"></div>');

    $('.lf-subscribers-filters-container').prependTo('#lf-subscribers-filter-container').show();

     $('#lf-filter').on('click', function(e) {
      $(this).parent().toggleClass('active');
      var url_slug = $(this).attr('name');

      var tags = '&' + url_slug + '=';

      $('select[name="' + url_slug + '"] option:selected').each(function(i, item) {
        tags += $(item).val() + '+';
      });

      tags = tags.substring(0, tags.length - 1);

      var newURLString = window.location.href + "" + tags;
      window.location.href = newURLString;
    });

    if ($('.lf-subscribers-filters-operator').length) {
      $('.lf-subscribers-filters-operator').show();
      $('.lf-subscribers-filters-container').appendTo('#lf-subscribers-filter-container');
    }

  }

  $('#lf-filter').on('click', function(e){
    e.preventDefault();

    var operator = $('#lf-subscribers-operator').val();
    var delimiter = '+';

    if (operator == 'OR') {
      delimiter = ',';
    }

    var tags = '&leadflow-subscriber-operator=' + operator + '&leadflow-subscriber-tags=';

    $('select[name="leadflow-subscriber-tags"] option:selected').each(function(i, item) {
      tags += $(item).val() + delimiter;
    });

    tags = tags.substring(0, tags.length - 1);

    tags += '&leadflow-subscriber-system-tags=';
    $('select[name="leadflow-subscriber-system-tags"] option:selected').each(function(i, item) {
      tags += $(item).val() + delimiter;
    });

    tags = tags.substring(0, tags.length - 1);

    var newURLString = window.location.href + "" + tags;
    window.location.href = newURLString;
  });

  function formatState (state) {
    if (!state.id) { return state.text; }

    var bgcolor = $(state.element).data('background-color');
    var fontcolor = $(state.element).data('font-color');

    var $state = $(
      '<span style="background-color:' + bgcolor + ';color:' + fontcolor + ';">' + state.text + '</span>'
    );
    return $state;
  };

  if ($('.lf-subscribers-filters').length) {
    $('.lf-subscribers-filters').lf_select2({
     placeholder: $(this).data('placeholder'),
     allowClear: true,
     tags:true,
     templateResult: formatState
    });
  }

  if ($('#bulk-action-selector-top').length) {
    $('option[value="trash"]', '#bulk-action-selector-top').text('Delete');
    $('#bulk-action-selector-top').append('<option value="lf-push-flow">Push Through Flow</option>');
    $('#bulk-action-selector-top').append('<option value="lf-export">Export</option>');
  }

  // Form submit - delete alert
  $('#posts-filter').on('submit', function(){
    var form = $(this);
    var bulk_action = $('#bulk-action-selector-top', form).val();
    if (bulk_action == 'trash') {
      var confirm_box = confirm('Are you sure you wish to delete this subscriber? There is NO undo!');
      if (confirm_box) {
        return true;
      } else {
        return false;
      }
    }
  });


  // Get Dialog
  var dlg_flow = $('#lf-subscribers-flows');
  var dlg_export = $('#lf-subscribers-export');

  // Dialog changed Push Type
  $('select[name="lf-push-type"]').on('change', function(){
    var body = $('body');
    var form = $('#posts-filter', body);
    var form_data = $(form).serialize();
    var value = $(this).val();
    var subscriber_count = 0;

    if (value == 'push-all') {
      // Setup
      subscriber_count = $('span.displaying-num', form).html();
      subscriber_count = subscriber_count.replace('items', '');

      // Write
      $('input[name="filter-form"]', dlg_flow).val(form_data);
      $('input[name="filter-selected"]', dlg_flow).val('');
    } else {
      // Setup
      subscriber_count = $('input[name="post[]"]:checked', form).length;

      // Gather selected checkboxes
      form_data = '';
      $('input[name="post[]"]:checked', form).each(function(i, item){
        form_data += $(item).val() + ',';
      });
      form_data = form_data.slice(0, -1);

      // Write
      $('input[name="filter-form"]', dlg_flow).val('');
      $('input[name="filter-selected"]', dlg_flow).val(form_data);
    }

    $('.subscribers-selected', dlg_flow).html(subscriber_count);
  });

  // Dialog changed Export Type
  $('select[name="lf-export-type"]').on('change', function(){
    var body = $('body');
    var form = $('#posts-filter', body);
    var form_data = $(form).serialize();
    var value = $(this).val();
    var subscriber_count = 0;

    if (value == 'export-all') {
      // Setup
      subscriber_count = $('span.displaying-num', form).html();
      subscriber_count = subscriber_count.replace('items', '');

      // Write
      $('input[name="filter-form"]', dlg_export).val(form_data);
      $('input[name="filter-selected"]', dlg_export).val('');
    } else {
      // Setup
      subscriber_count = $('input[name="post[]"]:checked', form).length;

      // Gather selected checkboxes
      form_data = '';
      $('input[name="post[]"]:checked', form).each(function(i, item){
        form_data += $(item).val() + ',';
      });
      form_data = form_data.slice(0, -1);

      // Write
      $('input[name="filter-form"]', dlg_export).val('');
      $('input[name="filter-selected"]', dlg_export).val(form_data);
    }

    $('.subscribers-selected', dlg_export).html(subscriber_count);
  });

  // Flow Push Dialog
  $('#posts-filter', 'body.post-type-leadflow-subscribers').on('submit', function(){
    var subscriber_count = 0;
    var body = $('body');
    var form = $(this);

    var action = $('select[name="action"]', form).val();

    if (action == 'lf-push-flow') {

      // Setup
      subscriber_count = $('span.displaying-num', form).html();
      subscriber_count = subscriber_count.replace('items', '');

      // Pass data
      $('.subscribers-selected', dlg_flow).html(subscriber_count);

      dlg_flow.dialog({'dialogClass' : 'wp-dialog',
                  'title' : 'Push Through Flow',
                  'modal' : true,
                  'autoOpen' : false,
                  'closeOnEscape' : true,
                  'open' : function() {
                    $('select[name="lf-push-type"]', dlg_flow).val('-');
                  },
                  'buttons' : [
                  {
                    'text' : 'Push',
                    'class' : 'button-primary',
                    'click': function(e){
                      if ($('.subscribers-selected', dlg_flow).html() == '0') {
                        alert('You have selected 0 subscribers!');
                        e.preventDefault();
                        return false;
                      }
                    },
                    type : 'submit',
                    form : 'lf-subscribers-flow-form'
                  },
                  {
                    'text' : 'Cancel',
                    'class' : 'button-secondary',
                    'click' : function() {
                      $(this).dialog('close');
                    }
                  }]
                  }).dialog('open');

      return false;
    } else if (action == 'lf-export') {

      // Setup
      subscriber_count = $('span.displaying-num', form).html();
      subscriber_count = subscriber_count.replace('items', '');

      // Pass data
      $('.subscribers-selected', dlg_export).html(subscriber_count);

      dlg_export.dialog({'dialogClass' : 'wp-dialog',
                  'title' : 'Export Subscribers',
                  'modal' : true,
                  'autoOpen' : false,
                  'closeOnEscape' : true,
                  'open' : function() {
                    $('select[name="lf-export-type"]', dlg_export).val('-');
                  },
                  'buttons' : [
                  {
                    'text' : 'Export',
                    'class' : 'button-primary',
                    'click': function(e){
                      if ($('.subscribers-selected', dlg_export).html() == '0') {
                        alert('You have selected 0 subscribers!');
                        e.preventDefault();
                        return false;
                      }
                    },
                    type : 'submit',
                    form : 'lf-subscribers-export-form'
                  },
                  {
                    'text' : 'Cancel',
                    'class' : 'button-secondary',
                    'click' : function() {
                      $(this).dialog('close');
                    }
                  }]
                  }).dialog('open');

      return false;
    }
  });

}); // jQuery.ready