/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

jQuery(function($) {

  $(window).on('resize', function() {
    lf_center_optin_dialog();
  });

  // target our links
  $('a.optin-popup').on('click', function(e) {
	e.preventDefault();
    lf_optin_open_popup($(this).attr('href'), $(this).attr('data-optin-position'));
  });

  // popup close button
  $('#lf-optin-close').live('click', function(e) {
    e.preventDefault();
    $('#lf-optin-dialog').hide();
  });

  // FlipClock
  //if (typeof FlipClock != 'undefined') {
  $('.lf-clock').each(function(i, item) {

    // Grab the current date
    var currentDate = new Date();
    // Set some date in the future. In this case, it's always Jan 1
    var end_time = $(item).data('end-time');
    var futureDate  = new Date(end_time.replace( /(\d{2})\/(\d{2})\/(\d{4}) (\d{2}):(\d{2})/, "$2/$1/$3 $4:$5"));
    // Calculate the difference in seconds between the future and current date
    var diff = futureDate.getTime() / 1000 - currentDate.getTime() / 1000;
    $(item).FlipClock(diff);
  });
  //}


  // Date/Time Picker
  if ($('.lf-datetime-picker').length) {
    $('.lf-datetime-picker').each(function(i, item) {

      var min = $(item).data('min-time');
      var max = $(item).data('max-time');
      var type = $(item).data('type');

      var options = [];

      if (min.length) {
        min = min.split(' '); // hours
        min_date = min[0].split("/");
        min_hours = min[1].split(':');
        options.push({minDate: new Date(min_date[2], min_date[0], min_date[1], min_hours[0], min_hours[1])});
      }

      if (max.length) {	
        max = max.split(' '); // hours
        max_date = max[0].split('/');
        max_hours = max[1].split(':');
        options.push({maxDate: new Date(max_date[2], max_date[0], max_date[1], max_hours[0], max_hours[1])});
      }

      if (type != '') {
        if (type == 'time') {
          // Give just option of time
          options.push({timeOnly:true});
        } else if (type == 'date') {

        } else {

        }
      }

      if (type == 'date') {
        $(item).datepicker(options);
      } else {
        $(item).datetimepicker(options[0]);
      }
    });
  }


  // Rating
  $('.lf-rating').each(function(i, item) {
    rating = $(item).data('default');
    name = $(item).data('field-name');

    $(item).raty({score:rating, path: optin_frontend.raty_path + '/images', scoreName: name});
  });

  // ColorPicker
  if ($('.colorpicker').length) {
    $('.colorpicker').wpColorPicker();
  }

  // FitVid
  if (typeof fitVids != 'undefined') {
    $(".fitvid").fitVids();
  }



});

function lf_optin_validate_position(position) {
  predefined = ['left top',    'center top',    'right top',
    'left center', 'center center', 'right center',
    'left bottom', 'center bottom', 'right bottom',
    'left', 'center', 'right'];

  position = position || 'center';
  position = position.toLowerCase();
  if (jQuery.inArray(position, predefined) == -1) {
    return 'center center';
  } else {
    return position;
  }
} // lf_optin_validate_position

var global_time = 0;
function lf_center_optin_dialog() {
  time = new Date().getTime();
  sec = parseInt(time / 1000);
  if (sec - global_time < 2) {
    return;
  }
  global_time = sec;

  jQuery('#lf-optin-dialog').position({ my: 'center center', at: 'center center', of: jQuery(window) });
} // lf_center_optin_dialog

function lf_optin_open_popup(url, position) {
  if (jQuery('.lf-optin-dialog').is(':visible')) {
    return false;
  }

  position = lf_optin_validate_position(position);

  jQuery('#lf-optin-dialog').position({ my: position, at: position, of: jQuery(window) }).show();

  return true;
} // lf_optin_open_popup