/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/


  (function($) {
    $.fn.lfp_form_grabber = function(options) {

      var defaults = {
        ajax_url: '',
        flow_id: 0,
        check_email: true,
        timeout: 3000,
        ignore_validator: false
      };

      var settings = $.extend({}, defaults, options);

      if (settings.ajax_url.length < 10) {
        lfp_log('AJAX URL is not defined. Aborting.');
        return;
      }

      if (!settings.flow_id) {
        lfp_log('Flow ID is not defined. Aborting.');
        return;
      }

      // Global Variables to store data while processing the form so they are accessible by other jquery functions like post
      $lfp_form = {};
      $lfp_form.processing = '';
      $lfp_form.valid = false;
      $lfp_form.has_ajax = false;
      $lfp_form.email_found = false;

      var form_data = {}, form_meta = {};

      //Determine something to identify the form by
      if (typeof $(this).attr('name') !== 'undefined' && $(this).attr('name').length > 0) {
        form_meta.form_name = $(this).attr('name');
      } else if (typeof $(this).attr('id') !== 'undefined' && $(this).attr('id').length > 0) {
        form_meta.form_name = $(this).attr('id');
      } else if (typeof $(this).attr('action') !== 'undefined' && $(this).attr('action').length > 0) {
        form_meta.form_name = $(this).attr('action');
      } else if (typeof $(this).attr('class') !== 'undefined' && $(this).attr('class').length > 0) {
        form_meta.form_name = $(this).attr('class');
      }


      //If the form doesn't have an ID we set a random one to target it later on
      if (typeof $(this).attr('id') === 'undefined' || (typeof $(this).attr('id') !== 'undefined' && $(this).attr('id').length == 0)) {
        $(this).attr('id', 'lfp_form_' + Math.floor(Math.random() * 10000));
      }

      $(this).on('submit', function(e) {

        // First time the form is submitted the script will process the data and send it via AJAX Etc. Once ajax is done it will resubmit it normally.
        if (typeof $lfp_form.processing !== 'undefined' && $lfp_form.processing == this.id) {
          return true;
        }

        // When form is submitted preven all other event handlers from doing anything until LFP is done
        e.preventDefault();
        e.stopImmediatePropagation();

        //Check to see if there is any other ajax handler listening for the form's submit
        var form_ajax_events = $._data(this, 'events');


        $lfp_form.processing = this.id;

        lfp_log('Form has ' + form_ajax_events.submit.length + ' submit listeners');
        lfp_log(form_ajax_events);


        // The script checks if the form has another validation function already set
        if ($(this).attr('onsubmit')) {
          $existing_form_validator = $(this).attr('onsubmit');
          lfp_log('Existing form validator present: ' + $existing_form_validator + '. Will call this after I\'m done.');
        } else {
          $existing_form_validator = '';
          lfp_log('No existing form validator present.');
        }


        //The script saves the data in the fields in an array that it will pass to the server
        $(this).find('*').each(function() {
          if (typeof $(this).attr('name') !== 'undefined' && typeof $(this).val() !== 'undefined') {
            if ($(this).attr('type') == 'text' || $(this).attr('type') == 'email' || $(this).is('textarea')) {
              form_data[$(this).attr('name')] = $(this).val();
              if (settings.check_email && lfp_test_email($(this).val())) {
                $lfp_form.email_found = true;
                lfp_log('Found email address');
              }
            } else if ( $(this).attr('type') == 'submit' && $(this).attr('id')=='submit' ){
              $(this).attr('id','submitcontactform');
              $(this).attr('name','submitcontactform');
        } else if ($(this).is('input') && $(this).attr('name').length > 0 && $(this).val().length > 0) {
              form_data[$(this).attr('name')] = $(this).val();
            } 
          } else if ($(this).is('select') && typeof $(this).attr('name') !== 'undefined' && $('option:selected', this).text() !== 'undefined') {
            form_data[$(this).attr('name')] = $('option:selected', this).text();
          } 
        });

        form_meta.flow_id = settings.flow_id;
        form_meta.page_url = window.location.href;

        lfp_log('Form Data Gathered:');
        lfp_log(form_data);

        if (settings.check_email && !$lfp_form.email_found) {
          lfp_log('Email required but not found. Resuming default form flow.');

          if ($existing_form_validator && eval($existing_form_validator)) {
            lfp_log('Existing form validator ' + $existing_form_validator + ' returned true. Will submit the form.');
            $lfp_form.valid = true;
            lfp_submit_form();
            $lfp_form.processing = '';
            return true;
          } else if ($existing_form_validator) {
            lfp_log('Existing form validator ' + $existing_form_validator + ' returned false. Will stop.');
            return false;
          } else {
            $lfp_form.valid = true;
            lfp_log('No existing form validator found. Will submit the form.');
            lfp_submit_form();
            $lfp_form.processing = '';
            return true;
          }
        }


        //The script will check if the form would have normally been validated and determine if it will submit it or not. 
        if ($existing_form_validator && eval($existing_form_validator)) {
          lfp_log('Existing form validator ' + $existing_form_validator + ' returned true. Will wait 5 seconds for AJAX then submit the form.');
          setTimeout(lfp_submit_form(), settings.timeout);
          $lfp_form.valid = true;
        } else if ($existing_form_validator) {
          lfp_log('Existing form validator ' + $existing_form_validator + ' returned false. Will do AJAX then stop.');
          $lfp_form.valid = false;
        } else {
          lfp_log('No existing form validator found. Will wait '+settings.timeout+' miliseconds for AJAX then submit the form.');
          setTimeout(lfp_submit_form(), settings.timeout);  
          $lfp_form.valid = true;
        }

        $.ajax({
          url: settings.ajax_url,
          method: 'POST',
          crossDomain: true,
          dataType: 'json',
          timeout: settings.timeout,
          xhrFields: {
            withCredentials: true
          },
          data: {
            action: 'lfp_catch_form',
            form_vars: form_data,
            form_meta: form_meta
          }
        }).success(function(response) {
          lfp_log(response);
          if (response.success) {
            lfp_log('Form data catched! User ID #' + response.data + '.');
          } else {
            lfp_log('Unable to catch form. Error: ' + response.data + '');
          }
        }).error(function(type) {
          lfp_log('Unable to catch form. Unknown error.');
        }).complete(function(type) {
          lfp_submit_form();
        });

      }); // on submit

      return this;
    };


    //Private LFP functions

    function lfp_submit_form() {
      //If existing form validator function returns true or does not exist and the form has no other ajax handlers resubmit it

      if ($lfp_form.valid) {
        lfp_log('Submitting form ' + $lfp_form.processing);
        $('#' + $lfp_form.processing).submit();
      } else {
        lfp_log('Form will not be submitted because existing validator failed');
      }
    }

    function lfp_test_email(value) {
      var regExp = new RegExp('[a-zA-Z0-9!#$%&\'*+/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])', '');
      return regExp.test(value);
    }

    }(jQuery));

function lfp_log(message, message2) {
  if (typeof console == 'object' && typeof console.log == 'function') {
    if (message2) {
      console.log('LFP - ', message, message2);
    } else {
      console.log('LFP - ', message);
    }
  }
} // lfp_log