<?php
/*
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_abtests_metabox extends leadflow {
  static $component_id = null;


  // A/B Tests Type
  static function type_box() {
    global $post;

    $ab_type = leadflow_ab_test_common::get_ab_test_type($post->ID);

    echo '<input type="hidden" name="ab_test_type" id="ab_test_type" value="' . $ab_type . '">';
    foreach (leadflow_optin_type::$types as $type => $type_desc) {
      if ($type == $ab_type) {
        echo '<div class="abtest_type_box selected" data-abtest_type="' . $type . '">';
      } else {
        echo '<div class="abtest_type_box" data-abtest_type="' . $type . '">';
      }
      echo '<img src="' . LF_PLUGIN_URL . '/images/optin_types/' . $type . '.png">';
      echo '<span>' . $type_desc . '</span>';
      echo '</div>';
    }
    echo '<div class="clear"></div>';
    echo '<p>Note: make sure you save the A/B Test after changing the type.</p>';

  } // type_box
  
  
  // A/B Tests Conditionals
  static function conditionals_box() {
    global $post;
    
    $optin_type = leadflow_optin_common::get_optin_type();
    $options = get_option(LF_OPTIONS, array());
    $meta = leadflow_optin_common::get_optin_meta();
    $field_generator = new leadflow_field_generator();
    
    $posts_tmp = get_posts(array('posts_per_page' => 500, 'orderby' => 'title', 'order' => 'ASC'));
    $posts = array();
    foreach ($posts_tmp as $post_tmp) {
      $posts[$post_tmp->ID] = $post_tmp->post_title;
    }

    $pages_tmp = get_pages(array('posts_per_page' => 500, 'orderby' => 'title', 'order' => 'ASC'));
    $pages = array();
    foreach ($pages_tmp as $page_tmp) {
      $pages[$page_tmp->ID] = $page_tmp->post_title;
    }

    $cats_tmp = get_terms('category', array('hide_empty' => false));
    $categories = array();
    foreach ($cats_tmp as $cat_tmp) {
      $categories[$cat_tmp->term_id] = $cat_tmp->name . ' (' . $cat_tmp->count . ')';
    }

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Filter Subscribed Users:', 'ab-test', 'filter_subscribed', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'filter_subscribed', array('0' => 'Show to all users', '1' => 'Do not show to users that already subscribed to this OptIn'), '', true, false, 'If the user has already subscribed to the list attached to this OptIn there is no reason to show him the popup again.');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Filter Logged in Users:', 'ab-test', 'filter_loggedin', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'filter_loggedin', array('0' => 'Show to all users', '1' => 'Show only to logged in users', '2' => 'Show only to logged out users'), '', true, false, 'If you want to show a popup only to your logged in users enable this option.');
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Limit per User:', 'ab-test', 'limit_per_user', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'limit_per_user', array('0' => 'Show unlimited times', '1' => 'Show max 1 time per user', '2' => 'Show max 2 times per user', '3' => 'Show max 3 times per user', '4' => 'Show max 4 times per user', '5' => 'Show max 5 times per user'), '', true, false, 'Maximum amount of times a user can see the popup.', '');
    echo $field_generator->end_row();

    echo '<hr>';
    echo '<p>By default, if none of the option below are set, the popup will be shown on all pages. If you enable any option then that condition has to be met in order for the popup to show. Ie enabling home page and search page options means the popup will only be shown on the home and search pages.</p>';

    $conditions = array('is_home' => 'is_home', 'is_front_page' => 'is_front_page', 'is_archive' => 'is_archive', 'is_archive' => 'is_archive', 'is_single' => 'is_single');

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show only when following conditions are met:', 'ab-test', 'conditions', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'conditions', $conditions, '', true, false, 'Popup will be shown when is_home() or is_front_page() conditionals return true.', '', array('multiple' => true, 'data-placeholder' => 'Choose conditions'));
    echo $field_generator->end_row();


    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Posts:', 'ab-test', 'on_posts', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'on_posts', $posts, '', true, false, 'Popup will be shown only on selected posts.', '', array('multiple' => true, 'data-placeholder' => 'Choose posts'));
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on Pages:', 'ab-test', 'on_pages', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'on_pages', $pages, '', true, false, 'Popup will be shown only on selected pages.', '', array('multiple' => true, 'data-placeholder' => 'Choose pages'));
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Show on/in Categories:', 'ab-test', 'on_categories', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'ab-test', 'on_categories', $categories, '', true, false, 'Popup will be shown only on/in selected categories.', '', array('multiple' => true, 'data-placeholder' => 'Choose categories'));
    echo $field_generator->end_row();
  } // conditionals_box


} // leadflow_abtests_metabox