<?php
/*
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_flow_general_settings extends leadflow {
   static function content() {
     global $post,$wpdb;

     $flow_type = leadflow_flow_common::get_flow_type($post->ID);
     $field_generator = new leadflow_field_generator();
	 
     if ($flow_type == 'external') {
       $variables_orders = array('get' => 'Only use GET variables', 'post' => 'Only use POST variables', 'postget' => 'Use POST and GET (POST overwrites GET)', 'getpost' => 'Use GET and POST (GET overwrites POST)', 'internal' => 'Use function call variables');

       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'Custom URL:', 'general', 'custom-url', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'custom_url', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'If the default URL (' . get_permalink($post->ID) . ') doesn\'t suite your needs you can define a custom one by enabling this option and entering an URL below.', '', array('default' => '0'));
       echo $field_generator->end_row();

       echo $field_generator->start_row('custom_url_box');
       echo $field_generator->generate('label', '', 'general', 'flow-custom-url', '', '', true, '', '', '');
       echo $field_generator->generate('input', 'Custom URL', 'general', 'flow-custom-url', '', '', '','', 'URL has to start and end with a forward slash -  "/". Multiple flows and/or OptIns can\'t share the same URL and if more than one are defined on the same one whichever was defined first will be the one to get loaded.', true, array('class' => 'normal-text code', '_before_field' => home_url()));
       ?>
       <script>
	   <?php 	   
	   echo 'var custom_urls_in_use=JSON.parse(\''.json_encode( leadflow_common::custom_url_print_all_urls_as_js() ).'\');'."\r\n";   
	   echo 'var current_post_id='.$post->ID.';';
	   ?>
	   
	   var custom_urls_in_use_html = '';
	   function check_url_exists(value){
		   custom_urls_in_use_html = '';
		   for(i in custom_urls_in_use){
			   if( i != current_post_id && custom_urls_in_use[i].url == value.replace(/[^a-z0-9-]+/gi, '')){
				   custom_urls_in_use_html = 'This URL is already in use by <a href="'+custom_urls_in_use[i].permalink+'">'+custom_urls_in_use[i].title+'</a>'; 
			   }
		   }
		   jQuery('#custom_url_in_use').html(custom_urls_in_use_html);
	   }	   
	   
	   jQuery('#general_flow-custom-url').on('change', function(){
		  check_url_exists(jQuery('#general_flow-custom-url').val()); 
	   });
	   
	   jQuery('#general_flow-custom-url').on('keyup', function(){
		  check_url_exists(jQuery('#general_flow-custom-url').val()); 
	   });
	   
	   </script>
       
       <?php
	   
	   
	   $flow_meta = get_post_meta($post->ID,LF_META,true);
       $custom_url_used = leadflow_common::custom_url_usage_check($post->ID, 'flow');
       if (!empty($custom_url_used)) {
         echo '<div class="lf-error-label" id="custom_url_in_use">This URL is already in use by another ' . $custom_url_used['type'] . '. <br/>' . $custom_url_used['found'] . '</div>';
       } else {
		   echo '<div class="lf-error-label" id="custom_url_in_use"></div>';
	   }
       echo $field_generator->end_row();

       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'External Variables Load Order:', 'general', 'variables-order', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'variables-order', $variables_orders, '', true, false, 'Please choose the external variables\' source and load order carefully as you will not be able to access variables if this setting is misconfigured.<br>A list of predefined, system variables can be found in the help section of every flow component.', '', array('default' => 'get'));
       echo $field_generator->end_row();
	   	   
	   $flow_custom_url = get_post_meta($post->ID,'flow-custom-url',true);
       echo '<input type="hidden" id="flow_permalink" value="';
	   if( @$flow_meta['general']['custom_url'] == 1 && strlen($flow_custom_url) !== false){
		 echo site_url().$flow_custom_url;  
	   } else {
	     echo get_permalink($post->ID);
	   }
	   echo '">';
       
       echo '<div class="link_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Sample Flow URL:</label></div>';
	  
	   echo '<div class="col-6"><pre id="sample_flow_url">';
	   	   
	   if( $flow_meta['general']['custom_url'] == 1 && strlen($flow_custom_url) !== false){
		 echo site_url().$flow_custom_url. '?email=test@test.com&name=John&lastname=Doe';  
	   } else {
	     echo get_permalink($post->ID) . '?email=test@test.com&name=John&lastname=Doe';
	   }
	   echo '</pre>';
       echo '<p class="description">This is a sample flow call URL. Please replace the variable values (VAL) with your own.</p></div></div>';

       echo '<div class="code_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Sample Flow Function Call:</label></div><div class="col-6"><pre id="sample_flow_code">lfp_external_flow(' . $post->ID . ', array(\'email\' => \'test@test.com\', \'price\' => 13));</pre>
       <p class="description">This is a sample flow function call. Please replace the variable values (VAL) with your own.</p></div></div>';
       
       echo '<div class="form_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Sample Form Code:</label></div><div class="col-6"><textarea rows="3" style="width: 100%;" id="sample_flow_form">' . get_permalink($post->ID) . '?email=test@test.com&name=John&lastname=Doe</textarea>
       <p class="description">This is a sample flow form code. You can copy/paste it in most HTML/page editors and it will work out-of-the-box.</p></div></div>';


		

       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'SPAM / DDoS Protection:', 'general', 'spam-protection', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'spam-protection', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'SPAM protection prevents bots and harmfull users from submitting the form multiple times and filling your DB with garbage. Please note that this does NOT protect you from users submitting arbitrary garbage data. Open <a href="' . admin_url('admin.php?page=leadflow-settings') . '">settings</a> to fine tune this option.', '', array('default' => '1'));
       echo $field_generator->end_row();
     } // external


     if ($flow_type == 'ecommerce') {
       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'Custom URL:', 'general', 'custom-url', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'custom_url', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'If the default URL (' . get_permalink($post->ID) . ') doesn\'t suite your needs you can define a custom one by enabling this option and entering an URL below.', '', array('default' => '0'));
       echo $field_generator->end_row();

       echo $field_generator->start_row('custom_url_box');
       echo $field_generator->generate('label', '', 'general', 'flow-custom-url', '', '', true, '', '', '');
       echo $field_generator->generate('input', 'Custom URL', 'general', 'flow-custom-url', '', '', '','', 'URL has to start and end with a forward slash -  "/". Multiple flows and/or OptIns can\'t share the same URL and if more than one are defined on the same one whichever was defined first will be the one to get loaded.', true, array('class' => 'normal-text code', '_before_field' => home_url()));
       echo $field_generator->end_row();

       $variables_orders = array('script' => 'Use only <script> variables', 'getscript' => 'Use page\'s GET and <script> variables (GET overwrites <script>)', 'scriptget' => 'Use page\'s <script> and GET variables (<script> overwrites GET)', 'post' => 'Use only POST variables', 'get' => 'Use only GET variables', 'internal' => 'Use function call variables');

       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'Variables Source &amp; Load Order:', 'general', 'variables-order', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'variables-order', $variables_orders, '', true, false, 'Please choose the external variables\' source and load order carefully as you will not be able to access variables if this setting is misconfigured.<br>A list of predefined, system variables can be found in the help section of every flow component.', '', array('default' => 'get'));
       echo $field_generator->end_row();

       echo '<div class="script_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Tracking script:</label></div><div class="col-6"><textarea rows="4" style="width: 100%;">' . esc_html('<script type="text/javascript" id="lfp-tracking" data-lfp-id="' . $post->ID . '" data-lfp-ajaxurl="' . admin_url('admin-ajax.php') . '" async="async" src="'. LF_PLUGIN_URL . '/js/lfp-ecommerce-tracking.js" data-price="33" data-custom-var="value"></script>') . '</textarea><p class="description">Copy paste this code to your checkout page. If needed change the value option.</p></div></div>';

       echo '<div class="link_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Sample Flow URL:</label></div><div class="col-6"><pre>' . get_permalink($post->ID) . '?email=test@test.com&name=John&price=67.22</pre>
       <p class="description">This is just a sample flow call URL. Please replace the variable names and values with your own.</p></div></div>';

       echo '<div class="code_sample_box meta-container" style=""><div class="label col-2 left"><label for="general_optin-url" class="optin-label">Sample Flow Function Call:</label></div><div class="col-6"><pre>lfp_ecommerce_flow(' . $post->ID . ', array(\'email\' => \'test@test.com\', \'price\' => 13));</pre>
       <p class="description">This is just a sample flow function call. Please replace the variable names (array keys) and values with your own.</p></div></div>';

       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'SPAM / DDoS Protection:', 'general', 'spam-protection', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'spam-protection', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'SPAM protection prevents bots and harmfull users from submitting the flow multiple times and filling your DB with garbage. Please note that this does NOT protect you from users submitting arbitrary garbage data. Open <a href="' . admin_url('admin.php?page=leadflow-settings#0') . '">settings</a> to fine tune this option.', '', array('default' => '1'));
       echo $field_generator->end_row();
     } // ecommerce


     if ($flow_type == 'form') {
       echo $field_generator->start_row();
       echo $field_generator->generate('label', 'SPAM / DDoS Protection:', 'general', 'spam-protection', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'spam-protection', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'SPAM protection prevents bots and harmfull users from submitting the form multiple times and filling your DB with garbage. Please note that this does NOT protect you from users submitting arbitrary garbage data. Open <a href="' . admin_url('admin.php?page=leadflow-settings') . '">settings</a> to fine tune this option.', '', array('default' => '1'));
       echo $field_generator->end_row();
     } // form


     if ($flow_type == 'internal') {
       // should never get here
     } // internal
   } // content
 } // leadflow_flow_general_settings