<?php
/*
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

 class leadflow_optin_form extends leadflow {
   public static function content() {
     global $wpdb, $post;

     $options = get_option(LF_OPTIONS, array());
     $field_generator = new leadflow_field_generator();
     $optin_type = leadflow_optin_common::get_optin_type();

     $mail_list_service = array('local' => 'Local database');
     $mail_list_service['customurl'] = 'Custom HTML Form';

     // Get all lead flows
     $flow_lists = array('0' => '- None -');
     $flows = get_posts(array('post_type' => 'lead-flows', 
                              'posts_per_page' => -1, 
                              'meta_key' => 'flow_type', 
                              'meta_value' => 'internal', 
                              'order'=> 'ASC', 
                              'orderby' => 'title', 
                              'post_status' => 'publish'));
     if ($flows) {
       foreach ($flows as $flow) {
         $flow_lists[$flow->ID] = $flow->post_title;
       }
     }
     
     $form_fields = array('name-email' => 'Name and email', 'email' => 'Email Only');

     $meta = get_post_meta($post->ID, LF_META, true);
     if (!$meta) {
       $meta = array();
     }
     
     $options = get_option(LF_OPTIONS);
     $lists = get_option(LF_OPTIN_LISTS, array());

     $redirect_l = false;
     $alert_l = false;
     $prevent_l = false;

     if (isset($meta['form']['after-subscribe-action']) && $meta['form']['after-subscribe-action'] == 'redirect') {
       $redirect_l = true;
     } else if(isset($meta['form']['after-subscribe-action']) && $meta['form']['after-subscribe-action'] == 'stay-alert') {
       $alert_l = true;
     } else {
       $redirect_l = true;
     }

     if (isset($meta['form']['prevent-from-leaving']) && $meta['form']['prevent-from-leaving'] == 'yes') {
       $prevent_l = true;
     }
     
     $after_subscriber_actions = array('redirect' => 'Redirect to URL', 'stay-alert' => 'Stay on page with alert');
     if ($optin_type == 'header' || $optin_type == 'pullout' || $optin_type == 'popup' || $optin_type == 'welcome' ) {
       $after_subscriber_actions['hide'] = 'Hide Optin';
     }
     
     $locked_pages = array('0' => '- Select URL to open -', 'custom-url' => 'Custom URL');
     $get_locked_pages = get_posts(array('post_type' => 'page', 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'DESC'));
     if ($get_locked_pages) {
       foreach ($get_locked_pages as $locked_page) {
         $locked = get_post_meta($locked_page->ID, '_lf_lock', true);
         if (!empty($locked) && $locked['lock'] == '1') {
           $locked_pages[$locked_page->ID] = $locked_page->post_title . ' (page locked by LFP)';
         } else {
           $locked_pages[$locked_page->ID] = $locked_page->post_title . ' (page)';
         }
       } 
     }
     
     $get_locked_posts = get_posts(array('post_type' => 'post', 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'DESC'));
     if ($get_locked_posts) {
       foreach ($get_locked_posts as $locked_post) {
         $locked = get_post_meta($locked_post->ID, '_lf_lock', true);
         if (!empty($locked) && $locked['lock'] == '1') {
           $locked_pages[$locked_post->ID] = $locked_post->post_title . ' (post locked by LFP)';
         } else {
           $locked_pages[$locked_post->ID] = $locked_post->post_title . ' (post)';
         }
       } 
     }
     

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Push Through internal Flow:', 'form', 'push-through-flow', '', '', '', true, '', '', array('columns' => 'col-12'));
     echo $field_generator->generate('dropdown', '', 'form', 'push-through-flow', $flow_lists, '', '', '', 'Select the flow through which you wish to push this user.', '', array('columns' => 'col-12'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'After Subscribe Action:', 'form', 'after-subscribe-action', '', '', '', true, '', '', array('columns' => 'col-12'));
     echo $field_generator->generate('dropdown', '', 'form', 'after-subscribe-action', $after_subscriber_actions, '', '', '', 'What should happen after user subscribes?', '', array('columns' => 'col-12', 'default' => 'stay-alert'));
     echo $field_generator->end_row();

     echo $field_generator->start_row('redirect', $redirect_l);
     echo $field_generator->generate('label', 'Redirect URL:', 'form', 'after-subscribe-url', '', '', '', true, '', '', array('columns' => 'col-12'));
     echo $field_generator->generate('dropdown', '', 'form', 'after-subscribe-url', $locked_pages, '', '', '', 'Please select the URL you wish to use.', '', array('columns' => 'col-12'));
     echo $field_generator->end_row();
     
     if ($meta['form']['after-subscribe-url'] == 'custom-url') {
       echo '<div class="lf-after-subscribe-custom-url">';
     } else {
       echo '<div class="lf-after-subscribe-custom-url" style="display:none;">';
     }
     echo $field_generator->start_row('redirect-custom-url', $redirect_l);
     echo $field_generator->generate('label', 'Custom URL:', 'form', 'redirect-custom-url', '', '', '', true, '', '', array('columns' => 'col-12'));
     echo $field_generator->generate('input', '', 'form', 'redirect-custom-url', '', '', '', '', 'Please insert full url path including http://....', '', array('columns' => 'col-12'));
     echo $field_generator->end_row();
     echo '</div>';

     echo $field_generator->start_row('stay-alert', $alert_l);
     echo $field_generator->generate('label', 'Alert Message:', 'form', 'after-subscribe-alert-message', '', '', '', true, '', '', array('columns' => 'col-12'));
     echo $field_generator->generate('input', '', 'form', 'after-subscribe-alert-message', '', '', '', '', 'Message is shown as a standard JavaScript alert.', '', array('columns' => 'col-12', 'default' => 'Thank you for subscribing!', 'style' => 'width: 100%;'));
     echo $field_generator->end_row();
   } // content

 } // leadflow_form_box