<?php
/*
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_general_settings extends leadflow {
  static function content() {
    global $post, $wpdb;
    $optin_type = leadflow_optin_common::get_optin_type();
    $field_generator = new leadflow_field_generator();
	
     // A/B Tests
     global $wpdb;
     $tests = leadflow_ab_test_common::get_ab_tests(array('type' => $optin_type, 
                                                          'order_by' => 'name', 
                                                          'order' => 'ASC'));
                                                          
     $tests_array = array();
     $tests_array[0] = '- None -';
     if ($tests) {
       foreach ($tests as $test) {
         $tests_array[$test->ID] = $test->post_title;
       }
     }
    
	$optin_meta = get_post_meta($post->ID, LF_META, true);
	if(isset($optin_meta['general']) && isset($optin_meta['general']['google-fonts']) && is_array($optin_meta['general']['google-fonts'])) {
		$selected_fonts = $optin_meta['general']['google-fonts'];
	} else {
		$selected_fonts = array();
	}
	
	
	$google_fonts = self::load_google_fonts();  
	$fonts_array=array();
	
	echo "<script>";
	echo "var font_style = {";
	
	foreach($google_fonts as $slug=>$font){
		$fonts_array[$slug]=$font['name'];
		echo $slug.":\"font-family:'".$font['name']."', ".$font['fallback'].";\",";
	}
	echo "};";
	echo "</script>";
	$fonts_array_page_load=array_slice($fonts_array,0,20);
	
	//Check that fonts selected for user are in the onload array, if not add them
	foreach($selected_fonts as $selectedfont){
		if(!array_key_exists($selectedfont, $fonts_array_page_load)){
			$fonts_array_page_load[$selectedfont]=$fonts_array[$selectedfont];
		}
	}
	
	echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Google Fonts:', 'general', 'grid', '1170px', '', '', true, '', '');
	echo $field_generator->generate('dropdown', '', 'general', 'google-fonts', $fonts_array_page_load, '', true, false, 'Select Fonts you would like to load', '', array('multiple' => true, 'data-placeholder' => 'Choose fonts'));
    echo $field_generator->end_row();
	
	?>
    
    <style>
	#general_google-fonts{
		display:none;
	}
	</style>
    
    <script>
	
	<?php 
	
	
	
	echo "var data = [";
	foreach($fonts_array_page_load as $slug=>$font){
		echo "{ id: '".$slug."', text: '".$font."' },";	
	}
	echo "{ id:999,text:'Load All Fonts'}];";
	
	echo "var data_all = [";
	foreach($fonts_array as $slug=>$font){
		echo "{ id: '".$slug."', text: '".$font."' },";	
	}
	echo "];";
	
	
	?>
		
	jQuery(document).ready(function(e) {      
		var formatResult = function(result) {
			if(result.text == 'Searching…'){
				return result.text;
			} else if(result.id == 999){
				return jQuery("<span style='color:#61a038; font-size:20px; font-weight:bold; text-align:center;'><i data-fip-value='icon-eye' class='icon-eye'></i>Load All Front Previews</span>");
			} else {
				return jQuery("<img src='<?php echo LF_PLUGIN_URL; ?>/images/google_fonts/"+result.id+".jpeg' />");
			}
		  }
  
    	var google_fonts_select2 = jQuery("#general_google-fonts").lf_select2({
			data:data,
			templateResult: formatResult
		});
		
		jQuery("#general_google-fonts").on("select2:select", function (e) { 
			if(e.params.data.id == 999 ) {
				load_all_fonts();
			}
			display_available_styles();			
		});
		
		function load_all_fonts(){
			google_fonts_select2.lf_select2("destroy");
			var selected_fonts=google_fonts_select2.val();
			selected_fonts.splice(selected_fonts.indexOf("999"), 1);
			google_fonts_select2.val(selected_fonts);
			google_fonts_select2 = jQuery("#general_google-fonts").lf_select2({
				data:data_all,
				templateResult: formatResult
			});
			jQuery("#general_google-fonts option[value='999']").remove();
			google_fonts_select2.lf_select2("open");
			
		}
		
		function display_available_styles(){
			var available_styles=google_fonts_select2.val();
			
			var available_styles_html='';
			if( available_styles && available_styles.length>0){
				available_styles_html="<strong>Google font families available:</strong><br />";
				for (s in available_styles){
					available_styles_html+=font_style[available_styles[s]]+"<br />";	
				}
				available_styles_html+="<br />";
			}
			jQuery('#available_font_families').html(available_styles_html);
		}
		display_available_styles();
	});
	</script>
    <?php
		 
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Optin width:', 'general', 'width', '500px', '', '', true, '', '');
    echo $field_generator->generate('input', '', 'general', 'width', '', '', '', '', 'Set your default optin width in pixels (example: 320px).', '', array('default' => '100%'));
    echo $field_generator->end_row();
    
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Content width:', 'general', 'grid', '1170px', '', '', true, '', '');
    echo $field_generator->generate('input', '', 'general', 'grid', '', '', '', '', 'Set your default optin content width in pixels (example: 920px or 1170px or any other value...).', '', array('default' => '960px'));
    echo $field_generator->end_row();

    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'A/B Test:', 'general', '_ab-test', '', '', '', true, '', '');
    echo $field_generator->generate('dropdown', '', 'general', '_ab-test', $tests_array, '', '', '', 'Each OptIn can belong to a single test. You can only test OptIns of the same type in a single A/B test. If you change the Test while people are using it stats will no longer be relative. <a href="edit.php?post_type=leadflow-abtests">Manage A/B Tests</a>', true);
    echo $field_generator->end_row();
	
    echo $field_generator->start_row();
    echo $field_generator->generate('label', 'Custom CSS Code:', 'general', 'css-code', '', '', true, true, '','');
    echo $field_generator->generate('textarea', '', 'optin-general', 'css-code', '', '', true, false, '<div id="available_font_families"></div>Write only the CSS code, do not include &lt;style&gt; tags.<br /><span style="color:#F00;">Prepend each ruleset with #lf-optin-'.$post->ID.'</span>', '');
    echo $field_generator->end_row();
	
	echo "<div style='display:none;'>";
	wp_editor('','lfp_hidden_field');
	echo "</div>";
    
    if ($optin_type == 'standalone') {
      echo $field_generator->start_row();
      echo $field_generator->generate('label', 'Prevent from leaving:', 'general', 'prevent-from-leaving', '', '', '', true, '', '');
      echo $field_generator->generate('dropdown', '', 'general', 'prevent-from-leaving', array('0' => 'Disabled', '1' => 'Enabled'), '', true, false, 'Alert message will be shown when user\'s mouse gesture suggest that he is leaving the page by moving the cursor to the upper part of the screen in order to close the tab/window. This does not block users from closing the tab/window.', '');
      echo $field_generator->end_row();
      
      echo $field_generator->start_row('prevent-alert');
      echo $field_generator->generate('label', 'Prevent from leaving message:', 'general', 'prevent-alert-message', '', '', '', true, '', '');
      echo $field_generator->generate('input', '', 'general', 'prevent-alert-message', '', '', '','', 'Text which will appear for prevent from leaving message.');
      echo $field_generator->end_row();
      
      echo $field_generator->start_row();
       echo $field_generator->generate('label', 'Custom URL:', 'general', 'custom-url', '', '', '', true, '', '');
       echo $field_generator->generate('dropdown', '', 'general', 'custom_url', array('1' => 'Enabled', '0' => 'Disabled'), '', true, false, 'If the default URL (' . get_permalink($post->ID) . ') doesn\'t suite your needs you can define a custom one by enabling this option and entering an URL below.', '', array('default' => '0'));
       echo $field_generator->end_row();
       
       echo $field_generator->start_row('custom_url_box');
       echo $field_generator->generate('label', '', 'general', 'optin-custom-url', '', '', true, '', '', '');
       echo $field_generator->generate('input', 'Custom URL', 'general', 'optin-custom-url', '', '', '','', 'URL has to start and end with a forward slash -  "/". Multiple flows and/or OptIns can\'t share the same URL and if more than one are defined on the same one whichever was defined first will be the one to get loaded.', true, array('class' => 'normal-text code', '_before_field' => home_url()));
       
	   ?>
       
       <script>
	   <?php 	   
	   echo 'var custom_urls_in_use=JSON.parse(\''.json_encode( leadflow_common::custom_url_print_all_urls_as_js() ).'\');'."\r\n";   
	   echo 'var current_post_id='.$post->ID.';';
	   ?>
	   
	   var custom_urls_in_use_html = '';
	   function check_url_exists(value){
		   custom_urls_in_use_html = '';
		   for(i in custom_urls_in_use){
			   if( i != current_post_id && custom_urls_in_use[i].url == value.replace(/[^a-z0-9-]+/gi, '')){
				   custom_urls_in_use_html = 'This URL is already in use by <a href="'+custom_urls_in_use[i].permalink+'">'+custom_urls_in_use[i].title+'</a>'; 
			   }
		   }
		   jQuery('#custom_url_in_use').html(custom_urls_in_use_html);
	   }
	   
	   jQuery('#general_optin-custom-url').on('change', function(){
		  check_url_exists(jQuery('#general_optin-custom-url').val()); 
	   });
	   
	   jQuery('#general_optin-custom-url').on('keyup', function(){
		  check_url_exists(jQuery('#general_optin-custom-url').val()); 
	   });
	   
	   </script>
       
       <?php
	   
       $custom_url_used = leadflow_common::custom_url_usage_check($post->ID, 'optin');
       if (!empty($custom_url_used)) {
         echo '<div class="lf-error-label" id="custom_url_in_use">This URL is already in use by another ' . $custom_url_used['type'] . '.  <br/>' . $custom_url_used['found'] . '</div>';
       } else {
		 echo '<div class="lf-error-label" id="custom_url_in_use"></div>';  
	   }
       
       echo $field_generator->end_row();

      echo $field_generator->start_row();
      echo $field_generator->generate('label', 'Custom HTML Head Code:', 'general', 'head-code', '', '', true, true, '','');
      echo $field_generator->generate('textarea', '', 'general', 'head-code', '', '', true, false, 'This code gets inserted at the end of the HTML\'s &lt;head&gt; tag so you can place any custom JS in it. Don\'t forget &lt;script&gt; or &lt;style&gt; tags.<br>
        Copy/paste the complete tracking code for Google Analytics here (&lt;script&gt; and everything).', '');
      echo $field_generator->end_row();
	  
	  
    } // if standalone
  } // content
} // leadflow_optin_general_settings