<?php
/*
 * LeadsFlow
 * (c) Web factory Ltd, 2015
 */

 class leadflow_optin_second_optin extends leadflow {

   static function content() {
     global $post;

     $field_generator = new leadflow_field_generator();
     $optin_type = leadflow_optin_common::get_optin_type();

     $border_radius = array();
     for($i=0;$i<=30;$i++) {
       $border_radius[$i] = $i . ' px';
     }

     $font_size = array();
     for($i=0;$i<=30;$i++) {
       $font_size[$i] = $i . ' px';
     }

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Disable Second Content Box:', 'second-optin', 'disable-second-optin', '', '', '', true, '', '', array());
     echo $field_generator->generate('dropdown', '', 'second-optin', 'disable-second-optin', array('0' => 'No', '1' => 'Yes'), '', true, false, 'If disabled users will immediately see the second content box. Stats for an OptIn page will not bo correct if you use it for some time with and then some time without the first box. Clone the OptIn page and then enable/disable the first box in order to keep the stats relevant.', '');
     echo $field_generator->end_row();

     $meta = get_post_meta($post->ID, LF_META, true);

     if (!empty($meta['second-optin']['disable-second-optin']) && $meta['second-optin']['disable-second-optin'] == '1') {
       echo '<div class="lf-second-box-options" style="display:none;">';
     } else {
       echo '<div class="lf-second-box-options">';
     }

     // Background Cover
     $background_cover = array('none' => 'Image width & height', 'cover' => 'Full page cover', 'contain' => 'Contain image within box');

     // Background Position
     $background_position = array('left-top' => 'Left Top', 'left-center' => 'Left Center', 'left-bottom' => 'Left Bottom', 'right-top' => 'Right Top', 'right-center' => 'Right Center', 'right-bottom' => 'Right Bottom', 'center-top' => 'Center Top', 'center-center' => 'Center', 'center-bottom' => 'Center Bottom');

     // Background Repeat
     $background_repeat = array('repeat' => 'Repeat X/Y', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y', 'no-repeat' => 'No Repeat');


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Box Background Color:', 'second-optin', 'box-background-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-background-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#f2f2f2'));
     echo $field_generator->generate('label', 'Box Shadow Color:', 'second-optin', 'box-shadow-color', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('colorpicker', '', 'second-optin', 'box-shadow-color', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '#f2f2f2'));

     echo $field_generator->end_row();


     echo $field_generator->start_row();

     echo $field_generator->generate('label', 'Background Opacity:', 'second-optin', 'bg-opacity', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('input', '', 'second-optin', 'bg-opacity', '', '', '', '', '', '', array('columns' => 'col-2', 'default' => '1', 'class' => 'small-text'));
     echo $field_generator->end_row();


     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Position:', 'second-optin', 'background-position', '', '', true, '', '', '', array());
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-position', $background_position, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Cover:', 'second-optin', 'background-cover', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-cover', $background_cover, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('label', 'Background Repeat:', 'second-optin', 'background-repeat', '', '', true, '', '', '', array('columns' => 'col-2'));
     echo $field_generator->generate('dropdown', '', 'second-optin', 'background-repeat', $background_repeat, '', '', '', '', '', array('columns' => 'col-2'));
     echo $field_generator->end_row();

     echo $field_generator->start_row();
     echo $field_generator->generate('label', 'Background Image:', 'second-optin', 'background-image', '', '', true, true);
     echo $field_generator->generate('upload', 'Upload background', 'second-optin', 'background-image', '', '', false, false, '', '', array('default' => ''));
     echo $field_generator->end_row();

     // ------------------
     echo '<hr/>';
     echo '<br/>';

     echo '<div class="lf-optin-layout-preview">';

     echo '<h2 style="margin:0 0 15px 0px;">Optin Layout</h2>';
     echo '<ol class="row optin-layout" id="second-optin-layout">';

     // Fetch saved widgets for this optin
     $rows = get_post_meta($post->ID, 'optin_widget_second_optin', true);

     $default_row_settings = array('width' => 'col-lg-12', 'background_color' => '#eeeeee', 'background_image' => '');

     if (!empty($rows)) {
       foreach ($rows as $k => $row) {

         $settings = $row['settings'];
         $settings = array_merge($default_row_settings, $settings);

         echo '<li class="row ' . $settings['width'] . '" data-optin-widget-id="' . $k . '" data-optin-widget-type="row">';
         echo '<div class="lf-outer">';
         echo '<input type="hidden" name="optin_row[second_optin][' . $k . ']" class="row_id" value="' . $k . '" />';
         echo '<input type="hidden" name="optin_row[second_optin][' . $k .'][settings][width]" id="" value="' . $settings['width'] . '" />';

         echo '<div class="header">';
         echo '<a href="#" class="move_row ui-sortable-handle"><i class="dashicons dashicons-menu"></i></a>';
         echo '<div class="actions">';
         echo '<a href="#" class="edit_row"><i class="dashicons dashicons-edit"></i></a>';
         echo '<a href="#" class="remove_row"><i class="dashicons dashicons-trash"></i></a>';
         echo '</div>';
         echo '</div>';
         echo '</div>';

         // Row Settings
         echo '<div class="row-outer-container">';
         echo '<div class="row-inner-container">';

         echo '<div class="row-ic-header">Row <a href="#" class="lf-row-settings-close"><i class="dashicons dashicons-dismiss"></i></a></div>';
         echo '<div class="row-ic-inner">';
         
         // Columns
         /*
         echo '<div class="lf-widget-setting">';
         echo '<label>Columns:</label>';
         echo '<input name="optin_row[second_optin][' . $k . '][settings][columns]" class="row-columns" type="text" value="' . $settings['columns'] . '" data-old-value="' . $settings['columns'] . '" />';
         echo '</div>';
         */
         
         // Force full width
         echo '<div class="lf-widget-setting">';
         echo '<label>Full Width:</label>';
         if (!empty($settings['full_width'])) {
           echo '<input name="optin_row[second_optin][' . $k . '][settings][full_width]" type="checkbox" value="1" checked="checked" />';
         } else {
           echo '<input name="optin_row[second_optin][' . $k . '][settings][full_width]" type="checkbox" value="1" />';
         }
         echo '</div>';

         // Background Color
         echo '<div class="lf-widget-setting">';
         echo '<label>Background Color:</label>';
         echo '<input name="optin_row[second_optin][' . $k . '][settings][background_color]" type="text" class="colorpicker" value="' . $settings['background_color'] . '" data-old-value="' . $settings['background_color'] . '" data-default-color="#ffffff" />';
         echo '</div>';

         // Background Image
         echo '<div class="lf-widget-setting">';
         echo '<label>Background Image:</label>';
         echo '<div class="bg-input-holder">';
         echo '<div class="bg-input">';
         echo '<input type="text" value="' . $settings['background_image'] . '" data-old-value="' . $settings['background_image'] . '" class="regular-text process_custom_images" name="optin_row[second_optin][' . $k .'][settings][background_image]" />';
         echo '<button class="set_custom_images button">Select image</button>';
         echo '</div>';
         echo '</div>';
         echo '</div>';

         echo '<hr/>';
         echo '<div class="text-right">
               <a href="#" class="row-inner-close button button-primary">Save &amp; Close</a>
               <a href="#" class="row-inner-cancel button button-secondary">Cancel</a>
               </div>';
         echo '</div>';

         echo '</div>';
         echo '</div>';
         // Row Settings End
         echo '<ol>';
         if (!empty($row['widgets'])) {
           foreach ($row['widgets'] as $widget) {
             $widget['container_id'] = $k;
             echo leadflow_optin_admin_common::generate_widget('second_optin', $widget);
           }
         }
         echo '</ol>';
         echo '<div class="no-widgets-msg"><a href="#" class="lf-add-widget" data-row-id="' . $k . '">Click to add new widgets.</a></div>';
         echo '</li>';
       }
      }

     echo '<li class="no-widgets-msg add-new-row not-sortable mjs-nestedSortable-no-nesting"><a href="#" class="lf-add-row">Click to add new rows.</a></li>';
     echo '</ol>';

     // Available Widgets Dialog
     echo '<div class="widgets-dialog-outer-container" style="display:none;">';
     echo '<input type="hidden" name="connect_to_row" value=""/>';
     echo '<div class="widgets-dialog-inner-container">';
     echo '<div class="widgets-dialog-header">Available Widgets - Click to insert <a href="#" class="lf-widget-type-close"><i class="dashicons dashicons-dismiss"></i></a></div>';
     echo '<div class="widgets-dialog-inner">';

     echo '<div class="lf-optin-layout-widgets">';

     echo '<ul class="optin-available-widgets" id="second-optin-widgets" data-connected-to="second-optin-layout" data-optin-box="second_optin">';

     $widgets = leadflow_optin_admin_common::$widgets;
     unset($widgets['next-button']);
     if ($optin_type != 'welcome') {
       unset($widgets['scroll-down']);
     }

     if (!empty($widgets)) {
       asort($widgets);
       foreach ($widgets as $widget_key => $widget_name) {
         echo '<li data-widget-type="' . $widget_key . '">';
         echo '<a href="#" class="add-to-layout">';
         echo '<div class="lf-widget-overlay"><i class="dashicons dashicons-plus-alt"></i></div>';
         echo '<img src="' . LF_PLUGIN_URL . '/images/widget-icons/' . $widget_key . '.png" />';
         echo '<div><b>' . $widget_name . '</b></div>';
         echo '</a>';
         echo '</li>';
       }
     }


     echo '</ul>';
     echo '</div>';
     echo '</div>';
     echo '</div>'; // widgets-dialog-outer-container

     echo '</div>';
     echo '</div>';
     echo '</div>';
     echo '<div class="clear"></div>';
   } // content

   static function generate_widget_ajax() {
     extract($_POST);

     $output = leadflow_optin_admin_common::generate_widget('second_optin', array('id' => $id, 'container_id' => $container_id, 'type' => $widget_type, 'settings' => array()));

     wp_send_json_success($output);
   } // generate_widget_ajax

 } // leadflow_second_optin