<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

global $optin_ID, $post;
$optin_css_ID = 'lf-optin-header-' . $optin_ID;
$optin_generic_ID = 'lf-optin-' . $optin_ID;

// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];
$options = $meta['header'];

// Optin Width
if (isset($meta['general']['width'])) {
	$options['width'] = rtrim($meta['general']['width'], 'px') . 'px';
} else {
	$options['width'] = '500px';
}

// Optin Width
if (isset($meta['general']['width'])) {
	$options['width'] = rtrim($meta['general']['width'], 'px') . 'px';
} else {
	$options['width'] = '500px';
}

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
	$skin = $meta['general']['skin'];
}


if(isset($meta['background']['bg-image'])){
  $background="background-image:url(".$meta['background']['bg-image']."); background-position:".$meta['background']['bg-position'].";";
} else if(isset($meta['background']['bg-color'])) {
  $background = "background-color:".$meta['background']['bg-color'].";";
} else {
  $background = "background:transparent;";
}


// Get Optin - for post title
$optin = get_post($optin_ID);

// Count Statistics - Always visible
leadflow_stats::optin_add_view($optin_ID, 'box1');

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}
?>

<div id="<?php echo $optin_generic_ID; ?>" style=" <?php echo $background; ?>" class="lf-optin-main-container lf-optin-header <?php echo 'lf-optin-header-' . $options['position']; ?> <?php echo $skin; ?> <?php echo $optin_css_ID; ?> <?php echo $optin_generic_ID; ?>" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $optin->post_title; ?>" data-optin-id="<?php echo $optin_ID; ?>">
<form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
<div class="lf-optin-container" style="width:<?php echo $options['width']; ?>;">

  <div class="lf-optin-box box-border-radius box-background-color first-optin">
  <div class="lf-optin-box-inner">

    <?php
    // First Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);
    
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $row_css = '';
        if ($settings['background_color'] != '') {
          $row_css = 'background-color:' . $settings['background_color'] . ';';
        }
        
        if (!empty($settings['background_image'])) {
          $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
    ?>
  </div>
  </div>
<?php
  if (empty($meta['second-optin']['disable-second-optin'])) {
?>
  <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display: none;">
  <div class="lf-optin-box-inner">

    <?php
    // Second Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $background_color = '';
        if ($settings['background_color'] != '') {
          $background_color = 'background-color:' . $settings['background_color'] . ';';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
		?>

  </div>
  </div>
  <?php } ?>
  </div>
</form>
</div>
