/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

// required for file upload - global
var files;

jQuery(document).ready(function($){

  var ga_tracked = false;
  var captcha_validated = false;
  //   
  $('#fileupload').on('change', function(event){
    files = event.target.files;
    upload_file();
  });

  // form submit
  $('.ajax-subscribe').submit(function(){
    var optin = $(this);
	
	if (validate_fields(optin)) {
      begin_submit(optin);
      fields = $('input, textarea, select', optin).serialize();
      $.ajax({
        timeout: 3000,
        url:optin_vars.ajaxurl,
        method: 'POST',
        data: {action:'lf_optin_subscribe', 'fields': fields, post_id: optin_vars.postID}})
      .done(function(response){
        if(response.success){
		  if(response.data == 3){
		    alert('You are already subscribed.');
		  } else {
			exit_optin(optin);
		  }
		} else {
		  if(response.data == 'invalid_captcha'){
		    alert('Incorrect captcha value');
			jQuery('#captcha').addClass('error');
		  }
		}
      })
      .fail(function(response) {
        end_submit(optin);
        alert('An undocumented error has occured. Please reload the page and try again.');
      })
      .always(function() {
        end_submit(optin);
      });
    }

    return false;
  });


  if (typeof fitVids != 'undefined') {
    $(".lf-optin-box-inner").fitVids();
  }


  $('.btn-submit').click(function(){
    var optin = $(this).parents('form');
    $(optin).trigger('submit');

    return false;
  });


  // Next Optin
  $('.next-optin').click(function(){
    var optin = $(this).parents('form');

    $('.first-optin', optin).fadeOut(500, function(){
      //center_box(2, optin);
      $('.second-optin', optin).fadeIn(500, function() {
        $.post(optin_vars.ajaxurl, {action: 'lf_optin_step2_stats', post:optin_vars.postID},
          function (response) {
            if (!ga_tracked) {
              var ga_tracked = true;
              ga_track('Show Box #2', optin);
            }
        });
      });
    });
    return false;
  });


  // Prev Optin
  $('.prev-optin').click(function(){
    var optin = $(this).parents('form');

    $('.second-optin', optin).fadeOut(500, function(){
      //center_box(2, optin);
      $('.first-optin', optin).fadeIn(500, function() {
      });
    });
    return false;
  });

});

function ga_track(event_name, optin) {

  if (optin) {
    optin_title = jQuery(optin).data('post-title');
  } else {
    optin_title = optin_vars.post_title;
  }

  if (typeof _gaq != 'undefined') {
    _gaq.push(['_trackEvent', 'OptIn Pages', event_name, optin_title]);
  }
  if (typeof ga != 'undefined') {
    ga('send', 'event', 'OptIn Pages', event_name, optin_title);
  }
} // track_ga


function exit_optin(optin) {

  if (!jQuery(optin).hasClass('lf-optin-main-container')) {
    optin = jQuery(optin).parents('.lf-optin-main-container');
  }

  action = jQuery(optin).data('after-subscriber-action');
  message = jQuery(optin).data('after-subscriber-message');
  url = jQuery(optin).data('after-subscriber-url');

  if (action == 'hide') {
	jQuery('#lf-optin-'+jQuery(optin).data('optin-id')).hide();
    if (message) {
      jQuery('body').css('padding-top', '');
      alert(message);
    }
  }

  if (action == 'stay-alert' && message) {
    alert(message);
  }

  if (action == 'redirect' && url) {
    window.top.location.href = url;
  }

  ga_track('Subscribed', optin);
  subscribed = true;
} // exit_optin


// Validate Form Fields
function validate_fields(optin) {

  error = false;
  emailfilter = /^\w+[\+\.\w-]*@([\w-]+\.)*\w+[\w-]*\.([a-z]{2,4}|\d+)$/i

  captcha_input = jQuery('input[name="lf-captcha-input"]', optin).val();
  captcha_exists = 'false';
  if (jQuery('input[name="lf-captcha-input"]', optin).length) {
    captcha_exists = 'true';
  }

  if ( typeof jQuery(optin).data('optin-id') !== 'undefined' && jQuery(optin).data('optin-id') > 0) {
    optin_ID = jQuery(optin).data('optin-id');
  } else {
    optin_ID = optin_vars.postID;
  }

  
  // Reset optin fields (remove error markers)
  jQuery('textarea, input[type=text], input[type=email], input[type=checkbox], select', optin).removeClass('error');
  // Pass through each field
  jQuery('textarea, input[type=text], input[type=email], input[type=checkbox], select', optin).each(function(ind, el) {
    if (jQuery(el).data('required')) {
      if (jQuery(el).attr('type') == 'checkbox') {
        val = jQuery(el).is(':checked');
      } else {
        val = jQuery(el).val();
      }

      if(!val) {
        error = true;
        jQuery(el).addClass('error');
      }

      if(jQuery(el).attr('name') == 'email' && (val.length < 6 || emailfilter.test(val) == false)) {
        error = true;
        jQuery(el).addClass('error');
      }
    }
  });

  if (error) {
    return false;
  } else {
    return true;
  }
} // validate_fields


function begin_submit(optin) {
  jQuery('.btn-submit', optin).html('Please wait ...');
  jQuery('.btn-submit', optin).addClass('loading').addClass('disabled');
  jQuery('.btn-submit', optin).attr('disabled', 'disabled');
}


function end_submit(optin) {
  jQuery('.btn-submit', optin).html(jQuery('.btn-submit').attr('data-default-value'));
  jQuery('.btn-submit', optin).removeClass('loading').removeClass('disabled');
  jQuery('.btn-submit', optin).removeAttr('disabled');
}

function optin_loaded(optin) {

  if (!optin) {
    optin = optin_vars.postID;
  } 

  jQuery.ajax({
    url:optin_vars.ajaxurl,
    type:'POST',
    data: {action:'lf_optin_step1_stats', post:optin}})
  .done(function(response){
    // Counted
  })
  .fail(function(){
    // Not counter
  });
}

function upload_file() {
  // START A LOADING SPINNER HERE
  jQuery('.upload-spinner').show();
  jQuery('#fileupload').hide();
  
  var data = new FormData();
  data.append(jQuery('#fileupload').attr('name'), jQuery('#fileupload').prop('files')[0]);
  // append other variables to data if you want: data.append('field_name_x', field_value_x);

  jQuery.ajax({
    type: 'POST',               
    processData: false, // important
    contentType: false, // important
    data: data,
    url: optin_vars.ajaxurl + '?action=lf_upload_file',
    dataType : 'json'
  }).done(function(response){
    // All done
  }).fail(function(response){
    // Error
    alert('Sorry, the file has not been uploaded. We don\'t accept specified file type.');
  }).always(function(response){
    // Always
    jQuery('.upload-spinner').hide();  
    jQuery('#fileupload').show();  
  }); 

}