<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

global $optin_ID, $post;

$popup_ID = 'lf-optin-popup-' . $optin_ID;
$optin_generic_ID = 'lf-optin-' . $optin_ID;


// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

$toggle_popup = $meta['popup']['optin_toggle_popup'];

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
  $skin = $meta['general']['skin'];
}

// Optin Width
if (isset($meta['general']['width'])) {
  $optin_width = $meta['general']['width'];
  
  if (strpos($optin_width, 'px')) {
    $meta['general']['width'] = rtrim($optin_width, 'px');'px';
    $meta['general']['width'] = (int) $optin_width . 'px';
  } else {
    $meta['general']['width'] = rtrim($optin_width, '%');'%';
    $meta['general']['width'] = (int) $optin_width . '%';
  }
  
} else {
    $meta['general']['width'] = '500px';
}


// Get Optin - for post title
$optin = get_post($optin_ID);

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}
?>
<div id="<?php echo $optin_generic_ID; ?>" class="lf-optin-overlay <?php echo $popup_ID; ?> <?php echo $optin_generic_ID; ?>">
<div class="lf-optin-main-container lf-optin-popup <?php echo $skin; ?> <?php echo $popup_ID . '-inner'; ?>" style="width:<?php echo $meta['general']['width']; ?>;" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $optin->post_title; ?>" data-optin-id="<?php echo $optin_ID; ?>">
<form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
  
  <?php if (!empty($toggle_popup) && $toggle_popup == '1') { /* ?>
  <a href="#" class="lf-popup-close"><i class="dashicons dashicons-dismiss"></i></a>
  <?php */ }  ?>
  
  <div class="lf-optin-container">

    <div class="lf-optin-box box-border-radius box-background-color first-optin">
      <div class="lf-optin-box-inner">

        <?php
        // First Optin widgets start here
        $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);

        if ($rows) {
          foreach ($rows as $row_id => $row) {
            $settings = $row['settings'];

            $row_css = '';
            if ($settings['background_color'] != '') {
              $row_css = 'background-color:' . $settings['background_color'] . ';';
            }

            if (!empty($settings['background_image'])) {
              $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover; background-position:top center;';
            }

            echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
            if (!empty($row['widgets'])) {
              foreach ($row['widgets'] as $k => $widget) {
                echo leadflow_optin_frontend_common::generate_widget($widget);
              }
            } else {
			  echo '<div class="lf-widget-row lf-widget-empty-row">Add widgets to your optin in the optin editor</div>';
		    }
            echo '</div>';
          }
        } else {
			echo '<div class="lf-widget-row lf-widget-empty-row">Add widgets to your optin in the optin editor</div>';
		}
        ?>
      </div>
    </div>
    <?php
    if (empty($meta['second-optin']['disable-second-optin'])) {
    ?>
    <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display: none;">
      <div class="lf-optin-box-inner">

        <?php
        // Second Optin widgets start here
        $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
        if ($rows) {
          foreach ($rows as $row_id => $row) {
            $settings = $row['settings'];

            $background_color = '';
            if ($settings['background_color'] != '') {
              $background_color = 'background-color:' . $settings['background_color'] . ';';
            }

            echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
            if (!empty($row['widgets'])) {
              foreach ($row['widgets'] as $k => $widget) {
                echo leadflow_optin_frontend_common::generate_widget($widget);
              }
            }
            echo '</div>';
          }
        }
        ?>

      </div>
    </div>
    <?php } ?>
  </div>
</form>
</div>
</div>

<script type="text/javascript">
  jQuery(window).resize(function(){
    var $ = jQuery.noConflict();
    
    $('.<?php echo $popup_ID; ?> .lf-optin-popup').position({ 
            my: '<?php echo $meta['popup']['position']; ?>', 
            at: '<?php echo $meta['popup']['position']; ?>', 
            of: window });
  });
  
  jQuery(document).ready(function($){
    
    $('.<?php echo $popup_ID; ?> .lf-optin-popup').position({ 
            my: '<?php echo $meta['popup']['position']; ?>', 
            at: '<?php echo $meta['popup']['position']; ?>', 
            of: window });

    <?php if (!empty($meta['popup']['on_inactivity'])) { ?>
      $(document).idle({
        onIdle: function(){
          $('.<?php echo $popup_ID; ?>').position({ 
            my: '<?php echo $meta['popup']['position']; ?>', 
            at: '<?php echo $meta['popup']['position']; ?>', 
            of: window });
            $('.lf-optin-overlay.<?php echo $popup_ID; ?>').show();
          optin_loaded('<?php echo $optin_ID; ?>');
        },
        idle: <?php echo $meta['popup']['on_inactivity']; ?>
      });
    <?php } ?>

    <?php 

	if($meta['popup']['on_pageload'] != 0){
	?>
      setTimeout(function() {
        $('.<?php echo $popup_ID; ?> ').show();
		
		$('.<?php echo $popup_ID; ?> .lf-optin-popup').position({ 
            my: '<?php echo $meta['popup']['position']; ?>', 
            at: '<?php echo $meta['popup']['position']; ?>', 
            of: window });
		  
        optin_loaded('<?php echo $optin_ID; ?>');
        }, <?php echo $meta['popup']['on_pageload']; ?>);
    <?php } ?>
    
    <?php if (!empty($meta['popup']['in_view'])) { ?>
      
     jQuery('<?php echo $meta['popup']['in_view']; ?>').bind("inview", function(event, visible) {
        var lf_optin_view_<?php echo $optin_ID; ?> = false;
        if (!lf_optin_view_<?php echo $optin_ID; ?>) {
          var lf_optin_view_<?php echo $optin_ID; ?> = true;
          $('.<?php echo $popup_ID; ?>').position({ my: '<?php echo $meta['popup']['position']; ?>', at: '<?php echo $meta['popup']['position']; ?>', of: window }).show();
        }
     });
    <?php } ?>
    
    <?php if ($meta['popup']['on_exit_intent']) { ?>

      ouibounce(false, 
        { aggressive: true, 
          timer: 2, 
          callback: function() { 
            $('.<?php echo $popup_ID; ?>').position({ 
          my: '<?php echo $meta['popup']['position']; ?>', 
          at: '<?php echo $meta['popup']['position']; ?>', 
          of: window }).show();
          } 
      });
    <?php } ?>

    <?php
    // Prevent From Leaving without Subscribing
    echo leadflow_optin_common::prevent_from_leaving();
    ?>
    
    <?php if (!empty($toggle_popup) && $toggle_popup == '1') { ?>
   	$('.lf-optin-overlay').mouseup(function (e)
		{
			var container = $('.<?php echo $popup_ID; ?>-inner');
		
			if (!container.is(e.target) 
				&& container.has(e.target).length === 0) 
			{
				$('.lf-optin-overlay').hide();
			}
		});
    
	$(document).keydown(function(e) {
		if (e.keyCode == 27) {
			$('.<?php echo $popup_ID; ?>, .lf-optin-overlay').hide();
		}
	});

    $('.lf-popup-close').on('click', function(e){
      e.preventDefault();
      $('.<?php echo $popup_ID; ?>, .lf-optin-overlay').hide();
    });
    <?php } ?>
  }); // ready
</script>