<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

if (!function_exists('get_header')) {
  die();
}

header('Access-Control-Allow-Origin: ' . get_http_origin());
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
header('Access-Control-Allow-Credentials: true');

global $post;

if (empty($_GET['preview-post-id'])) {
  wp_die('Unkown optin ID for preview.');
}


$post_ID = $_GET['preview-post-id'];
$post = get_post($post_ID);

// Fetch current optin meta
$meta = get_post_meta($post->ID, LF_META, true);
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
  $skin = $meta['general']['skin'];
}

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}
?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
  <!--<![endif]-->
  <head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <title><?php the_title(); ?></title>
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php
    // Add wp_head to attach enqueues
    wp_head();
    ?>

    <?php
    /* first box */
    echo leadflow_optin_frontend_common::generate_css($post->ID, true);

    $settings = $meta['second-optin'];
    
    // Button Text
    if (isset($settings['button-font-size']) && $settings['button-font-size'] != '') {
      echo '<link href="//fonts.googleapis.com/css?family=' . $settings['button-font'] . ':400,300,300italic,400italic,600,600italic,700,700italic,800,800italic" rel="stylesheet" type="text/css">' . "\r\n";
      echo '<style type="text/css">';
      echo '.first-optin .btn {' . "\r\n";
      echo 'font-family:"' . str_replace('+', ' ', $settings['button-font']) . '", sans-serif;' . "\r\n";
      echo '}' . "\r\n";
      echo '</style>';
    } // if ($settings['button-font-size'] != '')

    $settings = $meta['second-optin'];
    // Button Text
    if (isset($settings['button-font-size']) && $settings['button-font-size'] != '') {
      echo '<link href="//fonts.googleapis.com/css?family=' . $settings['button-font'] . ':400,300,300italic,400italic,600,600italic,700,700italic,800,800italic" rel="stylesheet" type="text/css">' . "\r\n";
      echo '<style type="text/css">';
      echo '.second-optin .btn {' . "\r\n";
      echo 'font-family:"' . str_replace('+', ' ', $settings['button-font']) . '", sans-serif;' . "\r\n";
      echo '}' . "\r\n";
      echo '</style>';
    } // if ($settings['button-font-size'] != '')

    if (isset($meta['general']['head-code']) && $meta['general']['head-code'] != '') {
      echo $meta['general']['head-code'];
    }

    ?>
  </head>
  <body>
  
    <div class="lf-optin-main-container" id="optin-preview-container" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $post->post_title; ?>" data-optin-id="<?php echo $post->ID; ?>">
      <form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
        <div class="lf-optin-container <?php echo $skin; ?>">

            <div class="lf-optin-box box-border-radius box-background-color first-optin">
              <div class="lf-optin-box-inner">

                <?php
                // First Optin widgets start here
                $rows = get_post_meta($post->ID, 'optin_widget_first_optin', true);

                if ($rows) {
                  foreach ($rows as $row_id => $row) {
                    $settings = $row['settings'];

                    $row_css = '';
                    if ($settings['background_color'] != '') {
                      $row_css = 'background-color:' . $settings['background_color'] . ';';
                    }

                    if (!empty($settings['background_image'])) {
                      $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
                    }

                    echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
                    if (!empty($row['widgets'])) {
                      foreach ($row['widgets'] as $k => $widget) {
                        echo leadflow_optin_frontend_common::generate_widget($widget);
                      }
                    }
                    echo '</div>';
                  }
                }
                ?>
              </div>
            </div>
            <?php
            if (empty($meta['second-optin']['disable-second-optin'])) {
            ?>
            <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display: none;">
            <div class="lf-optin-box-inner">

            <?php
            // Second Optin widgets start here
            $rows = get_post_meta($post->ID, 'optin_widget_second_optin', true);
            if ($rows) {
              foreach ($rows as $row_id => $row) {
                $settings = $row['settings'];

                $background_color = '';
                if ($settings['background_color'] != '') {
                  $background_color = 'background-color:' . $settings['background_color'] . ';';
                }

                echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
                if (!empty($row['widgets'])) {
                  foreach ($row['widgets'] as $k => $widget) {
                    echo leadflow_optin_frontend_common::generate_widget($widget);
                  }
                }
                echo '</div>';
              }
            }
            ?>

          </div>
            </div>
          <?php } ?>
        </div>
      </form>
    </div>
    <?php
    leadflow_optin_enqueues::clean_footer();
    wp_footer();
    ?>
    <script type="text/javascript">
      var subscribed = false;
      jQuery(document).ready(function($){

        <?php
        // Prevent From Leaving without Subscribing
        echo leadflow_optin_common::prevent_from_leaving();
        ?>
      }); // onload
    </script>
  </body>
</html>