<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

global $optin_ID, $post;

$popup_ID = 'lf-optin-pullout-' . $optin_ID;
$optin_generic_ID = 'lf-optin-' . $optin_ID;


// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$options = $meta['pullout'];
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

// Backgound color
if (empty($meta['background']['bg-color'])) {
  $bg_color = 'transparent';
} else {
  $bg_color = $meta['background']['bg-color'];
}

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
  $skin = $meta['general']['skin'];
}

// Optin Width
if (isset($meta['general']['width'])) {
  $optin_width = $meta['general']['width'];
  
  if (strpos($optin_width, 'px')) {
    $meta['general']['width'] = rtrim($optin_width, 'px');'px';
    $meta['general']['width'] = (int) $optin_width . 'px';
  } else {
    $meta['general']['width'] = rtrim($optin_width, '%');'%';
    $meta['general']['width'] = (int) $optin_width . '%';
  }
  
} else {
    $meta['general']['width'] = '500px';
}


// Get Optin - for post title
$optin = get_post($optin_ID);

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}

// Pullout Tab Settings
$pullout_tab_bg = '';
if (!empty($options['tab-background-color'])) {
  $pullout_tab_bg = 'style="background-color:' . $options['tab-background-color'] . ';"';
}

$pullout_icon_color = '';
if (!empty($options['tab-icon-color'])) {
  $pullout_icon_color = 'style="color:' . $options['tab-icon-color'] . ';"';
}

?>

<div  id="<?php echo $optin_generic_ID; ?>" class="lf-optin-main-container lf-optin-pullout <?php echo $skin; ?> <?php echo $optin_ID; ?> <?php echo 'lf-optin-pullout-' . $meta['pullout']['position']; ?>" style="width:<?php echo $meta['general']['width']; ?>;background-color:<?php echo $bg_color; ?>;" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $optin->post_title; ?>" data-optin-id="<?php echo $optin_ID; ?>">

  <div class="lf-optin-pullout-trigger" <?php echo $pullout_tab_bg; ?>><a href="#" <?php echo $pullout_icon_color; ?>><i class="icon icon-plus"></i></a></div>

  <form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
  <div class="lf-optin-container">

    <div class="lf-optin-box box-border-radius box-background-color first-optin">
      <div class="lf-optin-box-inner">

        <?php
        // First Optin widgets start here
        $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);

        if ($rows) {
          foreach ($rows as $row_id => $row) {
            $settings = $row['settings'];

            $row_css = '';
            if ($settings['background_color'] != '') {
              $row_css = 'background-color:' . $settings['background_color'] . ';';
            }

            if (!empty($settings['background_image'])) {
              $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
            }
			
			
			if (!empty($settings['box-shadow-color'])) {
              $row_css.= 'box-shadow: 0px 2px 8px 0px '.$settings['box-shadow-color'].';';
            }
			

            echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
            if (!empty($row['widgets'])) {
              foreach ($row['widgets'] as $k => $widget) {
                echo leadflow_optin_frontend_common::generate_widget($widget);
              }
            }
            echo '</div>';
          }
        }
        ?>
      </div>
    </div>
      <?php
      if (empty($meta['second-optin']['disable-second-optin'])) {
      ?>
      <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display:none;">
      <div class="lf-optin-box-inner">

        <?php
        // Second Optin widgets start here
        $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
        if ($rows) {
          foreach ($rows as $row_id => $row) {
            $settings = $row['settings'];

            $background_color = '';
            if ($settings['background_color'] != '') {
              $background_color = 'background-color:' . $settings['background_color'] . ';';
            }

            echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
            if (!empty($row['widgets'])) {
              foreach ($row['widgets'] as $k => $widget) {
                echo leadflow_optin_frontend_common::generate_widget($widget);
              }
            }
            echo '</div>';
          }
        }
        ?>

      </div>
      </div>
      <?php } ?>
</div>
</form>
</div>
<script type="text/javascript">
  jQuery(document).ready(function($){

    var pullout = $('.<?php echo $optin_ID; ?>');
    var width = $(pullout).width();
    var height = $(pullout).height();

    <?php 
    $pullout_position = $options['position'];
    ?>
    pullout_<?php echo $pullout_position;?>('.<?php echo $optin_ID; ?>');

    <?php if (!empty($options['on_inactivity'])) { ?>
      $(document).idle({
        onIdle: function(){
          // Then Display
          if (!pullout_visible('.<?php echo $optin_ID; ?>', '<?php echo $pullout_position;?>')) {
            pullout_trigger('.<?php echo $optin_ID; ?>', '<?php echo $pullout_position;?>');
            optin_loaded('<?php echo $optin_ID; ?>');
          }
        },
        idle: <?php echo $options['on_inactivity']; ?>
      });
    <?php } ?>

    <?php 
	if($options['on_pageload'] != 0){
	?>
      setTimeout(function() {
        // Then Display
        if (!pullout_visible('.<?php echo $optin_ID; ?>', '<?php echo $pullout_position;?>')) {
          pullout_trigger('.<?php echo $optin_ID; ?>', '<?php echo $pullout_position;?>');
          optin_loaded('<?php echo $optin_ID; ?>');
        }
        }, <?php echo $options['on_pageload']; ?>);
    <?php } ?>
	
	
    <?php if ($options['on_exit_intent']) { ?>

      ouibounce(false, 
        { aggressive: true, 
          timer: 2, 
          callback: function() { 
            pullout_trigger('.<?php echo $optin_ID; ?>', '<?php echo $pullout_position;?>');
            optin_loaded('<?php echo $optin_ID; ?>');
          } 
      });
    <?php } ?>

    <?php
    // Prevent From Leaving without Subscribing
    echo leadflow_optin_common::prevent_from_leaving();
    ?>

  });
</script>