<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

global $optin_ID, $post, $preview_optin;


// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

// Optin Width
if (isset($meta['general']['width'])) {
  $optin_width = $meta['general']['width'];
  
  if (strpos($optin_width, 'px')) {
    $meta['general']['width'] = rtrim($optin_width, 'px');'px';
    $meta['general']['width'] = (int) $optin_width . 'px';
  } else {
    $meta['general']['width'] = rtrim($optin_width, '%');'%';
    $meta['general']['width'] = (int) $optin_width . '%';
  }
  
} else {
    $meta['general']['width'] = '500px';
}

// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
	$skin = $meta['general']['skin'];
}

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}


if(isset($preview_optin)){
	echo '<div class="lf-optin-preview-message-shortcode">If you want to see this shortcode optin in the context of actual content please insert the shortcode <strong>[optin_shortcode id="'.$optin_ID.'"]</strong> where you would like it to appear and preview that page/post.</div>';	
}

?>

<div id="<?php echo 'lf-optin-' . $optin_ID; ?>" class="lf-optin-main-container lf-optin-shortcode <?php echo $skin; ?>" style="width:<?php echo $meta['general']['width']; ?>;" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $post->post_title; ?>" data-optin-id="<?php echo $post->ID; ?>">
<form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
<div class="lf-optin-container">

  <div class="lf-optin-box box-border-radius box-background-color first-optin">
  <div class="lf-optin-box-inner">

    <?php
    // First Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);
    
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $row_css = '';
        if ($settings['background_color'] != '') {
          $row_css = 'background-color:' . $settings['background_color'] . ';';
        }
        
        if (!empty($settings['background_image'])) {
          $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
    ?>
  </div>
  </div>
  <?php
  if (empty($meta['second-optin']['disable-second-optin'])) {
  ?>
  <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display:none;">
  <div class="lf-optin-box-inner">

    <?php
    // Second Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $background_color = '';
        if ($settings['background_color'] != '') {
          $background_color = 'background-color:' . $settings['background_color'] . ';';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
    ?>

  </div>
  </div>
  <?php } ?>
  </div>
</form>
<script type="text/javascript">
	jQuery(document).ready(function(e) {
        optin_loaded(<?php echo $optin_ID; ?>);
    });
</script>
</div>
