<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

global $optin_ID, $post;


// Fetch current optin meta
$meta = get_post_meta($optin_ID, LF_META, true);
$options = $meta['welcome'];

// Optin Width
if (isset($meta['general']['width'])) {
  $optin_width = $meta['general']['width'];
  
  if (strpos($optin_width, 'px')) {
    $meta['general']['width'] = rtrim($optin_width, 'px');'px';
    $meta['general']['width'] = (int) $optin_width . 'px';
  } else {
    $meta['general']['width'] = rtrim($optin_width, '%');'%';
    $meta['general']['width'] = (int) $optin_width . '%';
  }
  
} else {
    $meta['general']['width'] = '500px';
}

// Backgound color
if (isset($meta['background']['bg-color'])) {
  $bg_color = 'background-color:'.$meta['background']['bg-color'].';';
} else {
  $bg_color = '';
}


if (isset($meta['background']['bg-image'])) {
  $bg_image = 'background-image:('.$meta['background']['bg-image'].');';
} else {
  $bg_image = '';
}

if (isset($meta['background']['bg-cover'])) {
  $bg_cover = 'background-size:'.$meta['background']['bg-cover'].';';
} else {
  $bg_cover = '';
}


// Setup optin skin
$skin = '';
if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
	$skin = $meta['general']['skin'];
}

$meta['second-optin']['disable-second-optin'] = (int) @$meta['second-optin']['disable-second-optin'];

// Force various enqueues
// leadflow_optin_enqueues::conditional_header_enqueues('true');

// Get Optin - for post title
$optin = get_post($optin_ID);

$after_subscribe_url = '';
if (!empty($meta['form']['after-subscribe-url']) && ctype_digit($meta['form']['after-subscribe-url'])) {
  $after_subscribe_url = get_permalink($meta['form']['after-subscribe-url']);
} elseif ($meta['form']['after-subscribe-url'] == 'custom-url' && !empty($meta['form']['redirect-custom-url'])) {
  $after_subscribe_url = $meta['form']['redirect-custom-url'];
}
?>

<div id="lf-optin-<?php echo $optin_ID; ?>" class="lf-optin-main-container lf-optin-welcome <?php echo @$options['position']; ?>" style=" <?php echo $bg_color.$bg_image.$bg_cover; ?> visibility:hidden;" data-after-subscriber-action="<?php echo $meta['form']['after-subscribe-action']; ?>" data-after-subscriber-message="<?php echo $meta['form']['after-subscribe-alert-message']; ?>" data-after-subscriber-url="<?php echo $after_subscribe_url; ?>" data-post-title="<?php echo $optin->post_title; ?>" data-optin-id="<?php echo $optin_ID; ?>">
<form method="post" action="#" class="ajax-subscribe" enctype="multipart/form-data">
<div class="lf-optin-container" style="width:<?php echo $meta['general']['width']; ?>;">

  <div class="lf-optin-box box-border-radius box-background-color first-optin">
  <div class="lf-optin-box-inner">

    <?php
    // First Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_first_optin', true);
    
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $row_css = '';
        if ($settings['background_color'] != '') {
          $row_css = 'background-color:' . $settings['background_color'] . ';';
        }
        
        if (!empty($settings['background_image'])) {
          $row_css = 'background-image:url(' . $settings['background_image'] . ');background-size:cover;';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $row_css . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
    ?>
  </div>
  </div>
  <?php
  if (empty($meta['second-optin']['disable-second-optin'])) {
  ?>
  <div class="lf-optin-box box-border-radius box-background-color second-optin" style="display: none;">
  <div class="lf-optin-box-inner">

    <?php
    // Second Optin widgets start here
    $rows = get_post_meta($optin_ID, 'optin_widget_second_optin', true);
    if ($rows) {
      foreach ($rows as $row_id => $row) {
        $settings = $row['settings'];
        
        $background_color = '';
        if ($settings['background_color'] != '') {
          $background_color = 'background-color:' . $settings['background_color'] . ';';
        }
        
        echo '<div class="lf-widget-row ' . $settings['width'] . '" style="' . $background_color . '">';
        if (!empty($row['widgets'])) {
          foreach ($row['widgets'] as $k => $widget) {
            echo leadflow_optin_frontend_common::generate_widget($widget);
          }
        }
        echo '</div>';
      }
    }
    ?>

  </div>
  </div>
  <?php } ?>
  </div>
</form>
</div>
<script type="text/javascript">
jQuery(document).ready(function($){
  
  <?php 
  $automatic_welcome = $meta['welcome']['optin_auto_welcome'];
  if ($automatic_welcome) {
    $automatic_welcome = 'true';
  } else {
    $automatic_welcome = 'false';
  }
  ?>
  var automatic_welcome = '<?php echo $automatic_welcome; ?>';
  
  // Welcome on Idle
  if (automatic_welcome == 'true' && $('.lf-optin-welcome').length) {
    <?php
    if ($options['on_inactivity'] != '0') {
    ?>
      $(document).idle({
        onIdle: function(){
          // First setup the height to fill the window
          //welcome_optin_setup();
          // Then Display
		  
		  display_welcome_optin($('.lf-optin-welcome'));
        },
        idle: <?php echo $options['on_inactivity']; ?>
      });
    <?php 
    }
    ?>

    <?php
    if($options['on_pageload'] != 0){
    ?>
      setTimeout(function() {
        // First setup the height to fill the window
        //welcome_optin_setup();
        // Then Display	
		display_welcome_optin($('.lf-optin-welcome'));
      }, <?php echo $options['on_pageload']; ?>);
    <?php } ?>
    
    $('.lf-scroll-down').on('click', function(e){
      e.preventDefault();
      var parent = $(this).parents('.lf-optin-welcome');
	  $('html,body').animate({scrollTop:$(parent).height()}, 500);
      return false;
    });
    
  }
  
  <?php
  if ($meta['welcome']['on_exit_intent']) {
  ?>
  
  ouibounce(false, 
    { aggressive: true, 
      timer: 2, 
      callback: function() { 
        welcome_optin_setup();
        // Then Display
        display_welcome_optin($('.lf-optin-welcome'));
      } 
    });
  <?php
  }
  ?>
  
});
</script>