/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

jQuery(document).ready(function($){

  $('.optin-welcome').on('click', function(e){
    e.preventDefault();
    optin_id = $(this).data('optin-id');
    optin = $('.lf-optin-' + optin_id);
    if ($(optin).length) {
      
      display_welcome_optin(optin);
    }
  });

});

function display_welcome_optin(optin) {
  if (optin == '') {
    optin = jQuery('.lf-optin-welcome');
  }
  
  welcome_optin_setup();
  
  if (!jQuery(optin).data('shown') || jQuery(optin).data('shown') == '' || typeof jQuery(optin).data('shown') == 'undefined') {
    jQuery(optin).attr('data-shown', 'true').hide().slideDown(500, function() {
		optin_loaded(jQuery(optin).attr('id').replace('lf-optin-',''));
    });
  }
  
  
} // display_welcome_optin

function welcome_optin_setup() {  
  // Welcome Optin
  var optin_welcome = jQuery('.lf-optin-welcome');

  jQuery('body').addClass('lf-body-optin-welcome');
  window_height = jQuery(window).height();
  
  jQuery(optin_welcome).css('height', window_height);
  jQuery('body').attr('style','padding-top:' + window_height + 'px !important');

  form_height = jQuery('form', optin_welcome).height();
  jQuery('form', optin_welcome).attr('style','margin-top:-' + (form_height/2) + 'px !important;');
  
  jQuery(optin_welcome).css('visibility','visible').prependTo('body');
  
  jQuery("html,body").animate({ scrollTop: 0 }, 500);	
}