<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_ab_tests extends leadflow {
   // complete a/b test page markup
   static function content() {
	   
     $tests = leadflow_ab_test_common::get_all();

     settings_errors('optin');
     echo '<div class="wrap">';
     echo '<h2>OptIn Pages A/B Tests</h2><br>';

     echo '<div id="dialog-ab-shortcode"></div>';

     // Col Right Start
     echo '<div id="col-right">';
     echo '<div class="col-wrap">';

     echo '<table class="wp-list-table widefat fixed">';
     echo '<thead>';
     echo '<tr>';
     echo '<th>Name</th>';
     echo '<th>Type</th>';
     echo '<th>URL</th>';
     echo '<th style="width: 120px;">OptIn Pages</th>';
     echo '<th style="width: 120px;">Unique Views</th>';
     echo '<th>Conversion rate</th>';
     echo '<th>Created</th>';
     echo '<th>&nbsp;</th>';
     echo '</tr>';
     echo '</thead>';

     echo '<tbody>';

     if ($tests) {
       $i = 0;
       foreach ($tests as $test) {
		   
         $test_stats = leadflow_stats::get_ab_test_stats($test['id'], 2);
         
		 $ids = '';
         $tmp = get_posts(array('post_type' => 'optin-pages', 'meta_key' => '_ab-test', 'meta_value' => $test['slug'], 'post_status' => 'publish'));
         
		 $ab_test_details = leadflow_ab_test_common::get_details($ab_test_id);
		 $ab_test_ids=explode(',',$ab_test_details['ids']);
		 $optins_stats=array();
		 $optin_views=array();
		 foreach($ab_test_ids as $optin_id){
			 $optins_stats[$optin_id] = leadflow_stats::get_optin_stats($optin_id, 2);
			 $optin_views[$optin_id]=number_format($optins_stats[$optin_id]['views']);
		 }
		 
		 foreach ($tmp as $tmp2) {
           $ids .= $tmp2->ID . ',';
         }
         $ids = trim($ids, ',');
         
         if (!$test_stats['conversion_rate'] || $test_stats['conversion_rate'] == '0.0') {
           $conversion = '0%';
         } else {
           $conversion = $test_stats['conversion_rate'] . '% (24h: ' . leadflow_common::trend_number_format($test_stats['trend_conversions']) . ')';
         }
         
         if (current_time('timestamp') - strtotime($test['created']) > DAY_IN_SECONDS * 2) {
           $time = date(get_option('date_format'), strtotime($test['created']));
         } else {
           $time = human_time_diff(strtotime($test['created']), current_time('timestamp')) . ' ago';
         }
         
         $i++;
         if ($i % 2) {
          echo '<tr class="alternate">';
         } else {
           echo '<tr>';
         }
         echo '<td>' . $test['name'] . '</td>';
         echo '<td>';
         if ($test['optin_type']) {
           echo '<img width="24" src="' . LF_PLUGIN_URL . '/images/optin_types/small/' . $test['optin_type'] . '.png" alt="' . leadflow_optin_type::$types[$test['optin_type']] . '" title="'. leadflow_optin_type::$types[$test['optin_type']] . '">';
         } else {
           echo 'Unknown';
         }
         echo '</td>';
         echo '<td><a href="' . home_url() . $test['slug'] . '" target="_blank">' . $test['slug'] . ' </a></td>';
         if ($ids) {
           echo '<td>' . sizeof($tmp) . ' (<a title="View pages in this test" href="edit.php?post_type=optin-pages&id_filter=' . $ids .'">view</a>)</td>';
         } else {
           echo '<td>0</td>';
         }
         echo '<td>';
		 
		 echo 'Views'.implode('/',$optin_views);
		 
		 echo $test_stats['views'] . ' (<a href="edit.php?post_type=optin-pages&page=leadflow-stats&stats-test=' . $test['slug'] . '">details</a>)</td>';
         echo '<td>' . $conversion . '</td>';
         echo '<td>' . $time . '</td>';
         echo '<td><a class="button button-secondary optin-ab-shortcode" href="#" data-ab-id="' . $test['id'] . '" data-ab-href="' . $test['slug'] . '">View shortcode</a>&nbsp; <a class="button button-delete optin-del-ab" href="admin.php?action=optin_ab_tests&action_do=delete&test-id=' . $test['id'] . '">Delete</a></td>';
         echo '</tr>';
       } // foreach test
     }

     echo '</tbody>';
     echo '</table>';
     echo '<div class="tablenav bottom optin-bottom"><span class="displaying-num">' . sizeof($tests) . ' item' . (sizeof($tests) == 1? '': 's') . '</span></div>';

     if (!$tests) {
       echo '<p>No A/B tests found. Use the form on the left to create new ones.</p>';
     }

     echo '</div>';
     echo '</div>';
     // Col Right End

     // Col Left Start
     echo '<div id="col-left">';
     echo '<div class="col-wrap">';

     echo '<form method="post" action="admin.php?action=optin_ab_tests">';
     echo '<div class="form-wrap">';
     echo '<h3>Add new A/B test</h3>';
     echo '<div class="form-field">
           <label for="tag-name">Name:</label>
           <input type="text" size="40" value="" id="tag-name" name="tag-name">
           <p>This is just for easier handling in the admin; it\'s not shown anywhere public.</p>
           </div>';
     echo '<div class="form-field">
           <label for="tag-url">URL:</label>
           <span style="display: inline-block;">' . home_url() . '</span>
           <input type="text" size="40" value="" id="tag-url" name="tag-url" style="display: inline-block;width:50%;" />
           <p>Please note that this slug will override any other WP objects on that URL. So if you leave it blank your homepage will open that A/B test. Slashes will be automatically added to the beginning and the end of the slug as needed.</p>
           </div>';
     
     echo '<div class="form-field">
           <label for="optin_type">Type:</label>
           <select id="optin_type" name="optin_type" xstyle="display: inline-block;width:50%;">';
     leadflow_common::create_select_options(leadflow_optin_type::$types, 'none', true);
     echo '</select>';
     echo '<p>All OptIn pages in a test must be of the same type. When editing an OptIn you\'ll only see A/B Tests the same type as that OptIn.</p>
           </div>';

     echo '<p class="submit"><input type="submit" value="Add New A/B Test" class="button button-primary" id="submit" name="submit"></p><br>';

          echo '<p><b>Notes:</b><br>OptIn pages are added to A/B tests in the OptIn edit screen. Each OptIn can be assigned to only one test and they will be randomly shown to users on a per-session basis.<br>
          In order to perserve the continuity of A/B Tests and their statistics, tests can\'t be edited, only deleted and recreated.<br>
          Deleting an A/B Test does not delete the OptIn pages that are associated with it.</p>';

     echo '</form>';
     echo '</div>';
     echo '</div>';
     echo '</div>';
     // Col Left End

     echo '</div>';
   } // content
} // lf_optin_options_ab_tests