<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_settings extends leadflow {
  static $defaults = array('api_key' => '', 'api_access' => 0, 'optin_preview_page' => '', 'optin_pages_url' => 'optin', 'ab_pages_url' => 'ab-test', 'lead_flows_url' => 'flow', 'ban_request_time' => 2, 'ban_request_cnt' => 10, 'ban_time' => 60, 'memory_limit' => 0);
  static $pro_apis = array('php','mysql','zapier');
  
  static function save_settings() {
    if (!empty($_POST['lf_settings'])) {
      $new = $_POST['lf_settings'];

      $options = get_option(LF_OPTIONS, array());
      $options = array_merge(self::$defaults, $options);

      $options['api_access'] = $new['api_access'];

      if ($new['api_access'] && empty($options['api_key'])) {
          $options['api_key'] = strtoupper(substr(md5(time() . 'monkey'), 0, 16));
      } elseif(!$new['api_access']) {
        $options['api_key'] = '';
      }

      $options['optin_preview_page'] = $new['optin_preview_page'];
      $options['optin_pages_url'] = sanitize_title($new['optin_pages_url']);
      $options['lead_flows_url'] = sanitize_title($new['lead_flows_url']);
      $options['ab_pages_url'] = sanitize_title($new['ab_pages_url']);

      if (empty($options['optin_pages_url'])) {
        $options['optin_pages_url'] = $defaults['optin_pages_url'];
      }
      if (empty($options['lead_flows_url']) || $options['lead_flows_url'] == $options['optin_pages_url']) {
        $options['lead_flows_url'] = $defaults['lead_flows_url'];
      }

      if ($new['optin_pages_url'] != $options['optin_pages_url'] || $new['lead_flows_url'] != $options['lead_flows_url'] || $new['ab_pages_url'] != $options['ab_pages_url']) {
        update_option('lf_flush_rewrite', false);
      }

      $options['ban_request_time'] = abs((int) $new['ban_request_time']);
      $options['ban_request_cnt'] = abs((int) $new['ban_request_cnt']);
      $options['ban_time'] = abs((int) $new['ban_time']);
      $options['memory_limit'] = $new['memory_limit'];

      update_option(LF_OPTIONS, $options);
      add_settings_error('leadflow', 'leadflow-saved', 'Settings saved.', 'updated');
    }
  } // save_options

  // complete options page markup
  static function content() {
    self::save_settings();
    settings_errors();

    $settings = get_option(LF_OPTIONS, array());
    $settings = array_merge(self::$defaults, $settings);

    echo '<div class="wrap">';
    echo '<h2>LeadsFlow Pro Settings</h2><br>';

    $tabs = array('general' => 'General', 'api_services' => 'API Services', 'mobile' => 'Mobile Access', 'geoip' => 'GeoIP', 'optin-templates' => 'OptIn Templates', 'miscellaneous' => 'Miscellaneous');

    echo '<div id="lf-settings-tabs">';
    echo '<h2 class="nav-tab-wrapper">';
    echo '<ul class="nav-tab-wrapper">';
    foreach($tabs as $tab => $name){
      echo "<li class='nav-tab'><a href='#$tab'>$name</a></li>";
    }
    echo '</ul>';
    echo '</h2>';

    echo '<form id="optin_options" action="admin.php?page=leadflow-settings" method="post">';
    echo '<div class="container">';

    // general
    echo '<div id="general" style="display: none;">';
    echo '<table class="form-table">';
    echo '<tbody>';
    echo '<tr>
    <th scope="row"><label for="optin_preview_page">OptIn Preview Page</label></th>
    <td><select name="lf_settings[optin_preview_page]" id="optin_preview_page">';

    $preview_pages = array();
    $preview_pages[0] = '- None -';

    $pages = get_posts(array('post_type' => 'page', 'posts_per_page' => -1, 'order' => 'ASC', 'orderby' => 'title'));
    if ($pages) {
      foreach ($pages as $page) {
        $preview_pages[$page->ID] = $page->post_title;
      }
    }
    leadflow_common::create_select_options($preview_pages, $settings['optin_preview_page'], true);
    echo '</select>';
    echo '<p class="description">This page is used to preview all OptIn Pages. We recommend setting it to a regular page with a sidebar and at least a few paragraphs of content.<br>You can keep the page as a draft so that visitors can\'t access it.</p></td></tr>';

    echo '<tr>
           <th scope="row"><label for="optin_pages_url">OptIn Pages URL Prefix</label></th>
           <td><input name="lf_settings[optin_pages_url]" type="text" id="optin_pages_url" value="' . $settings['optin_pages_url'] . '"><p class="description">Each OptIn page can have an additional, completely custom URL. The URL with the following format is automatically assigned to all OptIns: ' . home_url() . '/' . $settings['optin_pages_url'] . '/optin-name/<br>Default setting: optin.</p></td>
           </tr>';

    echo '<tr>
           <th scope="row"><label for="lead_flows_url">Lead Flows URL Prefix</label></th>
           <td><input name="lf_settings[lead_flows_url]" type="text" id="lead_flows_url" value="' . $settings['lead_flows_url'] . '"><p class="description">Each Flow can have an additional, completely custom URL. The URL with the following format is automatically assigned to all Flows: ' . home_url() . '/' . $settings['lead_flows_url'] . '/flow-name/<br>Default setting: flow.</p></td>
           </tr>';

    echo '<tr>
           <th scope="row"><label for="ab_pages_url">A/B Tests URL Prefix</label></th>
           <td><input name="lf_settings[ab_pages_url]" type="text" id="ab_pages_url" value="' . $settings['ab_pages_url'] . '"><p class="description">Each A/B Test can have an additional, completely custom URL. The URL with the following format is automatically assigned to all Tests: ' . home_url() . '/' . $settings['ab_pages_url'] . '/ab-test-name/<br>Default setting: ab-test.</p></td>
           </tr>';

    echo '<tr>
           <th scope="row"><label for="ban_request_cnt">SPAM Protection</label></th>
           <td>If a user accesses a flow more than <input step="1" class="small-text" min="1" name="lf_settings[ban_request_cnt]" type="number" id="ban_request_cnt" value="' . $settings['ban_request_cnt'] . '"> times in a period of <input step="1" class="small-text" min="1" name="lf_settings[ban_request_time]" type="number" id="ban_request_time" value="' . $settings['ban_request_time'] . '"> minutes ban him for <input step="1" class="small-text" min="1" name="lf_settings[ban_time]" type="number" id="ban_time" value="' . $settings['ban_time'] . '"> minutes<p class="description">SPAM protection can be enabled or disabled on a per-flow basis. Logged in admin users are never affected by SPAM protection. Default settings: 10, 2, 60.<br>';
    if (sizeof(get_option('lf_banned_ips', array()))) {
      echo 'At the moment ' . sizeof(get_option('lf_banned_ips', array())) . ' IPs are banned.</span></td></tr>';
    } else {
      echo 'At the moment no IPs are banned.</p></td></tr>';
    }

    if (substr(WP_MAX_MEMORY_LIMIT, -1) == 'M') {
      $tmp = WP_MAX_MEMORY_LIMIT . 'B';
    } else {
      $tmp = WP_MAX_MEMORY_LIMIT;
    }
    $memory_limits = array('0' => 'Use default WordPress setting of ' . $tmp, '64M' => '64MB', '128M' => '128MB', '196M' => '196MB', '256M' => '256MB', '512M' => '512MB', '1024M' => '1024MB');

    echo '<tr>
    <th scope="row"><label for="memory_limt">PHP Memory Limit</label></th>
    <td><select name="lf_settings[memory_limit]" id="memory_limit">';
    leadflow_common::create_select_options($memory_limits, $settings['memory_limit']);
    echo '</select><p class="description">Do not change this setting unless you run into "memory exhausted" related problems.<br>Current limit: ' . ini_get('memory_limit') . 'B. Please refresh the page after saving the new value for it to take effect.</p></td></tr>';

    echo '</tbody>';
    echo '</table>';
    self::save_button();
    echo '</div>';

    // misc
    echo '<div id="miscellaneous" style="display: none;">';
    echo '<table class="form-table">';
    echo '<tbody>';
    echo '<tr>
    <th class="top-align" scope="row">
    <input type="button" id="lf-reset-stats" class="button button-secondary button-delete" value="Reset all statistics">
    </th>
    <td>
    <p class="description">This will erase all OptIn, A/B Test, Flow, Subscribers and other statistics. There is no undo!</p>
    </td>
    </tr>';
    echo '<tr>
    <th class="top-align" scope="row">
    <input type="button" id="lf-delete-temp" class="button button-secondary button-delete" value="Delete all cache">
    </th>
    <td>
    <p class="description">Recent events, FullContact data, catched JVZoo transactions - everything will be deleted. JVZoo transactions will be processed again and you may get duplicate transactions. There is NO undo!</p>
    </td>
    </tr>';
    echo '</tbody>';
    echo '</table>';
    echo '</div>';


    // API services
    echo '<div id="api_services" style="display: none;">';

    echo '<div id="settings_services_container_active">';

    echo '<h3>Active Services</h3>';
    self::generate_services('active');
    echo '</div>';

    echo '<div id="settings_services_container_inactive">';
    echo '<h3>Inactive Services</h3>';
    self::generate_services('inactive');

    echo '</div>'; // settings_services_container

    echo '<div class="clear"></div>';

    echo '</div>'; // services container

    // mobile
    echo '<div id="mobile" style="display: none;">';
    // todo - lite vs pro
    if (0) {
      echo '<p>This feature is not available in the lite version. <a href="#">Upgrade to pro</a> to access all LFP data from unlimited number of sites on your <a href="https://itunes.apple.com/WebObjects/MZStore.woa/wa/viewSoftware?id=1035184782&mt=8" target="_blank">Apple</a> or <a href="https://play.google.com/store/apps/details?id=com.imsc.leadsflowpro" target="_blank">Android</a> mobile device.</p>';
    } else {
      echo '<table class="form-table">';
      echo '<tbody>';
      echo '<tr>
             <th scope="row"><label for="api_access">Mobile Access</label></th>
             <td><select name="lf_settings[api_access]" id="api_access">';
      leadflow_common::create_select_options(array('Disabled', 'Enabled'), $settings['api_access'], true);
      echo '</select>';
      echo '<p class="description">When enabled mobile access allows you to access all LFP data from our Android and Apple mobile applications.<br>If the access details are compromised disable Mobile Access and save; then enable it and save again.</p></td>
             </tr>';
      if ($settings['api_access']) {
        $details = leadflow_mobile_api::get_access_details();
        $current_user = wp_get_current_user();

        echo '<tr>
               <th scope="row"><label for="">Auto-add Site to Mobile App: </label></th>
               <td><p><input type="button" class="button button-secondary" id="lf_send_api_info" data-type="sms" value="Send site API details to phone via SMS"> &nbsp; <input type="button" class="button button-secondary" id="lf_send_api_info" data-type="email" data-email="' . $current_user->user_email . '" value="Send site API details to phone via email"></p>
               <p class="description">Easiest way to add the site to the mobile app is to send the details via email or SMS and click the provided link.</p>';
        echo '</td></tr>';
        echo '<tr>
               <th scope="row"><label for="">Auto-add Site URL: </label></th>
               <td><b>' . $details['redirect_url']  . '</b><p class="description">Open this URL on your mobile device and the site will be automatically added to the LFP mobile app.</p>';
        echo '</td></tr>';
        echo '<tr>
               <th scope="row"><label for="">API Endpoint URL: </label></th>
               <td><b>' . $details['api_endpoint']  . '</b><p class="description">If you need to manually add the site to your mobile application use this URL.</p>';
        echo '</td></tr>';
        echo '<tr>
               <th scope="row"><label for="">API Key: </label></th>
               <td><b>' . $details['api_key']  . '</b>';
        echo '<p class="description">If you need to manually add the site to your mobile application use this API key. Do NOT share the key as it provides read-only access to all LFP data.<br>To reset the API key disable Mobile Access and save; then enable it and save again.</p></td>
               </tr>';

      }
      echo '</tbody>';
      echo '</table>';
      self::save_button();
    }
    echo '</div>'; // mobile api

    // geoip
    echo '<div id="geoip" style="display: none;">';

    leadflow_geoip::settings();

    echo '</div>'; // geoip

    // optin templates
    echo '<div id="optin-templates" style="display: none;">';

    leadflow_templates::settings();

    echo '</div>'; // optin templates

    echo '</div>';
    echo '</form>';

    echo '</div>';
    echo '</div>';
  } // options_page


  static function save_button() {
    echo '<p class="submit"><input type="submit" value="Save Settings" class="button button-primary" name="submit"></p>';
  } // save_button


  static function api_field_value($field, $default = '') {
    $provider = explode('-', $field);
    $field = $provider[1];
    $provider = $provider[0];

    leadflow_external_api::set_provider($provider);
    $options = leadflow_external_api::get_options();

    if (!empty($options[$field])) {
      return $options[$field];
    } else {
      return $default;
    }
  } // api_field_value


  static function api_status($provider) {
    $status = self::api_field_value($provider . '-status', false);

    if ($status) {
      return '<label>Status:</label> <span class="dashicons dashicons-yes"></span>';
    } else {
      return '<label>Status:</label> <span class="dashicons dashicons-no"></span>';
    }
  } // api_status


  static function api_lists($provider) {
    $lists = self::api_field_value($provider . '-lists', array());
    $status = self::api_field_value($provider . '-status', false);

    if ($provider == 'twilio') {
      if ($lists && $status) {
        return '<label>Available phone numbers:</label> ' . implode(', ', $lists);
      } else {
        return '<label>Available phone numbers:</label> none';
      }
    } elseif ($provider == 'gotowebinar' || $provider == 'webinarignition' || $provider == 'webinarjam') {
      if ($lists && $status) {
        return '<label>Webinars:</label> ' . implode(', ', $lists);
      } else {
        return '<label>Webinars:</label> none';
      }
    } elseif ($provider == 'infusionsoft') {
      if ($lists && $status) {
        return '<label>Groups:</label> ' . implode(', ', $lists);
      } else {
        return '<label>Groups:</label> none';
      }
    } elseif ($provider == 'ontraport') {
      if ($lists && $status) {
        return '<label>Tags &amp; Sequences:</label> ' . implode(', ', $lists);
      } else {
        return '<label>Tags &amp; Sequences:</label> none';
      }
    } elseif ($provider == 'jvzoo') {
      if ($status) {
        $time = self::api_field_value($provider . '-sync_from_timestamp', false);
        return '<label>Syncing transactions from:</label> ' . date(get_option('date_format'), $time);
      } else {
        return '<label>Syncing transactions from:</label> date unknown';
      }
    } else {
      if ($lists && $status) {
        return '<label>Lists:</label> ' . implode(', ', $lists);
      } else {
        return '<label>Lists:</label> none';
      }
    }
  } // api_lists


  static function save_api_ajax() {
    parse_str($_POST['fields'], $fields);
    $provider = $fields['provider_name'];
    unset($fields['provider_name']);

    leadflow_external_api::set_provider($provider);
    $status = leadflow_external_api::verify_api($fields, true);
    if ($status) {
      leadflow_external_api::get_lists(true);
      $data['status'] = self::api_status($provider);
      $data['lists'] = self::api_lists($provider);
      wp_send_json_success($data);
    } else {
      $data['status'] = self::api_status($provider);
      $data['lists'] = self::api_lists($provider);
      wp_send_json_error($data);
    }
  } // save_api_ajax


  static function activate_service_ajax() {
    $provider = $_POST['provider'];

    leadflow_external_api::set_provider($provider);
    leadflow_external_api::update_options(array('gui_status' => true));

    wp_send_json_success();
  } // activate_service_ajax


  static function deactivate_service_ajax() {
    $provider = $_POST['provider'];

    leadflow_external_api::set_provider($provider);
    leadflow_external_api::update_options(array('gui_status' => false, 'status' => false));

    wp_send_json_success();
  } // deactivate_service_ajax


  // Provider Box
  static function provider_box($params) {
    $output = '';

    // Provider Names
    $provider_names = array();

    // Default provider settings
    $defaults = array('overlay' => 'inactive');

    // Replace missing settings with default ones
    $settings = array_merge($defaults, $params);
	
	
	global $leadflow_lc;
	$lclevel = $leadflow_lc->GetLevelNo();
		
	if(in_array($settings['provider_key'],self::$pro_apis) && $lclevel<2){
		$output .= '<div class="settings_service_box lf-overlay-pro-only">';
		$output .= '<div class="lf-service-overlay">';
		$output .= '<div class="lf-service-overlay-inner">';
		$output .= '<img width="80" src="' . LF_PLUGIN_URL . '/images/services/' . $settings['provider_key'] . '.png" />';
		$output .= '<h3>' . $settings['provider'] . '</h3>';
		$output .= '<div class="lf-service-pro-title">Upgrade to LeadsFlow Pro to use this Service</div>';
		$output .= '</div>';
		$output .= '</div>';
	} else {
		$output .= '<div class="settings_service_box lf-overlay-' . $settings['overlay'] . '">';
		$output .= '<a href="#" class="lf-service-activate">';
		$output .= '<div class="lf-service-overlay">';
		$output .= '<div class="lf-service-overlay-inner">';
		$output .= '<img width="80" src="' . LF_PLUGIN_URL . '/images/services/' . $settings['provider_key'] . '.png" />';
		$output .= '<h3>' . $settings['provider'] . '</h3>';
		$output .= '<div class="lf-service-activate-title">Activate Service</div>';
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</a>';
	}
    // Hidden fields
    $output .= '<input type="hidden" name="provider_name" value="' . $settings['provider_key'] . '" />';

    // Service Title
    $output .= '<div class="service-box-title">';
    $output .= '<img height="50" src="' . LF_PLUGIN_URL . '/images/services/' . $settings['provider_key'] . '.png' . '" alt="' . $settings['provider'] . '" title="' . $settings['provider'] . '" />';
    $output .= '<h4>' . $settings['provider'] . '</h4>';
    $output .= '<a title="How to setup &amp; activate ' . $settings['provider'] . '" href="#" class="service-box-info"><span class="dashicons dashicons-editor-help"></span></a>';
    $output .= '</div>';

    // Service Stuff
    switch ($settings['provider_key']) {
      
      // MyMail
      case 'mymail':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Simply install the latest version of <a href="https://mymail.newsletter-plugin.com/" target="_blank">MyMail</a> and click "Save & test settings". No configuration is needed.</p>';
      $output .= '<p class="api-status">' . self::api_status('mymail') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('mymail') . '</p>';
      $output .= '</div>';
      break;
      
      // MailPoet
      case 'mailpoet':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Simply install the latest version of <a href="https://wordpress.org/plugins/wysija-newsletters/" target="_blank">MailPoet</a> and click "Save &amp; test settings". No configuration is needed.</p>';
      $output .= '<p class="api-status">' . self::api_status('mailpoet') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('mailpoet') . '</p>';
      $output .= '</div>';
      break;

      // WebinarJam
      case 'webinarjam':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Login to <a href="http://app.webinarjam.com/members/" target="_blank">WebinarJam</a>. Create a new webinar or edit an existing one; go trough the necessary steps until you get to <i>Integrations</i>. Enable <i>API custom integrations</i> and copy/paste the API key below. Don\'t forget to confirm and save.</p>';
      $output .= '<label for="webinarjam-api_key">API key:</label>';
      $output .= '<input id="webinarjam-api_key" type="text" name="api_key" value="' . self::api_field_value('webinarjam-api_key') . '">';

      $output .= '<p class="api-status">' . self::api_status('webinarjam') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('webinarjam') . '</p>';
      $output .= '</div>';
      break;

      // MailChimp
      case 'mailchimp':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="http://www.mailchimp.com/" target="_blank">MailChimp account</a><br />2. Go to <i>Account - Extras - API keys</i><br />3. Generate a new API key and paste it here</p>';

      $output .= '<label for="mailchimp-api_key">API key:</label>';
      $output .= '<input id="mailchimp-api_key" type="text" name="api_key" value="' . self::api_field_value('mailchimp-api_key') . '">';

      $output .= '<p class="api-status">' . self::api_status('mailchimp') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('mailchimp') . '</p>';
      $output .= '</div>';
      break;

      // SendInBlue
      case 'sendinblue':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="http://www.sendinblue.com/" target="_blank">SendInBlue account</a><br />2. Go to <i>API &amp; Integration - Manage your (API) keys</i><br />3. Copy/paste a <i>Version 2.0</i> API key</p>';
	  $output .= '<label for="sendinblue-api_key">API key:</label>';
      $output .= '<input id="sendinblue-api_key" type="text" name="api_key" value="' . self::api_field_value('sendinblue-api_key') . '">';

      $output .= '<p class="api-status">' . self::api_status('sendinblue') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('sendinblue') . '</p>';
      $output .= '</div>';
      break;
	  
	  // Facebook
      case 'facebook':
      $output .= '<div class="service-box-form">';
      
	  $output .= '<p class="help">
	  1. Login to <a href="https://developers.facebook.com">https://developers.facebook.com</a> and create a new app if you do not already have one<br />
	  2. Your app will need "manage_pages" permission. If you just want to use your app for personal use create a Test app, otherwise submit your Application for review.<br />
	  3. Add this website\'s domain to the App Domains<br />
	  4. Enter your App ID and App Secret in the boxes below<br />
	  5. Click on "Get List of Facebook Pages". This will retrieve a list of pages you have access to.<br />
	  6. Select the page you want to connect to and click "Save &amp; Test Settings.<br />
	  7. If the settings are valid you can then create an External Lead Flow and enable Facebook Leads in Flow Start<br />
	  8. In the Flow Start section enter any text in the Verify Token field and Save the flow<br />
	  9. In Graph API Explorer create a Webhook that uses your Flow\'s URL as callback_url, enter "leadgen" for fields used and the veiry_token you entered for your Flow<br />
	  10. You can use <a href="https://developers.facebook.com/tools/lead-ads-testing?hc_location=ufi">https://developers.facebook.com/tools/lead-ads-testing?hc_location=ufi</a> to test your flows<br />
	  11. Once you receive the first lead data you should check the fields sent by facebook in the Flow Start box and make sure you use the ones you need.	  
	  </p>';

	  if(!is_ssl()){
		$output .=  "Your website needs to use SSL in order to connect to the Facebook API";		  
	  } else {
	  
		  $output .= '<label for="facebook-app_id">App ID:</label>';
		  $output .= '<input id="facebook-app_id" type="text" name="app_id" value="' . self::api_field_value('facebook-app_id') . '"><br />';
	
		  $output .= '<label for="facebook-app_secret">App Secret:</label>';
		  $output .= '<input id="facebook-app_secret" type="text" name="app_secret" value="' . self::api_field_value('facebook-app_secret') . '">';
		  
		  
		  $output .= '<div>';
		  
		  $output .= '<div style="margin: 10px 0px 10px 97px;" id="lfp_facebook_login_button" class="button button-primary">Get List of Facebook Pages</div><br />';
		  $output .= '<label for="facebook_page">Page:</label>';
		  	
		  
		  $output .= '<select id="lfp_facebook_page" name="lfp_facebook_page">';
		  
		  $facebook_page_selected = get_option('lfp_facebook_page');
		  $facebook_pages = json_decode(stripslashes(get_option('lfp_facebook_pages_all')), true); 
		  if(is_array($facebook_pages)) foreach($facebook_pages as $facebook_page){
			  $output .= '<option value="'.$facebook_page['id'].'" '.($facebook_page_selected==$facebook_page['id']?'selected="selected"':'').'>'.$facebook_page['name'].'</option>';
		  }
						
		  $output .= '</select>';
		  
		  
		  $output .= '<input type="hidden" id="lfp_facebook_pages_all" name="lfp_facebook_pages_all" value=\''.get_option('lfp_facebook_pages_all').'\' /> ';
		  $output .= '</div>';
		  		  
			
		  $output .= '<p class="api-status">' . self::api_status('facebook') . '</p>';
	  }
      $output .= '</div>';
      break;

      // FullContact
      case 'fullcontact':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Free (with very limited number of requests) and payed accounts are available on <a href="https://www.fullcontact.com/developer/pricing/" target="_blank">FullContact.com</a>. API key will be sent to your email and shown to you if you open your <a href="https://portal.fullcontact.com/signin" target="_blank">FullContact account</a></p>';

      $output .= '<label for="fullcontact-api_key">API key:</label>';
      $output .= '<input id="fullcontact-api_key" type="text" name="api_key" value="' . self::api_field_value('fullcontact-api_key') . '">';

      $output .= '<p class="api-status">' . self::api_status('fullcontact') . '</p>';
      $output .= '</div>';
      break;

      // JVZoo
      case 'jvzoo':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. <a href="https://www.jvzoo.com/account/applications/index" target="_blank">Login to JVZoo</a> and open <i>My Account - Applications</i><br />2. Create a new application (name and description are not important)<br />3. Be sure to set the app status to "Active", save API app and copy/paste the generated API key here<br /><i>Sync start date is relative to the time of API activation.</i></p>';

      $output .= '<label for="jvzoo-api_key">API key:</label>';
      $output .= '<input id="jvzoo-api_key" type="text" name="api_key" value="' . self::api_field_value('jvzoo-api_key') . '"><br>';

      $sync_days = array('0' => 'Today', '1' => 'Yesterday', '3' => '3 days ago', '5' => '5 days ago', '7' => 'A week ago', '14' => 'Two weeks ago', '365' => 'All Transactions');

      $output .= '<label for="jvzoo-sync_days">Sync from:</label>';
      $output .= '<select id="jvzoo-sync_days" name="sync_days">';
      $output .= leadflow_common::create_select_options($sync_days, self::api_field_value('jvzoo-sync_days'), false);
      $output .= '</select>';

      $output .= '<p class="api-status">' . self::api_status('jvzoo') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('jvzoo') . '</p>';
      $output .= '</div>';
      break;

      // MadMimi
      case 'mad_mimi';
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="https://madmimi.com/user/edit?account_info_tabs=account_info_authorizations" target="_blank">Mad Mimi account</a><br />2. Go to <i>Account</i><br />3. Find the API key in the right sidebar and copy it here</p>';
      $output .= '<label for="mad_mimi-username">Email:</label>';
      $output .= '<input id="mad_mimi-username" type="text" name="username" value="' . self::api_field_value('mad_mimi-username') . '"><br>';
      $output .= '<label for="mad_mimi-api_key">API key:</label>';
      $output .= '<input id="mad_mimi-api_key" type="text" name="api_key" value="' . self::api_field_value('mad_mimi-api_key') . '">';

      $output .= '<p class="api-status">' . self::api_status('mad_mimi') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('mad_mimi') . '</p>';
      $output .= '</div>';
      break;

      // CampaignMonitor
      case 'campaign_monitor':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="https://login.createsend.com/l?" target="_blank">Campaign Monitor</a> (Createsend) account<br />2. Go to <i>Manage Account - API keys</i><br />3. Click "Show API key", copy and paste it here</p>';
      $output .= '<label for="campaign_monitor-api_key">API key:</label>';
      $output .= '<input id="campaign_monitor-api_key" type="text" name="api_key" value="' . self::api_field_value('campaign_monitor-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('campaign_monitor') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('campaign_monitor') . '</p>';
      $output .= '</div>';
      break;

      // ActiveCampaign
      case 'activecampaign';
      // Service Stuff
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="http://www.activecampaign.com/login/" target="_blank">ActiveCampaign account</a><br />2. Go to <i>My Settings - Developer</i><br />3. From <i>API Access</i> copy/paste the API info here</p>';
      $output .= '<label for="activecampaign-username">API URL:</label>';
      $output .= '<input id="activecampaign-username" type="text" name="username" value="' . self::api_field_value('activecampaign-username') . '"><br>';
      $output .= '<label for="activecampaign-api_key">API key:</label>';
      $output .= '<input id="activecampaign-api_key" type="text" name="api_key" value="' . self::api_field_value('activecampaign-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('activecampaign') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('activecampaign') . '</p>';
      $output .= '</div>';
      break;

      // Ontraport
      case 'ontraport';
      // Service Stuff
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Login to your Ontraport account and open <a href="https://app.ontraport.com/#!/api_settings/listAll" target="_blank">Administration - API keys</a>, create a new API key, set the appropriate permissions and save. On the list you will see App ID and API key - copy/paste both values here.</p>';
      $output .= '<label for="ontraport-app_id">App ID:</label>';
      $output .= '<input id="ontraport-app_id" type="text" name="app_id" value="' . self::api_field_value('ontraport-app_id') . '"><br>';
      $output .= '<label for="ontraport-api_key">API key:</label>';
      $output .= '<input id="ontraport-api_key" type="text" name="api_key" value="' . self::api_field_value('ontraport-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('ontraport') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('ontraport') . '</p>';
      $output .= '</div>';
      break;

      // GetResponse
      case 'getresponse':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="https://app.getresponse.com/main.html" target="_blank">GetResponse account</a><br />2. Go to <i>Account details - API &amp; OAuth</i><br />3. Generate My GetResponse API key and paste it here<br /></p>';
      $output .= '<label for="getresponse-api_key">API key:</label>';
      $output .= '<input id="getresponse-api_key" type="text" name="api_key" value="' . self::api_field_value('getresponse-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('getresponse') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('getresponse') . '</p>';
      $output .= '</div>';
      break;

      // Aweber
      case 'aweber':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Enter the app ID or use our if you don\'t have one: <i>bc1b62cc</i><br />2. Click "Authorize" button<br />3. Login with your account and click "Allow Access"<br />4. Copy/paste the generated authorization code in the field below.<br /><span style="color:#F00; font-style:italic;">Each authorization code can only be used once. So click "Save &amp; test settings" only once.</span></p>';
      $output .= '<label for="aweber-app_id">Aweber App ID:</label>';
      $output .= '<input id="aweber-app_id" type="text" name="app_id" value="' . self::api_field_value('aweber-app_id', 'bc1b62cc') . '"> <a href="https://auth.aweber.com/1.0/oauth/authorize_app/" class="button button-secondary" target="_blank" id="aweber_authorize">Authorize</a><br>';
      $output .= '<label for="aweber-api_key">Authorization code:</label>';
      $output .= '<input id="aweber-api_key" type="text" name="api_key" value="' . self::api_field_value('aweber-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('aweber') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('aweber') . '</p>';
      $output .= '</div>';
      break;

      // PushOver
      case 'pushover':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. <a href="https://pushover.net/login" target="_blank">Login or create a new account</a> on Pushover<br />2. <a href="https://pushover.net/apps/build" target="_blank">Create a new application</a>. Name will be visible on your device, and icon if you upload it<br />3. Copy/paste application\'s API token/key below</p>';
      $output .= '<label for="pushover-api_key">API key:</label>';
      $output .= '<input id="pushover-api_key" type="text" name="api_key" value="' . self::api_field_value('pushover-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('pushover') . '</p>';
      $output .= '</div>';
      break;

      // GoToWebinar
      case 'gotowebinar':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Open the <a href="https://developer.citrixonline.com/user/me/apps" target="_blank">Citrix Developer portal</a>, login and click "Add new app"<br />2. Name and description are not important, but make sure you select the right product - GoToWebinar<br />3. For application URL use "https://api.citrixonline.com"<br />4. Once the app is created copy/paste the Consumer Key below. Username &amp; password are the same you use for login.</p>';
      $output .= '<label for="gotowebinar-username">Username:</label>';
      $output .= '<input id="gotowebinar-username" type="text" name="username" value="' . self::api_field_value('gotowebinar-username') . '"><br>';
      $output .= '<label for="gotowebinar-password">Password:</label>';
      $output .= '<input id="gotowebinar-password" type="password" name="password" value="' . self::api_field_value('gotowebinar-password') . '"><br>';
      $output .= '<label for="gotowebinar-api_key">API Consumer Key:</label>';
      $output .= '<input id="gotowebinar-api_key" type="text" name="api_key" value="' . self::api_field_value('gotowebinar-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('gotowebinar') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('gotowebinar') . '</p>';
      $output .= '</div>';
      break;

      // InfusionSoft
      case 'infusionsoft':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Login to <a href="https://signin.infusionsoft.com/" target="_blank">InfusionSoft</a>, select an account and go to Admin - Settings - Application. On the bottom, under the API section, you will find "Encrypted key" - copy/paste it here. <br>Username is not your login email; it is the username/subdomain//name of the account on the accounts list after you login.</p>';
      $output .= '<label for="infusionsoft-username">Username:</label>';
      $output .= '<input id="infusionsoft-username" type="text" name="username" value="' . self::api_field_value('infusionsoft-username') . '"><br>';
      $output .= '<label for="infusionsoft-api_key">API key:</label>';
      $output .= '<input id="infusionsoft-api_key" type="text" name="api_key" value="' . self::api_field_value('infusionsoft-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('infusionsoft') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('infusionsoft') . '</p>';
      $output .= '</div>';
      break;

      // WebinarIgnition
      case 'webinarignition':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Simply install the latest version of <a href="http://webinarignition.com/" target="_blank">WebinarIgnition</a> and click "Save &amp; test settings". No configuration is needed.</p>';
      $output .= '<p class="api-status">' . self::api_status('webinarignition') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('webinarignition') . '</p>';
      $output .= '</div>';
      break;

      // iContact
      case 'icontact':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Open the <a href="https://app.icontact.com/icp/core/registerapp/" target="_blank">iContact developer portal</a><br>2. Register a new API app using the API v2.0<br />3. Make sure you immediately authorize the app for your account<br>4. Copy/paste your standard account username, the APP ID and the password you <strong>created for the app</strong></p>';
      $output .= '<label for="icontact-username">Username:</label>';
      $output .= '<input id="icontact-username" type="text" name="username" value="' . self::api_field_value('icontact-username') . '"><br>';
      $output .= '<label for="icontact-password">Password:</label>';
      $output .= '<input id="icontact-password" type="password" name="password" value="' . self::api_field_value('icontact-password') . '"><br>';
      $output .= '<label for="icontact-api_key">APP ID:</label>';
      $output .= '<input id="icontact-api_key" type="text" name="api_key" value="' . self::api_field_value('icontact-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('icontact') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('icontact') . '</p>';
      $output .= '</div>';
      break;

      // RapidMailer
      case 'rapid_mailer':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Simply install the latest version of <a href="http://imscrapidmailer.com/" target="_blank">IMSC Rapid Mailer</a> and click "Save &amp; test settings". No configuration is needed.</p>';
      $output .= '<p class="api-status">' . self::api_status('rapid_mailer') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('rapid_mailer') . '</p>';
      $output .= '</div>';
      break;

      // WishList
      case 'wishlist':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Simply install the latest version of <a href="http://member.wishlistproducts.com/" target="_blank">WishList Member</a> and click "Save &amp; test settings". No configuration is needed.</p>';
      $output .= '<p class="api-status">' . self::api_status('wishlist') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('wishlist') . '</p>';
      $output .= '</div>';
      break;

      // Zapier
      case 'zapier':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">Zap trigger endpoints are entered on a per Flow basis in the Zapier component. Make sure you click "Test &amp; Save Settings" in order to confirm connectivity between your server and Zapier.<br><br>Our Zapier app is private. To add it to your Zapier account <a href="https://zapier.com/developer/invite/27948/c1c7d1debc7c8dba80d5c09cc11b779d/" target="_blank">accept our invitation</a>.</p>';
      $output .= '<p class="api-status">' . self::api_status('zapier') . '</p>';
      $output .= '<p>Our Zapier app is private. To add it to your Zapier account <a href="https://zapier.com/developer/invite/27305/5be6f3a3b2dabf5dd5ae7a0f4c5142eb/" target="_blank">accept our invitation</a>.</p>';
      $output .= '</div>';
      break;

      // SendLane
      case 'sendlane':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Enter your Sendlane ID ( you can find this in the url of your Sendlane dashboard - <span style="color:#F00;">sendlaneid</span>.sendlane.com )<br />2. Login to your <a href="https://sendlane.com/users/login" target="_blank">SendLane</a> account<br />3. Click on your name on the right side menu and choose <i>Account Settings</i><br />4. Copy/paste the API key that\'s displayed under the <i>Your Security Credentials</i> section</p>';
      $output .= '<label for="sendlane-api_endpoint">Sendlane ID:</label>';
      $output .= '<input id="sendlane-username" type="text" name="api_endpoint" value="' . self::api_field_value('sendlane-api_endpoint') . '"><br>';
      $output .= '<label for="sendlane-username">Email:</label>';
      $output .= '<input id="sendlane-username" type="text" name="username" value="' . self::api_field_value('sendlane-username') . '"><br>';
      $output .= '<label for="sendlane-api_key">API key:</label>';
      $output .= '<input id="sendlane-api_key" type="text" name="api_key" value="' . self::api_field_value('sendlane-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('sendlane') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('sendlane') . '</p>';
      $output .= '</div>';
      break;

      // Twilio
      case 'twilio':
      $output .= '<div class="service-box-form">';
      $output .= '<p class="help">1. Login to your <a href="https://www.twilio.com/login" target="_blank">Twilio</a> account<br />2. Click "Show API Credentials" on the top to display your Account<br />3. Copy and paste SID and Auth Token here</p>';
      $output .= '<label for="twilio-username">Account SID:</label>';
      $output .= '<input id="twilio-username" type="text" name="username" value="' . self::api_field_value('twilio-username') . '"><br>';
      $output .= '<label for="twilio-api_key">Auth Token:</label>';
      $output .= '<input id="twilio-api_key" type="text" name="api_key" value="' . self::api_field_value('twilio-api_key') . '">';
      $output .= '<p class="api-status">' . self::api_status('twilio') . '</p>';
      $output .= '<p class="api-lists">' . self::api_lists('twilio') . '</p>';
      $output .= '</div>';
      break;

      default:
      $output .= 'Unknown API service.';
      break;

    }

    // Save Button
    $output .= '<div class="lf-bottom-buttons">';
    $output .= '<a class="button lf-save-api-provider" href="#">Save &amp; test settings</a>';
    $output .= '<a class="button lf-remove-api-provider" href="#">Deactivate</a>';
    $output .= '</div>';

    $output .= '</div>'; // box
    return $output;
  } // provider_box


  // Generate Services
  static function generate_services($status = 'inactive') {
    $not_empty = false;

    // get available providers
    $all_providers = leadflow_external_api::$available_providers;
    unset($all_providers['wp']);
    ksort($all_providers);
    $active_providers = leadflow_external_api::get_options(true);

    foreach ($all_providers as $provider_key => $provider) {
      if (isset($active_providers[$provider_key]) && !empty($active_providers[$provider_key]['gui_status'])) {
        if ($status == 'active') {
           echo self::provider_box(array('overlay' => 'inactive', 'provider_key' => $provider_key, 'provider' => $provider));
           $not_empty = true;
        }
      } else {
        if ($status == 'inactive') {
           echo self::provider_box(array('overlay' => 'active', 'provider_key' => $provider_key, 'provider' => $provider));
           $not_empty = true;
        }
      }
    } // foreach provider

    if ($not_empty == false) {
      echo '<p class="empty_message">There are currently no ' . $status . ' services.</p>';
    } else {
      echo '<p style="display: none;" class="empty_message">There are currently no ' . $status . ' services available.</p>';
    }
  } // generate_services


  static function reset_stats_ajax() {
    global $wpdb;

    $wpdb->query('TRUNCATE TABLE ' . $wpdb->lf_stats);

    wp_send_json_success();
  } // reset_stats_ajax

  static function delete_temp_ajax() {
    leadflow::deactivate(true);
    wp_send_json_success();

    global $wpdb;

    update_option(LF_EVENTS, array(), false);
    $wpdb->query($wpdb->prepare('DELETE FROM ' . $wpdb->options . ' WHERE option_name LIKE %s', array('%transient%lf_fullcontact%')));

    wp_send_json_success();
  } // delete_temp_ajax
} // leadflow_settings