<?php

/**

 * Plugin Name: WP Google Review

 * Plugin URI:

 * Description: This plugin displays reviews on your website through a small pop up in the lower right or left hand corner.

 * Version: 1.1.18

 * Author: Zach Anderson

 * Author URI:

 * Text Domain: 

 * Copyright:

 */
if ( ! defined( 'WPGOOGLEREVIEW_URL' ) )
{
	define( 'WPGOOGLEREVIEW_URL', plugin_dir_url( __FILE__ ) );
}

class FISAACGREVIEW_WOI

{

    protected $_plugin_dir;

    protected $_plugin_url;

	public $options;

    public function __construct()

    {

        //@session_start();

        $this->_plugin_dir = dirname(__FILE__);

        $this->_plugin_url = get_site_url(null, 'wp-content/plugins/' . basename($this->_plugin_dir));

		


		add_action( 'init', array($this,'activate_au') );

		add_action('init', array( $this, 'do_output_buffer'));

		add_action( 'wp_enqueue_scripts', array($this,'load'));
		add_action( 'admin_enqueue_scripts', array($this,'load'));		
		add_action( 'admin_menu', array($this,'plugin_menu') );
		
		$google_review_flag=get_option('wp_google_review_flag');


		if(!empty($google_review_flag)){
		add_action( 'wp_footer', array($this,'google_review_display') );    
		}
		$google_gmb_review_flag=get_option('wp_google_gmb_review_flag');


		if(!empty($google_gmb_review_flag)){
		add_action( 'wp_footer', array($this,'google_gmb_review_display') );    
		}	
		add_filter( 'plugin_action_links', array($this,'ttt_wpmdr_add_action_plugin'), 10, 5 );
			add_filter( 'set-screen-option', array( __CLASS__, 'set_screen' ), 10, 3 );
        
		add_action( 'wp_ajax_google_review_save_review', array($this,'save_review') );
		add_action( 'wp_ajax_nopriv_google_review_save_review', array($this,'save_review') );
		register_activation_hook( __FILE__, array($this,'create_plugin_database_table') );
		
		add_filter( 'cron_schedules', array($this,'myprefix_google_review_cron_schedule') );

		//Schedule an action if it's not already scheduled
		if ( ! wp_next_scheduled( 'google_review_cron_hook' ) ) {
			wp_schedule_event( time(), 'every_one_day_google_review', 'google_review_cron_hook' );
		}
		$google_gmb_mobile_review_flag = get_option('wp_google_gmb_mobile_review_flag');
        if(!empty($google_gmb_mobile_review_flag)){
		add_action( 'wp_footer', array($this,'google_gmb_review_display') );    
		}

		add_filter( 'archive_template',array($this, 'google_review_archive_template') ) ;

		///Hook into that action that'll fire every six hours
		  add_action( 'google_review_cron_hook', array($this,'get_google_gmb_review') );

	
		add_action( 'wp_ajax_dismiss_welcome_message',  array($this,'wp_google_review_dismiss_welcome_message') );
		$tblname = 'wp_google_review_list';
		$this->add_column_if_not_exist($tblname , 'place_id');
		$this->add_column_if_not_exist($tblname , 'business_name');	
		$this->add_column_if_not_exist($tblname , 'hash');	
		$this->add_column_if_not_exist($tblname , 'review_type');	
		$this->add_column_if_not_exist($tblname , 'site');	
		$this->add_column_if_not_exist($tblname , 'site_image');
	}


		function add_column_if_not_exist($tblname, $column, $column_attr = "VARCHAR( 255 ) NULL" )

			{

				global $wpdb;

				

				$wp_track_table = $wpdb->prefix . "$tblname";

				$check_column=$wpdb->get_col( "DESC {$wp_track_table}" );	 

				if(!in_array($column,$check_column)) 

				{

					$sql = "ALTER TABLE " . $wp_track_table ." ADD $column $column_attr";

					$wpdb->query($sql);			

				}   

		}
	
	public static function ttt_wpmdr_add_action_plugin( $actions, $plugin_file ) 
	{
		static $plugin;
		if (!isset($plugin))
			$plugin = plugin_basename(__FILE__);
		if ($plugin == $plugin_file) {
			
				$settings = array('settings' => '<a href="admin.php?page=wp_google_gmb_reviews">' . __('Settings', 'General') . '</a>');
			
					$actions = array_merge($settings, $actions);
				
			}
			
			return $actions;
	}
	function do_output_buffer() {

        ob_start();
		 flush_rewrite_rules();

	$args = array(
        'description' => '',
        'public' => true,
        'show_ui' => true,
		'has_archive' => true,
        'show_in_menu' => false,
        'hierarchical' => true,
		'query_var' => true,
        'rewrite' => array(
			'slug' => 'google_rcount', 'with_front' => false
        ),
        'exclude_from_search' => true,
        'supports' => array(
            'title',
            'revisions',
            'thumbnail',
            'author',
        ),
		
        'labels' => array()
    );
    register_post_type('google_rcount', $args);
	
	$args = array(
        'label' => '',
        'description' => '',
        'public' => true,
        'show_ui' => true,
		'has_archive' => true,
        'show_in_menu' => false,
        'hierarchical' => true,
		'query_var' => true,
        'rewrite' => array(
			'slug' => 'google_rconnect', 'with_front' => false
        ),
        'exclude_from_search' => true,
        'supports' => array(
            'title',
            'revisions',
            'thumbnail',
            'author',
        ),
		
        'labels' => array()
    );
    register_post_type('google_rconnect', $args);
	
	
	}
	
    public  function load()

    {

        if( is_admin())
        {
		
			 if( isset($_GET['page']) && ($_GET['page'] == 'wp_google_reviews' || $_GET['page'] == 'wp_google_gmb_reviews' || $_GET['page'] == 'wp_google_review_add') ){
				add_action('admin_print_scripts', array($this,'my_admin_scripts'));
				add_action('admin_print_styles',  array($this,'my_admin_styles'));
				}
        }else{
		
		
		}
	}
function myprefix_google_review_cron_schedule( $schedules ) {
    $schedules['every_one_day_google_review'] = array(
        'interval' => 60 * 60 * 24, 
        'display'  => __( 'Every one Day' ),
    );
    return $schedules;
}

function wp_google_review_word_digit($word) {
    $warr = strtolower($word);
        switch(trim($warr)){
            case 'zero':
                $result = '0';
                break;
            case 'one':
                $result = '1';
                break;
            case 'two':
                $result = '2';
                break;
            case 'three':
                $result = '3';
                break;
            case 'four':
                $result = '4';
                break;
            case 'five':
                $result = '5';
                break;
            case 'six':
                $result = '6';
                break;
            case 'seven':
                $result = '7';
                break;
            case 'eight':
                $result = '8';
                break;
            case 'nine':
                $result = '9';
                break;    
        }
    return $result;
}
	function get_google_gmb_review(){
	$author_url="";
		$google_gmb_review_location=get_option('wp_google_gmb_review_location');

							 $reviews = $this->wp_google_review_get_reviews($google_gmb_review_location);
  $place = $this->wp_google_review_get_place($google_gmb_review_location);
  if(isset($place['metadata']['newReviewUrl'])&&!empty($place['metadata']['newReviewUrl'])){
		$author_url=$place['metadata']['newReviewUrl'];
  }
$locationNames = $this->wp_google_review_get_specific_location();


							if(isset($locationNames)&&!empty($locationNames)){
								$locationValues = array();
								foreach($locationNames as $lk => $location){
										$locationValues[$lk] = $location;
								} 

							}  
							
foreach($reviews as $val){
$a1=array();
if(isset($val['createTime'])&&!empty($val['createTime'])){
$time=explode('T',$val['createTime']);
$ttime="";
if(isset($time[0])&&!empty($time[0])){
$ttime=strtotime($time[0]);
}
}
$a1['place_id']='';
$a1['place_check']='';
$a1['review_id']='';
$a1['name']='';
$a1['text']='';
$a1['time']='';
$a1['author_name']='';
$a1['author_url']='';
$a1['profile_photo_url']='';
if(isset($locationValues[$google_gmb_review_location])&&!empty($locationValues[$google_gmb_review_location])){
$a1['place_id']=$locationValues[$google_gmb_review_location];
}
if(isset($google_gmb_review_location)&&!empty($google_gmb_review_location)){
$a1['place_check']=$google_gmb_review_location;
}
if(isset($val['createTime'])&&!empty($val['createTime'])){
$a1['review_id']=$val['reviewId'];
}
if(isset($locationValues[$google_gmb_review_location])&&!empty($locationValues[$google_gmb_review_location])){
$a1['name']=$locationValues[$google_gmb_review_location];
}
if(isset($val['comment'])&&!empty($val['comment'])){
$a1['text']=$val['comment'];
}
if(isset($ttime)&&!empty($ttime)){
$a1['time']=$ttime;
}
if(isset($val['reviewer']['displayName'])&&!empty($val['reviewer']['displayName'])){
$a1['author_name']=$val['reviewer']['displayName'];
}
if(isset($author_url)&&!empty($author_url)){
$a1['author_url']=$author_url;
}

if(isset($val['reviewer']['profilePhotoUrl'])&&!empty($val['reviewer']['profilePhotoUrl'])){
$a1['profile_photo_url']=$val['reviewer']['profilePhotoUrl'];
}else{
$google_gmb_review_location_image=get_option('wp_google_gmb_review_location_image_'.$a1['place_id']);
if((isset($google_gmb_review_location_image)&&!empty($google_gmb_review_location_image))){
$a1['profile_photo_url']=$google_gmb_review_location_image;
}else{
if((isset($place['latlng']['latitude'])&&!empty($place['latlng']['latitude']))&&(isset($place['latlng']['longitude'])&&!empty($place['latlng']['longitude']))){
$location=$place['latlng']['latitude'].",".$place['latlng']['longitude'];

if(!empty($location)){
$imageUrl=$this->getImage($location);
$a1['profile_photo_url']=$imageUrl;
 update_option('wp_google_gmb_review_location_image_'.$a1['place_id'],$imageUrl);
}
}
}
}
$a1['rating']=$this->wp_google_review_word_digit($val['starRating']);
					if ($a1) {
                            $this->wp_google_review_save_gmb_reviews($a1);
                            $status = 'success';
                        } else {
                            $status = 'failed';
                        }
 }}	
 function get_google_gmb_review_add($reviews){
 global $wpdb;
	if( isset( $reviews['submit_google_gmb_review_add'] ) )
    {
	$a1=array();
	$a1['place_id']='';
		$a1['place_check']='';
		$a1['review_id']='';
		$a1['name']='';
		$a1['text']='';
		$a1['time']='';
		$a1['author_url']='';
		$a1['site']='';
		$a1['author_name']='';
		$a1['rating']='';
		if(isset($reviews['google_gmb_review_business_location'])&&!empty($reviews['google_gmb_review_business_location'])){
			$a1['place_id']=$reviews['google_gmb_review_business_location'];
		}
		if(isset($reviews['review_id'])&&!empty($reviews['review_id'])){
			$a1['review_id']=$reviews['review_id'];
		}
		if(isset($reviews['google_gmb_review_business_name'])&&!empty($reviews['google_gmb_review_business_name'])){
			$a1['name']=$reviews['google_gmb_review_business_name'];
		}
		if(isset($reviews['google_gmb_review_upload_profile_image_id'])&&!empty($reviews['google_gmb_review_upload_profile_image_id'])){
			$a1['profile_photo_url']=$reviews['google_gmb_review_upload_profile_image_id'];
		}else{
			if(isset($reviews['google_gmb_review_business_location'])&&!empty($reviews['google_gmb_review_business_location'])){
			$address=str_replace(' ','',$reviews['google_gmb_review_business_location']);
			$address=str_replace('(','',$address);
			$address=str_replace(')','',$address);
			$imageUrl=$this->getImage($address);
			$a1['profile_photo_url']=$imageUrl;
			}
		}
		if(isset($reviews['google_gmb_review_text'])&&!empty($reviews['google_gmb_review_text'])){
			$a1['text']=$reviews['google_gmb_review_text'];
		}
		if(isset($reviews['google_gmb_review_author_name'])&&!empty($reviews['google_gmb_review_author_name'])){
			$a1['author_name']=$reviews['google_gmb_review_author_name'];
		}
		if(isset($reviews['google_gmb_review_rating'])&&!empty($reviews['google_gmb_review_rating'])){
			$a1['rating']=$reviews['google_gmb_review_rating'];
		}
		if(isset($reviews['google_gmb_review_time'])&&!empty($reviews['google_gmb_review_time'])){
			$a1['time']=strtotime($reviews['google_gmb_review_time']);
		}
		if(isset($reviews['google_gmb_review_author_url'])&&!empty($reviews['google_gmb_review_author_url'])){
			$a1['author_url']=$reviews['google_gmb_review_author_url'];
		}
		if(isset($reviews['google_gmb_review_site'])&&!empty($reviews['google_gmb_review_site'])){
			$a1['site']=$reviews['google_gmb_review_site'];
		}
		
						if ($a1) {
								$this->wp_google_review_save_gmb_reviews_custom($a1);
								$status = 'success';
								wp_redirect('?page=wp_google_reviews');
								die;
							} else {
								$status = 'failed';
							}
	 }
	
  if(isset($reviews['review_id'])&&!empty($reviews['review_id'])){
   $review_data = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "wp_google_review_list WHERE id = %s", $reviews['review_id']));
   return $review_data;
   }
   return '';
   
 }	
 function getImage($address){
 
 $uploads_dir =  wp_upload_dir();
 $uploaddir='';
 if(isset($uploads_dir['basedir'])&&!empty($uploads_dir['basedir'])){
	$uploaddir=$uploads_dir['basedir']."/wp_google_review";
	if(!file_exists($uploaddir)){
		wp_mkdir_p( $uploaddir );
	}
	$uploaddir=$uploads_dir['basedir']."/wp_google_review/";

 }
  $uploadurl='';
 if(isset($uploads_dir['baseurl'])&&!empty($uploads_dir['baseurl'])){
	$uploadurl=$uploads_dir['baseurl']."/wp_google_review/";
 }
 if(!empty($address)){
 $src = 'https://maps.googleapis.com/maps/api/staticmap?center='.$address.'&markers=color:red%7Clabel:C%7C'.$address.'&zoom=12&size=600x400&key=AIzaSyDTzGxqcCka1HOWowhZnCcaCWY1yyscaSM';
			
			$time = time();
			$imageName = 'google-map_'.$time.'.png';
			$imagePath = $uploaddir.$imageName;
			$imageUrl = $uploadurl.$imageName;
			file_put_contents($imagePath,file_get_contents($src));
			return $imageUrl;
	}
 }
function wp_google_review_save_gmb_reviews($place, $min_filter = 0) {
    global $wpdb;

    $google_place_id = $place['place_id'];
   // if (get_option('wp_google_review_business_id')&&get_option('wp_google_review_business_id')==$google_place_id) {
           
           // $hash = sha1($place['place_id'] . $place['author_url']);
		    $hash = $place['review_id'];
            $google_review_id = $wpdb->get_var($wpdb->prepare("SELECT id FROM " . $wpdb->prefix . "wp_google_review_list WHERE hash = %s", $hash));
			$review_enable="0";
			if (get_option('wp_google_gmb_review_rating')&&($place['rating']>=get_option('wp_google_gmb_review_rating'))) {
				$review_enable="1";
			}
            if (!$google_review_id) {
                $wpdb->insert($wpdb->prefix . 'wp_google_review_list', array(
                    'place_id' => $google_place_id,
                    'hash' => $hash,
                    'rating' => $place['rating'],
                    'text' => $place['text'],
                    'time' => $place['time'],
                    //'relative_time_description' => $place['relative_time_description'],
                    'review_enable' => $review_enable,
                    'review_type' => 'GMB',
					 'business_name' => $place['name'],
                    'author_name' => $place['author_name'],
					'site' => isset($place['site']) ? $place['site'] : '',
                    'author_url' => isset($place['author_url']) ? $place['author_url'] : '',
				//	'site_image' => isset($place['site_image']) ? $place['site_image'] : '',
                    'profile_photo_url' => isset($place['profile_photo_url']) ? $place['profile_photo_url'] : null
                ));
            }else{
			if (get_option('wp_google_gmb_review_location')&&get_option('wp_google_gmb_review_location')==$place['place_check']) {
			 $wpdb->update($wpdb->prefix . 'wp_google_review_list', array(
					'place_id' => $google_place_id,
                    'hash' => $hash,
                    'rating' => $place['rating'],
                    'text' => $place['text'],
                    'time' => $place['time'],
                    //'relative_time_description' => $place['relative_time_description'],
					 'review_enable' => $review_enable,
                    'author_name' => $place['author_name'],
					 'business_name' => $place['name'],
                    'review_type' => 'GMB',
					'site' => isset($place['site']) ? $place['site'] : '',
                    'author_url' => isset($place['author_url']) ? $place['author_url'] : '',
					//'site_image' => isset($place['site_image']) ? $place['site_image'] : '',
                    'profile_photo_url' => isset($place['profile_photo_url']) ? $place['profile_photo_url'] : null
			), array('id' => $google_review_id));
			}
       }
    }
	
function wp_google_review_save_gmb_reviews_custom($place, $min_filter = 0) {
    global $wpdb;

    $google_place_id = $place['place_id'];
   // if (get_option('wp_google_review_business_id')&&get_option('wp_google_review_business_id')==$google_place_id) {
           
           // $hash = sha1($place['place_id'] . $place['author_url']);
		    $hash = $place['review_id'];
            $google_review_id = $wpdb->get_var($wpdb->prepare("SELECT id FROM " . $wpdb->prefix . "wp_google_review_list WHERE id = %s", $hash));
			$review_enable="1";
			
            if (!$google_review_id) {
                $wpdb->insert($wpdb->prefix . 'wp_google_review_list', array(
                    'place_id' => $google_place_id,
                    'hash' => $hash,
                    'rating' => $place['rating'],
                    'text' => $place['text'],
                    'time' => $place['time'],
                    'relative_time_description' => isset($place['relative_time_description']) ? $place['relative_time_description'] : '',
                    'review_enable' => $review_enable,
                    'review_type' => $place['site'],
					 'business_name' => $place['name'],
                    'author_name' => $place['author_name'],
					'site' => isset($place['site']) ? $place['site'] : '',
                    'author_url' => isset($place['author_url']) ? $place['author_url'] : '',
                    'profile_photo_url' => isset($place['profile_photo_url']) ? $place['profile_photo_url'] : '',
					//'site_image' => isset($place['site_image']) ? $place['site_image'] : '',
                ));
            }else{
			 $wpdb->update($wpdb->prefix . 'wp_google_review_list', array(
					'place_id' => $google_place_id,
                    'hash' => $hash,
                    'rating' => $place['rating'],
                    'text' => $place['text'],
                    'time' => $place['time'],
                    'relative_time_description' => isset($place['relative_time_description']) ? $place['relative_time_description'] : '',
					 'review_enable' => $review_enable,
                    'author_name' => $place['author_name'],
					 'business_name' => $place['name'],
                    'review_type' => $place['site'],
					'site' => isset($place['site']) ? $place['site'] : '',
                    'author_url' => isset($place['author_url']) ? $place['author_url'] : '',
                    'profile_photo_url' => isset($place['profile_photo_url']) ? $place['profile_photo_url'] : '',
					//'site_image' => isset($place['site_image']) ? $place['site_image'] : '',
			), array('id' => $google_review_id));
       }
    }
   public  function my_admin_scripts() 

    {

      
        wp_enqueue_script('jquery');    

		wp_enqueue_script( 'wp_google_review_admin_script', $this->_plugin_url . '/js/wp_google_review_admin_script.js', array('jquery') );
		// Load the datepicker script (pre-registered in WordPress).
		wp_enqueue_script( 'jquery-ui-datepicker' );

    wp_enqueue_media();

    wp_enqueue_script( 'wp-media-uploader', get_site_url(null, 'wp-content/plugins/' . basename(dirname(__FILE__))) . '/js/wp_media_uploader.js', array( 'jquery' ), 1.0 );
    }

    public  function my_admin_styles()  

    { 


    // You need styling for the datepicker. For simplicity I've linked to Google's hosted jQuery UI CSS.
    wp_register_style( 'jquery-ui', $this->_plugin_url.'/css/jquery-ui.css' );
    wp_enqueue_style( 'jquery-ui' );  
		wp_register_style( 'wp_google_review_admin_style', $this->_plugin_url.'/css/wp_google_review_admin_style.css' );
		wp_enqueue_style( 'wp_google_review_admin_style' );  

    }


	public function activate_au()

	{

		require_once ( 'library/wp_autoupdate.php' );

		$plugin_current_version = '1.1.18';

		$plugin_remote_path = 'http://165.227.86.239/update_google_review.php';

		$plugin_slug = plugin_basename( __FILE__ );

		$license_user = 'user';

		$license_key = 'abcd';

		new WP_AutoUpdateGoogleReview ( $plugin_current_version, $plugin_remote_path, $plugin_slug, $license_user, $license_key);

		

		

	}


    public function plugin_menu()

    {	

      	 add_menu_page(__('Google GMB Review'),__('Google GMB Review'),'manage_options','wp_google_gmb_reviews',array($this,'google_gmb_reviews'),'dashicons-star-half',81);
	

		$hook = add_submenu_page(

			'wp_google_gmb_reviews',

			__('Review'),

			__('Review'),

			'manage_options',

			'wp_google_reviews',

			array( $this, 'plugin_settings_page' )

		);



		add_action( "load-$hook", array( $this, 'screen_option' ) );

		add_submenu_page('wp_google_gmb_reviews', '', '', "manage_options", 'wp_google_review_add', array($this,'google_gmb_review_add'));
		

    }

	public function getUrlContent($url){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_HEADER, 0);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,  FALSE);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($ch, CURLOPT_URL, $url);

		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);

		$data = curl_exec($ch);

		curl_close($ch);

		return $data;

	}

	

	public function google_review_popup($place) 



	 {
		
		
		include( 'library/load_google_review_popup.php' );
		
	}
	
	public function google_gmb_reviews() 



	 {
		

		if ( !current_user_can( 'manage_options' ) )  

        {

            wp_die( __( 'You do not have sufficient permissions to access this page.' ) );

        }

		if( isset( $_POST['submit_google_gmb_review'] ) )

        {

            //if(isset($_POST['google_gmb_review_flag']))

            {

                $google_gmb_review_flag = $_POST['google_gmb_review_flag'];

                update_option('wp_google_gmb_review_flag',$google_gmb_review_flag);
				
				$google_gmb_mobile_review_flag = @$_POST['google_gmb_mobile_review_flag'];

                update_option('wp_google_gmb_mobile_review_flag',$google_gmb_mobile_review_flag);
				
            }

			 if(isset($_POST['google_gmb_review_connect']))

            {

                $google_gmb_review_connect = $_POST['google_gmb_review_connect'];

                update_option('wp_google_gmb_review_connect',$google_gmb_review_connect);

            }

		
			
			
			 if(isset($_POST['google_gmb_review_rating']))

            {

                $google_gmb_review_rating = $_POST['google_gmb_review_rating'];

                update_option('wp_google_gmb_review_rating',$google_gmb_review_rating);

            }
			
			 if(isset($_POST['google_gmb_review_position']))

            {

                $google_gmb_review_position = $_POST['google_gmb_review_position'];

                update_option('wp_google_gmb_review_position',$google_gmb_review_position);
				$this->get_google_gmb_review();

            }

			

		

			

		}
			
		 if(isset($_POST['google_gmb_review_disconnect'])&&!empty($_POST['google_gmb_review_disconnect']))

            {
				   update_option('wp_google_gmb_review_account','');
				update_option('wp_google_gmb_review_location_image_'.get_option('wp_google_gmb_review_location'),'');
                update_option('wp_google_gmb_review_location','');

               delete_transient('wp_google_review_accounts');
				delete_transient('wp_google_review_locations');
				delete_transient('wp_google_review_auth_settings');
				update_option('wp_google_review_auth_settings', '');

            }
		
	
		include( 'library/options_google_gmb_review.php' );

		include( 'library/google_review_gmb_options.php' );
	
		

	}	
	
	public function google_gmb_review_add() 



	 {
		

		if ( !current_user_can( 'manage_options' ) )  

        {

            wp_die( __( 'You do not have sufficient permissions to access this page.' ) );

        }

			$data=$this->get_google_gmb_review_add($_REQUEST);
            if(isset($data[0]->author_name))

            {

                $google_gmb_review_author_name = $data[0]->author_name;
				
            }

			 if(isset($data[0]->business_name))

            {

                $google_gmb_review_business_name = $data[0]->business_name;
				
            }

		
			
			
			 if(isset($data[0]->rating))

            {

                $google_gmb_review_rating = $data[0]->rating;
				
            }
			
			 if(isset($data[0]->time))

            {

                $google_gmb_review_time = $data[0]->time;
				
            }
			

		

			
		 if(isset($data[0]->author_url))

            {

                $google_gmb_review_author_url = $data[0]->author_url;
				
            }
			
			if(isset($data[0]->site))

            {

                $google_gmb_review_site = $data[0]->site;
				
            }
			if(isset($data[0]->site_image))

            {

                $image_id = $data[0]->site_image;
				
            }
			
			if(isset($data[0]->text))

            {

                $google_gmb_review_text = $data[0]->text;
				
            }
			if(isset($data[0]->profile_photo_url))

            {

                $profile_image_id = $data[0]->profile_photo_url;
				
            }
			if(isset($data[0]->place_id))

            {

                $google_gmb_review_business_location = $data[0]->place_id;
				
            }
			
		include( 'library/google_review_gmb_add.php' );
	
		

	}	
	public function google_gmb_review_display() 



	 {
		$google_gmb_review_location=get_option('wp_google_gmb_review_location');

							 $reviews = $this->wp_google_review_get_reviews($google_gmb_review_location);
 
$locationNames = $this->wp_google_review_get_specific_location();
								
							if(isset($locationNames)&&!empty($locationNames)){
								$locationValues = array();
								foreach($locationNames as $lk => $location){
										$locationValues[$lk] = $location;
								} 

							}  
		$place=$locationValues[$google_gmb_review_location];
		$google_review_position=get_option('wp_google_gmb_review_position');
		if((!empty($google_review_position)&&$google_review_position=='1')){
			$position_text="left";
		}elseif((!empty($google_review_position)&&$google_review_position=='2')){
			$position_text="right";
		}
        echo "<script>! function() {  if(typeof window.wp_google_review_config=='undefined'){  function b() {        var a = (new Date).getTime(),            b = document.createElement('script');        b.type = 'text/javascript', b.async = !0, b.src = '".plugins_url('wp_google_review/js/popup.js')."?' + a;        var c = document.getElementsByTagName('script')[0];        c.parentNode.insertBefore(b, c)    }    var a = window;    a.attachEvent ? a.attachEvent('onload', b) : a.addEventListener('load', b, !1), window.wp_google_review_config = {        acc: '".$place."', scc: '".get_site_url()."',pcc: '".$position_text."',       v: '1.1'    }}}()</script></p>";
		
	}


 public function wp_google_review_shortcode_builder_select($name,$default,$values){
                    
                    $html = '<select name="'.$name.'">';
					$html .= '<option value="" >--select--</option>';
                        foreach($values as $key=>$value){
                            
                            if($key == $default){
                                $selected = 'selected="selected"';       
                            } else {
                                $selected = '';    
                            }
                            $html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
                        }

                    $html .= '</select>';

                    return $html; 

                }
				
	public function wp_google_review_shortcode_builder_redio($name,$default,$values){
                    
                    
                    $html = '';
					$id=0;
                        foreach($values as $key=>$value){
                            
                            if($key == $default){
                                $checked = 'checked="checked"';       
                            } else {
                                $checked = '';    
                            }
							$html .= '<div class="location_radio"><input type="radio" name="'.$name.'" id="'.$name.'_'.$id.'" value="'.$key.'" '.$checked.'> <span id="'.$name.'_'.$id.'_title">'.$value.'</span></div>';
							$id++;
                        }


                    return $html; 

                }
				
	

public function wp_google_review_get_access_token() {
    
    
        $getTransient = get_transient('wp_google_review_auth_settings');
        
        //if the transient exists
        if ($getTransient != false){
            
            return $getTransient;
  
        } else {

				
            //the transient doesn't exist therefore do api call

            $pluginSettings = get_option('wp_google_review_auth_settings');
			 $currentRefreshToken = "";
            //current refresh token
			if(isset($pluginSettings['refresh_token'])&&!empty($pluginSettings['refresh_token'])){
				$currentRefreshToken = $pluginSettings['refresh_token'];
			}
			if(!empty($currentRefreshToken)){
            //do response
            $response = wp_remote_post( 'https://www.googleapis.com/oauth2/v4/token?refresh_token='.$currentRefreshToken.'&client_id=567146857464-u640lg2uopncv31q7ak7kd0vuj58bsbv.apps.googleusercontent.com&client_secret=rTcwS-sZccHNVVV-3Q4UFPPu&grant_type=refresh_token' );
		   
            if ( ! is_wp_error( $response ) ) {
                // The request went through successfully, check the response code against
                // what we're expecting
                if ( 200 == wp_remote_retrieve_response_code( $response ) ) {

 
                    //get new acess token and refresh token
                         
                    $jsondata = json_decode(preg_replace('/("\w+"):(\d+(\.\d+)?)/', '\\1:"\\2"', $response['body']), true); 

                    $newAccessToken = sanitize_text_field($jsondata['access_token']);
                    //$newRefreshToken = $jsondata['refresh_token'];

                    //now we need to update the settings
                    //set the new values from the existing array
                    $pluginSettings['access_token'] = $newAccessToken;
                    //$pluginSettings['refresh_token'] = $newRefreshToken;

                    //update the option
                    update_option('wp_google_review_auth_settings', $pluginSettings);
                    
                    //set the transient
                    //we will make this transient expire just before 60 minutes
                    set_transient( 'wp_google_review_auth_settings',$newAccessToken,MINUTE_IN_SECONDS*45);
                    
                    //return the array
                    return $newAccessToken;


                } else {
                    
                    //we can put some diagnostic info here if we wanted to
                    return 'ERROR';
                    
                }
            } else {
                return 'ERROR';
                //we can put some diagnostic info here if we wanted to
                
            } } else {
                return 'ERROR';
                //we can put some diagnostic info here if we wanted to
                
            } 
     
    }
    
}	

public function wp_google_review_get_accounts() {
    
    $transientName = 'wp_google_review_accounts';
    
    $getTransient = get_transient($transientName);
    //if the transient exists
    if ($getTransient != false){

        return $getTransient;

    } else {
        
        //there's no transient so do the api call
        $response = wp_remote_get( 'https://mybusiness.googleapis.com/v4/accounts', array(
            'headers' => array(
                'Authorization' => 'Bearer '.$this->wp_google_review_get_access_token(),
            ),
        ));

 
        if(200 == wp_remote_retrieve_response_code( $response )) {

            $jsondata = json_decode($response['body'],true); 

            $accounts = $jsondata['accounts'];

            set_transient($transientName,$accounts,DAY_IN_SECONDS*7);
            
            return $accounts;

        } else {
            
            return 'ERROR';
            
        }
        
    }
    
}	
function wp_google_review_get_specific_location() {
    
    $getLocations = $this->wp_google_review_get_locations();

    if($getLocations !== 'ERROR'){
        //turn locations data into retrievable data via an associative array
        $locationData = array();
        foreach($getLocations as $getLocation){
            $locationData[$getLocation['name']] = $getLocation['locationName'];    
        }
        
        return $locationData;

    }
    
    
    
}	
	
public function wp_google_review_get_locations() {
    
    $transientName = 'wp_google_review_locations';
    
    $getTransient = get_transient($transientName);
        
    //if the transient exists
    if ($getTransient != false){

        return $getTransient;

    } else {
       
        //there's no transient so do the api call
        $accountName = get_option('wp_google_gmb_review_account');
        
        $response = wp_remote_get( 'https://mybusiness.googleapis.com/v4/'.$accountName.'/locations', array(
            'headers' => array(
                'Authorization' => 'Bearer '.$this->wp_google_review_get_access_token(),
            ),
        ));
        
        if(200 == wp_remote_retrieve_response_code( $response )) {

            $jsondata = json_decode($response['body'],true); 

            $locations = $jsondata['locations'];

            set_transient($transientName,$locations,DAY_IN_SECONDS*7);
            
            return $locations;

        } else {
            
            return 'ERROR';
            
        }
        
    }
    
}

public function wp_google_review_get_locations_by_account($accountName) {
    
  
   
        
        //there's no transient so do the api call
       // $pluginSettings = get_option('wp_google_review_settings');
       // $accountName = $pluginSettings['wp_google_review_account_selection'];
        $transientName = 'wp_google_review_locations';
        $response = wp_remote_get( 'https://mybusiness.googleapis.com/v4/'.$accountName.'/locations', array(
            'headers' => array(
                'Authorization' => 'Bearer '.$this->wp_google_review_get_access_token(),
            ),
        ));
        
 
        if(200 == wp_remote_retrieve_response_code( $response )) {

            $jsondata = json_decode($response['body'],true); 

            $locations = $jsondata['locations'];

           set_transient($transientName,$locations,DAY_IN_SECONDS*7);
            
            return $locations;

        } else {
            
            return 'ERROR';
            
        }
        
    
}
	
function wp_google_review_get_reviews($location) {

    if($location == ''){
        return 'ERROR';
    }

    //parse location
    $locationParsed = explode('/',$location);
    $justLocation = $locationParsed[3];

    $transientName = 'reviews_'.$justLocation;
    
    $getTransient = get_transient($transientName);
        
    //if the transient exists
    if ($getTransient != false){

        return $getTransient;

    } else {
        
        //there's no transient so do the api call
        
        
        $response = wp_remote_get( 'https://mybusiness.googleapis.com/v4/'.$location.'/reviews?pageSize=200', array(
            'headers' => array(
                'Authorization' => 'Bearer '.$this->wp_google_review_get_access_token(),
            ),
        ));
        
 
        if(200 == wp_remote_retrieve_response_code( $response )) {

            $jsondata = json_decode($response['body'],true); 

            $reviews = $jsondata['reviews'];

            set_transient($transientName,$reviews,DAY_IN_SECONDS*1);
            
            return $reviews;

        } else {
            
            return 'ERROR';
            
        }
        
    }



}
	

function wp_google_review_get_place($location) {

    if($location == ''){
        return 'ERROR';
    }

    //parse location
    $locationParsed = explode('/',$location);
    $justLocation = $locationParsed[3];

    $transientName = 'place_'.$justLocation;
   
    $getTransient = get_transient($transientName);
        
    //if the transient exists
    if ($getTransient != false){

        return $getTransient;

    } else {
        
        //there's no transient so do the api call
        
        $response = wp_remote_get( 'https://mybusiness.googleapis.com/v4/'.$location, array(
            'headers' => array(
                'Authorization' => 'Bearer '.$this->wp_google_review_get_access_token(),
            ),
        ));
        
        if(200 == wp_remote_retrieve_response_code( $response )) {

            $jsondata = json_decode($response['body'],true);
            $place = $jsondata;

            set_transient($transientName,$place,DAY_IN_SECONDS*1);
            
            return $place;

        } else {
            
            return 'ERROR';
            
        }
        
    }



}
	
	
	
	
	
	
	
	function create_plugin_database_table()

	{

		global $table_prefix, $wpdb;



		$tblname = 'wp_google_review_list';

		$wp_track_table = $table_prefix . "$tblname";



		#Check to see if the table exists already, if not, then create it



		if($wpdb->get_var( "show tables like '$wp_track_table'" ) != $wp_track_table) 

		{
			
			$sql = "CREATE TABLE `". $wp_track_table . "` ( ";

			$sql .= "  `id`  int(11)  NOT NULL AUTO_INCREMENT, ";

			$sql .= "  `rating`  varchar(200)   NOT NULL, ";

			$sql .= "  `date`  TIMESTAMP  NOT NULL DEFAULT CURRENT_TIMESTAMP, ";

			$sql .= "  `author_name`  varchar(200)   NOT NULL, ";

			$sql .= "  `relative_time_description`  varchar(200) , ";

			$sql .= "  `time`  varchar(200) , ";
			
			$sql .= "  `place_id`  varchar(200) , ";
			
			$sql .= "  `business_name`  varchar(200) , ";
			
			$sql .= "  `hash`  varchar(200) , ";
			
			$sql .= "  `review_type`  varchar(200) , ";

			$sql .= "  `author_url`  varchar(200) , ";
			
			$sql .= "  `site`  varchar(200) , ";

			$sql .= "  `text`  TEXT, "; 

			$sql .= "  `status` ENUM('0', '1')  NOT NULL DEFAULT '0', "; 

			$sql .= "  `review_enable`  varchar(200) , ";

			$sql .= "  `profile_photo_url`  varchar(200) , ";			

			$sql .= "  PRIMARY KEY `id` (`id`) "; 

			$sql .= ") ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ; "; 
			

			require_once( ABSPATH . '/wp-admin/includes/upgrade.php' );

			dbDelta($sql);

		}

		
		

	}


	function save_review() {

		global $wpdb,$table_prefix; // this is how you get access to the database

	

		$str = $_POST['review_enable'];

		if(!empty($str)){
		
		$str=explode("-",$str);

		 $wpdb->update($wpdb->prefix . 'wp_google_review_list', array(
                    'review_enable' => $str['1']
			), array('id' => $str['0']));

		echo json_encode(array('status'=>'1'));

		die;

		}

		echo json_encode(array('status'=>'0'));

		die;
}

	
	// class instance

	static $instance;



	// activity_log WP_List_Table object

	public $activity_logs_obj;



	public static function set_screen( $status, $option, $value ) {

		return $value;

	}


function google_review_archive_template( $archive_template ) {
     global $post;
     if ( is_post_type_archive ('google_rcount' ) ) {
	
        $archive_template =  $this->_plugin_dir . '/library/wp_google_review_template.php';
     }
	  if ( is_post_type_archive ('google_rconnect' ) ) {
	
        $archive_template =  $this->_plugin_dir . '/library/wp_google_review_account_template.php';
     }
	 
     return $archive_template;
}
	/**

	 * Plugin settings page

	 */

	public function plugin_settings_page() {

			
		?>

		<style>

		#poststuff #post-body.columns-2{

		 margin-right: 0px;

		 }

		</style>

		<div class="wrap">

			<h2>Google Reviews</h2>
			
			<div id="poststuff">

				<div id="post-body" class="metabox-holder columns-2">

					<div id="post-body-content">

					<a href="?page=wp_google_review_add" class="button-primary" style="margin-left:20px;float:right" title="Add Review">Add Review </a>
						<div class="meta-box-sortables ui-sortable">

						<?php
							
								$this->activity_logs_obj->views();

						?>

						
							<form method="post">

							<input type="hidden" name="page" value="<?= esc_attr($_REQUEST['page']) ?>"/>
								<?php

								$this->activity_logs_obj->prepare_items();
								$this->activity_logs_obj->search_box( __( 'Search' ), 'search-box-id' );
								$this->activity_logs_obj->display(); ?>


							</form>

						</div>

					</div>

				</div>

				<br class="clear">

			</div>

		</div>

	<?php

	}



	/**

	 * Screen options

	 */

	public function screen_option() {



		$option = 'per_page';

		$args   = array(

			'label'   => 'Google Review',

			'default' => 10,

			'option'  => 'activity_logs_per_page'

		);



		add_screen_option( $option, $args );



		$this->activity_logs_obj = new Google_Review_Activity_log_List();

	}





	/** Singleton instance */

	public static function get_instance() {

		if ( ! isset( self::$instance ) ) {

			self::$instance = new self();

		}



		return self::$instance;

	}

}


$woiii = new FISAACGREVIEW_WOI();

// upload image



if ( ! class_exists( 'WP_List_Table' ) ) {

	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );

}



class Google_Review_Activity_log_List extends WP_List_Table {



	/** Class constructor */

	public function __construct() {



		parent::__construct( array(

			'singular' => __( 'Google Review', 'sp' ), //singular name of the listed records

			'plural'   => __( 'Google Reviews', 'sp' ), //plural name of the listed records

			'ajax'     => false //does this table support ajax?

		) );



	}



	

	protected function get_views() { 
		global $wpdb;
		  $views = array();
			if((isset($_GET['action'])&&$_GET['action']!='view')||!isset($_GET['action']) ){
				$current = ( !empty($_REQUEST['customvar']) ? $_REQUEST['customvar'] : 'all');

			$tblname = 'wp_google_review_list';

			$wp_track_table = $wpdb->prefix . "$tblname";

		   //All link
		   $sql = "SELECT COUNT(id) FROM $wp_track_table where status='0'";
		   if ( ! empty( $_REQUEST['s'] ) ) {
			$sql .= ' and ( rating like "%' . esc_sql( $_REQUEST['s'] ).'%" or author_name like "%' . esc_sql( $_REQUEST['s'] ).'%" or relative_time_description like "%' . esc_sql( $_REQUEST['s'] ).'%" or text like "%' . esc_sql( $_REQUEST['s'] ).'%" or time like "%' . esc_sql( $_REQUEST['s'] ).'%" date like "%' . esc_sql( $_REQUEST['s'] ).'%" ) ';
			}
			$all_cnt=$wpdb->get_var( $sql );
		   $class = ($current == 'all' ? ' class="current"' :'');

		   $all_url = remove_query_arg('customvar');

		   $views['all'] = "<a href='{$all_url }' {$class} >All ($all_cnt)</a>";



		   //Trash link
			$sql = "SELECT COUNT(id) FROM $wp_track_table where status='1'";
			if ( ! empty( $_REQUEST['s'] ) ) {
			$sql .= ' and ( rating like "%' . esc_sql( $_REQUEST['s'] ).'%" or author_name like "%' . esc_sql( $_REQUEST['s'] ).'%" or relative_time_description like "%' . esc_sql( $_REQUEST['s'] ).'%" or text like "%' . esc_sql( $_REQUEST['s'] ).'%" or time like "%' . esc_sql( $_REQUEST['s'] ).'%" date like "%' . esc_sql( $_REQUEST['s'] ).'%" ) ';
			}
			$trash_cnt=$wpdb->get_var( $sql );
		   $trash_url = add_query_arg('customvar','trash');

		   $class = ($current == 'trash' ? ' class="current"' :'');

		   $views['trash'] = "<a href='{$trash_url}' {$class} >Trash ($trash_cnt)</a>";



		   return $views;
			}
			return '';
	}



	/**

	 * Retrieve activity_logs data from the database

	 *

	 * @param int $per_page

	 * @param int $page_number

	 *

	 * @return mixed

	 */

	public static function get_activity_logs( $per_page = 10, $page_number = 1 ) {



		global $wpdb;

		$tblname = 'wp_google_review_list';

		$wp_track_table = $wpdb->prefix . "$tblname";

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$trash ='1';

		}else{

			$trash ='0';

		}

		$sql = "SELECT * FROM $wp_track_table where status='$trash' ";

		if ( ! empty( $_REQUEST['s'] ) ) {
			$sql .= ' and ( rating like "%' . esc_sql( $_REQUEST['s'] ).'%" or author_name like "%' . esc_sql( $_REQUEST['s'] ).'%" or relative_time_description like "%' . esc_sql( $_REQUEST['s'] ).'%" or text like "%' . esc_sql( $_REQUEST['s'] ).'%" or time like "%' . esc_sql( $_REQUEST['s'] ).'%" date like "%' . esc_sql( $_REQUEST['s'] ).'%" ) ';
			}

		if ( ! empty( $_REQUEST['orderby'] ) ) {

			$sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );

			$sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' ASC';

		}else{

			$sql .= ' ORDER BY date Desc';

		}



		$sql .= " LIMIT $per_page";

		$sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;





		$result = $wpdb->get_results( $sql, 'ARRAY_A' );

		//$sql1 = "SELECT * FROM $wp_track_table ";

		//$result1 = $wpdb->get_results( $sql1, 'ARRAY_A' );

		//print_r($result1);

		return $result;

	}





	/**

	 * Delete a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function delete_activity_log( $id ) {

		global $wpdb;

		$tblname = 'wp_google_review_list';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->delete(

				"$wp_track_table",

				array( 'id' => $id ),

				array( '%d' )

			);

		}

	}

	

	/**

	 * Trash a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function trash_activity_log( $id ) {

		global $wpdb;

		$tblname = 'wp_google_review_list';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->update(

				"$wp_track_table",

				array( 'status' => '1' ),

				array( 'id' => $id )

			);

		}

	}

	

	/**

	 * Restore a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function restore_activity_log( $id ) {

		global $wpdb;

		$tblname = 'wp_google_review_list';

		$wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		if($data){

			$wpdb->update(

				"$wp_track_table",

				array( 'status' => '0' ),

				array( 'id' => $id )

			);

		}

	}

	

	/**

	 * Delete a activity_log record.

	 *

	 * @param int $id activity_log ID

	 */

	public static function view_activity_log( $id ) {

		global $wpdb;

		$tblname = 'wp_google_review_list';

		 $wp_track_table = $wpdb->prefix . "$tblname";

		$data = $wpdb->get_results("SELECT * FROM $wp_track_table where id=$id");

		 
		if($data){

		?>

		<h1>Detail View</h1>

		<table  class="form-table">

			<tbody>

				<tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="review_enable">Review Enable</label>

                            </th>

                            <td class="forminp">
								<label class="google_review_switches">
								  <input type="checkbox" name="review_enable" id="<?php echo $data[0]->id;?>" value="1" onclick="wp_save_google_review_data(this,'<?php echo admin_url('admin-ajax.php'); ?>');" <?php if($data[0]->review_enable=='1'){echo "checked";}?>>
								   <span class="slider round"><span class="slider-text" >ON</span><span class="slider-text-off" >OFF</span></span>
								</label>
							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="profile_photo_url">Profile Photo Url</label>

                            </th>

                            <td class="forminp">
<img onerror="if(this.src!='https://lh3.googleusercontent.com/-8hepWJzFXpE/AAAAAAAAAAI/AAAAAAAAAAA/I80WzYfIxCQ/s64-c/114307615494839964028.jpg')this.src='https://lh3.googleusercontent.com/-8hepWJzFXpE/AAAAAAAAAAI/AAAAAAAAAAA/I80WzYfIxCQ/s64-c/114307615494839964028.jpg';" alt="Sanjay Kr Choubey" style="width:100px" src="<?php echo $data[0]->profile_photo_url;?>">
								

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="author_url">Author Url</label>

                            </th>

                            <td class="forminp">

								<a href="<?php echo $data[0]->profile_photo_url;?>" target="_blank"><?php echo $data[0]->author_url;?></a>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="author_name">Author Name</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->author_name;?>

							</td>

                 </tr>

				 

				    <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="text">Text</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->text;?>

							</td>

                 </tr>

				 

				  <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="time">Time</label>

                            </th>

                            <td class="forminp">

								<?php echo date("m-d-Y",$data[0]->time);?>

							</td>

                 </tr>

				

				 

				 

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="relative_time_description">Relative Time Description</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->relative_time_description;?>

							</td>

                 </tr>

				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="rating">Rating</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->rating;?>

							</td>

                 </tr>
				 
				 
				 <tr valign="top">

                            <th scope="row" class="titledesc">

                                <label for="rating">Business Name</label>

                            </th>

                            <td class="forminp">

								<?php echo $data[0]->business_name;?>

							</td>

                 </tr>



					</tbody>

  		</table>

		<?php

		}else{

			echo "No Records Found";

		}

		die;

	}

	

	/**

	 * Returns the count of records in the database.

	 *

	 * @return null|string

	 */

	public static function record_count() {

		global $wpdb;

		$tblname = 'wp_google_review_list';

		$wp_track_table = $wpdb->prefix . "$tblname";

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$trash ='1';

		}else{

			$trash ='0';

		}

		$sql = "SELECT COUNT(id) FROM $wp_track_table where status='$trash'";



		return $wpdb->get_var( $sql );

	}





	/** Text displayed when no activity_log data is available */

	public function no_items() {

		_e( 'No Google Reviews Available.', 'sp' );

	}





	/**

	 * Render a column when no column specific method exist.

	 *

	 * @param array $item

	 * @param string $column_name

	 *

	 * @return mixed

	 */

	public function column_default( $item, $column_name ) {

		switch ( $column_name ) {

			case 'id':

			case 'rating':

			case 'date':
			
			case 'business_name':
			
			case 'review_type':
							
			case 'author_url':

			case 'profile_photo_url':
			
			case 'author_name':

				return $item[ $column_name ];

			case 'time':
				if($item[ $column_name ]){
					return date("m-d-Y",$item[ $column_name ]);
				}else{
					return '';
				}	
			case 'text':

				if($item[ $column_name ]){

					$detail_comment=substr($item[ $column_name ],0,20);

					$detail_comment.=((strlen($item[ $column_name ])>20)?"...":'');

					return $detail_comment;

				}else{

					return '';

				}	
			case 'review_enable':

					$review_enable=$item[ $column_name ];
					$checked= "";
					$url=admin_url('admin-ajax.php');
			if($review_enable=='1'){$checked= "checked";}
			return '<label class="google_review_switches"><input type="checkbox" name="review_enable" id="'.$item[ 'id' ].'" onclick="wp_save_google_review_data(this,\''.$url.'\');"value="1" '.$checked.'><span class="slider round"><span class="slider-text" >ON</span><span class="slider-text-off" >OFF</span></span></label>';
			
			default:

				return print_r( $item, true ); //Show the whole array for troubleshooting purposes

		}

	}


	/**

	 * Render the bulk edit checkbox

	 *

	 * @param array $item

	 *

	 * @return string

	 */

	function column_cb( $item ) {

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			return sprintf(

			'<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']

			);

		}else{

			return sprintf(

				'<input type="checkbox" name="bulk-trash[]" value="%s" />', $item['id']

			);

		}

	}





	/**

	 * Method for name column

	 *

	 * @param array $item an array of DB data

	 *

	 * @return string

	 */

	function column_author_name( $item ) {

	

		$title = '<strong>' . $item['author_name'] . '</strong>';

		if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

			$delete_nonce = wp_create_nonce( 'sp_delete_activity_log' );

			$actions = array(

			'restore'      => sprintf('<a href="?page=%s&action=%s&activity_log=%s">Restore</a>',esc_attr($_REQUEST['page']),'restore',absint($item['id'])),

			'delete' => sprintf( '<a href="?page=%s&action=%s&activity_log=%s&_wpnonce=%s" onclick="return confirm(\'Are you sure to delete this record\');">Delete Permamently</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )

		);

		}else{

			$trash_nonce = wp_create_nonce( 'sp_trash_activity_log' );

			$actions = array(

			'edit'      => sprintf('<a href="?page=wp_google_review_add&review_id=%s">Edit</a>',absint($item['id'])),
			'view'      => sprintf('<a href="?page=%s&action=%s&activity_log=%s">View</a>',esc_attr($_REQUEST['page']),'view',absint($item['id'])),

			'trash' => sprintf( '<a href="?page=%s&action=%s&activity_log=%s&_wpnonce=%s">Trash</a>', esc_attr( $_REQUEST['page'] ), 'trash', absint( $item['id'] ), $trash_nonce )

		);

		}

		



		return $title . $this->row_actions( $actions );

	}





	/**

	 *  Associative array of columns

	 *

	 * @return array

	 */

	function get_columns() {

		$columns = array(

			'cb'      => '<input type="checkbox" />',

			//'id'    => __( 'ID', 'sp' ),

			'author_name' => __( 'Author Name', 'sp' ),

			'rating'    => __( 'Rating', 'sp' ),

			//'business_name'    => __( 'Business Name', 'sp' ),

			'time'    => __( 'Time', 'sp' ),

			'review_enable' => __( 'Review Enable', 'sp' ),

			'review_type' => __( 'Review Type', 'sp' ),

			'date' => __( 'Date', 'sp' ),

		);

		return $columns;

	}


	


	/**

	 * Columns to make sortable.

	 *

	 * @return array

	 */

	public function get_sortable_columns() {

		$sortable_columns = array(

			'id' => array( 'id', true ),

			'author_name' => array( 'author_name', false ),
			
			//'business_name' => array( 'business_name', false ),

			'date' => array( 'date', false ),
			
			'review_type' => array( 'review_type', false ),

			'rating' => array( 'rating', false )

		);



		return $sortable_columns;

	}



	/**

	 * Returns an associative array containing the bulk action

	 *

	 * @return array

	 */

	public function get_bulk_actions() {

	if (! empty( $_REQUEST['customvar'] ) && $_REQUEST['customvar']=='trash' ) {

		$actions = array(

			'bulk-delete' => 'Move to Delete'

		);

	}else{

		$actions = array(

			'bulk-trash' => 'Move to Trash'

		);

	}

		return $actions;

	}





	/**

	 * Handles data query and filter, sorting, and pagination.

	 */

	public function prepare_items() {



		$this->_column_headers = $this->get_column_info();



		/** Process bulk action */

		$this->process_bulk_action();



		$per_page     = $this->get_items_per_page( 'activity_logs_per_page', 10 );

		$current_page = $this->get_pagenum();

		$total_items  = self::record_count();



		$this->set_pagination_args( array(

			'total_items' => $total_items, //WE have to calculate the total number of items

			'per_page'    => $per_page //WE have to determine how many items to show on a page

		) );



		$this->items = self::get_activity_logs( $per_page, $current_page );

	}



	public function process_bulk_action() {

		

		if ( 'view' === $this->current_action() ) {

			if ( isset($_GET['activity_log']) && !empty($_GET['activity_log']) && $_GET['action']=='view' ) {

				self::view_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

		               // wp_redirect( esc_url_raw(add_query_arg()) );

				exit;

			}

		}	

		//Detect when a bulk action is being triggered...

		if ( 'trash' === $this->current_action() ) {



			// In our file that handles the request, verify the nonce.

			$nonce = esc_attr( $_REQUEST['_wpnonce'] );

			

			if ( ! wp_verify_nonce( $nonce, 'sp_trash_activity_log' ) ) {

				die( 'Go get a life script kiddies' );

			}

			else {

				self::trash_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			}



		}

		//Detect when a bulk action is being triggered...

		if ( 'restore' === $this->current_action() ) {



			

				self::restore_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			



		}

		

		// If the trash bulk action is triggered

		if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-trash' )

		     || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-trash' )

		) {



			$trash_ids = esc_sql( $_POST['bulk-trash'] );



			// loop over the array of record IDs and trash them

			foreach ( $trash_ids as $id ) {

				self::trash_activity_log( $id );



			}



			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		        // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

			exit;

		}

		

		//Detect when a bulk action is being triggered...

		if ( 'delete' === $this->current_action() ) {



			// In our file that handles the request, verify the nonce.

			$nonce = esc_attr( $_REQUEST['_wpnonce'] );

			

			if ( ! wp_verify_nonce( $nonce, 'sp_delete_activity_log' ) ) {

				die( 'Go get a life script kiddies' );

			}

			else {

				self::delete_activity_log( absint( $_GET['activity_log'] ) );



		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		                // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

				exit;

			}



		}

		// If the delete bulk action is triggered

		if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )

		     || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )

		) {



			$delete_ids = esc_sql( $_POST['bulk-delete'] );



			// loop over the array of record IDs and delete them

			foreach ( $delete_ids as $id ) {

				self::delete_activity_log( $id );



			}



			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"

		        // add_query_arg() return the current url

						$r_url=explode("&",add_query_arg());

						if(!empty($r_url[0])){

							wp_redirect( esc_url_raw($r_url[0]) );

						}

			exit;

		}

		

	}



}



