<?php
	//print_r($wpct);
	if(isset($_GET['Period'])){
		switch($_GET['Period']){
			case "today":
				$start_time = date('Y-m-d');
				$title_period = "Today";
				break;
			case "yesterday":
				$start_time = date('Y-m-d', strtotime('yesterday'));
				$title_period = "Yesterday";
				break;
			case "current_month":
				$start_time = date('Y-m-01');
				$title_period = "Current Month";
				break;
			case "last_month":
				$start_time = date('Y-m-01', strtotime('last month'));
				//$_GET['endDate'] = date('Y-m-d', strtotime('last day of ')'
				$title_period = "Last Month";
				break;
		}
		
	} elseif(isset($_GET['startDate'])){
		$start_time = date('Y-m-d', strtotime($_GET['startDate']));
		$title_period = $_GET['startDate'] . " - " . $_GET['endDate'];
	} else {
		$start_time = date('Y-m-01');
		$title_period = "Current Month";
	}
	
	$Number = $_GET['PhoneNumberReport'];
	
	//get sid/token
	$i = array_search($Number, $wpct['wpct']['twilio_number']);
	$lead_seconds = $wpct['wpct']['lead_seconds'][$i];
	
	$sid = $wpct['wpct']['twilio_sid'][$i];
	$token = $wpct['wpct']['twilio_token'][$i];
	
		$friendly_name = wpct::get_friendly_name($sid, $token, $Number);
		$url = sprintf('https://%s:%s@api.twilio.com/2010-04-01/Accounts/%s/Calls?Status=completed&pagesize=1000&To=%s', $sid, $token, $sid, $Number);
		//echo $url;
		if($start_time)
			$url .= "&StartTime>=".$start_time;
		//echo $url."<br />";
		$data = wpct::curl_operation($url);
		$calls = json_decode(json_encode((array) simplexml_load_string($data)),1);
		//print_r($calls);
		
		$call_count = 0;
		$lead_count = 0;
		if($calls['Calls']['@attributes']['total'] > 1){
			foreach($calls['Calls']['Call'] as $call){
				$date = date("Y-m-d", strtotime($call['StartTime']));
				if($_GET['endDate'] != ''){
					if(strtotime($call['StartTime']) < strtotime($_GET['endDate'])){
						$call_details[] = $call;
						$dates[$date]['calls']++;
						if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
							$dates[$date]['leads']++;
					}
				} else {
					$call_details[] = $call;
					$dates[$date]['calls']++;
					if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
						$dates[$date]['leads']++;
				}
			}
		} elseif($calls['Calls']['@attributes']['total'] == 1) {
			$call = $calls['Calls']['Call'];
			$date = date("Y-m-d", strtotime($call['StartTime']));
			if($_GET['endDate'] != ''){
				if(strtotime($call['StartTime']) < strtotime($_GET['endDate'])){
					$call_details[] = $call;
					$dates[$date]['calls']++;
					if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
						$dates[$date]['leads']++;
				}
			} else {
				$call_details[] = $call;
				$dates[$date]['calls']++;
				if($call['Duration'] >= $wpct['wpct']['lead_seconds'][$i])
					$dates[$date]['leads']++;
			}
		}
		//$rows[] = sprintf('["%s", %d, %d]', $friendly_name, $call_count, $lead_count);
		//$dates = array_reverse($dates);
		
		$i = 0;
		$current_time = strtotime($start_time);
		$end_time = $_GET['endDate'] != '' ? strtotime($_GET['endDate']) : time();
		
		while(true){
			$date = date("Y-m-d", $current_time);
			$dates[$date]['date'] = $date;
			//echo "Set $date\n";
			$current_time += 86400;	//one day
			$i++;
			//echo "i: $i\n";
			if($i>1000)
				break;
			if($current_time > $end_time)
				break;
		}
		ksort($dates);
		//print_r($dates);
		foreach($dates as $key => $val){
			$rows[] = sprintf('["%s", %d, %d]', $key, $val['calls'], $val['leads']);
		}
	
		
	$js_columns = "['Date', 'Calls', 'Leads']";
	//$rows = array_reverse($rows);
	$js_rows = implode(",", $rows);
?>

<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript">
	//google.load('visualization', '1.0', {'packages':['corechart']});
	google.load('visualization', '1', {packages: ['charteditor']}); 
	google.setOnLoadCallback(drawChart);
	var wrapper;
	var data = [ <?php echo $js_columns; ?>,
				 <?php echo $js_rows; ?>]
	var chartType = 'ColumnChart';
	
	function drawChart() {
		wrapper = new google.visualization.ChartWrapper({
          chartType: chartType,
          dataTable: data,
          options: {title: 'WpCallTracker Calls/Leads - <?php echo $friendly_name; ?> (<?php echo $title_period; ?>)',
		  			vAxis: {title: "Calls/Leads"},
            		hAxis: {title: "Date"}},
          containerId: 'chart_div'
        });
        wrapper.draw();
		
		//google.visualization.events.addListener(wrapper, 'select', selectHandler);
	}
	
	jQuery(function(){
		jQuery(".datepicker").datepicker({
            showOtherMonths: true,
            selectOtherMonths: true,
			showButtonPanel: true
        });
		
		jQuery("#go").click(function(e){
			e.preventDefault();
			var url = "?page=wpct_options&PhoneNumberReport=<?php echo $Number; ?>&startDate="+jQuery("#startDate").val()+"&endDate="+jQuery("#endDate").val();
			window.location = url;
		});
		
		jQuery("a.block").click(function(){
			ajaxurl = '<?php echo admin_url()."admin-ajax.php?action=wpct_block"; ?>&number='+jQuery(this).attr("block");
			jQuery.get(ajaxurl, function(data){
				
			});
			jQuery(this).parent().addClass('blocked');
		});
		
		jQuery("a.unblock").click(function(){
			ajaxurl = '<?php echo admin_url()."admin-ajax.php?action=wpct_unblock"; ?>&number='+jQuery(this).attr("unblock");
			jQuery.get(ajaxurl, function(data){
				
			});
			jQuery(this).parent().removeClass('blocked');
		});
		
	});
	
</script>
<div id="dialog" class="hide"></div>
<style>
	.blocked { text-decoration:line-through; }
</style>
    <?php
	$height = $options_page ? '500px' : '250px';
	?>
    <div style="text-align:right;">
    	<a href="?page=wpct_options&Period=today&PhoneNumberReport=<?php echo $Number; ?>">Today</a> | 
        <a href="?page=wpct_options&Period=yesterday&PhoneNumberReport=<?php echo $Number; ?>">Yesterday</a> | 
        <a href="?page=wpct_options&Period=current_month&PhoneNumberReport=<?php echo $Number; ?>">This Month</a> | 
        <a href="?page=wpct_options&Period=last_month&PhoneNumberReport=<?php echo $Number; ?>" style="margin-right:40px;">Last Month</a>
        
        Start <input type="text" name="startDate" id="startDate" class="datepicker" value="<?php echo $_GET['startDate']; ?>" />
        End <input type="text" name="endDate" id="endDate" class="datepicker" value="<?php echo $_GET['endDate']; ?>" />
        <button id="go">Go</button>
    </div>
    <div id="chart_div" style="height:<?php echo $height; ?>;"></div>
    <div id="call_details">
    	<pre>
        	<?php //print_r($call_details); ?>
        </pre>
        
        <h3>Call Details</h3>
    
		<table class="widefat fixed" cellspacing="0">
        	<thead>
            	<tr>
                    <th class="manage-column column-columnname" scope="col">Date/Time</th>
                    <th class="manage-column column-columnname" scope="col">From</th>
                    <th class="manage-column column-columnname" scope="col">Duration</th>
                    <th class="manage-column column-columnname" scope="col">Recording</th>
                </tr>
            </thead>
            <tbody>
            	 <?php
				 	$blocked = get_option("wpct_blocked");
					$blocked['base'] = 'base';
					$alternate = "alternate";
					foreach($call_details as $call){
						$style = $call['Duration'] >= $lead_seconds ? 'font-weight:bold;color:#00FF00;' : '';
						printf('<tr class="%s" style="%s">', $alternate, $style);
						printf('<td class="column-columnname" style="%s">%s</td> ', $style, $call['DateCreated']);
						if(array_key_exists(trim(str_replace('+', '', $call['From'])), $blocked))
							printf('<td class="column-columnname blocked" style="%s">%s <a href="javascript:void(0);" class="unblock" unblock="%s">Un-block</a></td> ', $style, $call['FromFormatted'], $call['From']);
						else
							printf('<td class="column-columnname" style="%s">%s <a href="javascript:void(0);" class="block" block="%s">Block</a></td> ', $style, $call['FromFormatted'], $call['From']);
						printf('<td class="column-columnname" style="%s">%s</td> ', $style, $call['Duration']);
						
						$recording_url = admin_url()."admin-ajax.php?action=wpct_recording&account_sid=".$call['AccountSid']."&call_sid=".$call['Sid'];
						printf('<td class="column-columnname"><a href="%s" target="_blank">Recording</a></td> ', $recording_url);
						printf('</tr>');
						$alternate = $alternate == "alternate" ? "" : "alternate";
					}
				?>
                
            </tbody>
        </table>
                    
    </div>
    <?php
		if(!$options_page)
			echo '<div style="text-align:right;"><a href="tools.php?page=tusage_options">More...</a></div>';
	?>
