<?php
/*
Plugin Name: SMS Campaigner
Plugin URI: http://wreckingballmarketing.com
Description: Build SMS Campaigns using twilio.
Version: 1.0
Author: Wrecking Ball Marketing
Author URI: http://wreckingballmarketing.com
*/

register_activation_hook(__FILE__,'wpsm_cam::createTable');
register_uninstall_hook(__FILE__,'wpsm_cam::deletePlugin');

if(!class_exists('wpsm_cam'))
{
    class wpsm_cam{
        
        //// Create Table on activatation of plugin.
        public static function createTable(){
           global $wpdb;
           $table = $wpdb->prefix."sc_camps";
           $sql = "CREATE TABLE IF NOT EXISTS `$table` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `camp_name` varchar(255) NOT NULL,
              `k_word` varchar(255) NOT NULL,
              `camp_num` varchar(255) DEFAULT NULL,
              `unsub_msg` text NOT NULL,
              `sub_msg` text NOT NULL,
              `alrdy_msg` text NOT NULL,
              `added_date` varchar(255) NOT NULL,
              PRIMARY KEY (`id`),
              KEY `id` (`id`),
              KEY `camp_name` (`camp_name`),
              KEY `k_word` (`k_word`),
              KEY `added_date` (`added_date`),
              KEY `id_2` (`id`),
              KEY `camp_name_2` (`camp_name`),
              KEY `k_word_2` (`k_word`),
              KEY `camp_num` (`camp_num`)
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
           $wpdb->query($sql);
           $table = $wpdb->prefix."sc_subscribers";
           $sql = "CREATE TABLE IF NOT EXISTS `wp_sc_subscribers` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `camp_id` int(11) NOT NULL,
                  `sub_num` varchar(255) NOT NULL,
                  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1 for subscribe 0 of unsubscribe',
                  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  PRIMARY KEY (`id`),
                  KEY `id` (`id`),
                  KEY `camp_id` (`camp_id`),
                  KEY `sub_num` (`sub_num`),
                  KEY `added_date` (`added_date`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
                $wpdb->query($sql);
        }
        
        public static function deletePlugin(){
            global $wpdb;
            $table = $wpdb->prefix."sc_camps";
            $sql = "DROP table`$table`";
            $table = $wpdb->prefix."sc_subscribers";
            $sql = "DROP table`$table`";
            $wpdb->query($sql);
            delete_option('t_sid');
            delete_option('t_tokken');
            delete_option('apnd_msg'); 
        }
        
        public static function post_curl($url,$body,$method){
        
        if(is_array($body))
        $body=http_build_query($body); 
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 100);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        if($method == "post")
        curl_setopt($ch, CURLOPT_POST, true );
        if($method == "get")
        curl_setopt($ch, CURLOPT_HTTPGET, true ); 
        if($method=="put")
        {
             curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        
        }     
        if($method=="delete")
        {
             curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        
        }
        if($body!="")
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        
        //curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        
        $filecontents=curl_exec($ch);
        
        curl_close($ch);
        
        return $filecontents;
        
        }

        
        //// This will load the required functionality
        public static function pageURL(){
            ob_start();
            include_once("page_url.php");
            return ob_get_clean();
        }
        
        public static function campaigns(){
            include_once("campaigns.php");
        }
        
        public static function subscribers(){
            include_once("subscribers.php");
        }
        
        public static function Settings(){
            include_once("settings.php");
        }
       
        //// Adding menus in admin panel (Side Bar) 
        public static function wpsm_cam_menu(){
            add_menu_page("SMS Campaigner","SMS Campaigner","administrator","wpsmc_settings","wpsm_cam::Settings");
            add_submenu_page("wpsmc_settings","Settings","Settings","administrator","wpsmc_settings","wpsm_cam::Settings");
            add_submenu_page("wpsmc_settings","Campaigns","Campaigns","administrator","wpsmc_camps","wpsm_cam::campaigns");
            add_submenu_page("wpsmc_settings","Subscribers","Subscribers","administrator","wpsmc_subs","wpsm_cam::subscribers");
        }
        
        public static function getCurrentURL_init(){
            //@session_start();
        }
        public static function send_sms($To,$from,$body)
         {
            $sid       = get_option('t_sid');
            $token     = get_option('t_tokken');
            $apnd_text = get_option('apnd_msg');
            $url = "https://$sid:$token@api.twilio.com/2010-04-01/Accounts/$sid/Messages";
                $val = array(
                "To"=>$To,
                "From"=>$from,
                "Body"=>$body." ".$apnd_text
                );
        	$ch = curl_init(); // Initialize the curl
        	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
        	curl_setopt($ch, CURLOPT_URL, $url);  // set the opton for curl
        	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);// set the option to transfer output from script to curl
        	curl_setopt($ch, CURLOPT_POST, 1);
        	curl_setopt($ch, CURLOPT_POSTFIELDS, $val);
            $response = curl_exec($ch);
        	curl_close($ch);
          
        	return $response;
        }
        
        public static function sms_con()
        {
            //echo "yes";
            global $wpdb;
            $Body 			= trim($_REQUEST['Body']);
            $SmsSid			= $_REQUEST['SmsMessageSid'];
            $From 			= $_REQUEST['From'];
            $To				= $_REQUEST['To'];
            $req_data       = $_REQUEST;
            $table_cam = $wpdb->prefix."sc_camps";
            $table_subs = $wpdb->prefix."sc_subscribers";
            $unsub_words = array("quit",'stop');
            if($SmsSid!="")
            {
                $k_word = $Body;
                if(in_array(strtolower($k_word),$unsub_words))//unsubscriber case
                {
                    $sql = "select * from $table_subs where sub_num='$From'";
                    $sub = $wpdb->get_row($sql,ARRAY_A);
                    if(count($sub)>0)
                    {
                        $ss = "select unsub_msg from $table_cam where id=$sub[camp_id]";
                        $dd = $wpdb->get_row($ss,ARRAY_A);
                    
                        wpsm_cam::send_sms($From,$To,$dd['unsub_msg']);//sending unsubscription message
                        $wpdb->update($table_subs,array("status"=>'0'),array("sub_num"=>$From));
                    }
                }else//subscriber case
                {
                    //echo "else";
                     $sql = "select * from $table_cam where camp_num='$To' and k_word='$k_word'";
                    //echo "<br>";
                    $camp = $wpdb->get_row($sql,ARRAY_A);
                    if(count($camp)>0)
                    {
                         $sql2 = "select * from $table_subs where sub_num='$From' and camp_id='$camp[id]'";
                        //echo "<br>";
                        $sub = $wpdb->get_row($sql2,ARRAY_A);
                        if(count($sub)==0) //new subscriber to  campaign
                        {
                            $sub_data = array("sub_num"=>$From,"camp_id"=>$camp['id']);
                            $wpdb->insert($table_subs,$sub_data);
                            wpsm_cam::send_sms($From,$To,$camp['sub_msg']);//sending subscription message
                            
                        }else //already exists subscriber
                        {
                            if($sub['status']=='0')
                            {
                                $wpdb->update($table_subs,array("status"=>'1'),array("id"=>$sub['id']));
                                wpsm_cam::send_sms($From,$To,$camp['sub_msg']);//sending subscription message agin to subscriber
                            }else
                            {
                                wpsm_cam::send_sms($From,$To,$camp['alrdy_msg']);//sending subscription message
                            }
                        }
                    }
                }
            }
 
            
            die();
        }
        
        public static function SendEmail()
        {
            date_default_timezone_set("America/Chicago");
            $data = array();
            global $wpdb;
            $table = $wpdb->prefix."email_history";
            if(!filter_var($_REQUEST['email'],FILTER_VALIDATE_EMAIL))
            {
                die("2");
            }
            $custom_email_text    = get_option('wp_mover_p_custom_email_text');
            $email_sub            = get_option('wp_mover_p_email_sub');
            $from_email           = get_option('wp_mover_p_from_email'); 
            if($custom_email_text != ""){
                $custom_email_text = str_replace("%url%",$_REQUEST['page_url'],$custom_email_text);
            }else{
                $custom_email_text = $_REQUEST['page_url'];
            }
            $headers[]= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
            $headers[]= "From: <".$from_email.">" . "\r\n";
            //$headers[]= "Reply-To: ".$level[0]->up_from_email."";
            $mail = wp_mail($_REQUEST['email'],$email_sub,$custom_email_text,$headers);
            if($mail)
            {
                $data['email']       = $_REQUEST['email'];
                $data['page_url']    = $_REQUEST['page_url'];
                $data['email_text']  = $custom_email_text;
                $data['sent_date']   = date("Y-m-d H:i:s");
                
                $res = $wpdb->insert($table,$data);
                echo "1";
            }
            else
            {
                echo "0";
            }
            
            die();
        }
        public static function set_num_url($url,$val)

        {
        
            $ch = curl_init($url);
        
             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        
            curl_setopt($ch, CURLOPT_POSTFIELDS,$val);
        
            $response = curl_exec($ch);
            curl_close($ch);
            return $response;
        
        }
        public static function save_camps()
        {
            global $wpdb;
           // echo "<pre>";
            //print_r($_POST);
            //echo $wpdb->sc_camps;
            $data = $_POST;
            $numsid = $data['num_sid'];
            $sid       = get_option('t_sid');
            $token    = get_option('t_tokken');
            $cc = array("SmsUrl"=>admin_url("admin-ajax.php?action=wpsmc_sms_con"));
            $url = "https://$sid:$token@api.twilio.com/2010-04-01/Accounts/$sid/IncomingPhoneNumbers/$numsid.json";
            $table = $wpdb->prefix."sc_camps";
            
            
            $id = $data['id'];
            unset($data['id']);
            unset($data['num_sid']);
            if($id!='')
            {
                $res = $wpdb->update($table,$data,array('id'=>$id));   
                if($res)
                {
                    echo "1";
                    $respon =wpsm_cam::set_num_url($url,$cc);//setting number url
                }else
                {
                    if($wpdb->affected_rows==0)
                    {
                        echo "1";
                         $respon = wpsm_cam::set_num_url($url,$cc);//setting number url
                    }else
                    {
                        echo "0";
                    }
                    
                    
                }
            }else
            {
                //echo "yes";
                $data['added_date'] = time();
                $res = $wpdb->insert($table,$data);   
                //var_dump($res);
               // echo $wpdb->last_query;
                //echo $wpdb->print_error();
                //echo $wpdb->last_error;
                if($res)
                {
                    echo "1";
                    $respon =wpsm_cam::set_num_url($url,$cc);//setting number url
                }else
                {
                    echo "0";
                }
            }
             //echo $wpdb->last_query;
            die();
        }
        
        public static function check_word()
        {
            global $wpdb;
            $table = $wpdb->prefix."sc_camps";
            $sql = "select * from $table where k_word='$_REQUEST[kw]'";
            $res = $wpdb->get_row($sql);
            if(count($res)==0)
            {
                echo "1";
            }else
            {
                echo"0";
            }
            die();
        }
        
        public static function get_camp()
        {
            global $wpdb;
            $table = $wpdb->prefix."sc_camps";
            $sql = "select * from $table where id='$_REQUEST[id]'";
            $res = $wpdb->get_row($sql,ARRAY_A);
            if(count($res)>0)
            {
                echo json_encode($res);
            }else
            {
                 echo '{"error":"true","msg":"record not found!"}';
            }
            die();
        }
        public static function del_camp()
        {
            global $wpdb;
            $table = $wpdb->prefix."sc_camps";
            $sql = "delete from $table where id='$_REQUEST[id]'";
            $res = $wpdb->query($sql);
            if($res)
            {
                echo "1";
            }else
            {
                 echo "0";
            }
            die();
        }
        public static function load_camps()
        {
            header('content-type:application/json');
            //echo "<pre>";
            global $wpdb;
            $columns = array( 
            // datatable column index  => database column name
            	0 =>'id', 
            	1 => 'camp_name',
            	2=> 'k_word',
                3=> 'camp_num',
                4=> 'added_date',
                5=>'action'
            );  
            $requestData= $_REQUEST;
            $table = $wpdb->prefix."sc_camps";
            // getting total number records without any search
            $sql = "SELECT id,camp_name, k_word,camp_num, added_date ";
            $sql.=" FROM $table";
            $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
            $totalData = $wpdb->num_rows;
            $totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
            
            
            $sql = "SELECT id,camp_name, k_word,camp_num, added_date ";
            $sql.=" FROM $table WHERE 1=1";
            if( !empty($requestData['search']['value']) ) {   // if there is a search parameter, $requestData['search']['value'] contains search parameter
            	$sql.=" AND ( camp_name LIKE '".$requestData['search']['value']."%' ";    
            	$sql.=" OR k_word LIKE '".$requestData['search']['value']."%' ";
            
            	$sql.=" OR camp_num LIKE '".$requestData['search']['value']."%' )";
            }
            $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
            $totalFiltered = $wpdb->num_rows; // when there is a search parameter then we have to modify total number filtered rows as per search result. 
            $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
            /* $requestData['order'][0]['column'] contains colmun index, $requestData['order'][0]['dir'] contains order such as asc/desc  */	
                // echo $sql;
                //die();
                $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
               //var_dump($query);
               //$row = $query->get_results();
               //print_r($query);
                //die();
                $data = array();
                $cont = $requestData['start']+1;
                foreach( $query as $k=>$v ) {  // preparing an array
            
                    $action = '<a onclick="edit_camp('.$v['id'].')" class="button button-primary" href="javascript:;" >Edit</a> ';
                    $action .='<a onclick="del_camp('.$v['id'].')" class="button button-primary" href="javascript:;" >Delete</a>';
                	$nestedData=array(); 
                
                	$nestedData[] = $cont;
                	$nestedData[] = $v["camp_name"];
                	$nestedData[] = $v["k_word"];
                    $nestedData[] = $v["camp_num"];
                    $nestedData[] = date("Y-m-d",$v["added_date"]);
                    $nestedData[] = $action;
                	
                	$data[] = $nestedData;
                    $cont++;
                }
            


            $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

            echo json_encode($json_data);  // send data as json format
            die();
            
        }
        
         public static function load_subs()
        {
            header('content-type:application/json');
            //echo "<pre>";
            global $wpdb;
            
            if($_REQUEST['type']=='live')
            {
                $table_c = $wpdb->prefix."sc_camps cc";
                $table_s = $wpdb->prefix."sc_subscribers sub";
                    $columns = array( 
                // datatable column index  => database column name
                	0 =>'sub.id', 
                	1 => 'cc.camp_name',
                    2=> 'sub.sub_num',
                    3=> 'sub.added_date',
                   	4=> 'sub.status',
                );  
                $requestData= $_REQUEST;
                
                // getting total number records without any search
                $sql = "SELECT sub.id,cc.camp_name, ,sub.sub_num, sub.added_date ";
                $sql.=" FROM $table_c,$table_s";
                $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
                $totalData = $wpdb->num_rows;
                $totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
                
                
                $sql = "SELECT sub.id,cc.camp_name, sub.sub_num, sub.added_date,sub.status ";
                $sql.=" FROM $table_c,$table_s WHERE 1=1 AND sub.camp_id=cc.id";
                if( !empty($requestData['search']['value']) ) {   // if there is a search parameter, $requestData['search']['value'] contains search parameter
                	$sql.=" AND ( cc.camp_name LIKE '".$requestData['search']['value']."%' ";    
                	
                    $sql.=" OR sub.sub_num LIKE '".$requestData['search']['value']."%' ";
                    
                    if($requestData['search']['value']=="active")
                    {
                        //	$sql.=" OR sub.status=1";
                        $sql.=" OR sub.status=1";
                    }
                    if($requestData['search']['value']=="unsub")
                    {
                       $sql.=" OR sub.status=0";
                    }
                    
                    
                	$sql.=" OR sub.added_date LIKE '".$requestData['search']['value']."%' )";
                    
                }
            }else
            {
                $table_c = $wpdb->prefix."sc_camps";
                $table_s = $wpdb->prefix."sc_subscribers";
                $columns = array( 
            // datatable column index  => database column name
            	0 =>'id', 
            	1 =>'camp_name',
            	2 =>'sub_num',
                3 =>'added_date',
                4 =>'status',
            );  
            $requestData= $_REQUEST;
            $table = $wpdb->prefix."sc_subscribers";
            // getting total number records without any search
            $sql = "SELECT id,sub_num,added_date ";
            $sql.=" FROM $table_s";
            $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
            $totalData = $wpdb->num_rows;
            $totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
            
            
           $sql = "SELECT id,sub_num,added_date ";
            $sql.=" FROM $table_s WHERE camp_id not in(select id from $table_c)";
            if( !empty($requestData['search']['value']) ) {   // if there is a search parameter, $requestData['search']['value'] contains search parameter
            	$sql.=" AND ( sub_num LIKE '".$requestData['search']['value']."%' ";    
            	//$sql.=" OR k_word LIKE '".$requestData['search']['value']."%' ";
            
            	$sql.=" OR added_date LIKE '".$requestData['search']['value']."%' )";
            }
         
                
            }
            $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
            $totalFiltered = $wpdb->num_rows; // when there is a search parameter then we have to modify total number filtered rows as per search result. 
            $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
            /* $requestData['order'][0]['column'] contains colmun index, $requestData['order'][0]['dir'] contains order such as asc/desc  */	
                 //echo $sql;
                //die();
                $query=$wpdb->get_results($sql,ARRAY_A);// or die("error");
               //var_dump($query);
               //$row = $query->get_results();
               //print_r($query);
                //die();
                $data = array();
                $cont = $requestData['start']+1;
                foreach( $query as $k=>$v ) {  // preparing an array
                    if($_REQUEST['type']=='live')
                    {
                        $status = ($v["status"]=='1')?"Active":"Unsubscribed";
                    }else
                    {
                        $status = "Abandoned";
                	}
                    $nestedData=array(); 
                
                	$nestedData[] = $cont;
                	$nestedData[] = $v["camp_name"];
                	$nestedData[] = $v["sub_num"];
                    $nestedData[] = $v["added_date"];
                    $nestedData[] = $status;
                	
                	$data[] = $nestedData;
                    $cont++;
                }
            


            $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

            echo json_encode($json_data);  // send data as json format
            die();
            
        }
        
    }
}

//add_shortcode("getpageurl","wp_getCurrentURL::pageURL");
//load ajax camps
add_action("wp_ajax_wpsmc_camps","wpsm_cam::load_camps");
add_action("wp_ajax_nopriv_wpsmc_camps","wpsm_cam::load_camps");

add_action("wp_ajax_wpsmc_subs","wpsm_cam::load_subs");
add_action("wp_ajax_nopriv_wpsmc_subs","wpsm_cam::load_subs");

//save campaigns
add_action("wp_ajax_wpsmc_save_camps","wpsm_cam::save_camps");
add_action("wp_ajax_nopriv_wpsmc_save_camps","wpsm_cam::save_camps");
//get campaign 
add_action("wp_ajax_wpsmc_get_camp","wpsm_cam::get_camp");
add_action("wp_ajax_nopriv_wpsmc_get_camp","wpsm_cam::get_camp");

//delete campaign 
add_action("wp_ajax_wpsmc_del_camp","wpsm_cam::del_camp");
add_action("wp_ajax_nopriv_wpsmc_del_camp","wpsm_cam::del_camp");

//check keyword
add_action("wp_ajax_wpsmc_check_word","wpsm_cam::check_word");
add_action("wp_ajax_nopriv_wpsmc_check_word","wpsm_cam::check_word");

//sms controlling
add_action("wp_ajax_wpsmc_sms_con","wpsm_cam::sms_con");
add_action("wp_ajax_nopriv_wpsmc_sms_con","wpsm_cam::sms_con");


if(is_admin()){
    add_action("admin_menu","wpsm_cam::wpsm_cam_menu");
   // add_action("init","wp_getCurrentURL::getCurrentURL_init");
}
?>