CREATE TABLE IF NOT EXISTS `admin` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



CREATE TABLE IF NOT EXISTS `customers` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customer_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_audience` int(11) NOT NULL DEFAULT '0' COMMENT '0 for not 1 for yes'
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `email_pipe` (
  `id` int(11) NOT NULL,
  `to_user` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from_user` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `text_body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `response` longtext COLLATE utf8_unicode_ci NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



CREATE TABLE IF NOT EXISTS `incoming_calls` (
  `id` int(11) NOT NULL,
  `to_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `call_sid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `response` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(244) COLLATE utf8_unicode_ci NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



CREATE TABLE IF NOT EXISTS `incoming_sms` (
  `id` int(11) NOT NULL,
  `to_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `Body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `SmsSid` text COLLATE utf8_unicode_ci NOT NULL,
  `is_mms` int(11) NOT NULL COMMENT '0 for not 1 for yes',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Inbound',
  `media_urls` longtext COLLATE utf8_unicode_ci NOT NULL,
  `response` longtext COLLATE utf8_unicode_ci NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(11) NOT NULL,
  `twilio_sid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `twilio_token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `twilio_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `twilio_app_sid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fb_app_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ad_account_id` text COLLATE utf8_unicode_ci NOT NULL,
  `fb_audience_id` text COLLATE utf8_unicode_ci NOT NULL,
  `aud_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fb_app_secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fb_access_token` longtext COLLATE utf8_unicode_ci NOT NULL,
  `whisper_text` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `subs_confrim_text` longtext COLLATE utf8_unicode_ci NOT NULL,
  `fwd_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `logo_img` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `settings` ADD `email_content` LONGTEXT NOT NULL AFTER `twilio_app_sid`;

ALTER TABLE `admin` ADD PRIMARY KEY (`id`);

ALTER TABLE `customers` ADD PRIMARY KEY (`id`);

ALTER TABLE `email_pipe` ADD PRIMARY KEY (`id`);


ALTER TABLE `incoming_calls` ADD PRIMARY KEY (`id`);

ALTER TABLE `incoming_sms` ADD PRIMARY KEY (`id`);


ALTER TABLE `settings` ADD PRIMARY KEY (`id`);


ALTER TABLE `admin` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `customers` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `email_pipe` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `incoming_calls` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `incoming_sms` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `settings` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1;

ALTER TABLE `customers` ADD `notes` LONGTEXT NOT NULL AFTER `customer_number`;
ALTER TABLE `settings` ADD `wbsms_url` LONGTEXT NOT NULL AFTER `logo_img`;