<?php
class webinarjamapi
{
	public $api_key;
		
	public function __construct($api_key)
    {
		$this->api_key = $api_key;
    }

	public function api_call($url, $parameters = array()){
		$response = wp_remote_post( $url, array(
			'method' => 'POST',
			'timeout' => 45,
			'redirection' => 5,
			'httpversion' => '1.0',
			'blocking' => true,
			'headers' => array(),
			'body' => $parameters,
			'cookies' => array()
			)
		);
		return $response;		
	}

	public function get_webinars()
	{
		$url= 'https://app.webinarjam.com/api/v2/webinars';
		$response=$this->api_call($url,array('api_key' => $this->api_key));
		
		if ( is_wp_error( $response ) || empty($response['body']) ) {
		   $error_message = $response->get_error_message();
		   return false;
		} else {
		   return $response['body'];
		}
	}

	public function get_webinar($webinar_id)
	{
		$url = 'https://app.webinarjam.com/api/v2/webinar';
		$response=$this->api_call($url, array('api_key' => $this->api_key, 'webinar_id' => $webinar_id));
		
		if ( is_wp_error( $response ) || empty($response['body']) ) {
		   $error_message = $response->get_error_message();
		   return false;
		} else {
		   return $response['body'];
		}
				
	}
	
	public function add_subscriber($webinar_id, $name, $email, $schedule, $ip_address = null, $country_code = null, $phone = null)
	{
		$url = 'https://app.webinarjam.com/api/v2/register';

		$data = array('api_key' => $this->api_key,
				   'webinar_id' => $webinar_id,
				   'name' => $name,
				   'email' => $email,
				   'schedule' => $schedule);
				   
		if ($ip_address != null)
			$data['ip_address'] = $ip_address;
		
		if ($country_code != null && $phone != null)
		{
			$data['country_code'] = $country_code;
			$data['phone'] = $phone;
		}
		
		$response=$this->api_call($url, $data);
		
		if ( is_wp_error( $response ) || empty($response['body']) ) {
		   $error_message = $response->get_error_message();
		   return false;
		} else {
		   return $response['body'];
		}

	}	
}
?>