<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_ab_test_common extends leadflow {
  
  
  static function get_ab_test_type($ab_id) {
    $type = get_post_meta($ab_id, 'ab_test_type', true);
    
    if (!$type) {
      $type = false;
    }

    return $type;
  } // get_ab_test_type
  static function get_count() {
    global $wpdb;
    
    $result = get_posts(array('post_type' => 'leadflow-abtests', 
                              'posts_per_page' => '-1',
                              'post_status' => 'publish'));

    return count($result);;
  } // get_count
  
  
  static function get_details($ab_test_id) {
    global $wpdb;
    $test = get_post($ab_test_id);
    
    if ($test) {
      $tmp = get_posts(array('post_type' => 'optin-pages', 'meta_key' => '_ab-test', 'meta_value' => $test->ID, 'post_status' => 'publish'));
      $ids = '';
      if ($tmp) {
        foreach ($tmp as $optin) {
          $ids .= $optin->ID . ',';
        }
        $ids = rtrim($ids, ',');
      }
      return array('count' => sizeof($tmp), 'ids' => $ids);  
    } else {
      return false;
    }
  } // get_details
  
  static function shortcode_optin_ab($atts){
    global $wp,$optin_ID, $attached_optins;

    $out = '';
    $atts = shortcode_atts(array(
      'id' => 0,
      'position' => 'center center',
      'class' => '',
      ), $atts);

    $link = get_permalink($atts['id']);
    if (!$link) {
      return 'Wrong AB Test ID.';
    }
	
	$ab_test=get_post($atts['id']);
	$clean = true;
	
	// Get URI Base
    $uri = untrailingslashit($wp->request);

    // We have direct url
    $uri_base = '';
    $uri_slug = basename(untrailingslashit($uri));
    $uri_slug = trim($uri_slug, '/');
    if ($uri_slug) {
      $uri_slug = '/' . $uri_slug . '/';
    } else {
      $uri_slug = '/';
    }
	
	if (!empty($ab_test)) {
		if (!empty($_SESSION['leadsflow']['ab-test'][$ab_test->ID])) {
			  $found_ab = true;
		
			  if ($clean) {
				$doing_test = $uri_slug;
			  }
		
			  $currently_active_ab = $ab_test->ID;
			  $optin = $_SESSION['leadsflow']['ab-test'][$ab_test->ID];
		} else {
	
		  $optins = get_posts(array('post_type' => 'optin-pages',
			'meta_query' => array(
			  array('key' => '_ab-test',
				'value' => $ab_test->ID,
				'compare' => '=')
			),
			'orderby' => 'rand',
			'posts_per_page' => '1',
			'post_status' => 'publish'));
	
		  if (!empty($optins)) {
			  
			$found_ab = true;
			$_SESSION['leadsflow']['ab-test'][$ab_test->ID] = $optins[0]->ID;
			$optin = $optins[0]->ID;
	
			if ($clean) {
			  $doing_test = $uri_slug;
			}
	
		  } else {
			wp_die('This A/B Test does not have any OptIns attached.', get_bloginfo('name'));
		  }
		}
	}
	  
	 
	$optin_ID = $_SESSION['leadsflow']['ab-test'][$ab_test->ID];

	$out .= leadflow_optin_common::template_to_string(LF_PLUGIN_PATH . '/templates/shortcode/default.php');

    wp_enqueue_script('optin-shortcode', LF_PLUGIN_URL . '/templates/shortcode/shortcode.js', array('jquery'), '1.0', true);
	
	echo leadflow_optin_common::generate_optin_css($optin_ID);
	
    // Localize
    wp_localize_script('optin-shortcode', 'optin_style', array('css' => leadflow_optin_common::generate_optin_css($optin_ID),'skin' => leadflow_optin_common::get_skin($optin_ID)));	
    
	$attached_optins[$optin_ID]=array('type'=>'shortcode');
	leadflow_optin_enqueues::css_enqueues();
	leadflow_optin_enqueues::js_enqueues();
	
		
    return $out;
  } // shortcode_optin  
  
  static function get_all() {
    global $wpdb;
    
    $result = get_posts(array('post_type' => 'leadflow-abtests', 
                              'posts_per_page' => '-1',
                              'post_status' => 'publish',
                              'orderby' => 'title', 
                              'order' => 'ASC'));
    foreach ($result as $i => $ab_test) {
      $tmp = get_posts(array('post_type' => 'optin-pages', 'post_status' => 'publish', 'meta_key' => '_ab-test', 'meta_value' => $ab_test->ID));
      $result[$i]->optins_cnt = sizeof($tmp);
    } // for
    
    return $result;
  } // get_all

  
  // Fetch AB Tests
  static function get_ab_tests($params = array()) {
    global $wpdb;
    
    $defaults = array('type' => 'standalone', 'id' => '');
    $params = array_merge($defaults, $params);
    
    if (empty($params['id'])) {
      $result = get_posts(array('post_type' => 'leadflow-abtests',
                                'post_status' => 'publish',
                                'meta_query' => array(
                                  array('key' => 'ab_test_type', 'value' => $params['type'], 'compare' => '=')
                                ), 'posts_per_page' => '-1', 'orderby' => 'title', 'order' => 'ASC'));
    } else {
      $result = get_post($params['id']);
    }
    
    return $result;
  } // get_ab_tests
  
  
  // Fetch Post AB Test Setup
  static function get_post_ab_test($post_id = '') {
    if (empty($post_id)) {
      return false;
    } 
    
    return get_post_meta($post_id, '_ab-test', true);
  } // get_post_ab_test
  
  
} // leadflow_ab_test_common