<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
* Admin Ajax
*/

class leadflow_admin_cpt extends leadflow {

  // register post update messages
  static function update_messages() {
    add_filter('bulk_post_updated_messages', array('leadflow_admin_cpt', 'bulk_post_updated_messages'), 10, 2);
    add_filter('post_updated_messages', array('leadflow_admin_cpt', 'post_updated_messages'));
  } // update_messages


  // customize messages for custom post type
  static function bulk_post_updated_messages($messages, $count) {
    $post             = get_post();
    $post_type        = get_post_type($post);
    $post_type_object = get_post_type_object($post_type);

    $messages['leadflow-subscribers']['trashed'] = _n('%s subscriber deleted.', '%s subscribers deleted.', $count['trashed']);

    return $messages;
  } // bulk_post_updated_messages


  // customize messages for custom post type
  static function post_updated_messages($messages) {
    $post             = get_post();
    $post_type        = get_post_type($post);
    $post_type_object = get_post_type_object($post_type);

    if ($post_type == 'optin-pages') {
      $messages['optin-pages'] = array(
        0  => '',
        1  => 'OptIn Page updated. ',
        2  => 'Custom field updated.',
        3  => 'Custom field deleted.',
        4  => 'OptIn Page updated.',
        5  => isset( $_GET['revision'] ) ? sprintf( 'OptIn Page restored to revision from %s', wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => 'OptIn Page published.',
        7  => 'OptIn Page saved.',
        8  => 'OptIn Page submitted.',
        9  => sprintf(
          'OptIn Page scheduled for: <strong>%1$s</strong>.',
          date_i18n( 'M j, Y @ G:i', strtotime( $post->post_date ) )
        ),
        10 => 'OptIn Page updated.'
      );

      if ( $post_type_object->publicly_queryable ) {
        $permalink = get_permalink( $post->ID );

        $view_link = sprintf('<a href="%s">%s</a>', esc_url( $permalink ),  'View OptIn Page');
        $messages[ $post_type ][1] .= $view_link;
        $messages[ $post_type ][6] .= $view_link;
        $messages[ $post_type ][9] .= $view_link;

        $preview_permalink = add_query_arg( 'preview', 'true', $permalink );
        $preview_link = sprintf('<a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), 'Preview OptIn Page');
        $messages[ $post_type ][8]  .= $preview_link;
        $messages[ $post_type ][10] .= $preview_link;
      }
    } elseif ($post_type == 'lead-flows') {
      $messages['lead-flows'] = array(
        0  => '',
        1  => 'Lead Flow updated. ',
        2  => 'Custom field updated.',
        3  => 'Custom field deleted.',
        4  => 'Lead Flow updated.',
        5  => isset( $_GET['revision'] ) ? sprintf( 'Lead Flow restored to revision from %s', wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => 'Lead Flow published.',
        7  => 'Lead Flow saved.',
        8  => 'Lead Flow submitted.',
        9  => sprintf(
          'Lead Flow scheduled for: <strong>%1$s</strong>.',
          date_i18n( 'M j, Y @ G:i', strtotime( $post->post_date ) )
        ),
        10 => 'Lead Flow updated.'
      );

      if ( $post_type_object->publicly_queryable ) {
        $permalink = get_permalink( $post->ID );

        $view_link = sprintf('<a href="%s">%s</a>', esc_url( $permalink ),  'View Lead Flow');
        $messages[ $post_type ][1] .= $view_link;
        $messages[ $post_type ][6] .= $view_link;
        $messages[ $post_type ][9] .= $view_link;

        $preview_permalink = add_query_arg( 'preview', 'true', $permalink );
        $preview_link = sprintf('<a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), 'Preview Lead Flow');
        $messages[ $post_type ][8]  .= $preview_link;
        $messages[ $post_type ][10] .= $preview_link;
      }
    }

    return $messages;
  } // post_updated_messages


  // register custom post type
  static function register_post_types() {
    $options = get_option(LF_OPTIONS);

    if (empty($options['optin_pages_url'])) {
      $options['optin_pages_url'] = leadflow_settings::$defaults['optin_pages_url'];
    }

    if (empty($options['lead_flows_url'])) {
      $options['lead_flows_url'] = leadflow_settings::$defaults['lead_flows_url'];
    }

    if (empty($options['ab_pages_url'])) {
      $options['ab_pages_url'] = leadflow_settings::$defaults['ab_pages_url'];
    }

    $labels = array('name'               => 'OptIns',
      'singular_name'      => 'OptIn',
      'menu_name'          => 'LeadsFlow Pro',
      'name_admin_bar'     => 'OptIn',
      'add_new'            => 'Add New OptIn',
      'add_new_item'       => 'Add New OptIn',
      'new_item'           => 'New OptIn',
      'edit_item'          => 'Edit OptIn',
      'view_item'          => 'View OptIn',
      'all_items'          => 'OptIns',
      'search_items'       => 'Search Optin\'s',
      'parent_item_colon'  => 'Parent',
      'not_found'          => 'No OptIns found',
      'not_found_in_trash' => 'No OptIns found in trash');

    $args = array('labels'             => $labels,
      'description'        => 'LeadsFlow Pages',
      'public'             => true,
      'exclude_from_search'=> true,
      'publicly_queryable' => true,
      'show_ui'            => true,
      'show_in_menu'       => 'leadflow',
      'show_in_nav_menus'  => false,
      'show_in_admin_bar'  => true,
      'query_var'          => false,
      'rewrite'            => array('slug' => $options['optin_pages_url'], 'with_front' => false,
                                    'feeds' => false, 'pages' => false),
      'capability_type'    => 'post',
      'has_archive'        => false,
      'hierarchical'       => false,
      'can_export'         => true,
      'menu_position'      => 200,
      'menu_icon'          => 'dashicons-networking',
      'supports'           => array('title','slug'));

    register_post_type('optin-pages', $args);

    $labels = array('name'               => 'Lead Flows',
      'singular_name'      => 'Lead Flow',
      'menu_name'          => 'LeadsFlow Pro',
      'name_admin_bar'     => 'Lead Flow',
      'add_new'            => 'Add New Lead Flow',
      'add_new_item'       => 'Add New Lead Flow',
      'new_item'           => 'New Lead Flow',
      'edit_item'          => 'Edit Lead Flow',
      'view_item'          => 'View Lead Flow',
      'all_items'          => 'Lead Flows',
      'search_items'       => 'Lead Flow\'s',
      'parent_item_colon'  => 'Parent',
      'not_found'          => 'No Lead Flows found',
      'not_found_in_trash' => 'No Lead Flows found in trash');

    $args = array('labels'             => $labels,
      'description'        => 'Lead Flows',
      'public'             => true,
      'exclude_from_search'=> true,
      'publicly_queryable' => true,
      'show_ui'            => true,
      'show_in_menu'       => 'leadflow',
      'show_in_nav_menus'  => false,
      'show_in_admin_bar'  => true,
      'query_var'          => false,
      'rewrite'            => array('slug' => $options['lead_flows_url'], 'with_front' => false,
                                    'feeds' => false, 'pages' => false),
      'capability_type'    => 'post',
      'has_archive'        => false,
      'hierarchical'       => false,
      'can_export'         => true,
      'menu_position'      => 200,
      'menu_icon'          => 'dashicons-networking',
      'supports'           => array('title'));

    register_post_type('lead-flows', $args);

    $labels = array('name'               => 'Subscribers',
      'singular_name'      => 'Subscriber',
      'menu_name'          => 'LeadsFlow Pro',
      'name_admin_bar'     => 'OptIn',
      'add_new'            => 'Add New Subscriber',
      'add_new_item'       => 'Add New Subscriber',
      'new_item'           => 'New Subscriber',
      'edit_item'          => 'Edit Subscriber',
      'view_item'          => 'View Subscriber',
      'all_items'          => 'Subscribers',
      'search_items'       => 'Search Subscriber\'s',
      'parent_item_colon'  => 'Parent',
      'not_found'          => 'No Subscribers found',
      'not_found_in_trash' => 'No Subscribers found in trash');

    $args = array('labels'             => $labels,
      'description'        => 'LeadFlow Subscribers',
      'public'             => false,
      'exclude_from_search'=> true,
      'publicly_queryable' => true,
      'show_ui'            => true,
      'show_in_menu'       => 'leadflow',
      'show_in_nav_menus'  => false,
      'show_in_admin_bar'  => true,
      'query_var'          => false,
      'rewrite'            => false,
      'capability_type'    => 'post',
      'has_archive'        => false,
      'hierarchical'       => false,
      'can_export'         => true,
      'menu_position'      => 200,
      'menu_icon'          => 'dashicons-admin-users',
      'supports'           => array('title', 'slug', 'custom-fields'));

    register_post_type('leadflow-subscribers', $args);

    $labels = array('name'               => 'A/B Tests',
      'singular_name'      => 'A/B Test',
      'menu_name'          => 'LeadsFlow Pro',
      'name_admin_bar'     => 'A/B Tests',
      'add_new'            => 'Add New A/B Test',
      'add_new_item'       => 'Add New A/B Test',
      'new_item'           => 'New A/B Test',
      'edit_item'          => 'Edit A/B Test',
      'view_item'          => 'View A/B Tests',
      'all_items'          => 'A/B Tests',
      'search_items'       => 'Search A/B Test\'s',
      'parent_item_colon'  => 'Parent',
      'not_found'          => 'No A/B Tests found',
      'not_found_in_trash' => 'No A/B Tests found in trash');

    $args = array('labels'             => $labels,
      'description'        => 'A/B Tests',
      'public'             => true,
      'exclude_from_search'=> true,
      'publicly_queryable' => true,
      'show_ui'            => true,
      'show_in_menu'       => 'leadflow',
      'show_in_nav_menus'  => false,
      'show_in_admin_bar'  => true,
      'query_var'          => false,
      'rewrite'            => array('slug' => $options['ab_pages_url'], 'with_front' => false,
                                    'feeds' => false, 'pages' => false),
      'capability_type'    => 'post',
      'has_archive'        => false,
      'hierarchical'       => false,
      'can_export'         => true,
      'menu_position'      => 200,
      'menu_icon'          => 'dashicons-networking',
      'supports'           => array('title','slug'));

    register_post_type('leadflow-abtests', $args);

    if (get_option('lf_flush_rewrite', false) == false) {
      flush_rewrite_rules();
      update_option('lf_flush_rewrite', true);
    }
  } // register_post_types


  static function register_taxonomies() {
    $labels = array(
      'name'                       => 'Subscriber Tags',
      'singular_name'              => 'Subscriber Tag',
      'search_items'               => 'Search Tags',
      'popular_items'              => 'Popular Tags',
      'all_items'                  => 'All Tags',
      'parent_item'                => null,
      'parent_item_colon'          => null,
      'edit_item'                  => 'Edit',
      'update_item'                => 'Update',
      'add_new_item'               => 'Add New Tag',
      'new_item_name'              => 'New Tag Name',
      'separate_items_with_commas' => 'Separate tags with commas',
      'add_or_remove_items'        => 'Add or remove tags',
      'choose_from_most_used'      => 'Choose from the most used tags',
      'not_found'                  => 'No tags found.',
      'menu_name'                  => 'Subscriber Tags');

    $args = array(
      'hierarchical'          => false,
      'labels'                => $labels,
      'show_ui'               => true,
      'show_admin_column'     => true,
      'query_var'             => true,
      'rewrite'               => array('slug' => 'subscriber-tags'));

    register_taxonomy('leadflow-subscriber-tags', array('leadflow-subscribers'), $args);

    $labels = array(
      'name'                       => 'Subscriber System Tags',
      'singular_name'              => 'Subscriber System Tag',
      'search_items'               => 'Search System Tags',
      'popular_items'              => 'Popular System Tags',
      'all_items'                  => 'All System Tags',
      'parent_item'                => null,
      'parent_item_colon'          => null,
      'edit_item'                  => 'Edit',
      'update_item'                => 'Update',
      'add_new_item'               => 'Add New System Tag',
      'new_item_name'              => 'New Tag System Name',
      'separate_items_with_commas' => 'Separate system tags with commas',
      'add_or_remove_items'        => 'Add or remove system tags',
      'choose_from_most_used'      => 'Choose from the most used system tags',
      'not_found'                  => 'No system tags found.',
      'menu_name'                  => 'System Subscriber Tags');

    $args = array(
      'hierarchical'          => true,
      'labels'                => $labels,
      'show_ui'               => false,
      'show_admin_column'     => false,
      'query_var'             => true,
      'rewrite'               => array('slug' => 'subscriber-system-tags'));

    register_taxonomy('leadflow-subscriber-system-tags', array('leadflow-subscribers'), $args);

    // Setup system terms
    if (!term_exists('Optins', 'leadflow-subscriber-system-tags')) {
      wp_insert_term('Optins', 'leadflow-subscriber-system-tags');
    }

    if (!term_exists('Flows', 'leadflow-subscriber-system-tags')) {
      wp_insert_term('Flows', 'leadflow-subscriber-system-tags');
    }

    if (!term_exists('Special', 'leadflow-subscriber-system-tags')) {
      wp_insert_term('Special', 'leadflow-subscriber-system-tags');
    }

    // Stars
    if (!term_exists('Stars', 'leadflow-subscriber-system-tags')) {
      wp_insert_term('Stars', 'leadflow-subscriber-system-tags');
    }

    // Stars Children
    $star_parent = get_term_by('slug', 'stars', 'leadflow-subscriber-system-tags');
    $stars = array();

    if (!term_exists('stars-0', 'leadflow-subscriber-system-tags', $star_parent->term_id) && $star_parent) {
      for ($i = 0; $i <= 5; $i += 0.5) {
        if ($i == 1) {
          wp_insert_term($i . ' star', 'leadflow-subscriber-system-tags', array('slug' => 'stars-' . $i, 'parent' => $star_parent->term_id, 'description' => 'Automatically added system tag'));
        } else {
          wp_insert_term($i . ' stars', 'leadflow-subscriber-system-tags', array('slug' => 'stars-' . $i, 'parent' => $star_parent->term_id, 'description' => 'Automatically added system tag'));
        }
      } // for
    } // if doing insert
  } // register_taxonomies
} // leadflow_admin_cpt