<?php
/**
* LeadsFlow Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_common extends leadflow {
  // complete logic for custom URL/template
  static function send_headers() {
    global $doing_test, $currently_active_ab, $wp, $wpdb, $post, $found_ab, $optin, $preview_optin;
			
    $get_post = false;
    $doing_test = false;
    $found_ab = false;
    $optin = 0;

    // Preview
    if (!empty($wp->request)) {
      $preview_page = get_page_by_path(basename(untrailingslashit($wp->request)), OBJECT, 'page');

      if (!empty($preview_page)) {
        $settings = get_option(LF_OPTIONS, array());

        if (!empty($settings['optin_preview_page'])) {
          if ($preview_page->ID == $settings['optin_preview_page']) {
            if(isset($_GET['preview-post-id'])) $preview_optin = $_GET['preview-post-id'];
          }
        }
      }
    }

    // fix for custom URL variables
    if (isset($wp->query_vars['post_type']) && $wp->query_vars['post_type'] == 'lead-flows') {
      $flow = get_page_by_path(basename(untrailingslashit($wp->request)), OBJECT, 'lead-flows');
      if ($flow) {
        leadflow_flow_common::process_flow($flow);
        exit;
      }
    }

    // Get URI Base
    $uri = untrailingslashit($wp->request);

    // We have direct url
    $uri_slug = basename(untrailingslashit($uri));
    $uri_slug = trim($uri_slug, '/');
    if ($uri_slug) {
      $uri_slug = '/' . $uri_slug . '/';
    } else {
      $uri_slug = '/';
    }


    // catch custom flow URLs
    $flow = get_posts(array('post_type' => 'lead-flows', 'meta_key' => 'flow-custom-url', 'meta_value' => $uri_slug, 'numberposts' => 1, 'post_status' => 'publish'));
    if ($flow) {
      leadflow_flow_common::process_flow($flow[0]);
      exit;
    }

    // before uri slug check for A/B let's first check A/B tests with conditionals
    if (empty($wp->query_vars['post_type'])) {


      if (!empty($wp->query_vars['pagename'])) {
        // It's a page
        $post = get_page_by_path($wp->query_vars['pagename']);
      } elseif (!empty($wp->query_vars['name'])) {
        // It's a post
        $post = get_page_by_path($wp->query_vars['name'], OBJECT, 'post');
      }


      $conds = leadflow_optin_conditionals::get_attached_ab();

      if (!empty($conds)) {
        $found_ab = self::setup_ab_session($conds, false);
        return true;
      }

    }
	
		

    if (!$found_ab) {
      // try with a test that's already been shown
      $ab_test = get_posts(array('post_type' => 'leadflow-abtests',
        'meta_query' => array(
          'relation' => 'AND',
          array('key' => 'abtests-custom-url',
            'value' => $uri_slug,
            'compare' => '=='),
        ),
        'posts_per_page' => '1',
        'post_status' => 'publish'));

      if (!empty($ab_test) || (!empty($wp->query_vars['post_type']) && $wp->query_vars['post_type'] == 'leadflow-abtests')) {

        if (empty($ab_test)) {
          $ab_test_by_path = get_page_by_path($wp->query_vars['name'], OBJECT, 'leadflow-abtests');
          $ab_test[0] = $ab_test_by_path;
        }

        $ab_test = $ab_test[0];
        $found_ab = self::setup_ab_session($ab_test);
      }

    }

    // single page
    if (!$get_post && !$found_ab) {
      $get_post = get_posts(array('post_type' => 'optin-pages',
        'meta_key' => 'optin-custom-url',
        'meta_value' =>$uri_slug,
        'numberposts' => 1,
        'posts_per_page' => 1,
        'post_status' => 'publish'));
      $post = $get_post;
    }

    if (!empty($doing_test) || ($get_post && is_array($get_post))) {

      if (!empty($get_post)) {
        $post = $get_post[0];
      } else {
        $post = get_post($optin);
      }

      if (empty($post)) {
        wp_die('This OptIn no longer exists.', get_bloginfo('name'));
      }

      // force setup headers
      leadflow_optin_conditionals::setup_headers();

      load_template(LF_PLUGIN_PATH . 'templates/standalone/default.php');
      exit;
    }
  } // send_headers



  static function check_custom_urls_in_editor() {
   global $post;
   ?>       
   <script>
   <?php 	   
   echo 'var custom_urls_in_use=JSON.parse(\''.json_encode( leadflow_common::custom_url_print_all_urls_as_js() ).'\');'."\r\n";   
   echo 'var current_post_id='.$post->ID.';';
   ?>
   
   var custom_urls_in_use_html = '';
   function check_url_exists(value){
	   if( typeof value != 'undefined'){
		   custom_urls_in_use_html = '';
		   for(i in custom_urls_in_use){
			   if( i != current_post_id && custom_urls_in_use[i].url == value.replace(/[^a-z0-9-]+/gi, '')){
				   custom_urls_in_use_html = 'This URL is already in use by <a href="'+custom_urls_in_use[i].permalink+'">'+custom_urls_in_use[i].title+'</a>'; 
			   }
		   }
		   jQuery('#custom_url_in_use').html(custom_urls_in_use_html);
	   }
   }
   
   jQuery('#edit-slug-box').on('change', '#new-post-slug', function(){
	  check_url_exists(jQuery(this).val()); 
   });
   
   jQuery('#edit-slug-box').on('keyup', '#new-post-slug', function(){
     check_url_exists(jQuery(this).val()); 
   });
   
   jQuery('#edit-slug-box').bind("DOMSubtreeModified",function(){
      check_url_exists(jQuery('#editable-post-name').html()); 
   });
   
   
   </script>
   <div style="color:red;font-weight: bold;padding-left:10px;" id="custom_url_in_use"></div>
   <?php 	
   
  } 



  static function setup_ab_session($ab_test, $clean = true) {
    global $wp, $currently_active_ab, $doing_test, $found_ab, $optin;

    if (!is_object($ab_test)) {
      $ab_test = (object) array('ID' => key($ab_test));
    }

    // Get URI Base
    $uri = untrailingslashit($wp->request);

    // We have direct url
    $uri_base = '';
    $uri_slug = basename(untrailingslashit($uri));
    $uri_slug = trim($uri_slug, '/');
    if ($uri_slug) {
      $uri_slug = '/' . $uri_slug . '/';
    } else {
      $uri_slug = '/';
    }

    // If Session is already set
    if (!empty($_SESSION['leadsflow']['ab-test'][$ab_test->ID])) {
      $found_ab = true;

      if ($clean) {
        $doing_test = $uri_slug;
      }

      $currently_active_ab = $ab_test->ID;
      $optin = $_SESSION['leadsflow']['ab-test'][$ab_test->ID];
      return true;
    } else {

      $optins = get_posts(array('post_type' => 'optin-pages',
        'meta_query' => array(
          array('key' => '_ab-test',
            'value' => $ab_test->ID,
            'compare' => '=')
        ),
        'orderby' => 'rand',
        'posts_per_page' => '1',
        'post_status' => 'publish'));

      if (!empty($optins)) {
        $found_ab = true;
        $_SESSION['leadsflow']['ab-test'][$ab_test->ID] = $optins[0]->ID;
        $optin = $optins[0]->ID;

        if ($clean) {
          $doing_test = $uri_slug;
        }

        $currently_active_ab = $ab_test->ID;
        return true;
      } else {
        wp_die('This A/B Test does not have any OptIns attached.', get_bloginfo('name'));
      }
    }
    return false;
  } // setup_ab_sesssion


  // helper function for creating dropdowns
  static function create_select_options($options, $selected = null, $output = true) {
    $out = "\n";
    $data = '';

    if(!is_array($selected)) {
      $selected = array($selected);
    }

    if(is_array($options) && !is_array(current($options))) {
      $new = array();

      foreach ($options as $val => $label) {
        $new[] = array('val' => $val, 'label' => $label);
      }
      $options = $new;
    }

	if (!is_array($options)) {
      $options = array();
    }

    foreach ($options as $tmp) {
      $tmp['label'] = esc_html($tmp['label']);

      if (in_array($tmp['val'], $selected)) {
        $out .= "<option selected=\"selected\" value=\"" . esc_attr($tmp['val']) . "\">{$tmp['label']}</option>\n";
      } else {
        $out .= "<option value=\"" . esc_attr($tmp['val']) . "\">{$tmp['label']}</option>\n";
      }
    } // foreach

    if ($output) {
      echo $out;
    } else {
      return $out;
    }
  } // create_select_options


  static function get_lang($lang_list = false) {
    if (!$lang_list) {
      if (!isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
        return '';
      }
      $lang_list = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    }
    $languages = array();
    $languageRanges = explode(',', trim($lang_list));
    foreach ($languageRanges as $languageRange) {
      if (preg_match('/(\*|[a-zA-Z0-9]{1,8}(?:-[a-zA-Z0-9]{1,8})*)(?:\s*;\s*q\s*=\s*(0(?:\.\d{0,3})|1(?:\.0{0,3})))?/', trim($languageRange), $match)) {
        if (!isset($match[2])) {
          $match[2] = '1.0';
        } else {
          $match[2] = (string) floatval($match[2]);
        }
        if (!isset($languages[$match[2]])) {
          $languages[$match[2]] = array();
        }
        $languages[$match[2]][] = strtolower($match[1]);
      }
    } // foreach
    krsort($languages);

    if (empty($languages)) {
      return '';
    }

    $tmp = current($languages);
    return $tmp[0];
  } // get_lang


  // get subscriber tags meta
  static function get_subscriber_tags_meta($term_id, $meta_key = '') {
    if (empty($term_id)) return false;

    $term_meta = get_option('taxonomy_meta_' . $term_id);

    if ($meta_key == '') {
      return $term_meta;
    } else {
      return $term_meta[$meta_key];
    }
  } // get_subscriber_tags_meta


  static function check_plugin_updates($checked_data) {
    $plugin_slug = plugin_basename(LF_PLUGIN_PATH . '/leadsflow.php');
    $api_url = 'https://leadsflowpro.com/download/leadsflow-pro/update.php';

    if (empty($checked_data->checked)) {
      return $checked_data;
    }

    $request_string = array(
      'body' => array(
        'action' => 'basic_check',
        'plugin_version' => $checked_data->checked[$plugin_slug],
        'api-key' => md5(get_bloginfo('url'))
    ));

    $raw_response = wp_remote_post($api_url, $request_string);

    if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200)) {
      $response = unserialize($raw_response['body']);

      if (is_object($response) && !empty($response)) {
        $checked_data->response[$plugin_slug] = $response;
      }
    }

    return $checked_data;
  } // check_plugin_updates


  static function plugin_api_call($def, $action, $args) {
    $plugin_slug = 'leadsflow-pro';
    $plugin_slug_long = plugin_basename(LF_PLUGIN_PATH . '/leadsflow.php');
    $api_url = 'https://leadsflowpro.com/download/leadsflow-pro/update.php';

    if (!isset($args->slug) || ($args->slug != $plugin_slug)) {
      return false;
    }

    $plugin_info = get_site_transient('update_plugins');
    $current_version = $plugin_info->checked[$plugin_slug_long];
    $args->version = $current_version;

    $request_string = array(
      'body' => array(
        'action' => $action,
        'request' => serialize($args),
        'api-key' => md5(get_bloginfo('url'))
    ));

    $request = wp_remote_post($api_url, $request_string);

    if (is_wp_error($request)) {
      $res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p>'), $request->get_error_message());
    } else {
      $res = unserialize($request['body']);

      if (!is_object($res))
        $res = new WP_Error('plugins_api_failed', __('An unknown error has occurred'), $request['body']);
    }

    return $res;
  } // plugin_api_call


  static function trend_number_format($trend) {
    $out = '';

    if (!$trend || $trend == '0.0' || $trend == '00.0') {
      $out .= '<span class="lfp-trend">0%</span>';
    } elseif ($trend[0] == '-' || $trend < 0) {
      $trend = str_replace('-', '', $trend);
      $trend = str_replace('.0', '', $trend);
      $out .= '<span class="lfp-trend"><span class="dashicons dashicons-arrow-down-alt"></span> ' . $trend . '%</span>';
    } else {
      $trend = str_replace('.0', '', $trend);
      $out .= '<span class="lfp-trend"><span class="dashicons dashicons-arrow-up-alt"></span> ' . $trend . '%</span>';
    }

    return $out;
  }


  // fetch coordinates based on the address
  static function get_coordinates($address, $force_refresh = false) {
    $address_hash = 'lf_' . md5($address);

    if ($force_refresh || ($coordinates = get_transient($address_hash)) === false) {
      $url = 'http://maps.googleapis.com/maps/api/geocode/xml?address=' . urlencode($address) . '&sensor=false';
      $result = wp_remote_get($url);

      if (!is_wp_error($result) && $result['response']['code'] == 200) {
        $data = new SimpleXMLElement($result['body']);

        if ($data->status == 'OK') {
          $cache_value['lat']     = (string) $data->result->geometry->location->lat;
          $cache_value['lng']     = (string) $data->result->geometry->location->lng;
          $cache_value['address'] = (string) $data->result->formatted_address;

          // cache coordinates for 3 months
          set_transient($address_hash, $cache_value, DAY_IN_SECONDS * 90);
          $data = $cache_value;
        } elseif (!$data->status) {
          return false;
        } else {
          return false;
        }
      } else {
        return false;
      }
    } else {
      // data is cached, get it
      $data = get_transient($address_hash);
    }

    return $data;
  } // get_coordinates


  static function merge_icons($icon_path, $usericon_path, $transparent_cutout = 'circle', $savetofolder=false, $debug = false){

    $transparent_cutout = 'circle';
    $icon_size = 108; //Width/height of base icon
    $icon_y = 14; //Offset from the top of the base icon
    $user_icon_size = 48; //Width/height of user icon
    $user_icon_x = 74; // user icon X position
    $user_icon_y = 74; // user icon Y position
    $user_icon_border = 4; // user icon border

    if(!file_exists($icon_path)){
      if($debug){
        return new WP_Error('404', 'Icon not found '. $icon_path);
      }
      return false;
    }

    if(!file_exists($usericon_path)){
      if($debug){
        return new WP_Error('404', 'User Icon not found '. $usericon_path);
      }
      return false;
    }

    $icon_pathinfo = pathinfo($icon_path);
    $size = getimagesize($icon_path);

    switch ($size['mime']) {
      case "image/gif":
        $source = imagecreatefromgif($icon_path);
        break;
      case "image/jpeg":
        $source = imagecreatefromjpeg($icon_path);
        break;
      case "image/png":
        $source = imagecreatefrompng($icon_path);
        break;
      case "image/bmp":
        $source = imagecreatefromwbmp($icon_path);
        break;
      default:
        if($debug){
          return new WP_Error('404', 'Icon '. $icon_path . ' format not valid');
        }
        return false;
        break;
    }

    $width = $size[0];
    $height = $size[1];

    $output = imagecreatetruecolor($width, $height);
    imagesavealpha($output, true);
    $transparent = imagecolorallocatealpha($output, 0, 0, 0, 127);
    imagefill($output, 0, 0, $transparent);
    imagecopyresampled( $output, $source,  0, $icon_y, 0, 0, $icon_size, $icon_size, $width, $height);

    if($transparent_cutout == 'square'){
      imagealphablending($output, false);
      imagefilledrectangle($output, 78, 78, 128, 128, $transparent);
      imagealphablending($output, true);
    } else if($transparent_cutout == 'circle') {
      imagealphablending($output, false);
      $elipse_x=$user_icon_x+($user_icon_size+$user_icon_border)/2+$user_icon_border/2;
      $elipse_y=$user_icon_y+($user_icon_size+$user_icon_border)/2+$user_icon_border/2;
      $elipse_size=$user_icon_size+$user_icon_border*2;
      if($debug){
        echo "Elipse X:".($elipse_x-$elipse_size/2)."<br />";
        echo "Elipse Y:".($elipse_y-$elipse_size/2)."<br />";
        echo "Elipse Center:".$elipse_x."/".$elipse_y."<br />";
        echo "Elipse Size:".$elipse_size."<br />";
      }
      imagefilledellipse($output, $elipse_x, $elipse_y, $elipse_size,$elipse_size, $transparent);
      imagealphablending($output, true);
    }

    $usericon_pathinfo = pathinfo($usericon_path);
    $usericon_size = getimagesize($usericon_path);

    $usericon_width = $usericon_size[0];
    $usericon_height = $usericon_size[1];

    switch ($usericon_size['mime']) {
      case "image/gif":
        $usericon_source = imagecreatefromgif($usericon_path);
        break;
      case "image/jpeg":
        $usericon_source = imagecreatefromjpeg($usericon_path);
        break;
      case "image/png":
        $usericon_source = imagecreatefrompng($usericon_path);
        break;
      case "image/bmp":
        $usericon_source = imagecreatefromwbmp($usericon_path);
        break;
      default:
        if($debug){
          return new WP_Error('404', 'User IconIcon '. $usericon_path . ' format not valid');
        }
        return false;
        break;
    }

    if($transparent_cutout == 'circle') {
      $usericon_rasterized = imagecreatetruecolor($usericon_width, $usericon_height);
      imagesavealpha($usericon_rasterized, true);
      $transparent = imagecolorallocatealpha($usericon_rasterized, 0, 0, 0, 127);
      imagefill($usericon_rasterized, 0, 0, $transparent);
      imagecopyresampled( $usericon_rasterized, $usericon_source,  0, 0, 0, 0, $usericon_width, $usericon_height, $usericon_width, $usericon_height);

      $usericon_source=$usericon_rasterized;

      if($usericon_width < $usericon_height){
        $radius=$usericon_width/2;
      } else {
        $radius=$usericon_height/2;
      }

      $q = 4;
      $radius *= $q;

      do {
        $r = rand(0, 255);
        $g = rand(0, 255);
        $b = rand(0, 255);
      } while (imagecolorexact($usericon_source, $r, $g, $b) < 0);

      $nw = $usericon_width*$q;
      $nh = $usericon_height*$q;

      $img = imagecreatetruecolor($nw, $nh);
      $alphacolor = imagecolorallocatealpha($img, $r, $g, $b, 127);
      imagealphablending($img, false);
      imagesavealpha($img, true);
      imagefilledrectangle($img, 0, 0, $nw, $nh, $alphacolor);

      imagefill($img, 0, 0, $alphacolor);
      imagecopyresampled($img, $usericon_source, 0, 0, 0, 0, $nw, $nh, $usericon_width, $usericon_height);

      imagearc($img, $radius-1, $radius-1, $radius*2, $radius*2, 180, 270, $alphacolor);
      imagefilltoborder($img, 0, 0, $alphacolor, $alphacolor);
      imagearc($img, $nw-$radius, $radius-1, $radius*2, $radius*2, 270, 0, $alphacolor);
      imagefilltoborder($img, $nw-1, 0, $alphacolor, $alphacolor);
      imagearc($img, $radius-1, $nh-$radius, $radius*2, $radius*2, 90, 180, $alphacolor);
      imagefilltoborder($img, 0, $nh-1, $alphacolor, $alphacolor);
      imagearc($img, $nw-$radius, $nh-$radius, $radius*2, $radius*2, 0, 90, $alphacolor);
      imagefilltoborder($img, $nw-1, $nh-1, $alphacolor, $alphacolor);
      imagealphablending($img, true);
      imagecolortransparent($img, $alphacolor);

      $dest = imagecreatetruecolor($usericon_width, $usericon_height);
      imagealphablending($dest, false);
      imagesavealpha($dest, true);
      imagefilledrectangle($dest, 0, 0, $usericon_width, $usericon_height, $alphacolor);
      imagecopyresampled($dest, $img, 0, 0, 0, 0, $usericon_width, $usericon_height, $nw, $nh);

      $usericon_source = $dest;
    }

    $wanted_width = $user_icon_size;
    $wanted_height = $user_icon_size;

    if(($usericon_width/$wanted_width) < ($usericon_height/$wanted_height)) {
      $wanted_width = ($usericon_width*$wanted_height)/$usericon_height;
    } else {
      $wanted_height = ($usericon_height*$wanted_width)/$usericon_width;
    }

    $x_offset=0;
    $y_offset=0;

    if( $usericon_width <= $usericon_height) {
      $x_offset = ($usericon_height - $usericon_width)/($usericon_height/$user_icon_size);
    } else {
      $y_offset = ($usericon_width - $usericon_height)/($usericon_width/$user_icon_size);
    }

    $dst_x = $user_icon_x + $user_icon_border + $x_offset/2;
    $dst_y = $user_icon_y + $user_icon_border + $y_offset/2;

    if($debug){
      echo "Icon X:".$dst_x."<br />";
      echo "Icon Y:".$dst_y."<br />";
      echo "Icon Center:".($dst_x+$wanted_width/2)."/".($dst_y+$wanted_height/2)."<br />";
    }

    imagecopyresampled( $output, $usericon_source,  $dst_x, $dst_y, 0, 0, $wanted_width, $wanted_height, $usericon_width, $usericon_height);

    if($savetofolder){
      $output_path = LF_PLUGIN_PATH . '/images/tmp-' . $icon_pathinfo['filename'] . '.png';
    } else {
      $output_path = $icon_pathinfo['filename'] . ".png";
    }

    imagepng($output, $output_path, 9);

    imagedestroy($source);
    imagedestroy($usericon_source);
    imagedestroy($output);

    $output_array = array('url' => LF_PLUGIN_URL . '/images/tmp-' . $icon_pathinfo['filename'] . '.png', 'path' => LF_PLUGIN_PATH . '/images/tmp-' . $icon_pathinfo['filename'] . '.png', 'name' => $icon_pathinfo['filename'] . '.png');
    return $output_array;
  } // merge_icons


  static function on_update_siteicon($value, $old_value) {

    // Not updated
    if ($value == $old_value) return $value;

    // Updated
    $site_icon = get_site_icon_url(256);

    $new_site_icon = stripslashes($_POST['customized']);
    $new_site_icon = json_decode($new_site_icon);
    $new_site_icon = $new_site_icon->site_icon;

    $site_icon = get_attached_file($new_site_icon);

    if (!empty($site_icon)) {
      $old_images = get_option('lf-icons');
      if (!empty($old_images)) {
        foreach ($old_images as $k => $image) {
          wp_delete_attachment($image['id'] ,true);
        }
      }

      self::merge_default_icons($site_icon);
    }

    return $value;
  } // on_update_siteicon


  static function custom_url_print_all_urls_as_js() {
	  global $wpdb;
	   
	  $urls_array=array(); 
	   
	  $custom_url_query = $wpdb->get_results( 'SELECT ID, post_title, post_name FROM '.$wpdb->prefix.'posts WHERE post_type!="leadflow-subscribers" AND post_status="publish" '); 
	  foreach($custom_url_query as $custom_url_data){
		 $urls_array[$custom_url_data->ID]=array('title'=>$custom_url_data->post_title, 'url'=>str_replace('/','',$custom_url_data->post_name), 'permalink'=>get_permalink($custom_url_data->ID) );
	  }
	  
	  $custom_url_query_meta = $wpdb->get_results( 'SELECT ID, meta_value, post_title FROM '.$wpdb->prefix.'postmeta LEFT JOIN '.$wpdb->prefix.'posts ON '.$wpdb->prefix.'posts.ID = '.$wpdb->prefix.'postmeta.post_id WHERE meta_key="flow-custom-url" OR meta_key="optin-custom-url" OR meta_key="abtests-custom-url" ' ); 
	  foreach($custom_url_query_meta as $custom_url_data){
		 $urls_array[$custom_url_data->ID]=array('title'=>$custom_url_data->post_title, 'url'=>str_replace('/','',$custom_url_data->meta_value), 'permalink'=>get_permalink($custom_url_data->ID) );
	  }
	  
	  return $urls_array;
  }


  static function custom_url_usage_check($post_ID, $type) {
    $output = array();

    $custom_url = get_post_meta($post_ID, $type . '-custom-url', true);

    if (empty($custom_url)) return false;

    $optins = get_posts(array('post_type' => 'optin-pages',
                              'meta_key' => 'optin-custom-url',
                              'meta_value' => $custom_url,
                              'post__not_in' => array($post_ID)));

    $ab_test = get_posts(array('post_type' => 'leadflow-abtests',
                               'meta_key' => 'abtests-custom-url',
                               'meta_value' => $custom_url,
                               'post__not_in' => array($post_ID)));

    $flows = get_posts(array('post_type' => 'lead-flows',
                             'meta_key' => 'flow-custom-url',
                             'meta_value' => $custom_url,
                             'post__not_in' => array($post_ID)));

    if ($optins || $ab_test || $flows) {

      if ($optins) {
        $output['type'] = 'OptIn';
        $output['found'] = '';

        foreach ($optins as $optin) {
          $output['found'] .= '<a href="' . admin_url('post.php?post=' . $optin->ID . '&action=edit') . '">' . $optin->post_title . '</a>, ';
        }

        $output['found'] = rtrim($output['found'], ', ');
      } elseif ($ab_test) {
        $output['type'] = 'A/B Test';

        $output['found'] = '';

        foreach ($ab_test as $optin) {
          $output['found'] .= '<a href="' . admin_url('post.php?post=' . $optin->ID . '&action=edit') . '">' . $optin->post_title . '</a>, ';
        }

        $output['found'] = rtrim($output['found'], ', ');
      } elseif ($flows) {
        $output['type'] = 'Flow';

        $output['found'] = '';

        foreach ($flows as $optin) {
          $output['found'] .= '<a href="' . admin_url('post.php?post=' . $optin->ID . '&action=edit') . '">' . $optin->post_title . '</a>, ';
        }

        $output['found'] = rtrim($output['found'], ', ');
      }

      return $output;
    } else {
      return false;
    }

  } // custom_url_usage_check


  static function merge_default_icons($site_icon) {
    if (empty($site_icon)) {
      $site_icon = LF_PLUGIN_PATH . '/images/default-site-icon.png';
    }

    if (!function_exists('media_sideload_image')) {
      require_once(ABSPATH . 'wp-admin/includes/image.php');
      require_once(ABSPATH . 'wp-admin/includes/file.php');
      require_once(ABSPATH . 'wp-admin/includes/media.php');
    }

    $default_images = array('bulk', 'export', 'flow', 'flow_ecommerce', 'import', 'optin');
    $optin_icons = array();

    foreach ($default_images as $k => $image) {
      $merged_image = leadflow_common::merge_icons(LF_PLUGIN_PATH . '/images/event_types/' . $image . '.png', $site_icon, true, true);

      if (!empty($merged_image['url']) && !is_wp_error($merged_image)) {
        $download['name'] = $merged_image['name'];
        $download['tmp_name'] = download_url($merged_image['url']);
        $id = media_handle_sideload($download, 0, 'LFP - Do Not Delete - ' . $image);

        if (!is_wp_error($id)) {

          // get attachment src
          $src = wp_get_attachment_url($id);

          $optin_icons[$image] = '';

          if (!is_wp_error($src)) {
            unlink($merged_image['path']);
            $optin_icons[$image]['id'] = $id;
            $optin_icons[$image]['file'] = $src;
          }
        }
      }
    }

    update_option('lf-icons', $optin_icons);
  } // merge_default_icons
} // leadflow_common