<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/


class leadflow_export extends leadflow {

  static private $export_per_call = 5;
  static private $csv_settings = array('double-quotes' => '"', 
    'single-quote' => "'",
    'comma' => ',',
    'colon' => ':',
    'semicolon' => ';',
    'tab' => "\n",
    'slash' => '\\');

  static private $default_fields = array('firstname' => '', 
    'lastname' => '', 
    'address' => '', 
    'phone' => '', 
    'notes' => '');

  // Setup Export CSV Headers
  static function export_setup_headers() {

    // Setup 
    $file = 'lf-export-' . $_POST['timestamp'] . '.txt';
    $offset = ($_POST['offset']-1);
    $export_per_call = $_POST['export_per_call'];
    $selected_users = $_POST['selected_users'];

    // Headers
    $csv_headers = array('email');

    $upload_dir = wp_upload_dir();

    // If file does not exist
    if (!file_exists($upload_dir['path'] .'/'. $file)) {
      $upload = wp_upload_bits($file, null, '');
      if (!$upload) {
        wp_send_json_error('CSV file could not be created!');
      }
    } else {
      $upload['file'] = $upload_dir['path'] .'/'. $file;
    }

    $csv = fopen($upload['file'], "a");

    // Parse WP Query
    if ($_POST['query'] != '') {
      // Query existing
      parse_str($_POST['query'], $params);

      // Fetch all subscribers
      $params['post_status'] = 'publish';
      $params['posts_per_page'] = '1';

      $subscribers = get_posts($params);

      if ($subscribers) {
        foreach ($subscribers as $sub) {

          $details = leadflow_subscribers_common::get_details($sub->ID);
          $fields = array_intersect_key($details, self::$default_fields);
          
          if (!empty($fields)) {
            foreach ($fields as $key => $default_value) {
              $csv_headers[] = $key;
            }
          }

          $csv_headers[] = 'ip';
          $csv_headers[] = 'time';
        } // foreach
      }
    } else {
      // Get only selected users
      $selected_users_array = explode(',', $selected_users);
      $subscriber = get_post($selected_users_array[0]);

      if ($subscriber) {

        $details = leadflow_subscribers_common::get_details($subscriber->ID);
        $fields = array_intersect_key($details, self::$default_fields);

        if (!empty($fields)) {
          foreach ($fields as $key => $default_value) {
            $csv_headers[] = $key;
          }
        }

        $csv_headers[] = 'ip';
        $csv_headers[] = 'time';

      } // if subscribers

    }
    fputcsv($csv, $csv_headers);
    fclose($csv);

    wp_send_json_success('headers created');
  } // export_setup_headers


  // Export CSV for Ajax Call
  static function export_csv() {    
    $file = 'lf-export-' . $_POST['timestamp'] . '.txt';
    $offset = ($_POST['offset']-1);
    $export_per_call = $_POST['export_per_call'];
    $selected_users = $_POST['selected_users'];

    $error = false;

    // get the csv file
    $upload_dir = wp_upload_dir();
    $csv_file = $upload_dir['path'] .'/'. $file;
	
	$csv_url = $upload_dir['url'] .'/'. $file;
	
	
    // Counter for inserted rows
    $exported_rows = 0;
    $skipped_rows = 0;
    $inserted_rows_callback = 0;
    $iarray = array();

    // Open the file for writing
    $csv = fopen($csv_file, "a");

    if (!$csv) {
      wp_send_json_error('CSV file does not exist or it\'s not writable.');
    }

    // Parse WP Query
    if ($_POST['query'] != '') {
      // Query existing
	  update_option('export_csv_params',$params);
      parse_str($_POST['query'], $params);

      // Fetch all subscribers
      $params['post_status'] = 'publish';
      $params['posts_per_page'] = $export_per_call;
      $params['offset'] = $offset*$export_per_call;

      $subscribers = get_posts($params);
      $total_subscribers =  count($subscribers);
      $total_selected = $total_subscribers;

      if ($subscribers) {
        foreach ($subscribers as $sub) {
          $subscriber_data = array();
          $subscriber_data[] = $sub->post_title;
			
		  	
		  $meta['ip'] = get_post_meta($sub->ID, 'ip', true);	
          $meta['time'] = $sub->post_date;	
          $details = leadflow_subscribers_common::get_details($sub->ID);
          $fields = array_intersect_key($details, self::$default_fields);
          
		 	
          if (!empty($fields)) {
            foreach ($fields as $key => $default_value) {
              $subscriber_data[] = $default_value;
            }
          }
			
		  	
          if (!empty($meta['ip'])) {
            $subscriber_data[] = $meta['ip'];
          } else {
			$subscriber_data[]='';  
		  }

          if (!empty($meta['time'])) {
            $subscriber_data[] = $meta['time'];
          } else {
			$subscriber_data[]='';  
		  }

          fputcsv($csv, $subscriber_data);
          $exported_rows++;
        }
      }
    } else {
      // Get only selected users
      $selected_users_array = explode(',', $selected_users);

      $offset = $offset*$export_per_call;
      $total_selected = count($selected_users_array);

      for ($i=0;$i<$export_per_call;$i++) {

        if ($i>=$total_selected) continue;

        $subscribers = get_post($selected_users_array[$offset+$i]);
        $total_subscribers = count($selected_users_array);

        if ($subscribers) {
          $subscriber_data = array();
          $subscriber_data[] = $subscribers->post_title;
			
			
		  $details = leadflow_subscribers_common::get_details($subscribers->ID);
          $fields = array_intersect_key($details, self::$default_fields);
          
		   	
          if (!empty($fields)) {
            foreach ($fields as $key => $default_value) {
              $subscriber_data[] = $default_value;
            }
          }	
			
          $meta['ip'] = get_post_meta($sub->ID, 'ip', true);	
          $meta['time'] = $sub->post_date;	
          
		  if (!empty($meta['ip'])) {
            $subscriber_data[] = $meta['ip'];
          } else {
			$subscriber_data[]='';  
		  }

          if (!empty($meta['time'])) {
            $subscriber_data[] = $meta['time'];
          } else {
			$subscriber_data[]='';  
		  }

          fputcsv($csv, $subscriber_data);
          $exported_rows++;
        } // if subscribers

      } // for
    }
    fclose($csv);

    wp_send_json_success(array('exported' => $exported_rows, 
                               'offset' => $offset,
                               'i-order' => $iarray,
                               'skipped' => $skipped_rows,
                               'total_selected' => $total_selected,
                               'url' => $csv_file,
							   'weburl' => $csv_url));
  } // import_csv


  static function content() {
    ini_set("auto_detect_line_endings", true);

    echo '<h2>LeadFlow Export</h2>';

    $filters = $_GET['filter-form'];
    $selected_users = $_GET['filter-selected'];

    if ($filters != '') {
      parse_str($filters, $params);

      // Fetch all subscribers
      $params['posts_per_page'] = -1;

      //$subscribers = get_posts($params);
	  $count_subscribers= wp_count_posts('leadflow-subscribers');
      $total_subscribers = $count_subscribers->publish;
	  
    } else {
      $selected_users_array = explode(',', $selected_users);
      $total_subscribers = count($selected_users_array);
    }
	
	echo '<h2>Total subscribers to export: '.$total_subscribers.'</h2><br />';
	echo 'Export Speed: <select id="export_subscribers_per_page"><option value="10">Slow (10 at a time)</option><option value="50">Fast (50 at a time)</option><option value="200">Fastest (200 at a time)</option></select><br />';
	echo '<small>Select how many subscribers should be written to the file at a time. Slower servers might not be able to handle big sets and timeout.</small>';
	echo '<br /><br />';

    // Export status
    echo '<div id="lf-export-status" style="display:none;">';

    // Current status info
    echo '<div class="lf-current-status">';
    echo '<span id="lf-exported-rows">Exported:<span></span></span>';
    echo '<span id="lf-skipped-rows">Skipped:<span></span></span>';
    echo '<span id="lf-total-rows">Total:<span></span></span>';
    echo '</div>';

    // Current Progress Info
    echo '<div class="lf-progress animate">';
    echo '<div class="lf-progress-bar"></div>';
    echo '<div class="lf-progress-text"></div>';
    echo '</div>';
	
	echo '<div class="lf-export-finished" style="display:none;"></div>';
	
    echo '</div>';

    echo '<form method="POST" action="#" name="lf-export-csv-ajax">';

    // Hidden Inputs
    echo '<input type="hidden" name="lf-subscriber-records" value="' . $total_subscribers . '" />';
    echo '<input type="hidden" name="lf-subscriber-query" value="' . $filters . '" />';
    echo '<input type="hidden" name="lf-subscriber-selected" value="' . $selected_users . '" />';
    echo '<input type="hidden" name="lf-export-per-call" value="' . self::$export_per_call . '" />';

    echo '<input type="submit" id="lf-export-data-btn" class="button button-primary" name="lf-export-flow" value="Start Export" />';
    echo '<a href="' .admin_url('edit.php?post_type=leadflow-subscribers') . '" id="lf-back-to-subscribers" class="button button-primary" style="display:none;">Back to Subscribers</a>';

    echo '</form>';


  } // content


} // leadflow_export