<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_flow_common extends leadflow {
  static $debug, $debug_output_done = false, $doing_flow_push = false, $options = array(), $start_time, $flow;


  static function get_flow_type($flow_id) {
    $type = get_post_meta($flow_id, 'flow_type', true);
    if (!$type) {
      $type = false;
    }

    return $type;
  } // get_flow_type

  static function get_flow_components($flow_id) {
    $components = get_post_meta($flow_id, 'flow_components', true);

    return $components;
  }

  static function get_flow_options($section = false, $flow_id = 0) {
    $options = get_post_meta($flow_id, LF_META, true);

    if (!$section) {
      return $options;
    } else {
      return @$options[$section];
    }
  } // get_flow_options

  static function get_special_vars($flow_id) {
    $flow_type = self::get_flow_type($flow_id);
    $out = array('_time' => date(get_option('time_format'), current_time('timestamp')),
                 '_date' => date(get_option('date_format'), current_time('timestamp')),
                 '_flow_id' => $flow_id,
                 '_flow_name' => get_the_title($flow_id),
                 '_timestamp' => time(),
                 '_rand' => rand(0, 9999),
                 '_uuid' => 0,
                 '_new' => 1);

    if ($flow_type == 'internal') {
    } elseif ($flow_type == 'ecommerce') {
      $location = leadflow_geoip::get_info(leadflow::getUserIP());
      $out['_ip'] = leadflow::getUserIP();
      $out['_referer'] = (string) @$_SERVER['HTTP_REFERER'];
      $out['_user_agent'] = (string) @$_SERVER['HTTP_USER_AGENT'];
      $out['_city'] = $location->city;
      $out['_country'] = $location->country_name;
      $out['_region'] = $location->region_name;
      $out['_remote_site'] = get_http_origin();
    } elseif ($flow_type == 'external') {
      $location = leadflow_geoip::get_info(leadflow::getUserIP());
      $out['_user_agent'] = (string) @$_SERVER['HTTP_USER_AGENT'];
		  if(strpos($out['_user_agent'],'Webhooks') !== false){
			  $out['_ip'] = '';
			  $out['_referer'] = (string) @$_SERVER['HTTP_REFERER'];      
			  $out['_city'] = '';
			  $out['_country'] = '';
			  $out['_region'] = '';
		  } else {
			  $out['_ip'] = leadflow::getUserIP();
			  $out['_referer'] = (string) @$_SERVER['HTTP_REFERER'];      
			  $out['_city'] = $location->city;
			  $out['_country'] = $location->country_name;
			  $out['_region'] = $location->region_name;
		  }
    } elseif ($flow_type == 'form') {
      $location = leadflow_geoip::get_info(leadflow::getUserIP());
      $out['_ip'] = leadflow::getUserIP();
      $out['_referer'] = (string) @$_SERVER['HTTP_REFERER'];
      $out['_user_agent'] = (string) @$_SERVER['HTTP_USER_AGENT'];
      $out['_city'] = $location->city;
      $out['_country'] = $location->country_name;
      $out['_region'] = $location->region_name;
      $out['_remote_site'] = get_http_origin();
      $out['_form_url'] = '';
      $out['_form_uuid'] = '';
    }

    return $out;
  } // get_internal_vars

  static function get_all_vars_external($flow_id, $order = 'get', $allowed_vars = array(), $data = array()) {
    $out = array();

    $internal_vars = self::get_special_vars($flow_id);

    if ($order == 'postget') {
      $out = array_merge($_GET, $_POST);
    } elseif ($order == 'getpost') {
      $out = array_merge($_POST, $_GET);
    } elseif ($order == 'get') {
      $out = $_GET;
    } elseif ($order == 'post') {
      $out = $_POST;
    } elseif ($order == 'internal') {
      $out = $data;
    }
    $org_request = $out;
    $out['_request'] = serialize($out);

    foreach($out as $name => $val) {
      if (!in_array($name, $allowed_vars)) {
        unset($out[$name]);
      }
    }

    $out = array_merge($out, $internal_vars);
    unset($out['_cookie'], $out['_subscriber']);

    if (!empty($out[self::get_email_field()]) && is_email($out[self::get_email_field()])) {
      $email = $out[self::get_email_field()];
    } 

    // merge user vars as well - prefix _subscriber_,  _cookies_ and _custom_
    $user = leadflow_subscribers_common::get_details($email);
    if (!$user) {
      $user = leadflow_subscribers_common::add($email, array(), array('source' => 'flow', 'source_id' => $flow_id));
      $out['_uuid'] = $user;
      $out['_new'] = 1;
      self::debug_notice('Provided email was not found in the local database. New entry created with ID #' . $user . '.');
    } else {
      $out['_uuid'] = $user['uuid'];
      $out['_new'] = 0;

      foreach ($user as $var => $value) {
        if (is_array($value)) {
          continue;
        }
        $out['_subscriber_' . $var] = $value;
      }

      foreach ($user['custom_vars'] as $var => $value) {
        if (is_array($value)) {
          continue;
        }
        $out['_custom_' . $var] = $value;
        }

      self::debug_notice('Provided email found in the local database with ID #' . $user['uuid'] . '.');
    }

    // always load cookies
    foreach ($_COOKIE as $var => $value) {
      if (is_array($value) || strpos($var, 'lfp_') === false) {
        continue;
      }
      $var = str_replace('lfp_', '', $var);
      $out['_cookie_' . $var] = $value;
    }

    unset($user);
    self::debug_notice('Available variables after merging all sources and subscriber vars: <pre>' . var_export($out, true) . '</pre>');

    return $out;
  } // get_all_vars_external


  static function get_email_field() {
    $components = self::get_flow_components(self::$flow->ID);
    $component = current($components);

    $field = $component['primary_email_field'];
    $field = str_replace('%', '', $field);

    if (empty($field)) {
      return '__non_existing_key__';
    } else {
      return $field;
    }
  } // get_email_field


  static function get_all_vars_ecommerce($flow_id, $allowed_vars = array(), $script_vars = array(), $get_vars = array(), $jvzoo = false) {
    $out = array();
    $subscriber = false;

    $order = self::$options['variables-order'];
    $internal_vars = self::get_special_vars($flow_id);

    if ($get_vars == 'false') {
      $get_vars = array();
    }

    if ($order == 'script') {
      $out = $script_vars;
    } elseif ($order == 'getscript') {
      $out = array_merge($script_vars, $get_vars);
    } elseif ($order == 'scriptget') {
      $out = array_merge($get_vars, $script_vars);
    } elseif($order = 'internal') {
      $out = $script_vars;
    } elseif($order = 'post') {
      $out = $_POST;
    } elseif($order = 'get') {
      $out = $_GET;
    }
    $out['_request'] = serialize($out);

    foreach($out as $name => $val) {
      if (!in_array($name, $allowed_vars)) {
        unset($out[$name]);
      }
    }

    // if IP was sent as a variable
    if (!empty($out['customer_ip'])) {
      $internal_vars['_ip'] = $out['customer_ip'];
      $location = leadflow_geoip::get_info($out['customer_ip']);
      $internal_vars['_city'] = $location->city;
      $internal_vars['_country'] = $location->country_name;
      $internal_vars['_region'] = $location->region_name;
    }

    $out = array_merge($out, $internal_vars);
    unset($out['_cookie'], $out['_subscriber']);

    if ($jvzoo == false && !empty($_COOKIE['lfp_uuid'])) {
      self::debug_notice('UUID cookie found - ID #' . $_COOKIE['lfp_uuid'] . '. Fetching subscriber.');
      $subscriber = leadflow_subscribers_common::get_details($_COOKIE['lfp_uuid']);
    }

    if (!$subscriber) {
      self::debug_notice('UUID cookie lookup failed. Trying email.');
      if (!empty($out[self::get_email_field()]) && is_email($out[self::get_email_field()])) {
        $email = $out[self::get_email_field()];
        self::debug_notice('Found email field with value: ' . $email);
        $subscriber = leadflow_subscribers_common::get_details($email);
      } else {
        if (self::get_email_field() == '__ecommerce') {
          self::debug_notice('Lookup by email disabled. Aborting.');
          return new WP_Error('get_all_vars', 'Lookup by email disabled.');
        } else {
          self::debug_notice('Invalid primary email value - "' . @$out[self::get_email_field()] . '". Aborting.');
          return new WP_Error('get_all_vars', 'Invalid primary email field.');
        }
      }
    }

    if (!$subscriber) {
      self::debug_notice('Subscriber lookup by email failed.');
    } else {
      self::debug_notice('Subscriber found. ID #' . $subscriber['uuid'] . ', email: ' . $subscriber['email'] . '.');
    }

    // merge user vars as well - prefix _subscriber_,  _cookies_ and _custom_
    if (!$subscriber) {
      $user = leadflow_subscribers_common::add($email, array(), array('source' => 'flow', 'source_id' => $flow_id));
      $out['_uuid'] = $user;
      $out['_new'] = 1;
      self::debug_notice('Provided email was not found in the local database. New entry created with ID #' . $user . '.');
      $user = leadflow_subscribers_common::get_details($user);
    } else {
      $user = $subscriber;
      $out['_uuid'] = $subscriber['uuid'];
      $out['_new'] = 0;
    }

    foreach ($user as $var => $value) {
      if (is_array($value)) {
        continue;
      }
      $out['_subscriber_' . $var] = $value;
    }

    foreach ($user['custom_vars'] as $var => $value) {
      if (is_array($value)) {
        continue;
      }
      $out['_custom_' . $var] = $value;
    }

    // always load cookies
    foreach ($_COOKIE as $var => $value) {
      if (is_array($value) || strpos($var, 'lfp_') === false) {
        continue;
      }
      $var = str_replace('lfp_', '', $var);
      $out['_cookie_' . $var] = $value;
    }

    unset($user);
    self::debug_notice('Available variables after merging all sources and subscriber vars: <pre>' . var_export($out, true) . '</pre>');

    return $out;
  } // get_all_vars_ecommerce


  static function get_all_vars_form($flow_id, $allowed_vars = array(), $form_vars = array(), $form_meta = array()) {
    $out = array();
    $subscriber = false;

    $internal_vars = self::get_special_vars($flow_id);
    $internal_vars['_form_url'] = $form_meta['page_url'];
    $internal_vars['_form_uuid'] = $form_meta['form_name'];

    $out = $form_vars;
    $out['_request'] = serialize($out);

    foreach($out as $name => $val) {
      if (!in_array($name, $allowed_vars)) {
        unset($out[$name]);
      }
    }

    $out = array_merge($out, $internal_vars);
    unset($out['_cookie'], $out['_subscriber']);

    // merge user vars as well - prefix _subscriber_,  _cookies_ and _custom_
    if (!empty($out[self::get_email_field()]) && is_email($out[self::get_email_field()])) {
      $email = $out[self::get_email_field()];
    } else {
      wp_send_json_error('Email field is missing or invalid.');
    }

    // merge user vars as well - prefix _subscriber_,  _cookies_ and _custom_
    $user = leadflow_subscribers_common::get_details($email);
    if (!$user) {
      $user = leadflow_subscribers_common::add($email, array(), array('source' => 'flow', 'source_id' => $flow_id));
      $out['_uuid'] = $user;
      $out['_new'] = 1;
      self::debug_notice('Provided email was not found in the local database. New entry created with ID #' . $user . '.');
    } else {
      $out['_uuid'] = $user['uuid'];
      $out['_new'] = 0;

      foreach ($user as $var => $value) {
        if (is_array($value)) {
          continue;
        }
        $out['_subscriber_' . $var] = $value;
      }

      foreach ($user['custom_vars'] as $var => $value) {
        if (is_array($value)) {
          continue;
        }
        $out['_custom_' . $var] = $value;
        }

      self::debug_notice('Provided email found in the local database with ID #' . $user['uuid'] . '.');
    }

    // always load cookies
    foreach ($_COOKIE as $var => $value) {
      if (is_array($value) || strpos($var, 'lfp_') === false) {
        continue;
      }
      $var = str_replace('lfp_', '', $var);
      $out['_cookie_' . $var] = $value;
    }

    unset($user);
    self::debug_notice('Available variables after merging all sources and subscriber vars: <pre>' . var_export($out, true) . '</pre>');

    return $out;
  } // get_all_vars_form


  static function get_all_vars_internal($flow_id, $subscriber, $extra_vars = array()) {
    $internal_vars = self::get_special_vars($flow_id);

    if (!is_array($extra_vars)) {
      $extra_vars = array($extra_vars);
    }
    $out = array_merge($extra_vars, $internal_vars);

    // merge user vars as well - prefix _subscriber_ and cookies
    $user = leadflow_subscribers_common::get_details($subscriber);
    $out['_new'] = 0;
    $out['_uuid'] = $user['uuid'];

    foreach ($user as $var => $value) {
      if (is_array($value)) {
        continue;
      }
      $out[$var] = $value;
    }

    foreach ($user['custom_vars'] as $var => $value) {
      if (is_array($value)) {
        continue;
      }
      $out['_custom_' . $var] = $value;
    }

    self::debug_notice('Provided user found in the local database with ID #' . $user['uuid'] . ' and email ' . $user['email'] . '.');

    self::debug_notice('Available variables after merging all sources and subscriber vars: <pre>' . var_export($out, true) . '</pre>');

    return $out;
  } // get_all_vars_internal


  static function check_required_vars($required_vars, $values) {
    $email = false;

    if (!$required_vars) {
      self::debug_notice('No external variables or validation rules are set.');
      return false;
    }

    foreach ($required_vars as $var_name => $var_rules) {
      if (!$var_name || !is_array($var_rules) || empty($var_rules)) {
        continue;
      }

      // go trough rules for each var
      foreach ($var_rules as $rule) {
        switch ($rule) {
          case 'required':
            if (!isset($values[$var_name])) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
		  case 'notempty':
            if (isset($values[$var_name]) && strlen(trim($values[$var_name])) == 0) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case 'email':
            if (isset($values[$var_name]) && !is_email($values[$var_name])) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case 'integer':
            if (isset($values[$var_name]) && !ctype_digit(strval($values[$var_name]))) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case '3chars':
            if (isset($values[$var_name]) && strlen(trim($values[$var_name])) < 3) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case '5chars':
            if (isset($values[$var_name]) && strlen(trim($values[$var_name])) < 5) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case '10chars':
            if (isset($values[$var_name]) && strlen(trim($values[$var_name])) < 10) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case '20chars':
            if (isset($values[$var_name]) && strlen(trim($values[$var_name])) < 20) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          case 'price':
            $tmp = preg_replace('/[^\d.]+/', '', @$values[$var_name]);
            if (isset($values[$var_name]) && !is_numeric($tmp)) {
              self::debug_notice('Variable ' . $var_name . ' failed the ' . $rule . ' variable rule.');
              return false;
            }
          break;
          default:
            self::debug_notice('Unknown variable rule - ' . $rule);
        }
      } // foreach $rules
    } // foreach required vars

    return true;
  } // check_required_vars


  static function debug_notice($notice) {
    if (!empty(self::$debug['display']) && !self::$doing_flow_push) {
      echo $notice . '<br>';
      @ob_end_flush();
    }
    if (self::$debug['log']) {
      self::$debug['messages'] .= $notice . "\n";
    }
  } // debug_notice
  
  static function debug_bulk_notice($notice) {
    self::$debug['bulk_messages'] .= $notice . "\n";
	if(!isset(self::$debug['bulk_errors'])){
		self::$debug['bulk_errors']=0;
	}
	self::$debug['bulk_errors']++;
  } // debug_notice


  static function debug_update_log() {
    if (self::$debug_output_done) {
      return;
    }

    self::$debug_output_done = true;

    self::debug_notice('');
    self::debug_notice('End flow run. Total run time: ' . round(microtime(true) - self::$start_time, 2) . ' sec.');

    if (self::$debug['log']) {
      update_post_meta(self::$flow->ID, 'flow_debug_last_call', self::$debug['messages']);
    }
  } // debug_update_log


  // handle all flow types
  static function process_flow($flow) {
    $flow_type = self::get_flow_type($flow->ID);

    if ($flow_type == 'external') {
      $tmp = self::process_external_flow($flow);
      if (is_wp_error($tmp)) {
        wp_die($tmp->get_error_message(), get_bloginfo('name'));
      }
    } elseif ($flow_type == 'ecommerce') {
      $tmp = self::process_ecommerce_flow($flow, array(), $_GET);
      if (is_wp_error($tmp)) {
        wp_die($tmp->get_error_message(), get_bloginfo('name'));
      }
    } else {
      wp_die('<b>LeadsFlow Pro</b> - Only external flows can be opened from a direct URL.', get_bloginfo('name'));
    }

    exit;
  } // process_flow


  static function process_internal_flow($flow_id, $subscriber, $extra_vars = array()) {
    self::$start_time = microtime(true);

    self::$flow = get_post($flow_id);

    if (!is_object(self::$flow) || !self::$flow || !isset(self::$flow->post_type) || self::$flow->post_type != 'lead-flows') {
      return new WP_Error('wrong_id', 'Unknown internal flow ID.');
    }

    if (!is_object($subscriber) || get_class($subscriber) != 'WP_Post' || $subscriber->post_type != 'leadflow-subscribers') {
      $subscriber = get_post($subscriber);
      if (!$subscriber) {
        return new WP_Error('wrong_id', 'Unknown subscriber ID.');
      }
    }

    self::$options = self::get_flow_options('general', self::$flow->ID);
    $components = self::get_flow_components(self::$flow->ID);
    self::$debug = self::get_flow_options('debug', self::$flow->ID);
    self::$debug['messages'] = '';

    if (self::$debug['log']) {
      register_shutdown_function(array('leadflow_flow_common', 'debug_update_log'));
    }

    self::debug_notice('Started on internal flow #' . self::$flow->ID . ' @ ' . date(get_option('date_format'), current_time('timestamp')) . ' ' . date(get_option('time_format'), current_time('timestamp')));

    leadflow_stats::flow_add_view(self::$flow->ID, true);

    $vars = self::get_all_vars_internal(self::$flow->ID, $subscriber, $extra_vars);
    self::debug_notice('');

    foreach ($components as $component) {
      foreach ($component as $var_name => $var_value) {
        if ($var_name == 'vars') {
          foreach ($var_value as $name => $val) {
            if (!is_array($val)) {
              continue;
            }
            $component['vars'][$name] = trim(implode(' ', $val));
          }
          $var_value = $component['vars'];
        } // if vars

        // don't parse some vars
        if ($var_name != 'tags_add' && $var_name != 'tags_remove' && (is_array($var_value) || $var_name[0] !== '_' || strpos($var_value, '%%') !== false)) {
          $component[$var_name] = self::parse_vars($var_value, $vars);
        } else {
          continue;
        }
      }

      $result = self::process_component($component, $vars);
      if (is_wp_error($result)) {
        return $result;
      }
      self::debug_notice('');
    } // foreach

    if ($vars['_new']) {
      leadflow_stats::flow_add_view(self::$flow->ID, false, true);
    } else {
      leadflow_stats::flow_add_view(self::$flow->ID, false, false);
    }
    leadflow_stats::event_add_flow(array('uuid' => $vars['_uuid'], 'post_id' => self::$flow->ID, 'new' => $vars['_new']), true);

    return $vars['_uuid'];
  } // process_internal_flow


  static function process_form_flow_ajax() {

    header('Access-Control-Allow-Origin: ' . get_http_origin());
    header('Access-Control-Allow-Methods: POST');
    header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
    header('Access-Control-Allow-Credentials: true');
    header('Content-Type: application/json; charset=UTF-8');

    $form_vars = $_POST['form_vars'];
    $form_meta = $_POST['form_meta'];

    $flow_id = $form_meta['flow_id'];

    if (!$flow_id) {
      wp_send_json_error('Unknown form catcher flow ID.');
    }

    self::process_form_flow($flow_id, $form_vars, $form_meta);

    exit;
  } // process_form_flow_ajax


  static function process_form_flow($flow_id, $form_vars = array(), $form_meta = array()) {
    global $vars;
	self::$start_time = microtime(true);

    self::$flow = get_post($flow_id);

    if (!is_object(self::$flow) || !self::$flow || !isset(self::$flow->post_type) || self::$flow->post_type != 'lead-flows') {
      wp_send_json_error('Unknown form catcher flow ID.');
    }

    self::$options = self::get_flow_options('general', self::$flow->ID);
    $components = self::get_flow_components(self::$flow->ID);
    self::$debug = self::get_flow_options('debug', self::$flow->ID);
    self::$debug['messages'] = '';

    if (self::$debug['log']) {
      register_shutdown_function(array('leadflow_flow_common', 'debug_update_log'));
    }

    self::debug_notice('Started on form catcher flow #' . self::$flow->ID . ' @ ' . date(get_option('date_format'), current_time('timestamp')) . ' ' . date(get_option('time_format'), current_time('timestamp')));

   if (self::$options['spam-protection']) {
      $check = self::check_ip_ban();
      if (is_wp_error($check)) {
        wp_send_json_error($check->get_error_message());
      }
    }

    leadflow_stats::flow_add_view(self::$flow->ID, true);

    $component = current($components);
    reset($components);
    $vars = self::get_all_vars_form(self::$flow->ID, array_keys($component['vars']), $form_vars, $form_meta);

    self::debug_notice('');

    foreach ($components as $component) {
      foreach ($component as $var_name => $var_value) {
        if ($var_name == 'vars') {
          foreach ($var_value as $name => $val) {
            if (!is_array($val)) {
              continue;
            }
            $component['vars'][$name] = trim(implode(' ', $val));
          }
          $var_value = $component['vars'];
        } // if vars

        // don't parse some vars
        if ($var_name != 'tags_add' && $var_name != 'tags_remove' && (is_array($var_value) || $var_name[0] !== '_' || strpos($var_value, '%%') !== false)) {
          $component[$var_name] = self::parse_vars($var_value, $vars);
        } else {
          continue;
        }
      }

      $result = self::process_component($component, $vars);
      if (is_wp_error($result)) {
        return $result;
      }
      self::debug_notice('');
    } // foreach

    if ($vars['_new']) {
      leadflow_stats::flow_add_view(self::$flow->ID, false, true);
    } else {
      leadflow_stats::flow_add_view(self::$flow->ID, false, false);
    }
    leadflow_stats::event_add_flow(array('uuid' => $vars['_uuid'], 'post_id' => self::$flow->ID, 'new' => $vars['_new'], 'country' => $vars['_country'], 'city' => $vars['_city'], 'region' => $vars['_region']), true);

    wp_send_json_success($vars['_uuid']);
  } // process_form_flow


  static function process_ecommerce_flow_ajax() {

    header('Access-Control-Allow-Origin: ' . get_http_origin());
    header('Access-Control-Allow-Methods: POST');
    header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
    header('Access-Control-Allow-Credentials: true');
    header('Content-Type: application/json; charset=UTF-8');

    $script_vars = $_POST['script_vars'];
    unset($script_vars['lfpAjaxurl']);
    $get_vars = $_POST['get_vars'];
    $flow_id = $script_vars['lfpId'];

    if (!$flow_id) {
      wp_send_json_error('Unknown ecommerce flow ID.');
    }

    $tmp = self::process_ecommerce_flow($flow_id, $script_vars, $get_vars);

    if (is_wp_error($tmp)) {
      wp_send_json_error($tmp->get_error_message());
    } else {
      wp_send_json_success($tmp);
    }
  } // process_ecommerce_flow_ajax


  static function process_ecommerce_flow_jvzoo_cron() {
    
	$processed = 0;
    $out = array('flows' => 0, 'transactions_from_api' => 0, 'processed_transactions' => 0);
    $flows = get_posts(array('post_type' => 'lead-flows', 'posts_per_page' => -1, 'meta_key' => 'flow_type', 'meta_value' => 'ecommerce', 'order' => 'ASC', 'orderby' => 'date', 'post_status' => 'publish'));
		
    $jvzoo_flows = array();
    foreach ($flows as $flow) {
      $components = self::get_flow_components($flow->ID);
      $types = array_map(function($element){ return (empty($element['ecommerce_type'])? false: $element['ecommerce_type']); }, $components);
      if (in_array('jvzoo', $types)) {
        $jvzoo_flows[] = $flow->ID;
      }
    }

    if (empty($jvzoo_flows)) {
      return $out;
    }
    
	
    leadflow_external_api::set_provider('jvzoo');
    $transactions = leadflow_external_api::get_transactions();

    if (!is_wp_error($transactions) && !empty($transactions)) {
      $processed_transactions = get_option('lf_jvzoo_processed_transactions', array());
      foreach ($transactions as $transaction) {
        $flow_id = $jvzoo_flows[0];
        $params = array('price' => $transaction['price'], 'product_name' => $transaction['product_name'], 'email' => $transaction['customer_email'], 'firstname' => $transaction['first_name'], 'lastname' => $transaction['last_name'], 'customer_ip' => $transaction['ip'], 'transaction_id' => $transaction['transaction_id'], 'affiliate_transaction' => $transaction['is_affiliate_transaction']);

        if (empty($processed_transactions[$transaction['transaction_id']])) {
          self::process_ecommerce_flow($flow_id, $params, array(), true);
          $processed_transactions[$transaction['transaction_id']] = true;
          $processed++;
        } else {
          continue;
        }
      } // foreach $transactions
      update_option('lf_jvzoo_processed_transactions', $processed_transactions);
    } // if $transactions

    $out = array('flows' => sizeof($jvzoo_flows), 'transactions_from_api' => sizeof($transactions), 'processed_transactions' => $processed);
    return $out;
  } // process_ecommerce_flow_ajax


  static function process_ecommerce_flow($flow_id, $script_vars = array(), $get_vars = array(), $jvzoo = false) {
    global $vars;
	self::$start_time = microtime(true);

    self::$flow = get_post($flow_id);

    if (!is_object(self::$flow) || !self::$flow || !isset(self::$flow->post_type) || self::$flow->post_type != 'lead-flows') {
      return new WP_Error('ecommerce_flow', 'Unknown ecommerce flow ID.');
    }

    self::$options = self::get_flow_options('general', self::$flow->ID);
    $components = self::get_flow_components(self::$flow->ID);
    self::$debug = self::get_flow_options('debug', self::$flow->ID);
    self::$debug['messages'] = '';

    if (self::$debug['log']) {
      register_shutdown_function(array('leadflow_flow_common', 'debug_update_log'));
    }

    self::debug_notice('Started on ecommerce flow #' . self::$flow->ID . ' @ ' . date(get_option('date_format'), current_time('timestamp')) . ' ' . date(get_option('time_format'), current_time('timestamp')));

    if ($jvzoo == false && self::$options['spam-protection']) {
      $check = self::check_ip_ban();
      if (is_wp_error($check)) {
        return $check;
      }
    }

    leadflow_stats::flow_add_view(self::$flow->ID, true);

    $component = current($components);
    reset($components);
    $vars = self::get_all_vars_ecommerce(self::$flow->ID, array_keys($component['vars']), $script_vars, $get_vars, $jvzoo);
    if (is_wp_error($vars)) {
      return $vars;
    }
    self::debug_notice('');

    foreach ($components as $component) {
      foreach ($component as $var_name => $var_value) {
        if ($var_name == 'vars') {
          foreach ($var_value as $name => $val) {
            if (!is_array($val)) {
              continue;
            }
            $component['vars'][$name] = trim(implode(' ', $val));
          }
          $var_value = $component['vars'];
        } // if vars

        // don't parse some vars
        if ($var_name != 'tags_add' && $var_name != 'tags_remove' && (is_array($var_value) || $var_name[0] !== '_' || strpos($var_value, '%%') !== false)) {
          $component[$var_name] = self::parse_vars($var_value, $vars);
        } else {
          continue;
        }
      }

     $result = self::process_component($component, $vars);
      if (is_wp_error($result)) {
        return $result;
      }
      self::debug_notice('');
    } // foreach

    if ($vars['_new']) {
      leadflow_stats::flow_add_view(self::$flow->ID, false, true);
    } else {
      leadflow_stats::flow_add_view(self::$flow->ID, false, false);
    }

    return $vars['_uuid'];
  } // process_ecommerce_flow


  static function process_external_flow($flow, $data = array()) {
	global $vars;
    self::$start_time = microtime(true);
	
    self::$flow = $flow;
	
	$facebook_verify_token = get_post_meta($flow->ID, 'facebook-verify-token', true);
	
	
	if(isset($_REQUEST['hub_challenge']) && $facebook_verify_token){
		$challenge = $_REQUEST['hub_challenge'];
		$verify_token = $_REQUEST['hub_verify_token'];
		
		if($verify_token === $facebook_verify_token){
			self::debug_notice('Facebook Challenge Sent and Passed.');
			echo $challenge;
			die();
		}
	}
	
	
	

    if (!is_object(self::$flow) || !self::$flow || !isset(self::$flow->post_type) || self::$flow->post_type != 'lead-flows') {
      self::debug_notice('Unknown Flow ID. Aborting.');
      return new WP_Error('wrong_id', 'Unknown external flow ID.');
    }

    self::$options = self::get_flow_options('general', self::$flow->ID);
    $components = self::get_flow_components(self::$flow->ID);
    self::$debug = self::get_flow_options('debug', self::$flow->ID);
    self::$debug['messages'] = '';

    if (self::$debug['log']) {
      register_shutdown_function(array('leadflow_flow_common', 'debug_update_log'));
    }

    self::debug_notice('Started on external flow #' . self::$flow->ID . ' @ ' . date(get_option('date_format'), current_time('timestamp')) . ' ' . date(get_option('time_format'), current_time('timestamp')));
    
	
	
	$facebook_data_received = file_get_contents('php://input');
	if(!empty($facebook_data_received)){
		ini_set('precision',20);
		$leaddata=json_decode($facebook_data_received);
		$leadgenid=$leaddata->entry[0]->changes[0]->value->leadgen_id;
		
		if($leadgenid){
			self::debug_notice('Facebook Lead Received: '.$leadgenid);
			update_option('facebook_data_received',$leadgenid);
					
			self::debug_notice('Attempting to retrieve lead form data.');
			
			$lfp_facebook_long_token = get_option('lfp_facebook_long_token');
			
			if($lfp_facebook_long_token){
				self::debug_notice('Using access token: '.$lfp_facebook_long_token);	
				
				$graph_url= 'https://graph.facebook.com/v2.5/'.$leadgenid."?access_token=".$lfp_facebook_long_token;
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $graph_url);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
				$output = curl_exec($ch); 
				curl_close($ch);
			
				//work with the lead data
				$leaddata = json_decode($output);
				$lead = [];
				$facebook_fields = array();
				for($i=0;$i<count($leaddata->field_data);$i++) {
					$lead[$leaddata->field_data[$i]->name]=$leaddata->field_data[$i]->values[0];
					$_GET[$leaddata->field_data[$i]->name]=$leaddata->field_data[$i]->values[0];
					$facebook_fields[]=$leaddata->field_data[$i]->name;
				}
				
				update_option('lfp_last_facebook_fields',$facebook_fields);
				self::debug_notice('Lead Data Received: '.serialize($lead));	
					
			} else {
				self::debug_notice('Access token not found! Please recheck API settings.');
			}
	
			
		}
	
	}

	
	self::debug_notice('Raw GET data: ' . var_export($_GET, true));
    self::debug_notice('Raw POST data: ' . var_export($_POST, true));
    self::debug_notice('Raw function call data: ' . var_export($data, true));

	
    if (self::$options['spam-protection'] && empty($facebook_data_received)) {
      $check = self::check_ip_ban();
      if (is_wp_error($check)) {
        return $check;
      }
    }

    leadflow_stats::flow_add_view(self::$flow->ID, true);

    $component = current($components);
    reset($components);
    $vars = self::get_all_vars_external(self::$flow->ID, self::$options['variables-order'], array_keys($component['vars']), $data);
    if (is_wp_error($vars)) {
      return $vars;
    }

    self::debug_notice('');
	if($vars['_uuid']>0) {
		leadflow_stats::event_add_flow(array('uuid' => $vars['_uuid'], 'post_id' => self::$flow->ID, 'new' => $vars['_new'], 'country' => $vars['_country'], 'city' => $vars['_city'], 'region' => $vars['_region']), true);
	}

    foreach ($components as $component) {
      foreach ($component as $var_name => $var_value) {
        if ($component['_flow-component-type'] != 'start' && $var_name == 'vars') {
          foreach ($var_value as $name => $val) {
            if (!is_array($val)) {
              continue;
            }
            $component[$var_name][$name] = trim(implode(' ', $val));
          }
          $var_value = $component['vars'];
        } elseif ($component['_flow-component-type'] == 'email' && $var_name == 'recipient') {
          $component[$var_name] = trim(implode(' ', $var_value));
          $var_value = trim(implode(' ', $var_value));
        }

        // don't parse some vars
        if ($component['_flow-component-type'] != 'start' && $var_name != 'tags_add' && $var_name != 'tags_remove'
            && (is_array($var_value) || $var_name[0] !== '_' || strpos($var_value, '%%') !== false)) {
          $component[$var_name] = self::parse_vars($var_value, $vars);
        } else {
          continue;
        }
      }

      $result = self::process_component($component, $vars);
      
	  if (is_wp_error($result)) {
        return $result;
      }
      self::debug_notice('');
    } // foreach

    if ($vars['_new']) {
      leadflow_stats::flow_add_view(self::$flow->ID, false, true);
    } else {
      leadflow_stats::flow_add_view(self::$flow->ID, false, false);
    }
    
    return $vars['_uuid'];
  } // do_external_flow


  static function process_component($component, $vars) {
    
    $providers = leadflow_external_api::$available_providers;
    $active_apis = get_option('leadflow_external_api');
  
    if (!empty($providers[$component['_flow-component-type']]) && 
        (empty($active_apis[$component['_flow-component-type']]) || 
        $active_apis[$component['_flow-component-type']]['status'] === false)) {
        self::debug_notice('Component Inactive - ' . $component['_flow-component-type'] . '.');
        return false;
    }
    // end => $active ide dalje
    
    // auto call component function if it exists
    if (method_exists(__CLASS__, 'process_component_' . $component['_flow-component-type'])) {
      self::debug_notice('Component: '. $component['_flow-component-type']);
      $result = call_user_func(array(__CLASS__, 'process_component_' . $component['_flow-component-type']), $component['_flow-component-type'], $component, $vars);
      if (is_wp_error($result)) {
        return $result;
      }
    } else {
      self::debug_notice('Unknown component - ' . $component['_flow-component-type'] . '.');
    }
  } // process_component


  static function parse_vars($input, $vars) {
    $out = preg_replace_callback('/(%%\w+%%)/iU', function($match) use($vars) {
      if (!isset($match[1]) || !trim($match[1], '%%')) {
        return $match[0];
      }
      $name = trim($match[1], '%%');
      if (isset($vars[$name])) {
        return $vars[$name];
      } else {
        return '';
      }
    }, $input);

    return $out;
  } // parse_vars


  static function check_ip_ban() {
    // admins can't get banned
    if (is_user_logged_in() && current_user_can('administrator')) {
      return false;
    }

    $ip = leadflow::getUserIP();
    $banned = get_option('lf_banned_ips', array());

    if (isset($banned[$ip]) && $banned[$ip] > time()) {
      self::debug_notice('IP ' . $ip . ' is banned due to excessive usage');
      return new WP_Error('ip_ban_engine', 'IP banned due to excessive usage.');
    } elseif (isset($banned[$ip]) && $banned[$ip] <= time()) {
      // cleanup
      unset($banned[$ip]);
      update_option('lf_banned_ips', $banned, true);
    }

    $options = get_option(LF_OPTIONS, array());
    $ban_time = $options['ban_time'] * 60? $options['ban_time'] * 60: 60 * 60;
    $request_cnt = $options['ban_request_cnt']? $options['ban_request_cnt']: 10;
    $request_delta = $options['ban_request_time'] * 60? $options['ban_request_time'] * 60: 2 * 60;
    $log = get_transient('lf_ip_log_' . $ip);

    if (!is_array($log)) {
      $log = array(time());
    } else {
      $tmp2 = array();
      foreach ($log as $tmp) {
        if ($tmp > time() - $request_delta) {
          $tmp2[] = $tmp;
        }
      } // foreach
      $log = $tmp2;
      $log[] = time();

      if (sizeof($log) >= $request_cnt) {
        $banned[$ip] = time() + $ban_time;
        update_option('lf_banned_ips', $banned, true);
      }
    }
    set_transient('lf_ip_log_' . $ip, $log, $request_delta + 10);

    return false;
  } // check_ip_ban


  static function set_cookies($expire, $vars) {
    $out = true;

    foreach ($vars as $cookie_name => $cookie_value) {
      $cookie_name = 'lfp_' . strtolower($cookie_name);

      $tmp = setcookie($cookie_name, $cookie_value, current_time('timestamp') + DAY_IN_SECONDS * (int) $expire, '/');
      if (!$tmp) {
        $out = false;
      }
    }

    return $out;
  } // set_cookies


  // refresh list of lists via ajax in flow GUI
  static function refresh_list_ajax() {
    $provider = @$_GET['provider'];
    if(!leadflow_external_api::set_provider($provider)) {
      wp_send_json_error('Unknown API provider.');
    }

    $lists = leadflow_external_api::get_lists(true);
    if (is_wp_error($lists)) {
      wp_send_json_error('Unable to fetch lists.');
    } else {
      wp_send_json_success($lists);
    }
  } // refresh_list_ajax


  static function process_component_start($component_name, $component, $vars) {
    global $flow_id;

    if (self::get_flow_type(self::$flow->ID) != 'internal') {
      if (!self::check_required_vars($component['vars'], $vars)) {
        
		if ($component['fallback_type'] == 'optin') {
          $permalink = get_permalink($component['fallback_optin']);
          $permalink = add_query_arg($_GET, $permalink);
          self::debug_notice('Redirecting to OptIn #' . $component['fallback_optin'] . ' - ' . $permalink . ' with the following variables: ' . var_export($vars, true));
          wp_redirect($permalink);
          exit;
		} elseif ($component['fallback_type'] == 'custom_url') {
			self::debug_notice('Redirecting to custom fallback URL ' . $component['fallback_custom_url'] . '.');
            $url = $component['fallback_custom_url'];
			wp_redirect($url);
			exit;
		} elseif ($component['fallback_type'] == 'custom_url_get') {
			self::debug_notice('Redirecting to custom fallback URL ' . $component['fallback_custom_url'] . ' with the following variables: ' . var_export($_GET, true));
			$url = add_query_arg($_GET, $component['fallback_custom_url']);
			wp_redirect($url);
			exit;
        } else {
          self::debug_notice('One or more required variables are missing or failed defined variable rules.');
          return new WP_Error('start_component', 'One or more required variables are missing or failed defined variable rules.');
        }
		// new fallback
      } else {
        self::debug_notice('Required vars are checked.');
      }
    }

    if ($component['uuid_cookie'] == '1') {
      self::set_cookies(90, array('uuid' => $vars['_uuid']));
      self::debug_notice('UUID tracking cookie with a value of ' . $vars['_uuid'] . ' set for 90 days.');
    } elseif ($component['uuid_cookie'] == '2') {
      self::set_cookies(20 * 365, array('uuid' => $vars['_uuid']));
      self::debug_notice('UUID tracking cookie with a value of ' . $vars['_uuid'] . ' set for 20 years.');
    }
  } // process_component_start


  static function process_component_local_db($component_name, $component, $vars) {
    self::debug_notice('Merging the following variables into subscriber\'s profile: ' . var_export($component['vars'], true));

    if ($vars['_new']) {
      unset($component['vars']['email']);
      leadflow_subscribers_common::edit($vars['_uuid'], $component['vars'], array('signup_source' => 'flow', 'source_id' => self::$flow->ID), $component['auto_set_vars']);
    } else {
      // email can't be edited
      unset($component['vars']['email']);
      leadflow_subscribers_common::edit($vars['_uuid'], $component['vars'], array(), $component['auto_set_vars']);
    }

    leadflow_subscribers_common::add_system_tags($vars['_uuid'], 'flows', array('flow-' . self::$flow->ID));

    if (!empty($component['tags_remove'])) {
      self::debug_notice('Removing the following tags (if subscriber is tagged with them): ' . var_export($component['tags_remove'], true));
      leadflow_subscribers_common::remove_tags($vars['_uuid'], $component['tags_remove']);
    }

    if (!empty($component['tags_add'])) {
      self::debug_notice('Adding the following tags: ' . var_export($component['tags_add'], true));
      if (!leadflow_subscribers_common::add_tags($vars['_uuid'], $component['tags_add'])) {
        self::debug_notice('Error adding one or more tags.');
      };
    }
  } // process_component_local_db


  static function process_component_ecommerce($component_name, $component, $vars) {
    if ($component['ecommerce_type'] == 'universal') {
      if (!isset($component['price_field']) || $component['price_field'] === '') {
        $price = $component['default_price'];
        self::debug_notice('Using default price.');
      } else {
        $price = $component['price_field'];
      }
    } elseif ($component['ecommerce_type'] == 'woocommerce') {
      if (!empty($vars['price'])) {
        $price = $vars['price'];
      } else {
        $price = 0;
      }
    } elseif ($component['ecommerce_type'] == 'jvzoo') {
      if (!empty($vars['price'])) {
        $price = $vars['price'];
      } else {
        $price = 0;
      }
    }

    if (!empty($vars['product_name'])) {
      $product_name = $vars['product_name'];
    } else {
      $product_name = 'unknown product';
    }
    if (!empty($vars['transaction_id'])) {
      $transaction_id = $vars['transaction_id'];
    } else {
      $transaction_id = '';
    }

    $price = preg_replace('/[^\d.]+/', '', $price);
    if ($price[0] == '.') {
      $price = '0' + $price;
    }

    $ttv = $vars['_subscriber_ttv'] + $price;
    $ttc = (int) $vars['_subscriber_ttc'] + 1;

    leadflow_subscribers_common::edit($vars['_uuid'], array(), array('ttv' => $ttv, 'ttc' => $ttc));

    leadflow_stats::event_add_ecommerce(array('uuid' => $vars['_uuid'], 'post_id' => self::$flow->ID, 'new' => $vars['_new'], 'country' => $vars['_country'], 'city' => $vars['_city'], 'region' => $vars['_region'], 'price' => $price, 'product_name' => $product_name, 'transaction_id' => $transaction_id, 'affiliate_transaction' => $vars['affiliate_transaction']), true);

    self::debug_notice('Price for ' . $product_name . ' is: $' . $price . '. Updating total transaction values to $' . $ttv . ' and total transaction count to ' . $ttc . '.');
  } // process_component_ecommerce


  static function process_component_end($component_name, $component, $vars) {
    if ($component['action'] == 'message') {
      self::debug_notice('End with message.');
      $template = self::prepare_end_template($component['message'], $component['tracking_code']);
      if (!empty($component['tracking_code'])) {
        self::debug_notice('Tracking code added to page.');
      }
      echo $template;
    } elseif ($component['action'] == 'redirect' && !empty($component['redirect_url'])) {
      if (ctype_digit($component['redirect_url'])) {
        $redirect_url = get_permalink($component['redirect_url']);
      } else {
        $redirect_url = $component['redirect_url_custom'];
      }
	  
	  if(@$component['redirect_url_passvars'] == 'passvars'){
		$msg  = '<h1>Redirecting. Please wait ...</h1>';
		if (!empty($component['tracking_code'])) {
		  $msg .= '<div style="display: none;" id="tracking_code">' . $component['tracking_code'] . '</div>';
		}
		$msg .= '<form action="'.$redirect_url.'" method="post" name="lfp_redirect_form">';
		foreach ($vars as $name => $value) {
		  $msg .= '<input type="hidden" name="'.$name.'" value="'.$value.'">';
		}
		$msg .= '</form>';
		$msg .= '<script type="text/javascript">';
		$msg .= 'document.lfp_redirect_form.submit();';
		$msg .= '</script>';
		wp_die($msg, get_bloginfo('name'), 200);
	  } else {
		  @wp_redirect($redirect_url);
	  }
	   
	  
	  
      self::debug_notice('End with redirect to: ' . $redirect_url);
      exit;
    } elseif ($component['action'] == 'return') {
      self::debug_notice('End with return.');
      return $vars['_uuid'];
    } elseif ($component['action'] == 'json') {
      self::debug_notice('End with UUID json response.');
      wp_send_json_success($vars['_uuid']);
    } elseif ($component['action'] == 'auto') {
      self::debug_notice('Auto-detecting response type.');
      return;
    } elseif ($component['action'] == 'image') {
      self::debug_notice('End with a transparent GIF pixel.');
      header('Content-Type: image/gif');
      echo base64_decode('R0lGODlhAQABAJAAAP8AAAAAACH5BAUQAAAALAAAAAABAAEAAAICBAEAOw==');
      exit;
    } elseif ($component['action'] == 'blank') {
      self::debug_notice('End with blank response.');
      exit;
    } else {
      self::debug_notice('End component - unknown action.');
      return new WP_Error('end_component', 'End component - unknown action.');
    }
  } // process_component_end


  static function prepare_end_template($message, $tracking_code = '') {
    $out = file_get_contents(LF_PLUGIN_PATH . '/templates/thank-you-pages/index.html');

    if (!empty($tracking_code)) {
      $tracking_code = '<div style="display: none;" id="lf_tracking_code">' . $tracking_code . '</div>';
    }

    $out = str_replace(array('%%TITLE%%', '%%BODY%%', '%%TRACKING_CODE%%', '%%TEMPLATE_URL%%'), array(get_bloginfo('name'), $message, $tracking_code, LF_PLUGIN_URL . '/templates/thank-you-pages/'), $out);

    return $out;
  } // prepare_end_template


  static function process_component_custom_url($component_name, $component, $vars) {
    if ($component['request_type'] == 'original') {
      $url = explode('?', $component['url']);
      $url = $url[0];
      if (!empty($_GET)) {
        $url = add_query_arg($_GET, $url);
      }
      $post = $_POST;
    } else {
      $url = $component['url'];
      $post = $component['vars'];
    }

    if (!empty($post)) {
      self::debug_notice('Making a POST request to ' . $url . ' with these params: ' . var_export($post, true));
      $response = wp_remote_post($url, array('body' => $post));
    } else {
      self::debug_notice('Making a GET request to ' . $url);
      $response = wp_remote_get($url, array('sslverify' => false));
    }

    if (is_wp_error($response)) {
      self::debug_notice('Remote server responded with an eror: ' . $response->get_error_message());
    } else {
      self::debug_notice('Response code: ' . $response['response']['code']);

      if (trim($component['save_response'], '_')) {
        self::debug_notice('Saving response to variable: %%' . trim($component['save_response'], '_') . '%%');
        $body = json_decode($response['body']);
        if (json_last_error() != JSON_ERROR_NONE) {
          $body = $response['body'];
          self::debug_notice('Response body raw: ' . var_export(esc_html($response['body']), true));
        } else {
          self::debug_notice('Response body JSON decoded: ' . var_export($body, true));
        }
        $vars[trim($component['save_response'], '_')] = $body;
      } else {
        self::debug_notice('Response body raw: ' . var_export($response['body'], true));
      }
    }
  } // process_component_custom_url


  static function process_component_email($component_name, $component, $vars) {
    $headers = array();
    if (!empty($component['attachment_id'])) {
      $attachment = get_attached_file((int) $component['attachment_id']);
    } else {
      $attachment = '';
    }

    self::debug_notice('Sending email (' . $component['subject'] . ') to ' . $component['recipient'] . ($attachment? ' with ' . $attachment: ''));
    $return = wp_mail($component['recipient'], $component['subject'], $component['body'], $headers, $attachment);
    if ($return) {
      self::debug_notice('Email sent successfully.');
    } else {
      self::debug_notice('Email failed to send.');
    }
  } // process_component_email


  static function process_component_wp($component_name, $component, $vars) {
    leadflow_external_api::set_provider($component['_flow-component-type']);
    $res = leadflow_external_api::add_subscriber($component['list_id'], $component['vars']);

    self::debug_notice('Creating a new user with the ' . $component['list_id'] . ' role using the following variables: ' . var_export($component['vars'], true));
    if (is_wp_error($res)) {
      self::debug_notice('User was NOT created due to the following error: ' . $res->get_error_message());
    } elseif ($res === true) {
      self::debug_notice('User was sucessfully created.');
    } else {
      self::debug_notice('User was NOT created because that email or user_login is already in use.');
    }
  } // process_component_wp


  static function process_component_pushover($component_name, $component, $vars) {
    leadflow_external_api::set_provider($component['_flow-component-type']);
    $options = leadflow_external_api::get_options();
    if (empty($options['status']) || empty($options['gui_status'])) {
      self::debug_notice('This API service is disabled. Please verify its settings.');
      return;
    }

    self::debug_notice('Sending Pushover notifications; subject: ' . $component['subject'] . ', message: ' . $component['message']);

    $users = explode("\n", $component['to']);
    if (empty($users)) {
      self::debug_notice('No user keys defined.');
      break;
    }
    foreach ($users as $user) {
      $user = trim($user);
      if (empty($user)) {
        continue;
      }
      $res = leadflow_external_api::send($user, $component['subject'], $component['message'], array('sound' => $component['sound']));
      if (is_wp_error($res) || !$res) {
        self::debug_notice('Error sending to ' . $user . '. ' . $res->get_error_message());
      } else {
        self::debug_notice('Push message successfully sent to ' . $user . '.');
      }
    } // foreach line / user
  } // process_component_pushover


  static function process_component_twilio($component_name, $component, $vars) {
    leadflow_external_api::set_provider($component['_flow-component-type']);
    $options = leadflow_external_api::get_options();
    if (empty($options['status']) || empty($options['gui_status'])) {
      self::debug_notice('This API service is disabled. Please verify its settings.');
      return;
    }
    
	if(is_array($component['to'])){
		$numbers = $component['to'];
		$component['to']=implode(',',$component['to']);
	} else {
		$numbers = explode(',', $component['to']);
	}
	
    self::debug_notice('Sending SMS from ' . $component['from'] . ' to ' . $component['to']);
    self::debug_notice('Message: ' . $component['message']);
    
	
	foreach ($numbers as $nid=>$number) {
		$numbers[$nid]='+'.preg_replace("/[^0-9]/","",$number);	
	}
	
    foreach ($numbers as $number) {
	  	
      $number = trim($number);
      if (empty($number)) {
        continue;
      }
      $res = leadflow_external_api::send($number, $component['from'], $component['message'], array());
      if (is_wp_error($res) || !$res) {
        self::debug_notice('Error sending to ' . $number . '. ' . $res->get_error_message());
      } else {
        self::debug_notice('SMS successfully sent to ' . $number . '.');
      }
    }
  } // process_component_twilio


  static function process_component_zapier($component_name, $component, $vars) {
    leadflow_external_api::set_provider($component['_flow-component-type']);
    $options = leadflow_external_api::get_options();
    if (empty($options['status']) || empty($options['gui_status'])) {
      self::debug_notice('This API service is disabled. Please verify its settings.');
      return;
    }

    self::debug_notice('Sending Zap to: ' . $component['webhook_url'] . ' with these params: ' . var_export($component['vars'], true));

    $res = leadflow_external_api::send($component['webhook_url'], $component['vars'], '');
    if (!is_wp_error($res)) {
      self::debug_notice('Zap successfully sent.');
    } else {
      self::debug_notice('Zap failed to send. ' . $res->get_error_message());
    }
  } // process_component_zapier


  static function process_component_php($component_name, $component, $vars) {
	global $vars;
    self::debug_notice('Running PHP code: <pre>' . $component['code'] . '</pre>');
    
    ob_start();
    $res = eval($component['code']);
    $php_echo = ob_get_contents();
    ob_end_clean();

    if (is_null($res)) {
      self::debug_notice('Code returned no value.');
    } elseif ($res === false) {
      self::debug_notice('Error parsing PHP code.');
    } else {
      self::debug_notice('Returned value: ' . var_export($res, true));
    }

    if (trim($component['save_return'], '_')) {
      self::debug_notice('Saving returned value to variable: %%php_' . trim($component['save_return'], '_')  . '%%');
      $vars['php_'.trim($component['save_return'], '_')] = $res;
    }
  } // process_component_php


  static function process_component_mysql($component_name, $component, $vars) {
    global $wpdb;

    if (empty($component['query'])) {
      self::debug_notice('No MySQL query defined.');
      return;
    }

    self::debug_notice('Running query: ' . $component['query']);
    $res = $wpdb->get_results($component['query'], ARRAY_A);
    if ($wpdb->last_error) {
      self::debug_notice('Error: ' . $wpdb->last_error);
    } else {
      self::debug_notice('Result: ' . var_export($res, true));
    }
  } // process_component_mysql


  static function process_component_filesystem($component_name, $component, $vars) {
    if (empty($component['path'])) {
      self::debug_notice('File path is not configured.');
      return;
    }
    self::debug_notice('Saving data to ' . $component['path'] . ' in ' . $component['mode'] . ' mode.');
    self::debug_notice('Data: ' . $component['format']);
    $fh = fopen($component['path'], $component['mode']);
    if ($fh) {
      $cnt = fputs($fh, $component['format']);
      fclose($fh);
      if ($cnt >= sizeof($component['format'])) {
        self::debug_notice('Success! ' . $cnt . ' bytes saved.');
      } else {
        self::debug_notice('Data save failed.');
      }
    } else {
      self::debug_notice('Failed to open file.');
    }
  } // process_component_filesystem


  static function process_component_cookie($component_name, $component, $vars) {
    self::debug_notice('Setting the following cookies for ' . $component['expire'] . ' day(s): ' . var_export($component['vars'], true));
    $return = self::set_cookies($component['expire'], $component['vars']);
    if ($return) {
      self::debug_notice('Cookies were sent.');
    } else {
      self::debug_notice('Cookies were not sent.');
    }
  } // process_component_cookie


  // generic autoresponder implementation
  static function process_component_generic_autoresponder($component_name, $component, $vars) {
    if (empty($component['vars'])) {
      self::debug_notice('No variables defined, please check component settings.');
      return;
    }
    if (empty($component['list_id'])) {
      self::debug_notice('No list selected, please check component settings.');
      return;
    }

    leadflow_external_api::set_provider($component['_flow-component-type']);

    $options = leadflow_external_api::get_options();
    if (empty($options['status']) || empty($options['gui_status'])) {
      self::debug_notice('This API service is disabled. Please verify its settings.');
      return;
    }

    $res = leadflow_external_api::add_subscriber($component['list_id'], $component['vars']);

    self::debug_notice('Adding subscriber to list ' . $component['list_id'] . ' with the following variables: ' . var_export($component['vars'], true));
    if (is_wp_error($res)) {
      self::debug_notice('Subscriber was NOT added to the list due to the following error: ' . $res->get_error_message());
	  self::debug_bulk_notice('<strong>'.$component['_flow-component-type'].':</strong> Subscriber <strong>'.$component['vars']['email'].'</strong> was NOT added to the list due to the following error: ' . $res->get_error_message());
    } elseif ($res === true) {
      self::debug_notice('Subscriber was successfully added to the list.');
    } else {
      self::debug_notice('Subscriber was NOT added to the list because that email is already on the list.');
	  self::debug_bulk_notice('<strong>'.$component['_flow-component-type'].'</strong>: Subscriber <strong>'.$component['vars']['email'].'</strong> was NOT added to the list because that email is already on the list.');
    }
  } // process_component_generic_autoresponder


  // uses generic autoresponder
  static function process_component_mailchimp($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_mailchimp

  // uses generic autoresponder
  static function process_component_infusionsoft($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_infusionsoft

  // uses generic autoresponder
  static function process_component_wishlist($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_wishlist

  // uses generic autoresponder
  static function process_component_ontraport($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_ontraport

  // uses generic autoresponder
  static function process_component_aweber($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_aweber

  // uses generic autoresponder
  static function process_component_sendinblue($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_sendinblue

  // uses generic autoresponder
  static function process_component_mad_mimi($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_mad_mimi


  // uses generic autoresponder
  static function process_component_campaign_monitor($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_campaign_monitor


  // uses generic autoresponder
  static function process_component_sendlane($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_sendlane


  // uses generic autoresponder
  static function process_component_activecampaign($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_activecampaign


  // uses generic autoresponder
  static function process_component_rapid_mailer($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_rapidmailer


  // uses generic autoresponder
  static function process_component_mailpoet($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_mailpoet
  
  
  // uses generic autoresponder
  static function process_component_mymail($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_mymail


  // uses generic autoresponder
  static function process_component_icontact($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_icontact


  // uses generic autoresponder
  static function process_component_gotowebinar($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_gotowebinar


  // uses generic autoresponder
  static function process_component_getresponse($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_getresponse


  // uses generic autoresponder
  static function process_component_webinarignition($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_webinarignition


  // uses generic autoresponder
  static function process_component_webinarjam($component_name, $component, $vars) {
    return self::process_component_generic_autoresponder($component_name, $component, $vars);
  } // process_component_webinarjam


  // load template for end component
  static function load_end_template_ajax() {
    $template = $_GET['template'];
    if(empty($template)) {
      wp_send_json_error('Unknown template.');
    }

    $source = @file_get_contents(LF_PLUGIN_PATH . '/templates/thank-you-pages/' .  $template . '.html');
    if (empty($source)) {
      wp_send_json_error('Template file is missing or empty.');
    } else {
      $source = str_replace(array('%%TEMPLATE_URL%%'), array(LF_PLUGIN_URL . '/templates/thank-you-pages/'), $source);

      wp_send_json_success($source);
    }
  } // load_end_template_ajax


  static function enqueue_form_catcher_js() {
    global $post;
    $active_flows = array();

    if (!empty($post->post_type) && $post->post_type == 'optin-pages') {
      return;
    }

    $flows = get_posts(array('post_type' => 'lead-flows', 'meta_key' => 'flow_type', 'meta_value' => 'form', 'numberposts' => -1, 'post_status' => 'publish'));
    foreach ($flows as $flow) {
      $options = get_post_meta($flow->ID, LF_META, true);
      if (empty($options['form']['location']) || $options['form']['location'] != 'local') {
        continue;
      } else {
        $active_flows[] = array('id' => $flow->ID, 'selector' => $options['form']['selector']);
      }
    } // foreach form flows

    if ($active_flows) {
      wp_enqueue_script('lf-form-catcher', LF_PLUGIN_URL . '/js/lfp-form-catcher-local.js', array('jquery'), leadflow::$version, true);
      $js  = '<script type="text/javascript">';
      $js .= 'jQuery(document).ready(function($) {' . "\n";
      foreach ($active_flows as $flow) {
        if ($flow['selector']) {
          $js .= '$("' . $flow['selector'] . '").each(function(index) {
              lfp_log("Catching data from form: ", this);
              $(this).lfp_form_grabber({
                ajax_url: "' . admin_url('admin-ajax.php') . '",
                flow_id: "' . $flow['id'] . '"
              });
              });' . "\n";
        } else {
          $js .= '$("form").each(function(index) {
              lfp_log("Catching data from form: ", this);
              $(this).lfp_form_grabber({
                ajax_url: "' . admin_url('admin-ajax.php') . '",
                flow_id: ' . $flow['id'] . '
              });
              });' . "\n";
        }
      } // foreach active form flows
      $js .= "\n" . '});</script>';
      echo $js;
    } // if active_flows
  } // enqueue_form_catcher_js
} // leadflow_flow_common