<?php
/**
 * LeadsFlow Pro
 * (c) IMSuccessCenter.com, 2015
 * API Ajax
 */

 class leadflow_frontend_ajax extends leadflow {
   
   
   // Register Frontend Ajax Endpoints
   static function register_ajax_endpoints() {
     // frontend AJAX endpoints
     add_action('wp_ajax_lf_verify_captcha', array('leadflow_frontend_ajax', 'verify_captcha'));
     add_action('wp_ajax_nopriv_lf_verify_captcha', array('leadflow_frontend_ajax', 'verify_captcha'));
     
     add_action('wp_ajax_lf_optin_subscribe', array('leadflow_frontend_ajax', 'subscribe_wrapper'));
     add_action('wp_ajax_nopriv_lf_optin_subscribe', array('leadflow_frontend_ajax', 'subscribe_wrapper'));
     
     add_action('wp_ajax_lf_optin_step1_stats', array('leadflow_frontend_ajax', 'step1_stats'));
     add_action('wp_ajax_nopriv_lf_optin_step1_stats', array('leadflow_frontend_ajax', 'step1_stats'));
     add_action('wp_ajax_lf_optin_step2_stats', array('leadflow_frontend_ajax', 'step2_stats'));
     add_action('wp_ajax_nopriv_lf_optin_step2_stats', array('leadflow_frontend_ajax', 'step2_stats'));
     add_action('wp_ajax_lf_optin_step3_stats', array('leadflow_frontend_ajax', 'step3_stats'));
     add_action('wp_ajax_nopriv_lf_optin_step3_stats', array('leadflow_frontend_ajax', 'step3_stats'));
     
     add_action('wp_ajax_lfp_track_ecommerce', array('leadflow_flow_common', 'process_ecommerce_flow_ajax'));
     add_action('wp_ajax_nopriv_lfp_track_ecommerce', array('leadflow_flow_common', 'process_ecommerce_flow_ajax'));
    
     add_action('wp_ajax_lfp_catch_form', array('leadflow_flow_common', 'process_form_flow_ajax'));
     add_action('wp_ajax_nopriv_lfp_catch_form', array('leadflow_flow_common', 'process_form_flow_ajax'));
     
     add_action('wp_ajax_lf_upload_file', array('leadflow_frontend_ajax', 'upload_file'));
     add_action('wp_ajax_nopriv_lf_upload_file', array('leadflow_frontend_ajax', 'upload_file'));
   } // register_ajax_endpoints
   
   
   static function upload_file() {
     
     foreach($_FILES as $key => $file) {
       $file_id = media_handle_sideload($file, 0, 'LFP - Optin Upload');
       
       $file_url = wp_get_attachment_url($file_id);
       $file_path = parse_url($file_url);
       
       $file_data = array();
       $file_data['url']  = $file_url;
       $file_data['path'] = $file_path['path'];
       $file_data['file_field'] = $key;
       
       set_transient('lf-file-' . leadflow::getUserIP(), $file_data, HOUR_IN_SECONDS);
       wp_send_json_success('File uploaded successfully.');
     }
     
    wp_send_json_error('File not uploaded.');
   } // upload_file
   
   
   // verify captcha
   static function verify_captcha() {
     
     if (empty($_POST['check_captcha']) || $_POST['check_captcha'] == 'false') {
       wp_send_json_success(array('captcha_active' => 'false'));
     }
     
     if (empty($_POST) || empty($_POST['captcha'])) {
       wp_send_json_error(array('captcha_active' => 'true', 'captcha_status' => '0'));
     }
     
	  
     $session_captcha = leadflow_optin_captcha::get($_POST['optin_id']);
    
	 if ($session_captcha == $_POST['captcha']) {
       wp_send_json_success(array('captcha_active' => 'true', 'captcha_status' => '1'));
     } else {
       wp_send_json_error(array('captcha_active' => 'true', 'captcha_status' => '0'));
     }
     
     die();
   } // verify_captcha
   
    
   // main wrapper function
   static function subscribe_wrapper() {   	 
     if (empty($_POST['post_id'])) {
       wp_send_json_error('An error occured - post_id is empty.');
     }
     
	 	 
     $post_id = $_POST['post_id'];
     $meta = get_post_meta($post_id, LF_META, true);
     
     // Check if optin exists
     $optin = get_post($post_id);
     if (empty($optin) || $optin->post_type != 'optin-pages') {
       wp_send_json_error('An error occured - optin does not exist.');
     }
	 
	 
	 
	 parse_str(@$_POST['fields'], $fields);
	 
	 if(leadflow_optin_common::has_widget_type($_POST['post_id'],'captcha')){
		$session_captcha = leadflow_optin_captcha::get($_POST['post_id']);
		if($session_captcha != $fields['lf-captcha-input']){
		  wp_send_json_error('invalid_captcha');
		}
	 } 
	 
     
     $fields['email'] = sanitize_email($fields['email']);
     	 
	 
     // Check if email is valid
     if (!is_email($fields['email'])) {
       wp_send_json_error('An error occured - e-mail is invalid.');
     }
     
     $file = get_transient('lf-file-' . leadflow::getUserIP());
     if (!empty($file)) {
       $fields[$file['file_field'] . '_url'] = $file['url'];
       $fields[$file['file_field'] . '_path'] = $file['path'];
     }
     
     if (leadflow_subscribers_common::is_optin_subscriber($fields['email'], $optin->ID)) {
	   wp_send_json_success('3');
     } else {
       $email = $fields['email'];
       unset($fields['email']);
	   unset($fields['lf-captcha-input']);	   
       $user = leadflow_subscribers_common::add($email, $fields, array('source' => 'optin', 'source_id' => $optin->ID), true);
	   //Add Event
	   $geo = leadflow_geoip::get_info(leadflow::getUserIP());
       $required_vars['country'] = $geo->country_name;
       $required_vars['city'] = $geo->city;
       $required_vars['region'] = $geo->region_name;
	   
	   if(!is_array($component['vars'])){
	     $component['vars']=array();
	   }
	   $component['vars']=array_merge($component['vars'],$fields);
	   
	   leadflow_stats::event_add_optin(array('type'=>'optin', 'post_id' => $optin->ID, 'new' => true, 'country' => $required_vars['country'], 'city' => $required_vars['city'], 'region' => $required_vars['region'], 'uuid' => $user ), true);
	   leadflow_subscribers_common::edit($user, $component['vars'], array('signup_source' => 'optin', 'source_id' => $optin->ID), $component['auto_set_vars']);	
		
       if (!$user) {
         wp_send_json_error('Unable to add new subscriber.');
       }
       
       leadflow_subscribers_common::add_system_tags($user, 'optins', array('optin-' . $optin->ID));
       
       if (!empty($meta['form']['push-through-flow'])) {
         if (!leadflow_flow_common::get_flow_type($meta['form']['push-through-flow']) || leadflow_flow_common::get_flow_type($meta['form']['push-through-flow']) != 'internal') {
           wp_send_json_error('An error occured - unknown internal flow.');
         }
         leadflow_flow_common::process_internal_flow($meta['form']['push-through-flow'], $user, $fields);
       }
       
       leadflow_stats::optin_add_view($optin->ID, 'optin');
       wp_send_json_success('1');
     }
     
     wp_send_json_error('An error occured - unknown error.');
     
   } // subscribe_wrapper
   
   
   static function step1_stats() {
	 leadflow_stats::optin_add_view(@$_POST['post'], 'box1');
     wp_send_json_success();
   } // step1_stats   
   
   static function step2_stats() {
     leadflow_stats::optin_add_view(@$_POST['post'], 'box2');
     wp_send_json_success();
   } // step2_stats


   // post subscriber data to a custom url
   static function customurl($meta, $fields, $optin_id) {
     if ($meta['optin-form']['custom-url-extra']) {
       parse_str(htmlspecialchars_decode($meta['optin-form']['custom-url-extra']), $fields2);
     } else {
       $fields2 = array();
     }

     $email_field = 'email';
     if ($meta['optin-form']['custom-email-field']) {
       $email_field = $meta['optin-form']['custom-email-field'];
     }

     if (class_exists('leadflow_fields')) {
       $fields2 = array_merge($fields2, $fields);
       $fields2['optin_page_id'] = $optin_id;
       $fields2['optin_page_title'] = get_the_title($optin_id);
     } else {
       $fields2['name'] = $fields['name'];
       $fields2[$email_field] = $fields['email'];
       $fields2['optin_page_id'] = $optin_id;
       $fields2['optin_page_title'] = get_the_title($optin_id);
     }

     $response = wp_remote_post($meta['optin-form']['custom-url'], array(
      'method' => 'POST',
      'timeout' => 45,
      'redirection' => 3,
      'httpversion' => '1.0',
      'blocking' => true,
      'headers' => array(),
      'body' => $fields2));

     if (is_wp_error($response)) {
       return 0;
     } else {
       return 1;
     }
   } // custom_url
   

 } // leadflow_frontend_ajax