<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_geoip extends leadflow {
  
  
  static function get_info($ip) {
    require_once LF_PLUGIN_PATH . 'includes/geoip/geoipcity.php';
    require_once LF_PLUGIN_PATH . 'includes/geoip/geoipregionvars.php';

    if (!self::get_geoip_file_status()) { 
      $record = new stdClass();
      $record->city = '';
      $record->country_name = '';
      $record->country_code = '';
      $record->region_name = '';
      $record->region = '';
      
      return $record;
    }
    
    $geoip_file = get_option(LF_GEOIP_OPTION);
    $gi = geoip_open($geoip_file['path'], GEOIP_STANDARD);
    $record = geoip_record_by_addr($gi, $ip);
    
    if (!is_object($record)) {
      $record = new stdClass();
    }
    if (!isset($record->city)) {
      $record->city = '';
    }
    if (!isset($record->country_name)) {
      $record->country_name = '';
    }
    if (isset($record->country_code) && isset($record->region)) {
      global $GEOIP_REGION_NAME;
      $record->region_name = $GEOIP_REGION_NAME[$record->country_code][$record->region];
    } else {
      $record->region_name = '';
    }

    return $record;
  } // content
  
  
  static function download_geoip() {

    if ($_POST['force'] || !self::get_geoip_file_status()) {

      // Send a call to server
      global $leadflow_lc;
	  $auth_query = '&key='.$leadflow_lc->get_decryptedoption($leadflow_lc->authkey).'&domain='.$_SERVER['SERVER_NAME'].'&email='.$leadflow_lc->get_decryptedoption($leadflow_lc->email);
    
      $call_proxy = wp_remote_get(LF_GEOIP_URL . '?geoip_check=' . $_POST['geoip_check'] . $auth_query, array('sslverify' => false));

      if (!is_wp_error($call_proxy)) {
        $download_url = json_decode($call_proxy['body']);
        
        if (!$download_url->success) {
          wp_send_json_error('Error - Invalid License.');
        }
        
		$tmp = download_url($download_url->data->url);
        $file_array = array('name' => str_replace('leadflow-get-geoip.php?hash=', '', basename($download_url->data->url)) . '.dat', 'tmp_name' => $tmp);

        // Check for download errors
        if (is_wp_error($tmp)) {
          @unlink($file_array['tmp_name']);
          return false;
        }
        
        $id = media_handle_sideload($file_array, 0);

        // Check for handle sideload errors.
        if (is_wp_error($id)) {
          @unlink($file_array['tmp_name']);
          return false;
        }

        $attachment_url = wp_get_attachment_url($id);
        $attachment_path = get_attached_file($id);
        
        if (update_option(LF_GEOIP_OPTION, array('url' => $attachment_url, 'path' => $attachment_path))) {
          set_transient('lf-geoip-file-download', 'true', DAY_IN_SECONDS);
          wp_send_json_success('GeoIP Downloaded');
        } else {
          wp_send_json_error('GeoIP File Downloaded but not saved in options.');
        }
      } else {
        wp_send_json_error('Call error');
      } // if $call_proxy
    }

    die();
  } // download_geoip
  
  
  static function settings() {
    
	if (!get_option(LF_GEOIP_OPTION)) {
      // download
      echo '<div id="download-geoip">';
      echo '<table class="form-table">';
      echo '<tbody>';
      echo '<tr>
      <th scope="row"><label for="download_geoip">GeoIP Database</label></th>
      <td><input type="button" id="download_geoip" value="Download GeoIP Database" class="button button-secondary" /><p class="description">An up-to-date GeoIP database allows you to track the geographical location of your subscribers.<br>LFP will automatically notify you when a new version is available.</p></td>
      </tr>';
      echo '</tbody>';
      echo '</table>';
      echo '</div>';
    } else {
      // Already downloaded
      echo '<div id="download-geoip">';
      echo '<table class="form-table">';
      echo '<tbody>';
      echo '<tr>
      <th scope="row"><label for="download_geoip">GeoIP Database</label></th>
      <td>
      <input type="button" id="download_geoip" value="Redownload the Database" class="button button-secondary" />
      <p class="description">An up-to-date GeoIP database allows you to track the geographical location of your subscribers.<br>You have the latest version of the database. If you\'re experiencing problems you can redownload it.<br>LFP will automatically notify you when a new version is available.</p>
      </td>
      </tr>';
      echo '</tbody>';
      echo '</table>';
      echo '</div>';
    }
  } // settings
  
  
  // Check if geoip file exists
  static function get_geoip_file_status() {
    
    // return geoip path and geoip url
    $geoip_option = get_option(LF_GEOIP_OPTION);
    
    if (!empty($geoip_option)) {
      if (get_transient('lf-geoip-file-check')) {
        return true;
      } else {
        if (file_exists($geoip_option['path'])) {
          set_transient('lf-geoip-file-check', 'true', DAY_IN_SECONDS);
          return true;
        }
      }
    }
    
    return false;
  } // get_geoip_file_status
  
  
} // leadflow_geoip