<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_admin_common extends leadflow {

  static $widgets = array('headline' => 'Headline', 'dropdown' => 'Dropdown', 'checkbox' => 'Checkbox', 'image' => 'Image', 'list' => 'List', 'text' => 'Text', 'small-text' => 'Small Text', 'next-button' => 'Next Optin Button', 'previous-button' => 'Previous Optin Button', 'scroll-down' => 'Scroll Button', 'submit' => 'Submit Button', 'blank' => 'Blank', 'email-field' => 'E-mail Field', 'input-field' => 'Input Field', 'textarea-input' => 'Textarea Input', 'testimonials' => 'Testimonials', 'captcha' => 'Captcha', 'hidden' => 'Hidden', 'countdown' => 'Countdown', 'password' => 'Password', 'html' => 'HTML', 'divider' => 'Horizontal Divider', 'colorpicker' => 'Colorpicker', 'video' => 'Video', 'date-time-picker' => 'Date Time Picker', 'rating' => 'Rating', 'label' => 'Label', 'file-upload' => 'File Upload', 'map' => 'Map');

  static function generate_widget($optin_box, $params = array()) {
    $output = '';
    if (is_array($params) && !empty($params)) {
      extract($params);

      if (!isset($container_id)) {
        $container_id = '0';
      }

      if (!isset($width) || $width == '') {
        $width = 'col-lg-12';
      }

      $edit = '<a href="#" class="edit_widget" title="Edit"><i class="dashicons dashicons-edit"></i></a>';
      if ($type == 'divider') {
        $edit = '';		
      }

      if ($type == 'row') {
        $output .= '<li class="' . $width . ' row" data-optin-widget-id="' . $id . '" data-optin-widget-type="' . $type . '">';
        $output .= '<div class="lf-outer">';

        // Widget Info
        $output .= '<input type="hidden" name="optin_row[' . $optin_box . '][' . $id . ']" class="row_id" value="' . $id . '" />';
        $output .= '<input type="hidden" name="optin_row[' . $optin_box . '][' . $id . '][settings][width]" class="" value="' . $width . '" />';

        $output .= '<div class="header">';
        $output .= '<a href="#" class="move_row ui-sortable-handle" title="Move"><i class="dashicons dashicons-menu"></i></a>';
        $output .= '<div class="actions">';
        $output .= '<a href="#" class="edit_row" title="Edit"><i class="dashicons dashicons-edit"></i></a>';        
        $output .= '<a href="#" class="remove_row" title="Remove"><i class="dashicons dashicons-trash"></i></a>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        // Row Settings
        $output .= '<div class="row-outer-container">';
        $output .= '<div class="row-inner-container">';

        $output .= '<div class="row-ic-header">Row <a href="#" class="lf-row-settings-close"><i class="dashicons dashicons-dismiss"></i></a></div>';
        $output .= '<div class="row-ic-inner">';

        // Force full width
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Full Width:</label>';
        $output .= '<input name="optin_row[' . $optin_box . '][' . $id . '][settings][full_width]" type="checkbox" value="1" />';
        $output .= '</div>';

        // Background Color
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Background Color:</label>';
        $output .= '<input name="optin_row[' . $optin_box . '][' . $id . '][settings][background_color]" type="text" class="colorpicker" data-default-color="#ffffff" value="" type="text" />';
        $output .= '</div>';

        // Background Image
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Background Image:</label>';
        $output .= '<div class="bg-input-holder">';
        $output .= '<div class="bg-input">';
        $output .= '<input type="text" value="" class="regular-text process_custom_images" name="optin_row[' . $optin_box . '][' . $id .'][settings][image]" />';
        $output .= '<button class="set_custom_images button">Select image</button>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<hr/>';
        $output .= '<div class="text-right">
        <a href="#" class="row-inner-close button button-primary">Save &amp; Close</a>
        <a href="#" class="row-inner-cancel button button-secondary">Cancel</a>
        </div>';

        $output .= '</div>';

        $output .= '</div>';
        $output .= '</div>';

        $output .= '<ol>';
        // empty list
        $output .= '</ol>';

        $output .= '<div class="no-widgets-msg"><a href="#" class="lf-add-widget" data-row-id="' . $id . '">Click to add new widgets.</a></div>';


        $output .= '</li>';
        // Row Settings End

        return $output;
      }

      $output .= '<li class="child ' . $width . '" data-optin-widget-id="' . $id . '" data-optin-widget-type="' . $type . '">';
      $output .= '<div class="lf-outer">';

      // Preview Cleanup
      if (empty($settings['preview'])) {
        if (!empty($settings['text'])) {
          $settings['preview'] = strip_tags($settings['text']);
        } else {
          $settings['preview'] = 'Not edited...';
        }
      } else {
        $settings['preview'] = $settings['preview'];
      }
	  
	  if ($type == 'divider') {
        $settings['preview'] = '';		
      }

      // Widgets
      $widgets = leadflow_optin_admin_common::$widgets;

      if ($width == 'col-lg-6') {
        $resize_icon = '<i class="icon-resize-full"></i>';
      } else {
        $resize_icon = '<i class="icon-resize-small"></i>';
      }

      $output .= '<div class="header">
      <a href="#" class="move_widget" title="Move"><i class="dashicons dashicons-menu"></i></a>
      <div class="thumb"><img src="' . LF_PLUGIN_URL . '/images/widget-icons/' . $type . '.png" /></div>
      <div class="title">
      <p>' . $widgets[$type] . '</p>
      <div class="widget-preview">' . wp_strip_all_tags($settings['preview'], true) . '</div>
      </div>
      <div class="actions">
      ' . $edit . '';
      /*
      <a href="#" class="width_widget">
      ' . $resize_icon . '
      </a>';
      */
      $output .= '<a href="#" class="remove_widget" title="Delete"><i class="dashicons dashicons-trash"></i></a>
      </div>
      </div>';

      $output .= '<div class="widget-outer-container">';
      $output .= '<div class="widget-inner-container">';

      // Dialog Header
      $output .= '<div class="widget-ic-header">';
      $output .= ucfirst(str_replace('-', ' ', $widgets[$type]));
      $output .= '<a href="#" class="lf-widget-settings-close"><i class="dashicons dashicons-dismiss"></i></a>';
      $output .= '</div>';
      $output .= '<div class="widget-ic-inner">';

      // Widget Info
      $output .= '<input type="hidden" name="optin_widget[' . $optin_box . '][' . $id .'][id]" id="" value="' . $id . '" />';
      $output .= '<input type="hidden" name="optin_widget[' . $optin_box . '][' . $id .'][container_id]" class="container_id" value="' . $container_id . '" />';
      $output .= '<input type="hidden" class="lf-widget-type" name="optin_widget[' . $optin_box . '][' . $id .'][type]" id="" value="' . $type . '" />';

      $output .= self::generate_widget_settings(array('optin_box' => $optin_box, 'widget_type' => $type, 'widget_id' => $id, 'settings' => $settings, 'width' => $width));

      $output .= '<hr/>';
      $output .= '<div class="text-right">
      <a href="#" class="widget-inner-close button button-primary">Save &amp; Close</a>
      <a href="#" class="widget-inner-cancel button button-secondary">Cancel</a>
      </div>';

      $output .= '</div>';
      $output .= '</div>';
      $output .= '</div>';

      $output .= '</div>';
      $output .= '</li>';
    }
    return $output;
  } // generate_widget


  static function generate_widget_settings($params) {
    $output = '';

    // Default Setup
    $default_setup = array('widget_type' => '',
      'optin_box' => '',
      'widget_id' => '',
      'width' => '');

    // Default Settings
    $default_settings = array('name' => '',
      'preview' => '',
      'skin' => '',
      'end_time' => '',
      'headline' => '',
      'text' => '',
      'align' => '',
      'link' => '',
      'link_target' => '',
      'min' => '',
      'max' => '',
      'value' => '',
      'html' => '',
      'height' => '',
      'avatar' => '',
      'for' => '',
      'author' => '',
      'image' => '',
      'placeholder' => '',
      'mandatory' => '',
      'icon' => '',
      'rating' => '',
      'label' => '',
      'color' => '',
      'background_color' => '',
      'type' => '',
      'button_type' => '',
      'button_text' => '',
      'font_color' => '',
      'icon_color' => '',
      'options' => '',
      'css_button' => '',
      'image_button' => '',
      'address' => '',
      'zoom' => '',
      'type' => '',
      'widget_width' => '',
      'width' => '',
      'title' => '',
      'list' => '',
      'padding_left' => '',
      'padding_top' => '',
      'padding_right' => '',
      'padding_bottom' => '',
      'margin_left' => '',
      'margin_top' => '',
      'margin_right' => '',
      'margin_bottom' => '');

    // Default widget setup
    extract(shortcode_atts($default_setup, $params));

    // Default widget settings
    $settings = shortcode_atts($default_settings, $params['settings']);
    
    // Preview Settings for all widgets
    $output .= '<div class="lf-widget-setting">';
    $output .= '<input type="hidden" class="preview-field" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][preview]" id="" value="' . $settings['preview'] . '" />';
    $output .= '</div>';
    
    $output .= '<div class="lf-widget-setting">';
    $output .= '<label>Widget Width:</label>';
    $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][width]" data-old-value="' . $params['width'] . '" class="lf-widget-widget_width">';


    $sizes = array('col-12' => '100%', 'col-8' => '75%', 'col-7' => '66%', 'col-6' => '50%', 'col-5' => '33%', 'col-4' => '25%');
    foreach ($sizes as $k => $v) {
      if ($width == $k) {
        $output .= '<option value="' . $k . '" selected="selected">' . $v . '</option>';
      } else {
        $output .= '<option value="' . $k . '">' . $v . '</option>';
      }
    }

    $output .= '</select>';
    $output .= '</div>';
    
    $output .= '<div class="lf-widget-setting">';
    $output .= '<label>Paddings:</label>';
    $output .= '<div class="lf-widget-padding-input"><label>Left</label><input type="text" value="' . $settings['padding_left'] . '" data-old-value="' . $settings['padding_left'] . '" class="padding-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][padding_left]"/></div>';
    $output .= '<div class="lf-widget-padding-input"><label>Top</label><input type="text" value="' . $settings['padding_top'] . '" data-old-value="' . $settings['padding_top'] . '" class="padding-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][padding_top]"/></div>';
    $output .= '<div class="lf-widget-padding-input"><label>Right</label><input type="text" value="' . $settings['padding_right'] . '" data-old-value="' . $settings['padding_right'] . '" class="padding-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][padding_right]"/></div>';
    $output .= '<div class="lf-widget-padding-input"><label>Bottom</label><input type="text" value="' . $settings['padding_bottom'] . '" data-old-value="' . $settings['padding_bottom'] . '" class="padding-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][padding_bottom]"/></div>';
    $output .= '</div>';
    
    $output .= '<div class="lf-widget-setting">';
    $output .= '<label>Margins:</label>';
    $output .= '<div class="lf-widget-margin-input"><label>Left</label><input type="text" value="' . $settings['margin_left'] . '" data-old-value="' . $settings['margin_left'] . '" class="margin-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][margin_left]"/></div>';
    $output .= '<div class="lf-widget-margin-input"><label>Top</label><input type="text" value="' . $settings['margin_top'] . '" data-old-value="' . $settings['margin_top'] . '" class="margin-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][margin_top]"/></div>';
    $output .= '<div class="lf-widget-margin-input"><label>Right</label><input type="text" value="' . $settings['margin_right'] . '" data-old-value="' . $settings['margin_right'] . '" class="margin-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][margin_right]"/></div>';
    $output .= '<div class="lf-widget-margin-input"><label>Bottom</label><input type="text" value="' . $settings['margin_bottom'] . '" data-old-value="' . $settings['margin_bottom'] . '" class="margin-input" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][margin_bottom]"/></div>';
    $output .= '</div>';
    
    $output .= '<hr/>';

    switch ($widget_type) {

      // Map
      case 'map':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Map Zoom:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][zoom]" data-old-value="' . $settings['zoom'] . '" class="lf-widget-map-zoom">';

        for ($i=1;$i<=21;$i++) {
          if ($i == $settings['zoom']) {
            $output .= '<option value="' . $i . '" selected="selected">' . $i . '</option>';
          } else {
            $output .= '<option value="' . $i . '">' . $i . '</option>';
          }
        }

        $output .= '</select>';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Map Type:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][type]" data-old-value="' . $settings['type'] . '">';

        $map_types = array('p' => 'Road', 'k' => 'Satellite', 'm' => 'Map', 'h' => 'Hybrid');
        foreach ($map_types as $key => $map_type) {
          if ($key == $settings['type']) {
            $output .= '<option value="' . $key . '" selected="selected">' . $map_type . '</option>';
          } else {
            $output .= '<option value="' . $key . '">' . $map_type . '</option>';
          }
        }

        $output .= '</select>';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Map Width:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][width]" data-old-value="' . $settings['width'] . '" value="' . $settings['width'] . '" />';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Map Height:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][height]" data-old-value="' . $settings['height'] . '" value="' . $settings['height'] . '" />';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Map Address:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][address]" data-old-value="' . $settings['address'] . '" value="' . $settings['address'] . '" class="preview-editor" />';
        $output .= '</div>';
        break;

        // Button
      case 'next-button':
      case 'previous-button':

        // Image Buttons
        $files = array();
        $files = glob(LF_PLUGIN_PATH . 'images/buttons/*.{png,jpg,jpeg,gif}', GLOB_BRACE);


        // CSS Customizable Button
        $output .= '<div class="lf-widget-setting-css" id="css-button">';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Button Style:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][css_button]" class="lf-css-button-style" data-old-value="' . $settings['css_button'] . '">';

        for ($i=1;$i<=16;$i++) {
          if ($settings['css_button'] == 'lf-css3buttonstyle' . $i) {
            $output .= '<option value="lf-css3buttonstyle' . $i . '" selected="selected">Button Style ' . $i . '</option>';
          } else {
            $output .= '<option value="lf-css3buttonstyle' . $i . '">Button Style ' . $i . '</option>';
          }
        }

        $output .= '</select>';
        $output .= '</div>';

        // Button Text
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Button Text:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][button_text]" value="' . $settings['button_text'] . '" class="preview-editor" data-old-value="' . $settings['button_text'] . '"/>';
        $output .= '</div>';

        // Button Preview
        $output .= '<div class="lf-widget-setting lf-button-sample">';
        $output .= '<label>Button Preview:</label>';
        $output .= '<a href="#">Button Sample</a>';
        $output .= '</div>';

        $output .= '</div>';

        // CSS3 Button Preview
        break;

      case 'scroll-down':
        // Background Color
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Button Color:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][color]" type="text" class="colorpicker" data-default-color="#ffffff" value="' . $settings['color'] . '" data-old-value="' . $settings['color'] . '" />';
        $output .= '</div>';
        break;

        // Submit Button
      case 'submit':

        // Image Buttons
        $files = array();
        $files = glob(LF_PLUGIN_PATH . 'images/buttons/*.{png,jpg,jpeg,gif}', GLOB_BRACE);


        // CSS Customizable Button
        $output .= '<div class="lf-widget-setting-css" id="css-button">';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Button Style:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][css_button]" class="lf-css-button-style" data-old-value="' . $settings['css_button'] . '">';

        $selected = '';
        for ($i=1;$i<=16;$i++) {
          if ($settings['css_button'] == 'lf-css3buttonstyle' . $i) {
            $selected = 'lf-css3buttonstyle' . $i;
            $output .= '<option value="lf-css3buttonstyle' . $i . '" selected="selected">Button Style ' . $i . '</option>';
          } else {
            $output .= '<option value="lf-css3buttonstyle' . $i . '">Button Style ' . $i . '</option>';
          }
        }

        $output .= '</select>';
        $output .= '</div>';

        // Button Text
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Button Text:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][button_text]" value="' . $settings['button_text'] . '" class="preview-editor" data-old-value="' . $settings['button_text'] . '"/>';
        $output .= '</div>';

        // Button Preview
        $output .= '<div class="lf-widget-setting lf-button-sample">';
        $output .= '<label>Button Preview:</label>';
        $output .= '<a href="#" class="' . $selected . '">Button Sample</a>';
        $output .= '</div>';

        $output .= '</div>';

        // CSS3 Button Preview
        break;

        // Label
      case 'label':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Label Text:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" value="' . $settings['text'] . '" data-old-value="' . $settings['text'] . '" class="preview-editor" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Label For:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][for]" value="' . $settings['for'] . '" data-old-value="' . $settings['for'] . '" />';
        $output .= '<p class="description">the id is the name of your input field</p>';
        $output .= '</div>';
        break;

        // Hidden
      case 'hidden':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Hidden input name..." value="' . $settings['name'] . '" data-old-value="' . $settings['name'] . '" type="text" class="preview-editor" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Value:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][value]" placeholder="Hidden input value..." value="' . $settings['value'] . '" data-old-value="' . $settings['value'] . '" type="text" />';
        $output .= '</div>';
        break;

        // Password
      case 'password':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Password input name..." value="' . $settings['name'] . '"  data-old-value="' . $settings['name'] . '" type="text" class="preview-editor" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Placeholder:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][placeholder]" placeholder="" value="' . $settings['placeholder'] . '" data-old-value="' . $settings['placeholder'] . '" type="text" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Mandatory:</label>';
        $output .= '<input type="checkbox" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][mandatory]" value="1" ' . checked('1', $settings['mandatory'], false) . ' />';
        $output .= '</div>';
        break;

        // Captcha
      case 'captcha':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Background Color:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][color]" type="text" class="colorpicker" value="' . $settings['color'] . '" data-default-color="#ffffff" data-old-value="' . $settings['color'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Font Color:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][font_color]" type="text" class="colorpicker" value="' . $settings['font_color'] . '" data-default-color="#333333" data-old-value="' . $settings['font_color'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Captcha Text:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" placeholder="Copy numbers from image to input field" value="' . $settings['text'] . '" type="text" class="preview-editor" data-old-value="' . $settings['text'] . '" />';
        $output .= '</div>';
        break;

        // Countdown
      case 'countdown':

        $light = 'selected="selected"';
        $dark = '';
        if (!empty($settings['skin'])) {
          if ($settings['skin'] == 'light') {
            $light = 'selected="selected"';
          } else {
            $dark = 'selected="selected"';
          }
        }

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Countdown skin:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][skin]" data-old-value="' . $settings['skin'] . '">';
        $output .= '<option value="light" ' . $light . '>light</option>';
        $output .= '<option value="dark" ' . $dark . '>dark</option>';
        $output .= '</select>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Countdown End Time:</label>';
        $output .= '<input type="text" class="datetimepicker preview-editor" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][end_time]" placeholder="End time" value="' . $settings['end_time'] . '" data-old-value="' . $settings['end_time'] . '"/>';
        $output .= '</div>';
        break;

        // Date/Time Picker
      case 'date-time-picker':

        $datetime = '';
        $date = '';
        $time = '';
        if (!empty($settings['type'])) {
          if ($settings['type'] == 'datetime') {
            $datetime = 'selected="selected"';
          } elseif ($settings['type'] == 'date') {
            $date = 'selected="selected"';
          } elseif ($settings['type'] == 'time') {
            $time = 'selected="selected"';
          }
        }

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Type:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][type]" data-old-value="' . $settings['type'] . '">';
        $output .= '<option value="datetime" ' . $datetime . '>Date and Time picker</option>';
        $output .= '<option value="date" ' . $date . '>Just Date picker</option>';
        $output .= '<option value="time" ' . $time . '>Just Time picker</option>';
        $output .= '</select>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Field Name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" class="preview-editor" placeholder="" value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Minimum Time:</label>';
        $output .= '<input type="text" class="datetimepicker" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][min]" placeholder="Minimum date/time" value="' . $settings['min'] . '" data-old-value="' . $settings['min'] . '"/>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Maximum Time:</label>';
        $output .= '<input type="text" class="datetimepicker" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][max]" placeholder="Maximum date/time" value="' . $settings['max'] . '" data-old-value="' . $settings['max'] . '"/>';
        $output .= '</div>';
        break;

        // Headline
      case 'headline':

        $option = array('h1' => 'H1', 'h2' => 'H2', 'h3' => 'H3');
        $align = array('left' => 'Left', 'center' => 'Center', 'right' => 'Right');
        /*
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Headline size:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][headline]" data-old-value="' . $settings['headline'] . '">';

        foreach ($option as $k => $v) {
          $selected = '';

          if ($k == $settings['headline']) {
            $selected = 'selected="selected"';
          }

          $output .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
        }

        $output .= '</select>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Headline alignament:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][align]" data-old-value="' . $settings['align'] . '">';

        foreach ($align as $k => $v) {
          $selected = '';

          if ($k == $settings['align']) {
            $selected = 'selected="selected"';
          }

          $output .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
        }

        $output .= '</select>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Font Color:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][color]" type="text" class="colorpicker" value="' . $settings['color'] . '" data-default-color="#ffffff" data-old-value="' . $settings['color'] . '" />';
        $output .= '</div>';
        */
        $output .= '<div class="lf-widget-setting">';
        /*
        ob_start(); //Start output buffer
        wp_editor($settings['text'], $optin_box . '-' . $widget_id, array('textarea_name' => 'optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]'));
        $output .= ob_get_contents(); //Grab output
        ob_end_clean(); //Discard output buffer
		*/
		$output .= '<div class="wp-editor-tools"><div class="wp-editor-tabs">
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-tmce" class="toggle_editor_visual lfp-switch-editor switch-tmce" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Visual</button>
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-html" class="toggle_editor_text  lfp-switch-editor switch-html toggle_editor_active" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Text</button>
					</div></div>';
		$output .= '<div class="clear:both;"><textarea name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text" class="preview-editor">'.$settings['text'].' </textarea></div>';
        
        //$output .= '<input type="text" class="preview-editor" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" placeholder="Headline text..." value="' . $settings['text'] . '" data-old-value="' . $settings['text'] . '" />';
        $output .= '</div>';
        break;

        // Testimonials
      case 'testimonials':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Testimonial Avatar:</label>';
        $output .= '<input type="text" value="' . $settings['avatar'] . '" class="regular-text process_custom_images" name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][avatar]" data-old-value="' . $settings['avatar'] . '" />';
        $output .= '<button class="set_custom_images button">Select image</button>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Testimonial Author:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][author]" placeholder="Author" value="' . $settings['author'] . '" data-old-value="' . $settings['author'] . '" class="preview-editor" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting left">';
        $output .= '<label>Testimonial Text:</label>';
		
		$output .= '<div class="wp-editor-tools"><div class="wp-editor-tabs">
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-tmce" class="toggle_editor_visual lfp-switch-editor switch-tmce" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Visual</button>
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-html" class="toggle_editor_text  lfp-switch-editor switch-html toggle_editor_active" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Text</button>
					</div></div>';
		$output .= '<div class="clear:both;"><textarea name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text">'.$settings['text'].'</textarea></div>';
        
        $output .= '</div>';
        break;

        // E-Mail Field
      case 'email-field':
        // defaults
        $settings['name'] = 'email';
        $settings['mandatory'] = '1';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Placeholder:</label>';
        $output .= '<input type="text" class="preview-editor" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][placeholder]" placeholder="" value="' . $settings['placeholder'] . '" data-old-value="' . $settings['placeholder'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Icon:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][icon]" class="icon-select" id="icon-select-' . $widget_id . '" value="' . $settings['icon'] . '" data-old-value="' . $settings['icon'] . '" />';
        $output .= '</div>';
        break;

        // Input Field
      case 'input-field':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Placeholder:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][placeholder]" placeholder="Your text as placeholder" value="' . $settings['placeholder'] . '" data-old-value="' . $settings['placeholder'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Your text as name" value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Mandatory:</label>';
        $output .= '<input type="checkbox" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][mandatory]" value="1" ' . checked('1', $settings['mandatory'], false) . ' />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Icon:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][icon]" class="icon-select" id="icon-select-' . $widget_id . '" value="' . $settings['icon'] . '" data-old-value="' . $settings['icon'] . '" />';
        $output .= '</div>';
        break;

        // Rating Field
      case 'rating':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Default rating:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][rating]" data-old-value="' . $settings['rating'] . '">';
        for($i=0;$i<=5;$i++) {
          $selected = '';
          if (isset($settings['rating']) && $i == $settings['rating']) {
            $selected = 'selected="selected"';
          }
          $output .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
        }
        $output .= '</select>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Your text as name" value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '" />';
        $output .= '</div>';
        break;

        // Blank
      case 'blank':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Height:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][height]" placeholder="Height in pixels" value="' . $settings['height'] . '" data-old-value="' . $settings['height'] . '" />';
        $output .= '</div>';
        break;

        // Textarea Field
      case 'textarea-input':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Placeholder:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][placeholder]" placeholder="Your text as placeholder" value="' . $settings['placeholder'] . '" data-old-value="' . $settings['placeholder'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Your text as name" value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Mandatory:</label>';
        $output .= '<input type="checkbox" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][mandatory]" value="1" ' . checked('1', $settings['mandatory'], false) . ' />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Icon:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][icon]" class="icon-select" id="icon-select-' . $widget_id . '" value="' . $settings['icon'] . '" data-old-value="' . $settings['icon'] . '" />';
        $output .= '</div>';
        break;

        // Regular Text
      case 'text':
        $output .= '<div class="lf-widget-setting">';
		$output .= '<div class="wp-editor-tools"><div class="wp-editor-tabs">
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-tmce" class="toggle_editor_visual lfp-switch-editor switch-tmce" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Visual</button>
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-html" class="toggle_editor_text  lfp-switch-editor switch-html toggle_editor_active" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Text</button>
					</div></div>';
		$output .= '<div class="clear:both;"><textarea name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text" class="preview-editor">'.$settings['text'].' </textarea></div>';
        $output .= '</div>';
		break;

        // HTML
      case 'html':
        $output .= '<div class="lf-widget-setting left">';
        $output .= '<label>HTML:</label>';
        $output .= '<textarea class="preview-editor" class="fit" rows="10" cols="40" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][html]" placeholder="Your html goes here..." data-old-value="' . htmlspecialchars($settings['html'], ENT_QUOTES) . '">' . htmlspecialchars($settings['html'], ENT_QUOTES) . '</textarea>';
        $output .= '</div>';
        break;

        // Video
      case 'video':
        $output .= '<div class="lf-widget-setting left">';
        $output .= '<label>Your video code:</label>';
        $output .= '<textarea class="fit preview-editor" rows="10" cols="40" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][html]" placeholder="Your video html goes here...">' . $settings['html'] . '</textarea>';
        $output .= '<p class="description">You can also use WordPress Video by using this shortcode<br/>[video mp4="source.mp4" ogv="source.ogv" mov="source.mov"]</p>';
        $output .= '</div>';
        break;

        // Small Text
      case 'small-text':
        $output .= '<div class="lf-widget-setting left">';
        $output .= '<label>Text:</label>';
        
		$output .= '<div class="wp-editor-tools"><div class="wp-editor-tabs">
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-tmce" class="toggle_editor_visual lfp-switch-editor switch-tmce" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Visual</button>
					<button type="button" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text_text-html" class="toggle_editor_text  lfp-switch-editor switch-html toggle_editor_active" data-wp-editor-id="optin_widget_first_optin_10_settings_text">Text</button>
					</div></div>';
		$output .= '<div class="clear:both;"><textarea name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][text]" id="optin_widget_' . $optin_box . '_' . $widget_id .'_settings_text" class="preview-editor">'.$settings['text'].' </textarea></div>';
        
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Text alignament:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][align]" data-old-value="' . $settings['align'] . '">';

        $left = '';
        $center = '';
        $right = '';
        if (!empty($settings['align'])) {
          if ($settings['align'] === 'left') {
            $left = 'selected="selected"';
          } elseif ($settings['align'] == 'center') {
            $center = 'selected="selected"';
          } elseif ($settings['align'] == 'right') {
            $right = 'selected="selected"';
          }
        }

        $output .= '<option value="left" ' . $left . '>Left</option>';
        $output .= '<option value="center" ' . $center . '>Center</option>';
        $output .= '<option value="right" ' . $right . '>Right</option>';

        $output .= '</select>';
        $output .= '</div>';
        break;

        // Colorpicker
      case 'colorpicker':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Label:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][label]" placeholder="Your label goes here." value="' . $settings['label'] . '" data-old-value="' . $settings['label'] . '" class="preview-editor">';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Your name goes here." value="' . $settings['name'] . '" data-old-value="' . $settings['name'] . '">';
        $output .= '</div>';
        break;

        // Divider
      case 'divider':
        //
        break;

        // Dropdown
      case 'dropdown':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Dropdown field name:</label>';
        $output .= '<input type="text" class="preview-editor" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Dropdown field name" value="' . $settings['name'] . '" data-old-value="' . $settings['name'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Dropdown options:</label>';
        $output .= '<textarea cols="40" rows="5" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][options]" data-old-value="' . $settings['options'] . '">' . $settings['options'] . '</textarea>';
        $output .= '<small>Add each option on one row.</small></div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Mandatory:</label>';
        $output .= '<input type="checkbox" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][mandatory]" value="1" ' . checked('1', $settings['mandatory'], false) . ' />';
        $output .= '</div>';
        break;

        // List with Icons
      case 'list':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>List:</label>';
        $output .= '<textarea cols="40" rows="5" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][list]" class="preview-editor" data-old-value="' . $settings['list'] . '">' . $settings['list'] . '</textarea>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Icon Color:</label>';
        $output .= '<input name="optin_widget[' . $optin_box . '][' . $widget_id . '][settings][icon_color]" type="text" class="colorpicker" value="' . $settings['icon_color'] . '" data-default-color="#ffffff" data-old-value="' . $settings['icon_color'] . '" />';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Select List Icon:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][icon]" class="icon-select" id="icon-select-' . $widget_id . '" value="' . $settings['icon'] . '" data-old-value="' . $settings['icon'] . '" />';
        $output .= '</div>';
        break;

        // Checkbox
      case 'checkbox':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Checkbox label:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][label]" placeholder="Label before checkbox..." value="' . $settings['label'] . '" class="preview-editor" data-old-value="' . $settings['label'] . '"/>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Checkbox name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Label field name..." value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '"/>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Checkbox value:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][value]" placeholder="Checkbox value..." value="' . $settings['value'] . '" class="preview-editor" data-old-value="' . $settings['value'] . '"/>';
        $output .= '</div>';
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Mandatory:</label>';
        $output .= '<input type="checkbox" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][mandatory]" value="1" ' . checked('1', $settings['mandatory'], false) . ' />';
        $output .= '</div>';
        break;

        // Image
      case 'image':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Image Link:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][link]" placeholder="Link to some url..." value="' . $settings['link'] . '" data-old-value="' . $settings['link'] . '" />';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Image Link:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][link_target]" data-old-value="' . $settings['link_target'] . '">';

        $self = '';
        $blank = '';
        $parent = '';
        $top = '';
        if (!empty($settings['link_target'])) {
          if ($settings['link_target'] == '_self') {
            $self = 'selected="selected"';
          } elseif ($settings['link_target'] == '_blank') {
            $blank = 'selected="selected"';
          } elseif ($settings['link_target'] == '_parent') {
            $parent = 'selected="selected"';
          } elseif ($settings['link_target'] == '_top') {
            $top = 'selected="selected"';
          }
        }

        $output .= '<option value="_self">Self</option>';
        $output .= '<option value="_blank">Blank</option>';
        $output .= '<option value="_parent">Parent</option>';
        $output .= '<option value="_top">Top</option>';
        $output .= '</select>';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Image Align:</label>';
        $output .= '<select name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][align]" data-old-value="' . $settings['align'] . '">';

        $left = '';
        $center = '';
        $right = '';
        if (!empty($settings['align'])) {
          if ($settings['align'] === 'left') {
            $left = 'selected="selected"';
          } elseif ($settings['align'] == 'center') {
            $center = 'selected="selected"';
          } elseif ($settings['align'] == 'right') {
            $right = 'selected="selected"';
          }
        }

        $output .= '<option value="left" ' . $left . '>Left</option>';
        $output .= '<option value="center" ' . $center . '>Center</option>';
        $output .= '<option value="right" ' . $right . '>Right</option>';

        $output .= '</select>';
        $output .= '</div>';

        $output .= '<div class="lf-widget-setting">';
        $output .= '<div class="bg-input-holder">';
        $output .= '<div class="bg-input">';
        $output .= '<label>Image Source:</label><input type="text" value="' . $settings['image'] . '" class="regular-text process_custom_images preview-editor" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][image]" data-old-value="' . $settings['image'] . '" />';
        $output .= '<button class="set_custom_images button">Select image</button>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';
        break;

      case 'file-upload':
        $output .= '<div class="lf-widget-setting">';
        $output .= '<label>Field name:</label>';
        $output .= '<input type="text" name="optin_widget[' . $optin_box . '][' . $widget_id .'][settings][name]" placeholder="Label field name..." value="' . $settings['name'] . '" class="preview-editor" data-old-value="' . $settings['name'] . '"/>';
        $output .= '</div>';
        break;

      default:
        break;
    }

    return $output;
  } // generate_widget_settings

  static function subscribers_search_filters() {
    $screen = get_current_screen();

    if ($screen->id == 'edit-leadflow-subscribers') {
      echo '<div class="lf-subscribers-filters-container">';
      echo '<select class="lf-subscribers-filters" data-placeholder="Subscriber tags" multiple="multiple" name="leadflow-subscriber-tags" style="display:none;width:200px;">';
      // Get currently selected tags
      $selected_tags = '';
      if (isset($_GET['leadflow-subscriber-tags'])) {
        $selected_tags = $_GET['leadflow-subscriber-tags'];
      }

      // Get tags
      $tags = get_terms('leadflow-subscriber-tags', array('hide_empty' => false, 'fields' => 'all'));
      if ($tags) {
        $operator = '+';
        if (isset($_GET['leadflow-subscriber-operator'])) {
          if ($_GET['leadflow-subscriber-operator'] == 'OR') {
            $operator = '%2C';
          } else {
            $operator = '+';
          }
        }

        $selected_tags = urlencode($selected_tags);
        $selected_tags = explode($operator, $selected_tags);

        foreach ($tags as $tag) {
          $selected = '';
          if (!empty($selected_tags) && in_array($tag->slug, $selected_tags)) {
            $selected = 'selected="selected"';
          }
          // Colors
          $term_settings = leadflow_common::get_subscriber_tags_meta($tag->term_id);

          // Term
          echo '<option value="' . $tag->slug . '" ' . $selected . ' data-background-color="' . $term_settings['tag_color'] . '" data-font-color="' . $term_settings['font_color'] . '">' . $tag->name . ' (' . $tag->count . ')</option>';
        }
      }

      echo '</select>';
      echo '</div>';

      echo '<div class="lf-subscribers-filters-container">';
      echo '<select class="lf-subscribers-filters" multiple="multiple" data-placeholder="System tags" name="leadflow-subscriber-system-tags" style="display:none;width:200px !important;">';
      // Get currently selected tags
      $selected_tags = '';
      if (isset($_GET['leadflow-subscriber-system-tags'])) {
        $selected_tags = $_GET['leadflow-subscriber-system-tags'];
      }

      $operator = '+';
      if (!empty($_GET['leadflow-subscriber-operator'])) {
        if ($_GET['leadflow-subscriber-operator'] == 'OR') {
          $operator = '%2C';
        } else {
          $operator = '+';
        }
      }

      $selected_tags = urlencode($selected_tags);
      $selected_tags = explode($operator, $selected_tags);

      // Get tags
      $optins_term = get_term_by('slug', 'optins', 'leadflow-subscriber-system-tags');
      $tags = get_terms('leadflow-subscriber-system-tags', array('hide_empty' => false, 'parent' => $optins_term->term_id, 'fields' => 'all'));
      if ($tags) {
        echo '<optgroup label="Optins">';
        foreach ($tags as $tag) {
          $selected = '';
          if (!empty($selected_tags) && in_array($tag->slug, $selected_tags)) {
            $selected = 'selected="selected"';
          }
          // Colors
          $term_settings = leadflow_common::get_subscriber_tags_meta($tag->term_id);

          // Term
          echo '<option value="' . $tag->slug . '" ' . $selected . ' data-background-color="' . $term_settings['tag_color'] . '" data-font-color="' . $term_settings['font_color'] . '">' . $tag->name . ' (' . $tag->count . ')</option>';
        }
        echo '</optgroup>';
      }

      $flows_term = get_term_by('slug', 'flows', 'leadflow-subscriber-system-tags');
      $tags = get_terms('leadflow-subscriber-system-tags', array('hide_empty' => false, 'parent' => $flows_term->term_id, 'fields' => 'all'));
      if ($tags) {
        echo '<optgroup label="Flows">';
        foreach ($tags as $tag) {
          $selected = '';
          if (!empty($selected_tags) && in_array($tag->slug, $selected_tags)) {
            $selected = 'selected="selected"';
          }
          // Colors
          $term_settings = leadflow_common::get_subscriber_tags_meta($tag->term_id);

          // Term
          echo '<option value="' . $tag->slug . '" ' . $selected . ' data-background-color="' . $term_settings['tag_color'] . '" data-font-color="' . $term_settings['font_color'] . '">' . $tag->name . ' (' . $tag->count . ')</option>';
        }
        echo '</optgroup>';
      }


      $stars_term = get_term_by('slug', 'stars', 'leadflow-subscriber-system-tags');
      $tags = get_terms('leadflow-subscriber-system-tags', array('hide_empty' => false, 'parent' => $stars_term->term_id, 'fields' => 'all'));
      if ($tags) {
        echo '<optgroup label="Stars">';
        foreach ($tags as $tag) {
          $selected = '';
          if (!empty($selected_tags) && in_array($tag->slug, $selected_tags)) {
            $selected = 'selected="selected"';
          }
          // Colors
          $term_settings = leadflow_common::get_subscriber_tags_meta($tag->term_id);

          // Term
          echo '<option value="' . $tag->slug . '" ' . $selected . ' data-background-color="' . $term_settings['tag_color'] . '" data-font-color="' . $term_settings['font_color'] . '">' . $tag->name . ' (' . $tag->count . ')</option>';
        }
        echo '</optgroup>';
      }

      echo '</select>';
      echo '</div>';

      // AND or OR
      $and = 'selected="selected"';
      $or = '';
      if (isset($_GET['leadflow-subscriber-operator'])) {
        if ($_GET['leadflow-subscriber-operator'] == 'OR') {
          $or = 'selected="selected"';
          $and = '';
        } else {
          $or = '';
        }
      }
      echo '<div class="lf-subscribers-filters-container">';
      echo '<div class="lf-subscribers-filters-operator" style="display:none;">';
      echo '<label>Tag operator:</label>';
      echo '<select name="lf-subscribers-operator" id="lf-subscribers-operator">';
      echo '<option vlaue="AND" ' . $and . '>AND</option>';
      echo '<option vlaue="OR" ' . $or . '>OR</option>';
      echo '</select>';
      echo '</div>';
      echo '<input type="button" name="lf-filter" id="lf-filter" value="Go"/>';
      echo '</div>';
    }
  } // subscribers_search_filters


} // leadflow_optin_admin_common