<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_common extends leadflow {


  // Get widgets for optin per optin_box
  static function get_widgets($optin_ID, $optin_box) {

    if ($optin_box == 'first') {
      $optin_box = 'optin_widget_first_optin';
    } else {
      $optin_box = 'optin_widget_second_optin';
    }

    $widgets = array();
    $rows = get_post_meta($optin_ID, $optin_box, true);

    if ($rows) {
      foreach ($rows as $row_id => $row) {
        if (!empty($row['widgets'])) {
          $widgets[$row_id] = $row['widgets'];
        } else {
          $widgets[$row_id] = array();
        }
      }
    }

    return $widgets;
  } // get_widgets


  // use default URL but custom template
  static function template_redirect() {
    global $post;


	

    // mobile app API endpoint init
    if (get_query_var('leadflow_api_action') || get_query_var('lfp_mobile_install')) {
      leadflow_mobile_api::process();
      exit;
    }


    $post_type = get_query_var('post_type');
	
    if (($post_type == 'optin-pages' || $post_type == 'leadflow-abtests') && !is_404()) {
      remove_action('wp_footer', 'wp_admin_bar_render', 1000);

      $optin_type = leadflow_optin_common::get_optin_type();

      if ($post_type == 'leadflow-abtests') {
        leadflow_common::setup_ab_session($post);
        // force setup headers
        leadflow_optin_conditionals::setup_headers();

        load_template(LF_PLUGIN_PATH . 'templates/standalone/default.php');
        exit;
      }

      if ($optin_type != 'standalone' && $optin_type != 'embed') {
        wp_die('This optin type can not be opened directly from URL.', get_bloginfo('name'));
      }

      // leadflow_optin_enqueues::conditional_header_enqueues('true');       
      if ($optin_type == 'standalone' || $optin_type == 'embed') {
        // Check if it's a part of AB
        $ab_test = get_post_meta($post->ID, '_ab-test', true);
        if (!empty($ab_test)) {
          wp_die('This optin is part of A/B Test it can not be opened directly.', get_bloginfo('name'));
        }
      }
      
      load_template(LF_PLUGIN_PATH . 'templates/' . $optin_type . '/default.php');
      exit;
    }
  } // template_redirect


  // Get Optin Type
  static function get_optin_type($optin_id = null) {
    if (!$optin_id) {
      global $post;
      $optin_id = $post->ID;
    }
		
    $type = get_post_meta($optin_id, 'optin_type', true);
    if (!$type) {
      $type = false;
    }

    return $type;
  } // get_optin_type


  // Get Optin Template
  static function get_optin_template($optin_id = null) {
    if (!$optin_id) {
      global $post;
      $optin_id = $post->ID;
    }
	
	

    $type = get_post_meta($optin_id, 'optin_template', true);
    if (!$type) {
      $type = 'user-defined';
    }

    return $type;
  } // get_optin_template


  // get optin meta
  static function get_optin_meta($section = null, $optin_id = null) {
    if (!$optin_id) {
      global $post;
      $optin_id = $post->ID;
    }

    $meta = get_post_meta($optin_id, LF_META, true);

    if (!$section) {
      return $meta;
    } elseif (isset($meta[$section])) {
      return $meta[$section];
    } else {
      return array();
    }
  } // get_optin_meta


  static function get_all_optins() {
    return get_posts(array('posts_per_page'=>-1,'post_type' => 'optin-pages',
      'post_status' => 'publish',
      'meta_query' => array(
        'relation' => 'OR',
        array('key' => 'optin_type',
          'value' => 'welcome',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'popup',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'header',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'standalone',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'pullout',
          'compare' => '='),
        array('key' => 'optin_type',
          'value' => 'embed',
          'compare' => '=')
    )));
  } // get_all_optins


  // custom filter to get optins for a single A/B test
  static function filter_optins_by_id($where, $query) {
    if (!is_admin() || @$query->query['post_type'] != 'optin-pages') {
      return $where;
    }

    if (isset($_GET['id_filter']) && !empty($_GET['id_filter'])) {
      $ids = trim($_GET['id_filter']);
      $where .= " AND ID IN ($ids) ";
    }

    return $where;
  } // filter_optins_by_id


  // Convert .php template to string
  static function template_to_string($template_name, $part_name=null) {
    ob_start();
    require($template_name);
    $var = ob_get_contents();
    ob_end_clean();
    return $var;
  } // template_to_string


  // try stopping users from leaving
  static function prevent_from_leaving($optin = array()) {
    global $post;

    if (empty($optin)) {
      $meta = get_post_meta($post->ID, LF_META, true);
    } else {
      $meta = get_post_meta($optin, LF_META, true); 
    }

    if (!empty($meta['general']['prevent-from-leaving'])) {
      $prevent = $meta['general']['prevent-from-leaving'];
      $message = $meta['general']['prevent-alert-message'];

      if (!empty($prevent)) {
        return "jQuery(window).bind('beforeunload', function(){
        if (!subscribed && !window.parent.document.getElementById('lf-optin-iframe')) {
        return '" . addslashes($message) . "';
        }
        });";
      } else {
        return '';
      }
    }
  } // prevent_from_leaving


  static function shortcode_optin($atts, $content = 'OptIn popup link'){
    global $optin_ID, $attached_optins;

    $out = '';
    $atts = shortcode_atts(array(
      'id' => 0,
      'position' => 'center center',
      'class' => '',
      ), $atts);

    $link = get_permalink($atts['id']);
    if (!$link) {
      return 'Wrong OptIn Page ID.';
    }

    $optin_ID = $atts['id'];
    $out .= leadflow_optin_common::template_to_string(LF_PLUGIN_PATH . '/templates/shortcode/default.php');

    wp_enqueue_script('optin-shortcode', LF_PLUGIN_URL . '/templates/shortcode/shortcode.js', array('jquery'), '1.0', true);
	
	echo self::generate_optin_css($atts['id']);
	
    // Localize
    wp_localize_script('optin-shortcode', 'optin_style', array('css' => self::generate_optin_css($atts['id']),'skin' => self::get_skin($atts['id'])));	
    
	$attached_optins[$optin_ID]=array('type'=>'shortcode');
	leadflow_optin_enqueues::css_enqueues();
	leadflow_optin_enqueues::js_enqueues();
	
		
    return $out;
  } // shortcode_optin  


  static function get_skin($optin_id) {
    $out = '';

    $meta = get_post_meta($optin_id, LF_META, true);

    if (isset($meta['general']['skin']) && $meta['general']['skin'] != 'custom') {
      $out .= '<link rel="stylesheet" id="color-box-css-css"  href="' . LF_PLUGIN_URL . '/templates/skins/' . $meta['general']['skin'] . '.css" type="text/css" media="all"/>';
    }

    return $out;
  } // generate_optin_css 


  static function generate_optin_css($optin_id) {
    $out = '';

    $out .= leadflow_optin_frontend_common::generate_css($optin_id);
	
	

    return $out;
  } // generate_optin_css


  static function shortcode_optin_popup($atts, $content = 'OptIn popup link'){
    $out = '';
    $atts = shortcode_atts(array(
      'id' => 0,
      'position' => 'center center',
      'class' => '',
      ), $atts);

    $link = get_permalink($atts['id']);
    if (!$link) {
      return 'Wrong OptIn Page ID.';
    }
    //$link = str_replace(home_url(), '', $link);
    $class = 'optin-popup ' . trim($atts['class']);
    $position = self::sanitize_position($atts['position']);

    $out = '<a data-optin-position="' . $position . '" href="' . $link . '" class="' . $class . '">' . $content . '</a>';

    return $out;
  } // shortcode_optin_popup  
  

  static function sanitize_position($position) {
    $predefined = array('left top',    'center top',    'right top',
      'left center', 'center center', 'right center',
      'left bottom', 'center bottom', 'right bottom',
      'left', 'center', 'right');

    $position = strtolower($position);
    if (!in_array($position, $predefined)) {
      return 'center center';
    } else {
      return $position;
    }
  } // sanitize_position


  static function shortcode_optin_test_popup($atts, $content = 'OptIn popup link'){
    global $wpdb;
    $out = '';
    $atts = shortcode_atts(array(
      'id' => 0,
      'class' => '',
      'position' => 'center',
      ), $atts);

    $link = $wpdb->get_var($wpdb->prepare('SELECT slug FROM ' . $wpdb->lf_ab_tests . ' WHERE id = %d', $atts['id']));
    if (!$link) {
      return 'Wrong OptIn A/B Test ID.';
    }
    $link = home_url() . $link;
    $class = 'optin-popup ' . trim($atts['class']);
    $position = self::sanitize_position($atts['position']);

    $out = '<a data-optin-position="' . $position . '" href="' . $link . '" class="' . $class . '">' . $content . '</a>';

    return $out;
  } // shortcode_optin_test_popup


  // convert color from hex to RGB
  static function hex2rgb($hex) {
    $hex = str_replace("#", "", $hex);

    if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
    } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
    }
    $rgb = array($r, $g, $b);

    return $rgb;
  } // hex2rgb


  // checks if user has already subscribed to a selected OptIn
  static function is_user_subscribed($post_id) {
    $cookie = unserialize(@$_COOKIE['lf_subscribed']);
    if (isset($cookie[$post_id]) && $cookie[$post_id]) {
      return true;
    } else {
      return false;
    }
  } // is_user_subscribed


  // returns the number of times user has seen a popup
  static function get_user_popup_views($post_id) {
    $cookie = unserialize(@$_COOKIE['lf_optin_views']);
    if (isset($cookie[$post_id])) {
      return $cookie[$post_id];
    } else {
      return 0;
    }
  } // is_user_subscribed


  // bulk edit optin tags
  static function bulk_edit_tags() {

    switch($_REQUEST['action']) {
      case 'lf-push-all': 

        $selected_tags = '';
        if (isset($_GET['leadflow-subscriber-tags'])) {
          $selected_tags = $_GET['leadflow-subscriber-tags'];
        }

        $operator = '+';
        if (isset($_GET['leadflow-subscriber-operator'])) {
          if ($_GET['leadflow-subscriber-operator'] == 'OR') {
            $operator = '%2C';
          } else {
            $operator = '+';
          }
        } // if isset subscriber operator

        $selected_tags = urlencode($selected_tags);
        $selected_tags = explode($operator, $selected_tags);

        $args = array('post_type' => 'leadflow-subscribers',
                      'posts_per_page' => -1,
                      'tax_query' => array(
                      array('taxonomy' => 'leadflow-subscriber-tags',
                            'field' => 'slug',
                            'terms' => $selected_tags)));
                            
        $subscribers = get_posts($args);
        wp_redirect(admin_url('admin.php?page=leadflow-import'));

        break;
      default: return;
    }

  } // bulk_edit_tags

  // parse template layout
  static function parse_template_layout($post_id, $selected_template) {
    $old_template = self::get_optin_template($post_id);
	// Get installed templates
    $installed_templates = get_option(LF_INSTALLED_TEMPLATES);

    $optin_layout = unserialize($installed_templates[$selected_template]['layout']);;
	
	$optin_layout['settings']['optin-general']['css-code']=str_replace('%%OPTINID%%','#lf-optin-'.$post_id,$optin_layout['settings']['optin-general']['css-code']);
	
	
    update_post_meta($post_id, 'optin_widget_first_optin', $optin_layout['first_optin']);
    update_post_meta($post_id, 'optin_widget_second_optin', $optin_layout['second_optin']);
    update_post_meta($post_id, LF_META, $optin_layout['settings']);
  } // parse_template_layout


  // fix path to image
  static function fix_img_path(&$item, $key) {
    if (fnmatch("*image", $key) || fnmatch("image*", $key)) {
      if (!empty($item)) {
        $item = LF_TEMPLATE_PATH . '/' . $_POST['optin_template'] . '/' .$item;
      }
      // $item
    }
  }


  static function uses_shortcode($content) {
    $output = array();
    $shortcodes = array('optin-shortcode', 'optin_shortcode', 'optin_shortcode', 'optin-welcome', 'optin_welcome', 'optin-popup', 'optin_popup');

    foreach ($shortcodes as $k => $shortcode) {
      if (has_shortcode($content, $shortcode)) {
        $atts = shortcode_parse_atts($content);

        if ($atts && !empty($atts['id'])) {
          $output['id'] = $atts['id'];
          $output['type'] = str_replace(array('optin-', 'optin_'), '', $shortcode);
        }

      }
    }

    return $output;
  } // uses_shortcode

  static function has_widget_type($optinID,$type){
	$widgets_first=get_post_meta($optinID,'optin_widget_first_optin',true);
	$widgets_second=get_post_meta($optinID,'optin_widget_second_optin',true);
	 	 
	foreach($widgets_first as $row_id=>$row){
	  foreach($row['widgets'] as $widget_id=>$widget){
		if($widget['type'] == $type){
		  return true;	
		}
	  }
	}	 
	
	return false;	 
  }
} // leadflow_optin_common