<?php
/**
* LeadsFlow Pro Pro
* (c) IMSuccessCenter.com, 2015
*/

class leadflow_optin_frontend_common extends leadflow {


  static function generate_widget($params) {
    $output = '';
    global $optin_ID;

    if (is_array($params) && !empty($params)) {
      extract($params);

      // Widget width
      if (!isset($width) || $width == '') {
        $width = 'col-lg-12';
      }

      // Setup widget settings
      $settings = $params['settings'];

      // Mandatory not set fix
      if (!isset($settings['mandatory'])) {
        $settings['mandatory'] = '0';
        $mandatory = '';
      } else {
        $mandatory = 'data-required="required"';
      }

      foreach ($settings as $opt_name => $opt_value) {
        if ($opt_name == 'html') continue;
        #$settings[$opt_name] = strip_tags(html_entity_decode(trim($opt_value)), '<a><u><i><b><span>');
        $settings[$opt_name] = $opt_value;
      }

      // Fetch GET Variables
      if($type != 'hidden'){
		$settings['value'] = '';
	  }

      if (!empty($settings['name']) && !empty($_GET[$settings['name']])) {
        $settings['value'] = $_GET[$settings['name']];
      }

      if (!empty($_GET['email']) && $type == 'email-field') {
        $settings['value'] = $_GET['email'];
      }

      // Paddings
      $paddings = array('padding_top', 'padding_right', 'padding_bottom', 'padding_left');
      $padding = 'padding:';
      
      foreach ($paddings as $k => $pad) {
        if ($settings[$pad] != '') {
          $padding .= $settings[$pad] . ' ';
        }
      }
      
      $padding .= ';';
      // Margins
      $margins = array('margin_top', 'margin_right', 'margin_bottom', 'margin_left');
      $margin = 'margin:';
      
      foreach ($margins as $k => $mar) {
        if ($settings[$mar] != '') {
          if (($mar == 'margin_left' && $settings[$mar] == '0px') || ($mar == 'margin_right' && $settings[$mar] == '0px')) {
            $margin .= 'auto' . ' ';
          } else {
            $margin .= $settings[$mar] . ' ';
          }
        }
      }
      
      $margin .= ';';
      //

      $output .= '<div class="lf-widget-container ' . $width . ' lf-widget-' . $params['type'] . '" id="' . $params['type'] . '_' . $params['id'] . '" style="' . $margin . ' ' . $padding . '">';

      switch ($type) {

        // Map
        case 'map':
          $lang = 'en';
          $iwloc = 'addr';
          $ll = '';
          $map_url = '//maps.google.com/maps?hl=' . $lang . '&amp;ie=utf8&amp;output=embed&amp;iwloc=' . $iwloc . '&amp;iwd=1&amp;mrt=loc&amp;t=' . $settings['type'] . '&amp;q=' . urlencode(remove_accents($settings['address'])) . '&amp;z=' . urlencode($settings['zoom']) . $ll;

          $output .= '<div class="lf-gm-widget">';
          $output .= '<iframe width="' . $settings['width'] . '" height="' . $settings['height'] . '" src="' . $map_url . '"></iframe>';
          $output .= '</div>';
          break;

          // Blank
        case 'blank':
          $output .= '<div style="height:' . $settings['height'] . ';">&nbsp;</div>';
          break;

          // Hidden
        case 'hidden':
		  $output .= '<input type="hidden" id="' . $settings['name'] . '" name="' . $settings['name'] . '" value="' . $settings['value'] . '" />';
          break;

          // Captcha
        case 'captcha':
          if (empty($settings['font_color'])) {
            $settings['font_color'] = '#333';
          }

          if (empty($settings['color'])) {
            $settings['color'] = '#ddd';
          }

          $output .= '<div class="lf-captcha">';
          $output .= '<div>'.$settings['text'].' ';
          $output .= '<img src="' . LF_PLUGIN_URL . '/includes/optin_captcha.php?lf-generate-captcha=true&optin_ID=' . $optin_ID . '&color=' . urlencode($settings['color']) . '&font_color=' . urlencode($settings['font_color']) . '" alt="Captcha" />';
          $output .= '<input type="text" id="captcha" name="lf-captcha-input" value="" class="lf-mandatory" />';
          $output .= '</div>';
          $output .= '</div>';
          break;

          // Rating
        case 'rating':
          $output .= '<div class="lf-rating" data-default="' . $settings['rating'] . '" data-field-name="' . $settings['name'] . '"></div>';
          break;

          // Countdown
        case 'countdown':
          $output .= '<div class="lf-clock" data-end-time="' . $settings['end_time'] . '"></div>';
          break;

          // Date/Time picker
        case 'date-time-picker':
          $output .= '<input type="datetime" class="lf-datetime-picker" ' . $mandatory . ' data-min-time="' . $settings['min'] . '" data-max-time="' . $settings['max'] . '" id="' . $settings['name'] . '" data-type="' . $settings['type'] . '" name="' . $settings['name'] . '" value="' . $settings['value'] . '"/>';
          break;

          // Colorpicker
        case 'colorpicker':
          $output .= '<label>' . $settings['label'] . '</label><input type="text" id="' . $settings['name'] . '" name="' . $settings['name'] . '" class="colorpicker" ' . $mandatory . ' value="' . $settings['value'] . '" />';
          break;

          // Headlines
        case 'headline':

          $css = '';
          if (isset($settings['color'])) {
            $css .= 'color:' . $settings['color'] . ';';
          }

          //$output .= '<' . $settings['headline'] . ' class="text-' . $settings['align'] . '" style="' . $css . '">' . $settings['text'] . '</' . $settings['headline'] . '>';
          
          $output .= '' . $settings['text'] . '';
          break;

          // Text-area Input
        case 'textarea-input':
          $output .= '<div class="input-container textarea-container">';

          if (!empty($settings['icon'])) {
            $output .= '<i class="icon ' . $settings['icon'] . '"></i>';
          }

          $output .= '<textarea id="' . $settings['name'] . '" name="' . $settings['name'] . '" ' . $mandatory . '>' . $settings['placeholder'] . '</textarea>';

          $output .= '</div>';
          break;

          // Password Input
        case 'password':
          $output .= '<input type="password" name="' . $settings['name'] . '" id="' . $settings['name'] . '" value="' . $settings['value'] . '" placeholder="' . $settings['placeholder'] . '" ' . $mandatory . ' />';
          break;

          // Checkbox Input
        case 'checkbox':
          $output .= '<label>' . $settings['label'] . '</label><input type="checkbox" name="' . $settings['name'] . '" id="' . $settings['name'] . '" value="1" ' . $mandatory . ' />';
          break;

          // Input
        case 'input-field':
          $output .= '<div class="input-container">';

          if (!empty($settings['icon'])) {
            $output .= '<i class="icon ' . $settings['icon'] . '"></i>';
          }

          $output .= '<input type="text" id="' . $settings['name'] . '" name="' . $settings['name'] . '" placeholder="' . $settings['placeholder'] . '" value="' . $settings['value'] . '" ' . $mandatory . ' />';

          $output .= '</div>';
          break;

          // E-Mail input
        case 'email-field':
          $output .= '<div class="input-container">';

          if (!empty($settings['icon'])) {
            $output .= '<i class="icon ' . $settings['icon'] . '"></i>';
          }

          $output .= '<input type="email" name="email" placeholder="' . $settings['placeholder'] . '"  value="' . $settings['value'] . '" data-required="required" />';
          $output .= '</div>';
          break;

          // Text
        case 'text':
          $output .= '<p>' . $settings['text'] . '</p>';
          break;

          // Small Text
        case 'small-text':
          $output .= '<p style="text-align:' . $settings['align'] . ';">' . $settings['text'] . '</p>';
          break;

          // HTML
        case 'html':
          $output .= $settings['html'];
          break;

          // Video
        case 'video':
          $output .= '<div class="fitvid">' . $settings['html'] . '</div>';
          break;

          // Label
        case 'label':
          $output .= '<label for="' . $settings['for'] . '">' . $settings['text'] . '</label>';
          break;

          // Divider
        case 'divider':
          $output .= '<hr style="border: 0; height: 1px; background: #333;"/>';
          break;

          // Dropdown
        case 'dropdown':
          $output .= '<select id="' . $settings['name'] . '" name="' . $settings['name'] . '" ' . $mandatory . '>';
          if (isset($settings['options']) && $settings['options'] != '') {
            $options = explode("\n", $settings['options']);
            if (is_array($options) && count($options)>0) {
              foreach ($options as $i => $value) {
                if (trim($value) == trim($settings['value'])) {
                  $output .= '<option value="' . trim($value) . '" selected="selected">' . trim($value) . '</option>';
                } else {
                  $output .= '<option value="' . trim($value) . '">' . trim($value) . '</option>';
                }
              }
            }
          }
          $output .= '</select>';
          break;

          // List
        case 'list':
          $output .= '<ul>';
          if (isset($settings['list']) && $settings['list'] != '') {
            $options = explode("\n", $settings['list']);
            if (is_array($options) && count($options)>0) {

              $css = '';
              if (!empty($settings['icon_color'])) {
                $css .= 'color:' . $settings['icon_color'] . ';';
              }

              foreach ($options as $i => $value) {
                $output .= '<li><i class="' . $settings['icon'] . '" style="' . $css . '"></i><p>' . $value . '</p></li>';
              }
            }
          }
          $output .= '</ul>';
          break;

          // Image
        case 'image':
          if (isset($settings['image']) && $settings['image'] != '') {
            if (isset($settings['link']) && $settings['link'] != '') {
              $output .= '<a href="' . $settings['link'] . '" target="' . $settings['link_target'] . '">';
            }
            $output .= '<img src="' . $settings['image'] . '" />';
            if (isset($settings['link']) && $settings['link'] != '') {
              $output .= '</a>';
            }
          }
          break;

          // Testimonials
        case 'testimonials':
          $output .= '<div class="lf-testimonial">';
          $output .= '<div class="lf-testimonial-inner">';

          // Avatar
          $output .= '<div class="lf-testimonial-avatar">';
          $output .= '<img src="' . $settings['avatar'] . '" />';
          $output .= '</div>';

          // Author
          $output .= '<div class="lf-testimonial-author">';
          $output .= '' . $settings['author'] . '';
          $output .= '</div>';

          // Text
          $output .= '<p>';
          $output .= '' . $settings['text'] . '';
          $output .= '</p>';

          $output .= '</div>';
          $output .= '</div>';
          break;

          // Button
        case 'next-button':
        case 'previous-button':

          if ($type == 'next-button') {
            $action_class = 'next-optin';
          } else {
            $action_class = 'prev-optin';
          }

          $output .= '<a class="btn ' . $settings['css_button'] . ' btn-lg btn-block ' . $action_class . '" href="#">';
          $output .= $settings['button_text'];
          $output .= '</a>';
          break;

          // Scroll Down
        case 'scroll-down':
          $output .= '<a class="btn lf-scroll-down" href="#" style="border-color:' . $settings['color'] . ' !important;">';
          $output .= '<i class="dashicons dashicons-arrow-down-alt2" style="color:' . $settings['color'] . ' !important;"></i>';
          $output .= '</a>';
          break;

          // Submit Button
        case 'submit':
          $output .= '<button class="' . $settings['css_button'] . ' btn-lg btn-block bnt-submit" href="#">';
          $output .= $settings['button_text'];
          $output .= '</button>';
          break;

          // File Upload
        case 'file-upload':
          $output .= '<div class="upload-input">';
          $output .= '<div class="upload-spinner" style="display:none;"><img src="' . LF_PLUGIN_URL . '/images/spinner.gif' . '" /></div>';
          $output .= '<input id="fileupload" type="file" name="' . $settings['name'] . '"/>';
          $output .= '</div>';
          break;

        default:
          break;

      } // switch

      $output .= '</div>';


    }

    return $output;
  } // generate_widget


  // Generate custom CSS for current optin
  static function generate_css($optin_ID, $standalone = false) {
    $out = '';
    $meta = get_post_meta($optin_ID, LF_META, true);
	
    // Setup Optin Grid Size
    if (!empty($meta['general']['grid'])) {
      $grid = $meta['general']['grid'];
      $grid = rtrim($grid, 'px') . 'px';
      
      $out .= '<style type="text/css" id="lf-optin-grid-settings-' . $optin_ID . '">';
      $out .= '.col-12,';
      $out .= '.lf-widget-row {';
      $out .= 'max-width:' . $grid . ';';
      $out .= 'display:block;';
      $out .= 'margin:0 auto;';
      $out .= '}';
      $out .= '</style>';
    } else {
      // Default grid 1170px
      $out .= '<style type="text/css" id="lf-optin-grid-settings-' . $optin_ID . '">';
      $out .= '.col-12,';
      $out .= '.lf-widget-row {';
      $out .= 'max-width:100%;';
      $out .= 'display:block;';
      $out .= 'margin:0 auto;';
      $out .= '}';
      $out .= '</style>';
    }
	
    // Optin General Settings
    if ($standalone) {
      if (isset($meta['background'])) {
        $settings = $meta['background'];
        // Background is single image? or slideshow?
        if (isset($settings['type']) && $settings['type'] == 'image') {
          $out .= '<style type="text/css" id="lf-optin-bg-settings-' . $optin_ID . '">';
          $out .= 'body {';
          if (!empty($settings['bg-image']) && $settings['bg-cover'] != 'none') {
            $out .= 'background: url("' . $settings['bg-image'] . '") no-repeat fixed; ';
            $out .= 'background-size: ' . $settings['bg-cover'] . '; ';
          } elseif (!empty($settings['bg-image'])) {
            $out .= 'background-image: url("' . $settings['bg-image'] . '"); ';
            $out .= 'background-position: ' . str_replace('-', ' ', $settings["bg-position"]) . '; ';
            $out .= 'background-repeat: ' . $settings["bg-repeat"] . '; ';
          }
          $out .= 'background-color: ' .  $settings['bg-color'] .'; ';
          $out .= '}';
          $out .= '</style>';
        }
      }
    } else {
	
	
		$out .= '<style type="text/css" id="lf-optin-' . $optin_ID . '-css">' . "\r\n";
		
		$out .= '#lf-optin-' . $optin_ID . '{';
		// Backgound color
		if (!empty($meta['background']['bg-color'])) {
		  $out .= 'background-color:'.$meta['background']['bg-color'].';';
		} 
		if (!empty($meta['background']['bg-image'])) {
		  $out .= 'background-image:url(\''.$meta['background']['bg-image'].'\');';
		} 
		
		$out .= '}';
		
		$out .= '</style>' . "\r\n";
		
		
		
	
		// First Optin Box
		if (!empty($meta['first-optin'])) {
		  $settings = $meta['first-optin'];
	
		  $out .= '<style type="text/css" id="lf-optin-' . $optin_ID . '-css">' . "\r\n";
		  
		  $google_fonts = self::load_google_fonts();  
		  
		  if( isset($meta['general']['google-fonts']) && is_array($meta['general']['google-fonts']) ){
			  foreach($meta['general']['google-fonts'] as $load_font){
				  $out .= '@import url(https://fonts.googleapis.com/css?family='.str_replace(' ','+',$google_fonts[$load_font]['name']).':'.$google_fonts[$load_font]['variants'].');' . "\r\n";
			  }
		  }
		  
		  $out .= '#lf-optin-' . $optin_ID . ' .first-optin {' . "\r\n";
	
		  // Background Color
		  if (isset($settings['box-background-color']) && $settings['box-background-color'] != ''
		  && $settings['bg-opacity'] != '' && isset($settings['bg-opacity'])) {
			$color = leadflow_optin_common::hex2rgb($settings['box-background-color']);
			$out .= 'background-color: rgba(' . implode(',', $color) . ', ' . $settings['bg-opacity'] . ') !important;' . "\r\n"; 
		  }
		  
			if (!empty($settings['background-image'])) {
			  $out .= 'background-image: url("' . $settings['background-image'] . '"); ';
			} 
		 
		  
		  
		  
	
		  if (isset($settings['background-cover']) && $settings['background-cover'] != 'none') {
			$out .= 'background-size: ' . $settings['background-cover'] . '; ';
			$out .= 'background-position: ' . str_replace('-', ' ', $settings["background-position"]) . '; ';
		  } else {
			$out .= 'background-position: ' . str_replace('-', ' ', $settings["background-position"]) . '; ';
			$out .= 'background-repeat: ' . $settings["background-repeat"] . '; ';
		  }
		
		/*
		  if (isset($settings['box-shadow-color'])) {
			$out .= 'box-shadow: 0px 2px 8px 0px ' . $settings['box-shadow-color'] . '; ';
		  } 
		*/
		  $out .= '}' . "\r\n";
	
	
		  // First Optin Button Setup
		  $out .= '#lf-optin-' . $optin_ID . ' .first-optin .btn {' . "\r\n";
		  if (isset($settings['button-border-radius']) && $settings['button-border-radius'] != '') {
			$out .= 'border-radius:' . $settings['button-border-radius'] . 'px;' . "\r\n";
		  }
	
		  if (isset($settings['button-background-color']) && $settings['button-background-color'] != '') {
			$out .= 'background-color:' . $settings['button-background-color'] . ';' . "\r\n";
		  }
	
		  if (isset($settings['conbutton-text-color']) && $settings['button-text-color'] != '') {
			$out .= 'color:' . $settings['button-text-color'] . ';' . "\r\n";
		  }
	
		  if (isset($settings['button-font-size']) && $settings['button-font-size'] != '') {
			$out .= 'font-size:' . $settings['button-font-size'] . ' !important;' . "\r\n";
		  }
	
		  $out .= '}' . "\r\n";
		  $out .= '</style>' . "\r\n";
		}
		// first box
	
		// second box
		if (!empty($meta['second-optin'])) {
		  $settings = $meta['second-optin'];
		  $out .= '<style type="text/css" id="lf-optin-second-box-' . $optin_ID . '">' . "\r\n";
		  $out .= '#lf-optin-' . $optin_ID . ' .second-optin {' . "\r\n";
	
		  // Background Color
		  if (isset($settings['box-background-color']) && $settings['box-background-color'] != ''
		  && isset($settings['bg-opacity']) && $settings['bg-opacity'] != '') {
			$color = leadflow_optin_common::hex2rgb($settings['box-background-color']);
			$out .= 'background-color: rgba(' . implode(',', $color) . ', ' . $settings['bg-opacity'] . ') !important;' . "\r\n";
		  }
	
		  if (!empty($settings['background-image'])) {
			$out .= 'background-image: url("' . $settings['background-image'] . '"); ';
		  }
		  if (isset($settings['background-cover']) && $settings['background-cover'] != 'none') {
			$out .= 'background-size: ' . $settings['background-cover'] . '; ';
		  } else {
			$out .= 'background-position: ' . str_replace('-', ' ', $settings["background-position"]) . '; ';
			$out .= 'background-repeat: ' . $settings["background-repeat"] . '; ';
		  }
	
		  // Font Color
		  if (isset($settings['box-font-color']) && $settings['box-font-color'] != '') {
			$out .= 'color:' . $settings['box-font-color'] . ' !important;' . "\r\n";
		  }
	
		  // Font Size
		  if (isset($settings['content-font-size']) && $settings['content-font-size'] != '') {
			$out .= 'font-size:' . $settings['content-font-size'] . ' !important;' . "\r\n";
		  }
	
		  // Box Border Radius
		  if (isset($settings['box-border-radius']) && $settings['box-border-radius'] != '') {
			$out .= 'border-radius:' . $settings['box-border-radius'] . 'px !important;' . "\r\n";
		  }
	
		  // Box Border Width
		  if (isset($settings['box-border-width']) && $settings['box-border-width'] != '0px') {
			$out .= 'border:' . $settings['box-border-width'] . ' solid ' . $settings['box-border-color'] .';' . "\r\n";
		  }
	
		  // Box Shadow Setup
		  if (isset($settings['box-shadow-color']) && $settings['box-shadow-color'] != '') {
			$out .= 'box-shadow: 0 0 5px ' . $settings['box-shadow-color'] . ' !important;' . "\r\n";
		  }
	
	
		  $out .= '}' . "\r\n";
	
		  // Second Optin Button Setup
		  $out .= '.second-optin .btn {' . "\r\n";
		  if (isset($settings['button-border-radius']) && $settings['button-border-radius'] != '') {
			$out .= 'border-radius:' . $settings['button-border-radius'] . 'px;' . "\r\n";
		  }
	
		  if (isset($settings['background-color']) && $settings['button-background-color'] != '') {
			$out .= 'background-color:' . $settings['button-background-color'] . ';' . "\r\n";
		  }
	
		  if (isset($settings['button-text-color']) && $settings['button-text-color'] != '') {
			$out .= 'color:' . $settings['button-text-color'] . ';' . "\r\n";
		  }
	
		  if (isset($settings['button-font-size']) && $settings['button-font-size'] != '') {
			$out .= 'font-size:' . $settings['button-font-size'] . ' !important;' . "\r\n";
		  }
		  $out .= '}' . "\r\n";
	
		  // Second Optin Input Setup
		  $out .= '.second-optin input, .second-optin textarea, .second-optin select {' . "\r\n";
		  if (isset($settings['input-text-color']) && $settings['input-text-color'] != '') {
			$out .= 'color:' . $settings['input-text-color'] . ' !important;' . "\r\n";
		  }
		  if (isset($settings['input-background-color']) && $settings['input-background-color'] != '') {
			$out .= 'background-color:' . $settings['input-background-color'] . ' !important;' . "\r\n";
		  }
		  if (isset($settings['input-border-color']) && $settings['input-border-color'] != '') {
			$out .= 'border-color:' . $settings['input-border-color'] . ' !important;' . "\r\n";
		  }
		  if (isset($settings['input-border-radius']) && $settings['input-border-radius'] != '') {
			$out .= 'border-radius:' . $settings['input-border-radius'] . 'px !important;' . "\r\n";
		  }
		  $out .= '}'. "\r\n";
			
		 
		  $out .= $meta['optin-general']['css-code'];	
			
		  $out .= '</style>' . "\r\n";
		  // second box
		}
	}
	
	return $out;
	
  } // generate_css

} // leadflow_optin_admin_common