<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_pointers extends leadflow {
  static function load_pointers() {
    $pointers = array();
    
    $pointers[] = array('target' => '#toplevel_page_leadflow', 'edge' => 'left', 'align' => 'right', 'content' => 'Thank you for installing <b>LeadsFLow Pro</b>! Use <a href="admin.php?page=leadflow">this menu</a> to manage OptIn Pages and all other settings.');
    $pointers[] = array('target'=> 'tr.type-optin-pages:last', 'edge' => 'top', 'align' => 'center', 'content' => 'We\'ve already setup a couple of demo OptIn Pages so that you can get a quick start. Feel free to edit them, or delete if you want to start from scratch.');
    $pointers[] = array('target'=> '#stats-test-label', 'edge' => 'top', 'align' => 'left', 'content' => 'Our demo data also contains dummy statistics so that you can see how your graphs will look like. You can reset all stats in the <a href="edit.php?post_type=optin-pages&page=wf-optin-settings">Settings</a>.');
    $pointers[] = array('target'=> '.post-new-php.post-type-optin-pages #title', 'edge' => 'top', 'align' => 'left', 'content' => 'Did you know that in most cases preset settings will be more than enough to get your Page going. Just enter the title, content for two content boxes and you\'re all set.');
    $pointers[] = array('target'=> '#tag-url', 'edge' => 'left', 'align' => 'center', 'content' => 'A/B Tests can have the same URL as some OptIn Pages - their URL will override the Pages\'s one. You can create as many tests as needed and assign unlimited Pages to them. But each Page can belong to only one Test.');
    $pointers[] = array('target'=> '#wf-optin-options-page-tabs li:nth-child(2)', 'edge' => 'top', 'align' => 'left', 'content' => 'Autoresponders have to be configured before they\'re used in OptIn Pages. If you are not fond of 3rd party services feel free to use our built-in Subscibers Database.');
    $pointers[] = array('target'=> '#datatables', 'edge' => 'top', 'align' => 'left', 'content' => 'These are just some dummy subscribers to show you how things look. Feel free to delete them in the <a href="edit.php?post_type=optin-pages&page=wf-optin-settings">Settings</a>.');

    update_option(LF_POINTERS, $pointers, true);
  } // load_pointers
  
  
  static function dismiss_pointer_ajax() {
    $pointers = get_option(LF_POINTERS, array());
    $pointer = trim($_POST['pointer']);
    
    if (!$pointer) {
      wp_send_json_error('No pointer selected.');
    }

    if (empty($pointers)) {
      wp_send_json_error('No active pointers.');
    }

    $size = sizeof($pointers);
    for ($i = 0; $i < $size; $i++) {
      if ($pointers[$i]['target'] == $pointer) {
        unset($pointers[$i]);
        break;
      }
    }

    $pointers = array_values($pointers);
    update_option(LF_POINTERS, $pointers);
    
    wp_send_json_success(sizeof($pointers));
  } // dismiss_pointer_ajax
  
  
  static function enqueue_files() {
    $pointers = get_option(LF_POINTERS, false);
    
    if ($pointers === false) {
      self::load_pointers();
      $pointers = get_option(LF_POINTERS, array());
    }
    if (empty($pointers)) {
      return false;
    } 
    
    wp_enqueue_style('wp-pointer');
    wp_enqueue_script('wp-pointer');
    wp_enqueue_script('lf-pointers', LF_PLUGIN_URL .  '/js/lf-admin-pointers.js', array('jquery'), leadflow::$version, true);
    wp_localize_script('wp-pointer', 'leadflow_pointers', $pointers);
  } // enqueue_files
} // leadflow_pointers