<?php
/**
 * LeadsFlow Pro Pro
 * (c) IMSuccessCenter.com, 2015
 */

class leadflow_subscribers_common extends leadflow {
  static $required_vars_list = array('firstname' => '',
                                     'lastname' => '',
                                     'address' => '',
                                     'phone' => '',
                                     'notes' => '',
                                     'ip' => '',
                                     'region' => '',
                                     'city' => '',
                                     'country' => '',
                                     'lang' => '',
                                     'ttv' => 0,
                                     'ttc' => 0);
  static $subscriber_template = array('uuid' => 0,
                                      'email' => false,
                                      'firstname' => '',
                                      'lastname' => '',
                                      'address' => '',
                                      'phone' => '',
                                      'notes' => '',
                                      'ip' => '',
                                      'region' => '',
                                      'city' => '',
                                      'country' => '',
                                      'lang' => '',
                                      'stars' => 0,
                                      'ttv' => 0,
                                      'ttc' => 0,
                                      'signup_source' => '',
                                      'source_id' => 0,
                                      'created' => '',
                                      'modified' => '',
                                      'gravatar_url' => '',
                                      'tags_system' => array(),
                                      'tags_user' => array(),
                                      'events' => array(),
                                      'custom_vars' => array());

  /* Check if user_email exists on specified optin_id
   * @param $email (string)
   * @param $optin_id (int)
   */
  static function is_optin_subscriber($email, $optin_id) {
    $user = self::is_subscriber($email);

    if (!$user) {
      return false;
    }

    $tags = self::get_system_tags($user);
    if ($tags) {
      foreach ($tags as $tag) {
        if ($tag['slug'] == 'optin-' . $optin_id) {
          return true;
        }
      }
    }

    return false;
  } // is_optin_subscriber

  /* Check if user/email exists in the DB
   * @param $email (string)
   */
  static function is_subscriber($email) {
    if (!is_email($email)) {
      return false;
    }

    $subscriber = get_page_by_title(trim($email), OBJECT, 'leadflow-subscribers');

    if ($subscriber && !is_wp_error($subscriber)) {
      return $subscriber->ID;
    } else {
      return false;
    } // if $user
  } // edit


  /* Get subscriber details
   * @param Param can be e-mail address (string) or ID (int)
   */
  static function get_details($param) {
    $out = $all_meta = array();

    if (is_object($param) && get_class($param) == 'WP_Post' && $param->post_type == 'leadflow-subscribers') {
      $subscriber = $param;
    } elseif (ctype_digit(strval($param))) {
      $subscriber = get_posts(array('p' => $param, 'post_type' => 'leadflow-subscribers', 'numberposts' => 1, 'post_status' => 'publish'));
      if ($subscriber) {
        $subscriber = $subscriber[0];
      }
    } else {
      if (!is_email($param)) {
        return false;
      }
      $subscriber = get_page_by_title($param, OBJECT, 'leadflow-subscribers');
    }

    if ($subscriber && !is_wp_error($subscriber)) {
      $all_meta_tmp = get_post_meta($subscriber->ID);

      foreach ($all_meta_tmp as $key => $value) {
        if ($key[0] == '_') {
          continue;
        }
        if (is_array($all_meta_tmp[$key])) {
          $all_meta[$key] = maybe_unserialize($value[0]);
        } else {
          $all_meta[$key] = maybe_unserialize($value);
        }
      } // foreach

      // merge default values and ones from DB
      $out = shortcode_atts(self::$subscriber_template, $all_meta);

      $out['uuid'] = $subscriber->ID;
      $out['email'] = trim($subscriber->post_title);
      $out['created'] = $subscriber->post_date;
      $out['modified'] = $subscriber->post_modified;
      $out['gravatar_url'] = 'http://www.gravatar.com/avatar/' . md5(strtolower(trim($out['email']))) . '?d=mm&s=256';

      $out['tags_user'] = self::get_tags($subscriber->ID);
      $out['tags_system'] = self::get_system_tags($subscriber->ID);
    } else {
      $out = false;
    }

    return $out;
  } // get_details


  // fetch user's custom tags
  static function get_tags($user_id) {
    $out = array();
    $tags = wp_get_object_terms($user_id, 'leadflow-subscriber-tags');

    foreach ($tags as $tag) {
      $colors = get_option('taxonomy_meta_' . $tag->term_id, array('tag_color' => '', 'font_color' => ''));
      $tmp = array('id' => $tag->term_id, 'name' => $tag->name, 'slug' => $tag->slug);
      $tmp = array_merge($tmp, $colors);
      $out[] = $tmp;
    }

    return $out;
  } // get_tags


  // fetch user's system tags
  static function get_system_tags($user_id) {
    $out = array();
    $tags = wp_get_object_terms($user_id, 'leadflow-subscriber-system-tags');

    foreach ($tags as $tag) {
      $colors = get_option('taxonomy_meta_' . $tag->term_id, array('tag_color' => '', 'font_color' => ''));
      $tmp = array('id' => $tag->term_id, 'name' => $tag->name, 'slug' => $tag->slug);
      $tmp = array_merge($tmp, $colors);
      $out[] = $tmp;
    }

    return $out;
  } // get_system_tags


  /* Add new subscriber
   * @param email
   * @param fields - custom, ip
   */
  static function add($email, $fields, $sys_vars = array(), $auto_set_vars = false) {
    if (empty($email) || !is_email($email)) {
      return false;
    }
    $email = trim($email);
 
    // check if subscriber exists
    $old_user = self::is_subscriber($email);
    if ($old_user) {
      $tmp = self::edit($old_user, $fields, $sys_vars, $auto_set_vars);
	  $geo = leadflow_geoip::get_info(leadflow::getUserIP());
      $required_vars['country'] = $geo->country_name;
      $required_vars['city'] = $geo->city;
      $required_vars['region'] = $geo->region_name;
	  //leadflow_stats::event_add_optin(array('type'=>'optin', 'post_id' => 0, 'new' => false, 'country' => $required_vars['country'], 'city' => $required_vars['city'], 'region' => $required_vars['region'], 'uuid' => $old_user ), true);
      	
      return $tmp;
    }

    $required_vars = array_intersect_key($fields, self::$required_vars_list);
    $required_vars = array_merge(self::$required_vars_list, $required_vars);

    if ($auto_set_vars) {
      $required_vars['ip'] = leadflow::getUserIP();
      $required_vars['lang'] = leadflow_common::get_lang();

      $geo = leadflow_geoip::get_info(leadflow::getUserIP());
      $required_vars['country'] = $geo->country_name;
      $required_vars['city'] = $geo->city;
      $required_vars['region'] = $geo->region_name;
    } // if auto_set_vars

	
		
    $required_vars['stars'] = 0;
    $required_vars['signup_source'] = '';
    $required_vars['source_id'] = 0;
    $required_vars['ttv'] = 0;
    $required_vars['ttc'] = 0;

    $required_vars = array_merge($required_vars, $sys_vars);
    $custom_vars = array_diff_key($fields, self::$required_vars_list);
    unset($custom_vars['email']);

    $tmp = $required_vars;
    unset($tmp['email'], $tmp['stars'], $tmp['ttv'], $tmp['ttc'], $tmp['signup_source'], $tmp['source_id'], $tmp['gravatar_url']);
    $content = implode("\n", $tmp);
    foreach($custom_vars as $var => $val) {
      $content .= $var . ' ' . $val . "\n";
    }


    $new_sub = wp_insert_post(array('post_title' => $email, 'post_type' => 'leadflow-subscribers', 'post_status' => 'publish', 'post_content' => $content));

    // if ok save meta
    if ($new_sub) {
      foreach ($required_vars as $key => $value) {
        update_post_meta($new_sub, $key, $value);
      }
	  
	  //Set Cookie
	  $cookie_value=@unserialize(@$_COOKIE['lf_subscribed']);
	  $cookie_value[$sys_vars['source_id']]=true;
	  setcookie('lf_subscribed', serialize($cookie_value), time() + (86400 * 30), "/");
	  update_post_meta($new_sub, 'custom_vars', $custom_vars);

      self::update_stars($new_sub);

      return $new_sub;
    } else {
      return false;
    }
  } // add


  /* Edit custom fields for subscriber
   * @param $user_id (int)
   * @param $fields array('key' => 'value'...)
   */
  static function edit($user, $fields, $sys_vars = array(), $auto_set_vars = false) {
    if (ctype_digit(strval($user))) {
      $user_id = $user;
    } else {
      $user_id = self::is_subscriber($user);
    }

    if (!$user_id) {
      return false;
    }

    $required_vars = array_intersect_key($fields, self::$required_vars_list);

    if ($auto_set_vars) {
      $required_vars['ip'] = leadflow::getUserIP();
      $required_vars['lang'] = leadflow_common::get_lang();

      $geo = leadflow_geoip::get_info(leadflow::getUserIP());
      $required_vars['country'] = $geo->country_name;
      $required_vars['city'] = $geo->city;
      $required_vars['region'] = $geo->region_name;
    } // if auto_set_vars

    $required_vars = array_merge($required_vars, $sys_vars);

    $custom_vars = array_diff_key($fields, self::$required_vars_list);
    $old_custom_vars = get_post_meta($user_id, 'custom_vars', true);

    if (is_array($old_custom_vars)) {
      $custom_vars = array_merge($old_custom_vars, $custom_vars);
    }

    foreach ($required_vars as $key => $value) {
        update_post_meta($user_id, $key, $value);
    }
    update_post_meta($user_id, 'custom_vars', $custom_vars);

    $tmp = $required_vars;
    unset($tmp['email'], $tmp['stars'], $tmp['ttv'], $tmp['ttc'], $tmp['signup_source'], $tmp['source_id'], $tmp['gravatar_url']);
    $content = implode("\n", $tmp);
    foreach($custom_vars as $var => $val) {
      $content .= $var . ' ' . $val . "\n";
    }

    wp_update_post(array('ID' => $user_id, 'post_status' => 'publish', 'post_content' => $content));
    self::update_stars($user_id);

    return $user_id;
  } // edit


  // delete subscriber and all attached data
  static function delete($subscriber) {
    if (ctype_digit(strval($subscriber))) {
      $subscriber = $subscriber;
    } else {
      if (!is_email($subscriber)) {
        return false;
      }
      $subscriber = get_page_by_title($subscriber, OBJECT, 'leadflow-subscribers');
    }

    if ($subscriber) {
      $deleted = wp_delete_post($subscriber->ID);

      return true;
    } else {
      return false;
    }
  } // delete


  /* Add tags to subscriber
   * @param $user_id (int)
   * @param $tags array(string, string)
   */
  static function add_tags($user_id, $tags) {
    if (!is_array($tags)) {
      $tags = (array) $tags;
    }

    $added = wp_set_post_terms($user_id, $tags, 'leadflow-subscriber-tags', true);

    if ($added) {
      return true;
    } else {
      return false;
    }
  } // add_tags


  /* Remove specified tag(s) from subscriber
   * @param $user_id (int)
   * @param $tags array(mixed) can be int (term_id) or string
   */
  static function remove_tags($user_id, $tags) {
    if (!is_array($tags)) {
      $tags = (array) $tags;
    }

    foreach ($tags as $value) {
      wp_remove_object_terms($user_id, (int) $value, 'leadflow-subscriber-tags');
    } // foreach $tags

    return true;
  } // remove_tags


  /* Remove all tags from subscriber
   * @param $user_id (int)
   */
  static function remove_all_tags($user_id) {
    return wp_delete_object_term_relationships($user_id, 'leadflow-subscriber-tags');
  } // remove_all_tags


   /* Remove specified tag(s) from subscriber
   * @param $user_id (int)
   * @param $tags array(mixed) can be int (term_id) or string
   */
  static function remove_system_tags($user_id, $tags) {
    if (!is_array($tags)) {
      $tags = (array) $tags;
    }

    foreach ($tags as $value) {
      wp_remove_object_terms($user_id, $value, 'leadflow-subscriber-system-tags');
    } // foreach $tags

    return true;
  } // remove_system_tags


  /* Add System tags to subscriber
   * @param $user_id (int)
   * @param $type (string) - Optins, Flows, Internal
   * @param $tags array(string, string)
   */
  static function add_system_tags($user_id, $type, $tags) {
    $added = false;

    if(!is_array($tags)) {
      $tags = (array) $tags;
    }

    if (!in_array(strtolower($type), array('optins', 'flows', 'special', 'stars'))) {
      trigger_error('Invalid System Tag Type', E_USER_ERROR);

      return false;
    }

    // Get parent by Type
    $type = strtolower($type);
    $parent_term = get_term_by('slug', $type, 'leadflow-subscriber-system-tags');

    foreach ($tags as $key => $value) {
      if (!term_exists($value, 'leadflow-subscriber-system-tags', $type)) {
        // Term does not exist, create one
        if ($type == 'optins' || $type == 'flows') {
          $id = explode('-', $value);
          $id = @$id[1];
          if ($id) {
            $name = get_the_title((int) $id);
          } else {
            $name = $value;
          }
        } else {
          $name = $value;
        } // if optins || flows

        $term = wp_insert_term($value, 'leadflow-subscriber-system-tags', array('parent' => $parent_term->term_id, 'description' => 'Automatically added'));
        if ($term) {
          // Save Term
          wp_update_term((int) $term['term_id'], 'leadflow-subscriber-system-tags', array('name' => $name));
          $added = wp_set_post_terms($user_id, (int) $term['term_id'], 'leadflow-subscriber-system-tags', true);
        }
      } else {
        $term = get_term_by('slug', $value, 'leadflow-subscriber-system-tags');
        // Save Term
        $added = wp_set_post_terms($user_id, (int) $term->term_id, 'leadflow-subscriber-system-tags', true);
      }
      $added = true;
    } // foreach $tags

    return $added;
  } // add_internal_tags


  static function check_system_tag($user, $type, $object_id) {
    $user = self::get_details($user);
    if (!$user) {
      return false;
    }

    if (!in_array(strtolower($type), array('optin', 'flow', 'internal'))) {
      trigger_error('Invalid System Tag Type', E_USER_ERROR);

      return false;
    }

    $object_id = (int) $object_id;

    $tag_slug = $type . '-' . $object_id;
    foreach ($user['tags_system'] as $tag) {
      if ($tag['slug'] == $tag_slug) {
        return true;
      }
    }

    return false;
  } // check_system_tag


  /*
   * @param $user (int)
   * @param $event (array)
   */
  static function add_event($user_id, $event) {
    $events_old = get_post_meta($user_id, 'events', true);
    if (!$events_old) {
      $events_old = array();
    }

    unset($event['uuid']);

    if (empty($event[0])) {
      $event = array($event);
    }
    $events = array_merge($event, $events_old);
    update_post_meta($user_id, 'events', $events);

    return true;
  } // add_events


  /*
   * Delete subscribers - skip trash
   */
  static function skip_trash($new_status, $old_status, $post) {
    if ($new_status == 'trash' && $post->post_type == 'leadflow-subscribers') {
	  wp_delete_post($post->ID, true);
    }
  } // skip_trash


  static function update_stars($sub_id) {
    $sub = self::get_details($sub_id);
    if (!$sub) {
      return false;
    }

    global $wpdb;
    $score = 0.01;

    if ( false === ( $ttv_stats = get_transient( 'lfp_ttv_stats' ) ) ) {
		$ttv_stats = $wpdb->get_row($wpdb->prepare('SELECT EXP(SUM(LOG(CAST(meta_value AS DECIMAL))) / COUNT(CAST(meta_value AS DECIMAL))) as avg_geom, COUNT(post_id) as count, AVG(CAST(meta_value AS DECIMAL)) as avg, MIN(CAST(meta_value AS DECIMAL)) as min, MAX(CAST(meta_value AS DECIMAL)) as max FROM ' . $wpdb->postmeta . ' WHERE meta_key = %s', array('ttv')));
		set_transient( 'lfp_ttv_stats', $ttv_stats, 12 * HOUR_IN_SECONDS );
	}
	
	if ( false === ( $ttc_stats = get_transient( 'lfp_ttc_stats' ) ) ) {
		$ttc_stats = $wpdb->get_row($wpdb->prepare('SELECT EXP(SUM(LOG(CAST(meta_value AS DECIMAL))) / COUNT(CAST(meta_value AS DECIMAL))) as avg_geom, COUNT(post_id) as count, AVG(CAST(meta_value AS DECIMAL)) as avg, MIN(CAST(meta_value AS DECIMAL)) as min, MAX(CAST(meta_value AS DECIMAL)) as max FROM ' . $wpdb->postmeta . ' WHERE meta_key = %s', array('ttc')));
		set_transient( 'lfp_ttc_stats', $ttc_stats, 12 * HOUR_IN_SECONDS );
	}
	
	
	
    // ttc and ttv scores are based on max per-site values
    $ttc_multiplier = 5 / ($ttc_stats->max + 0.01);
    $score += min(5, $ttc_multiplier * $sub['ttc']);
    $ttv_multiplier = 5 / ($ttv_stats->max + 0.01);
    $score += min(5, $ttv_multiplier * $sub['ttv']);

    // how recent was the last activity
    $last_activity_days = max(0.5, (current_time('timestamp') - strtotime($sub['modified'])) / DAY_IN_SECONDS);
    $score += min(7, 1/$last_activity_days * 3.5);

    // main non-empty vars
    $base_vars = !empty($sub['firstname']) + !empty($sub['lastname']) + !empty($sub['address']) + !empty($sub['phone']) + !empty($sub['notes']) + !empty($sub['ip']) + !empty($sub['region']) + !empty($sub['city']) + !empty($sub['country']) + !empty($sub['lang']);
    $score += min(3, $base_vars * 0.3);

    // just a tiny bit for custom tags and custom vars
    $score += min(1, sizeof($sub['tags_user']) * 0.2) + min(1, sizeof($sub['custom_vars']));

    // events are worth more
    $score += min(4, sizeof($sub['events']) * 0.4);

    $score_max = 25;
    $stars = 5 / $score_max * $score;
    $stars = (int) ($stars * 10);
    $stars = round($stars / 5) * 5 / 10;
    $stars = max(0, min(5, $stars));
    //var_dump($stars);

    update_post_meta($sub_id, 'stars', $stars);
    self::remove_system_tags($sub_id, array('stars-0', 'stars-0.5', 'stars-1', 'stars-1.5', 'stars-2', 'stars-2.5', 'stars-3', 'stars-3.5', 'stars-4', 'stars-4.5', 'stars-5'));
    self::add_system_tags($sub_id, 'stars', array('stars-' . $stars));

    return $stars;
  } // update_stars

  static function filter_where_by_id($where = '') {
    global $wpdb;

    $tmp = (int) get_option('lf_stars_bulk_cron', 0);
    $where .= ' AND ' . $wpdb->posts . '.ID > ' . $tmp . ' ';

    return $where;
  } // filter_where_by_id


  static function update_stars_bulk_cron($recursive_count = 0) {
    global $wpdb;
    $last = $count = 0;

    $subs_total = (int) $wpdb->get_var($wpdb->prepare('SELECT COUNT(id) FROM ' . $wpdb->posts . ' WHERE post_type = %s AND post_status = %s', array('leadflow-subscribers', 'publish')));
    $per_call = (int) min(1500, max(150, $subs_total * 0.1));

    if (!$subs_total) {
      return 0;
    }

    $args = array('posts_per_page' => $per_call,
                  'post_type' => 'leadflow-subscribers',
                  'orderby' => 'ID',
                  'order' => 'ASC',
                  'suppress_filters' => false,
                  'status' => 'publish');

    add_filter('posts_where', array('leadflow_subscribers_common', 'filter_where_by_id'));
    $subscribers = get_posts($args);
    remove_filter('posts_where', array('leadflow_subscribers_common', 'filter_where_by_id'));

    foreach ($subscribers as $sub) {
      $last = $sub->ID;
      $count++;
      self::update_stars($sub->ID);
    }

    update_option('lf_stars_bulk_cron', $last);

    if ($recursive_count == 0 && ($last == 0 || $count < $per_call * 0.8)) {
      return self::update_stars_bulk_cron(1);
    }

    return $count;
  } // update_stars_bulk_cron
} // leadflow_subscribers_common